/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.dvj2me.dvSprite;
import com.dvidearts.dvj2me.dvTile;

public class Snake
extends dvSprite {
    public byte health;
    public byte mAnimation = (byte)-1;
    public byte state;
    public byte proCounter;
    public byte proDir;
    public short deathClock;
    public short wx;
    public short wy;
    public short sx;
    public short sy;
    public short prox;
    public short proy;
    public short prosx;
    public short prosy;
    public boolean active;
    public boolean onscreen;
    public boolean proActive;
    private Game game;
    private int xo;
    private int yo;

    public Snake(Game g) {
        super(g.sprSnake);
        this.game = g;
        this.wx = 0;
        this.wy = 0;
        this.active = false;
        this.deathClock = 0;
        this.health = 0;
        this.proCounter = 0;
        this.proActive = false;
        this.xo = this.getWidth() / 2;
        this.yo = this.getHeight() - this.getHeight() / 3;
    }

    public void move(int x, int y) {
        this.wx = (short)x;
        this.wy = (short)y;
    }

    public void moveCell(int x, int y, dvTile map) {
        this.wx = (short)(map.getCellWidth() * x);
        this.wy = (short)(map.getCellHeight() * y);
    }

    public void reset() {
        switch (this.game.sinfo[this.game.infoSlot].swordLevel) {
            case 0: {
                this.health = (byte)4;
                break;
            }
            case 1: {
                this.health = (byte)3;
                break;
            }
            case 2: {
                this.health = (byte)3;
                break;
            }
            case 3: {
                this.health = (byte)2;
                break;
            }
            case 4: {
                this.health = 1;
            }
        }
        this.active = true;
        this.state = 0;
        this.deathClock = 0;
        this.setAnimation((byte)0);
        this.proActive = false;
    }

    public void update(Player p) {
        if (this.game.dvpopup.IsActive()) {
            return;
        }
        this.onscreen = false;
        this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
        this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
        this.setPosition(this.sx, this.sy);
        this.onscreen = this.isOnScreen(this.game.x, this.game.y, this.game.resw, this.game.resh);
        if (this.game.wipe.IsActive()) {
            return;
        }
        if (this.health > 0 && this.onscreen) {
            if (this.game.sinfo[this.game.infoSlot].currTileMap == 16) {
                this.state = 1;
            } else {
                if (this.state != 1) {
                    this.state = 0;
                }
                if (p.wx < this.wx + this.game.SNAKE_ATTACK_RANGE && p.wx >= this.wx - this.game.SNAKE_ATTACK_RANGE && p.wy < this.wy + this.game.SNAKE_ATTACK_RANGE && p.wy >= this.wy - this.game.SNAKE_ATTACK_RANGE) {
                    this.state = 1;
                }
            }
            short tx = this.wx;
            short ty = this.wy;
            short cellid = 0;
            boolean moving = false;
            int px = p.wx - this.xo;
            int py = p.wy - this.yo;
            int runspeed = this.game.TILEW / 32;
            if (runspeed < 1) {
                runspeed = 1;
            }
            switch (this.state) {
                case 0: {
                    this.setAnimation((byte)0);
                    break;
                }
                case 1: {
                    if (this.onscreen && !this.proActive && (px == this.wx || py == this.wy)) {
                        this.prox = this.wx;
                        this.proy = this.wy;
                        this.proActive = true;
                        if (px < this.wx) {
                            this.proDir = 0;
                            this.setAnimation((byte)1);
                        } else if (px > this.wx) {
                            this.proDir = 1;
                            this.setAnimation((byte)2);
                        }
                        if (py < this.wy) {
                            this.proDir = (byte)2;
                            this.setAnimation((byte)3);
                        } else if (py > this.wy) {
                            this.proDir = (byte)3;
                            this.setAnimation((byte)4);
                        }
                        this.proCounter = 0;
                    }
                    if (px < this.wx) {
                        this.wx = this.wx - px < runspeed ? (short)px : (short)(this.wx - runspeed);
                        this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                        this.setPosition(this.sx, this.sy);
                        moving = true;
                        this.setAnimation((byte)1);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (this.game.world.collideSolid(cellid, this)) {
                            this.wx = tx;
                            this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                            this.setPosition(this.sx, this.sy);
                        }
                    } else if (px > this.wx) {
                        this.wx = px - this.wx < runspeed ? (short)px : (short)(this.wx + runspeed);
                        this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                        this.setPosition(this.sx, this.sy);
                        moving = true;
                        this.setAnimation((byte)2);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (this.game.world.collideSolid(cellid, this)) {
                            this.wx = tx;
                            this.sx = (short)(this.game.x + this.game.world.nx + this.wx);
                            this.setPosition(this.sx, this.sy);
                        }
                    }
                    if (py < this.wy) {
                        this.wy = this.wy - py < runspeed ? (short)py : (short)(this.wy - runspeed);
                        this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                        this.setPosition(this.sx, this.sy);
                        if (!moving) {
                            this.setAnimation((byte)3);
                        }
                        if (!this.game.world.collideSolid(cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo)), this)) break;
                        this.wy = ty;
                        this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                        this.setPosition(this.sx, this.sy);
                        break;
                    }
                    if (py <= this.wy) break;
                    this.wy = py - this.wy < runspeed ? (short)py : (short)(this.wy + runspeed);
                    this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                    this.setPosition(this.sx, this.sy);
                    if (!moving) {
                        this.setAnimation((byte)4);
                    }
                    if (!this.game.world.collideSolid(cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo)), this)) break;
                    this.wy = ty;
                    this.sy = (short)(this.game.y + this.game.world.ny + this.wy);
                    this.setPosition(this.sx, this.sy);
                }
            }
            if (!p.invinsible && p.collidesWith(this, (int)this.sx, (int)this.sy)) {
                p.invinsible = true;
                this.game.sinfo[this.game.infoSlot].health = (byte)(this.game.sinfo[this.game.infoSlot].health - 1);
            }
            tx = this.wx;
            ty = this.wy;
            if (p.getFrame() == 0) {
                switch (p.mAnimation) {
                    case 6: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health < 1) {
                            p.addMagic();
                            p.dropHeart(this.wx, this.wy);
                            this.health = 0;
                            this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)(this.game.sinfo[this.game.infoSlot].numSnakeKills + 1);
                            if (this.game.sinfo[this.game.infoSlot].numSnakeKills > 20) {
                                this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)20;
                            }
                            return;
                        }
                        this.wy = (short)(this.wy - runspeed * 7);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (!this.game.world.collideSolid(cellid, this)) break;
                        this.wy = ty;
                        break;
                    }
                    case 5: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health < 1) {
                            p.dropHeart(this.wx, this.wy);
                            p.addMagic();
                            this.health = 0;
                            this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)(this.game.sinfo[this.game.infoSlot].numSnakeKills + 1);
                            if (this.game.sinfo[this.game.infoSlot].numSnakeKills > 20) {
                                this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)20;
                            }
                            return;
                        }
                        this.wy = (short)(this.wy + runspeed * 7);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (!this.game.world.collideSolid(cellid, this)) break;
                        this.wy = ty;
                        break;
                    }
                    case 7: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health < 1) {
                            p.dropHeart(this.wx, this.wy);
                            p.addMagic();
                            this.health = 0;
                            this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)(this.game.sinfo[this.game.infoSlot].numSnakeKills + 1);
                            if (this.game.sinfo[this.game.infoSlot].numSnakeKills > 20) {
                                this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)20;
                            }
                            return;
                        }
                        this.wx = (short)(this.wx - runspeed * 7);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (!this.game.world.collideSolid(cellid, this)) break;
                        this.wx = tx;
                        break;
                    }
                    case 8: {
                        if (!p.sword.collidesWith(this, (int)this.sx, (int)this.sy) && !p.collidesWith(this, (int)this.sx, (int)this.sy)) break;
                        this.health = (byte)(this.health - p.getSwordDamage());
                        if (this.health < 1) {
                            p.dropHeart(this.wx, this.wy);
                            p.addMagic();
                            this.health = 0;
                            this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)(this.game.sinfo[this.game.infoSlot].numSnakeKills + 1);
                            if (this.game.sinfo[this.game.infoSlot].numSnakeKills > 20) {
                                this.game.sinfo[this.game.infoSlot].numSnakeKills = (byte)20;
                            }
                            return;
                        }
                        this.wx = (short)(this.wx + runspeed * 7);
                        cellid = this.game.world.currmap.getCell(this.game.world.currmap.getColumn(this.wx + this.xo), this.game.world.currmap.getRow(this.wy + this.yo));
                        if (!this.game.world.collideSolid(cellid, this)) break;
                        this.wx = tx;
                    }
                }
            }
        } else if (this.health < 1) {
            this.health = 0;
            if (this.game.sinfo[this.game.infoSlot].currTileMap == 16) {
                return;
            }
            this.deathClock = (short)(this.deathClock + 1);
            if (this.deathClock > 300) {
                this.reset();
            }
        }
        if (this.proActive) {
            if (this.proDir == 0) {
                this.prox = (short)(this.prox - 6);
            } else if (this.proDir == 1) {
                this.prox = (short)(this.prox + 6);
            } else if (this.proDir == 2) {
                this.proy = (short)(this.proy - 6);
            } else if (this.proDir == 3) {
                this.proy = (short)(this.proy + 6);
            }
            this.prosx = (short)(this.game.x + this.game.world.nx + this.prox);
            this.prosy = (short)(this.game.y + this.game.world.ny + this.proy);
            if (!p.invinsible && p.collidesWithFull(this.game.sprIcon.getFrame(3), (int)this.prosx, (int)this.prosy)) {
                p.invinsible = true;
                this.game.sinfo[this.game.infoSlot].health = (byte)(this.game.sinfo[this.game.infoSlot].health - 1);
            }
            this.proCounter = (byte)(this.proCounter + 1);
            if (this.proCounter > 70) {
                this.proActive = false;
                this.proCounter = 0;
            }
        }
    }

    void setAnimation(byte newAnimation) {
        if (newAnimation == this.mAnimation) {
            return;
        }
        switch (newAnimation) {
            case 0: {
                this.setFrame(0);
                break;
            }
            case 1: {
                this.setFrame(2);
                break;
            }
            case 2: {
                this.setFrame(3);
                break;
            }
            case 3: {
                this.setFrame(1);
                break;
            }
            case 4: {
                this.setFrame(0);
            }
        }
        this.mAnimation = newAnimation;
    }
}

