/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.dvj2me;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class dvMediaManager {
    public static final byte TONE1 = 60;
    public static final byte TONE2 = 80;
    public static final byte TONE3 = 90;
    public static final byte TONE4 = 100;
    private Player midiPlayer = null;
    private Player wavPlayer = null;
    private boolean mute = false;
    private int currtrack = -1;
    private String[] midiurl;
    private String[] wavurl;

    public dvMediaManager(String[] waves, String[] midi) {
        this.midiurl = midi;
        this.wavurl = waves;
    }

    private Player Init(String url) {
        Player player = null;
        String ctype = dvMediaManager.guessContentType(url);
        if (ctype.length() > 0) {
            InputStream is = this.getClass().getResourceAsStream(url);
            try {
                is.reset();
            }
            catch (Exception e) {
                System.out.println("is.reset(): Failed");
            }
            try {
                player = Manager.createPlayer((InputStream)is, (String)ctype);
            }
            catch (Exception e) {
                System.out.println("Failed to create player");
                this.free(player);
            }
        }
        return player;
    }

    private static String guessContentType(String url) {
        String ctype = "";
        if (url.endsWith("mp3")) {
            ctype = "audio/mpeg";
        } else if (url.endsWith("mid")) {
            ctype = "audio/midi";
        } else if (url.endsWith("au")) {
            ctype = "audio/basic";
        } else if (url.endsWith("wav")) {
            ctype = "audio/x-wav";
        } else if (url.endsWith("jts")) {
            ctype = "audio/x-tone-seq";
        } else if (url.endsWith("mpeg")) {
            ctype = "video/mpeg";
        } else if (url.endsWith("gif")) {
            ctype = "image/gif";
        } else {
            System.out.println("Cannot guess content type from URL: " + url);
        }
        return ctype;
    }

    private void free(Player player) {
        if (player != null) {
            try {
                if (player.getState() == 400) {
                    player.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (player.getState() == 300) {
                    player.deallocate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (player.getState() == 200 || player.getState() == 100) {
                    player.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player = null;
    }

    public void playWav(int id, boolean loop) {
        if (this.mute) {
            return;
        }
        this.free(this.wavPlayer);
        this.wavPlayer = this.Init(this.wavurl[id]);
        if (this.wavPlayer != null) {
            if (loop) {
                this.wavPlayer.setLoopCount(-1);
            }
            try {
                this.wavPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void playMidi(int id) {
        if (this.mute || this.currtrack == id) {
            return;
        }
        this.free(this.midiPlayer);
        this.midiPlayer = this.Init(this.midiurl[id]);
        if (this.midiPlayer != null) {
            this.midiPlayer.setLoopCount(-1);
            try {
                this.midiPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currtrack = id;
        }
    }

    public void stopWav() {
        if (this.wavPlayer != null) {
            try {
                if (this.wavPlayer.getState() == 400) {
                    this.wavPlayer.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopMidi() {
        if (this.midiPlayer != null) {
            try {
                if (this.midiPlayer.getState() == 400) {
                    this.midiPlayer.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setPosition(Player player, int pos) {
        if (player != null) {
            try {
                player.setMediaTime((long)pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        this.free(this.midiPlayer);
        this.free(this.wavPlayer);
    }

    public void stopAllSounds() {
        this.currtrack = -1;
        this.stopWav();
        this.stopMidi();
    }

    public void mute(boolean m) {
        this.mute = m;
        if (m) {
            this.stopAllSounds();
        }
    }

    public boolean isMute() {
        return this.mute;
    }

    public void PlayNote(int note, int vol) {
        if (this.mute) {
            return;
        }
        try {
            Manager.playTone((int)note, (int)100, (int)vol);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

