/*
 * Decompiled with CFR 0.152.
 */
package com.boragame.utils.j2me.nokias60;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    private Player[] players = null;
    private int currentIndex = -1;
    private int currentLoopCount = 0;
    private int volumeLevel = 50;
    private long currentMediaTime = -1L;
    private boolean isOn = true;

    public SoundPlayer(int n) {
        this.players = new Player[n];
    }

    private void checkIndex(int n) throws Exception {
        if (this.players == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n >= this.players.length) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
    }

    public void setSoundData(int n, String string) throws Exception {
        this.checkIndex(n);
        if (this.players[n] != null) {
            this.players[n].close();
            this.players[n] = null;
            System.gc();
        }
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        this.players[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
        this.players[n].prefetch();
    }

    public void setSoundData(int n, byte[] byArray, int n2, int n3) throws Exception {
        this.checkIndex(n);
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.players[n] != null) {
            this.players[n].close();
            this.players[n] = null;
            System.gc();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, n3);
        this.players[n] = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
        this.players[n].prefetch();
    }

    public void stopSound() throws Exception {
        if (this.currentIndex == -1) {
            return;
        }
        this.checkIndex(this.currentIndex);
        if (this.players[this.currentIndex] == null) {
            this.currentIndex = -1;
            this.currentMediaTime = -1L;
            return;
        }
        if (this.players[this.currentIndex].getState() == 400) {
            this.players[this.currentIndex].stop();
        }
        this.currentIndex = -1;
        this.currentMediaTime = -1L;
    }

    public void playSound(int n, int n2) throws Exception {
        if (!this.isOn) {
            return;
        }
        this.checkIndex(n);
        if (n2 == 0) {
            return;
        }
        if (this.players[n] == null) {
            throw new NullPointerException();
        }
        if (n == this.currentIndex) {
            if (this.players[n].getState() == 400) {
                return;
            }
        } else {
            this.stopSound();
        }
        this.players[n].setLoopCount(n2);
        if (this.currentMediaTime == -1L) {
            this.players[n].setMediaTime(0L);
        } else {
            this.players[n].setMediaTime(this.currentMediaTime);
        }
        VolumeControl volumeControl = (VolumeControl)this.players[n].getControl("VolumeControl");
        volumeControl.setLevel(this.volumeLevel);
        this.players[n].start();
        this.currentIndex = n;
        this.currentLoopCount = n2;
        this.currentMediaTime = -1L;
    }

    public void pauseSound() throws Exception {
        if (this.currentIndex == -1) {
            return;
        }
        this.checkIndex(this.currentIndex);
        if (this.players[this.currentIndex] == null) {
            return;
        }
        if (this.players[this.currentIndex].getState() == 400) {
            this.currentMediaTime = this.players[this.currentIndex].getMediaTime();
            this.players[this.currentIndex].stop();
        }
    }

    public void resumeSound() throws Exception {
        if (!this.isOn) {
            return;
        }
        if (this.currentIndex == -1 || this.currentMediaTime == -1L) {
            return;
        }
        this.playSound(this.currentIndex, this.currentLoopCount);
    }

    public void setSoundOn(boolean bl) throws Exception {
        this.isOn = bl;
        if (!bl) {
            this.stopSound();
        }
    }

    public boolean isSoundOn() {
        return this.isOn;
    }

    public void setVolume(int n) throws Exception {
        if (n < 0) {
            n = 0;
        }
        if (n > 100) {
            n = 100;
        }
        this.volumeLevel = n;
        if (this.currentIndex == -1) {
            return;
        }
        this.checkIndex(this.currentIndex);
        if (this.players[this.currentIndex] == null) {
            return;
        }
        if (this.players[this.currentIndex].getState() == 400) {
            VolumeControl volumeControl = (VolumeControl)this.players[this.currentIndex].getControl("VolumeControl");
            volumeControl.setLevel(n);
        }
    }

    public int getVolume() {
        return this.volumeLevel;
    }

    public void close() {
        if (this.players == null) {
            return;
        }
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null) continue;
            this.players[i].close();
            this.players[i] = null;
        }
        this.players = null;
        System.gc();
    }
}

