/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.party;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.Game;
import fi.darkwood.Player;
import fi.darkwood.Thing;
import fi.darkwood.ability.AbilityVisualEffect;
import fi.darkwood.network.CharacterSerializer;
import fi.darkwood.party.BluetoothConnector;
import fi.darkwood.party.BluetoothListener;
import fi.darkwood.room.Room;
import fi.darkwood.ui.component.MessageLog;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.ServiceRecord;
import nanoxml.kXMLElement;

public class Party {
    public Vector clientlist = new Vector();
    public Vector members = new Vector();
    public Game game;
    private boolean a = false;
    private boolean b = true;
    public boolean isLeader = false;
    public BluetoothConnector connectionToLeader;

    public void createParty(boolean bl, ServiceRecord serviceRecord) {
        this.cleanParty();
        if (this.isActive()) {
            System.out.println("ERROR: Party is already active!!!");
            return;
        }
        if (bl) {
            this.clientlist.addElement(new BluetoothListener(this));
            this.members.addElement(Game.player);
            this.setActive(true);
        } else {
            this.connectionToLeader = new BluetoothConnector(this, serviceRecord);
        }
        this.isLeader = bl;
    }

    public void finalizeParty() {
        if (!this.isLeader) {
            return;
        }
        Enumeration enumeration = this.clientlist.elements();
        while (enumeration.hasMoreElements()) {
            BluetoothListener bluetoothListener = (BluetoothListener)enumeration.nextElement();
            if (bluetoothListener.isConnected()) continue;
            bluetoothListener.closeListener();
            this.clientlist.removeElement(bluetoothListener);
        }
        if (this.clientlist.isEmpty()) {
            this.a = false;
            System.out.println("No members in party, setting active=false.");
        }
    }

    public void leaveParty() {
        Object object;
        Enumeration enumeration;
        if (!this.isActive()) {
            return;
        }
        System.out.println("Leaving party..");
        if (this.isLeader) {
            enumeration = this;
            ((Party)((Object)enumeration)).sendToAll("disband");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                enumeration = interruptedException;
                interruptedException.printStackTrace();
            }
            enumeration = this.clientlist.elements();
            while (enumeration.hasMoreElements()) {
                object = (BluetoothListener)enumeration.nextElement();
                ((BluetoothListener)object).closeListener();
                this.clientlist.removeElement(object);
            }
        } else {
            this.connectionToLeader.send("Leave:" + Game.player.getId());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                enumeration = interruptedException;
                interruptedException.printStackTrace();
            }
            this.connectionToLeader.closeConnector();
        }
        enumeration = this.members.elements();
        while (enumeration.hasMoreElements()) {
            object = (Player)enumeration.nextElement();
            if (object == Game.player) continue;
            Game.player.room.removeThing((Thing)object);
        }
        this.cleanParty();
        this.setActive(false);
        MessageLog.getInstance().addMessage("You left the party.");
    }

    public void memberLeftParty(int n, BluetoothListener bluetoothListener) {
        Object object;
        Enumeration enumeration = this.clientlist.elements();
        while (enumeration.hasMoreElements()) {
            object = (BluetoothListener)enumeration.nextElement();
            if (!object.equals(bluetoothListener)) continue;
            ((BluetoothListener)object).closeListener();
            this.clientlist.removeElement(bluetoothListener);
        }
        object = this.getMemberById(n);
        if (object == null) {
            System.out.println("Could not find party member with id " + n + " to remove!!");
            return;
        }
        this.members.removeElement(object);
        if (Game.player.room.getPlayers().contains(object)) {
            Game.player.room.removeThing((Thing)object);
        }
        MessageLog.getInstance().addMessage(((Player)object).name + " left the party.");
        if (this.clientlist.isEmpty()) {
            this.a = false;
            return;
        }
        this.syncParty();
    }

    public Player getMemberById(int n) {
        Enumeration enumeration = this.members.elements();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            if (player.getId() != n) continue;
            return player;
        }
        return null;
    }

    public void sendToAll(String string) {
        if (this.isActive() && this.isLeader) {
            Enumeration enumeration = this.clientlist.elements();
            while (enumeration.hasMoreElements()) {
                BluetoothListener bluetoothListener = (BluetoothListener)enumeration.nextElement();
                if (!bluetoothListener.isConnected()) continue;
                bluetoothListener.send(string);
            }
        }
    }

    public void readCommands() {
        if (this.isActive() && this.isLeader) {
            Enumeration enumeration = this.clientlist.elements();
            while (enumeration.hasMoreElements()) {
                BluetoothListener bluetoothListener = (BluetoothListener)enumeration.nextElement();
                if (!bluetoothListener.isConnected()) continue;
                bluetoothListener.readMessages();
            }
            return;
        }
        if (this.isActive() && !this.isLeader) {
            this.connectionToLeader.readMessages();
        }
    }

    public void sendAbilityUseToLeader(int n, Ability ability) {
        this.connectionToLeader.send("invoke:" + n + "/" + ability.getClass().getName() + "," + ability.getLevel());
    }

    public void sendVisualEffect(int n, AbilityVisualEffect abilityVisualEffect) {
        this.sendToAll("effect:" + n + "," + abilityVisualEffect.getImageFile() + "," + abilityVisualEffect.getOriginalDuration() + "," + abilityVisualEffect.frameWidth);
    }

    public void cleanParty() {
        System.out.println("Removing all party members, size before remove:" + this.members.size());
        this.members.removeAllElements();
    }

    public void syncParty() {
        this.sendToAll("cleanParty");
        Enumeration enumeration = this.members.elements();
        while (enumeration.hasMoreElements()) {
            Player player = (Player)enumeration.nextElement();
            this.sendToAll(player.sendInformation());
        }
    }

    public void addPartyMember(String object, int n) {
        System.out.println("Adding party member with id: " + n);
        kXMLElement kXMLElement2 = new kXMLElement();
        kXMLElement2.parseString((String)object);
        object = CharacterSerializer.loadCharacter(kXMLElement2, n);
        if (n == Game.player.getId()) {
            this.members.addElement(Game.player);
            return;
        }
        this.members.addElement(object);
        Game.player.room.addThing((Thing)object);
    }

    public void moveParty(Room room) {
        this.movePartyLocally(room);
        this.sendToAll("move:" + Game.player.room.getId());
    }

    public void movePartyLocally(Room room) {
        if (!this.isActive()) {
            return;
        }
        Enumeration enumeration = this.members.elements();
        while (enumeration.hasMoreElements()) {
            Creature creature = (Creature)enumeration.nextElement();
            creature.moveTo(room.getId(), room.getZone());
            creature.resetCoolDowns();
            creature = (Player)creature;
            ((Player)creature).rest();
        }
    }

    public void fallback() {
        if (this.isLeader) {
            this.sendToAll("fallback");
            return;
        }
        this.leaveParty();
    }

    public void initZoneForClients(String string, String string2) {
        System.out.println("Sending area init to members: " + string + ", " + string2);
        this.sendToAll("initzone:" + string + "," + string2);
    }

    public void initCityForClients(String string) {
        System.out.println("Sending city init to members: " + string);
        this.sendToAll("initcity:" + string);
    }

    public void sendAbilityUseToClients(String string) {
        this.sendToAll("message:" + string);
    }

    public void setActive(boolean bl) {
        this.a = bl;
    }

    public boolean isActive() {
        return this.a;
    }

    public boolean getBluetoothAvailable() {
        return this.b;
    }

    public void setBluetoothAvailable(boolean bl) {
        this.b = bl;
    }
}

