/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.ui.view;

import fi.darkwood.Chest;
import fi.darkwood.DarkwoodGraphics;
import fi.darkwood.Equipment;
import fi.darkwood.Game;
import fi.darkwood.Item;
import fi.darkwood.Logger;
import fi.darkwood.Monster;
import fi.darkwood.Player;
import fi.darkwood.Thing;
import fi.darkwood.UsableThing;
import fi.darkwood.Zone;
import fi.darkwood.room.Room;
import fi.darkwood.ui.component.AreaBackground;
import fi.darkwood.ui.component.Common;
import fi.darkwood.ui.component.Expbar;
import fi.darkwood.ui.component.MessageLog;
import fi.darkwood.ui.view.ViewAndControls;
import fi.darkwood.util.Font;
import fi.darkwood.util.Utils;
import fi.mirake.SoundPlayer;
import java.util.Enumeration;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MovementView
extends ViewAndControls {
    private MessageLog a;
    private Utils a;
    private Game a;
    private Expbar a;
    private Player a;
    private Monster a;
    private Sprite a;
    private Image a;
    private AreaBackground a;
    private boolean a;
    private Chest a = null;

    public MovementView(Game game, int n, int n2) {
        super(n, n2);
        this.a = game;
        this.a = Expbar.getInstance();
        this.a = AreaBackground.getInstance();
    }

    public void updateScreen(DarkwoodGraphics darkwoodGraphics) {
        Thing thing;
        this.a = "Leave";
        this.b = "";
        this.a = this.a.getImage(Game.player.room.zone.getBackground());
        this.a.drawBackground(darkwoodGraphics, Game.player);
        this.a = this.a.getImage("/images/ui/frames_shop.png");
        darkwoodGraphics.drawImage(this.a, 0, 0, 0);
        this.a.drawBar(darkwoodGraphics, Game.player);
        Common.drawStatus(darkwoodGraphics, Game.player);
        this.a.drawMessageLog(darkwoodGraphics);
        Enumeration enumeration = Game.player.room.getThings().elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            int n3;
            Thing thing2;
            thing = (Thing)enumeration.nextElement();
            this.a = this.a.getImage(thing.image);
            if (thing instanceof Chest) {
                thing2 = (Chest)thing;
                darkwoodGraphics.drawImage(this.a, 150, 162, 36);
                this.b = ((Chest)thing2).isOpen() || this.a ? "" : "Open";
            }
            if (thing instanceof UsableThing) {
                thing2 = (UsableThing)thing;
                this.a = thing.getSprite();
                if (this.a == null) {
                    darkwoodGraphics.drawImage(this.a, 100, 162, 36);
                } else {
                    this.a = thing.getSprite();
                    darkwoodGraphics.defineReferencePixel(this.a, 0, this.a.getHeight());
                    darkwoodGraphics.setRefPixelPosition(this.a, 100, 162);
                    this.a.paint(darkwoodGraphics.getGraphics());
                    this.a.nextFrame();
                }
                this.b = ((UsableThing)thing2).isUsed() ? ((UsableThing)thing2).queryUsedText() : ((UsableThing)thing2).queryUnusedText();
            }
            if (thing instanceof Player) {
                this.a = (Player)thing;
                int n4 = 1;
                if (Game.party.isActive()) {
                    n4 = Game.party.members.size();
                }
                n3 = (n4 - n2 - 1) * 25;
                Common.drawPlayer(this.a, darkwoodGraphics, n3, 160);
                Common.drawEquipmentPaperDoll(this.a, this.a.getSprite().getFrame(), darkwoodGraphics, n3, 160, this.a);
                this.a.getSprite().nextFrame();
                ++n2;
                darkwoodGraphics.setColor(255);
                if (thing != Game.player) {
                    darkwoodGraphics.drawText(thing.name, n3 + 2, 95, DarkwoodGraphics.FONT_ARIAL10_LIGHTBLUE);
                }
                if (Game.player.health > 10) {
                    darkwoodGraphics.setColor(65280);
                } else {
                    darkwoodGraphics.setColor(0xFF0000);
                }
                darkwoodGraphics.fillRect(n3 + 2, 162, this.a.health * 23 / this.a.maxHealth, 2);
                darkwoodGraphics.setColor(0x6060FF);
                darkwoodGraphics.fillRect(n3 + 2, 164, this.a.mana * 23 / this.a.maxMana, 2);
            }
            if (!(thing instanceof Monster)) continue;
            this.a = (Monster)thing;
            int n5 = 98 + n * 22;
            n3 = this.a.getFrameWidth();
            if (n3 == 0) {
                n3 = this.a.getWidth();
            }
            this.a = this.a.getImage("/images/grave/grave1.png");
            darkwoodGraphics.drawImage(this.a, n5 + n3 / 2 - this.a.getWidth() / 2, 160, 36);
            ++n;
        }
        darkwoodGraphics.setColor(0xFFFFFF);
        if (Game.player.room.getNorth() != null) {
            darkwoodGraphics.drawString("/\\", 88, 40, 0);
            darkwoodGraphics.drawString(Game.player.room.getNorth().getPath(), 83, 51, 0);
        }
        if (Game.player.room.getSouth() != null) {
            darkwoodGraphics.drawString("\\/", 88, 143, 0);
            darkwoodGraphics.drawString(Game.player.room.getSouth().getPath(), 83, 133, 0);
        }
        if (Game.player.room.getEast() != null) {
            darkwoodGraphics.drawText(Game.player.room.getPath() + "", 78, 168, DarkwoodGraphics.FONT_ANTIQUA10_WHITE_BOLD);
            this.a = this.a.getImage("/images/ui/simple_arrow.png");
            darkwoodGraphics.drawImage(this.a, 83, 188, 0);
        }
        if (this.a) {
            Equipment equipment;
            this.a = this.a.getImage("/images/ui/city_pergament_bg.png");
            darkwoodGraphics.drawImage(this.a, 10, 30, 0);
            darkwoodGraphics.drawText("Choose your reward:", 15, 35, DarkwoodGraphics.FONT_ARIAL10_BLACK);
            darkwoodGraphics.drawText(this.a.getMoney() + " Gold", 15, 45);
            darkwoodGraphics.drawText("OR", 20, 55, DarkwoodGraphics.FONT_ARIAL10_BLACK);
            thing = this.a.getEquipment();
            this.a = this.a.getImage(((Equipment)thing).image);
            darkwoodGraphics.drawImage(this.a, 15, 65, 0);
            Font font = DarkwoodGraphics.FONT_ARIAL10_BLACK;
            if (((Equipment)thing).quality == 1) {
                font = DarkwoodGraphics.FONT_ARIAL10_DARKGREEN;
            }
            if (((Equipment)thing).quality == 2) {
                font = DarkwoodGraphics.FONT_ARIAL10_LIGHTBLUE;
            }
            darkwoodGraphics.drawText(((Equipment)thing).description + "", 35, 67, font);
            darkwoodGraphics.drawText("Level: " + ((Item)thing).getLevel() + " " + ((Equipment)thing).getItemInfo(), 15, 80, DarkwoodGraphics.FONT_ARIAL10_BLACK);
            if (((Item)thing).getLevel() - 3 > Game.player.level) {
                darkwoodGraphics.drawText("(INSUFFICIENT LEVEL)", 38, 55, DarkwoodGraphics.FONT_ARIAL10_RED);
            }
            if ((equipment = Game.player.equipmentSlots[((Equipment)thing).getSlot()]) != null) {
                darkwoodGraphics.drawText("Current item to be replaced:", 15, 95);
                this.a = this.a.getImage(equipment.image);
                darkwoodGraphics.drawImage(this.a, 15, 105, 0);
                font = DarkwoodGraphics.FONT_ARIAL10_BLACK;
                if (equipment.quality == 1) {
                    font = DarkwoodGraphics.FONT_ARIAL10_DARKGREEN;
                }
                if (equipment.quality == 2) {
                    font = DarkwoodGraphics.FONT_ARIAL10_LIGHTBLUE;
                }
                darkwoodGraphics.drawText(equipment.description + "", 35, 107, font);
                darkwoodGraphics.drawText("Level: " + equipment.getLevel() + " " + equipment.getItemInfo(), 15, 120, DarkwoodGraphics.FONT_ARIAL10_BLACK);
            }
            this.a = "Gold";
            this.b = "Item";
        }
        super.a(darkwoodGraphics);
    }

    public void move(Room room) {
        if (room == null) {
            return;
        }
        if (Game.party.isActive() && Game.party.isLeader) {
            Game.party.moveParty(room);
            return;
        }
        if (!Game.party.isActive()) {
            Game.player.moveTo(room.getId(), room.getZone());
            Game.player.rest();
            Game.player.resetCoolDowns();
            return;
        }
        MessageLog.getInstance().addMessage("You are not the leader.");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkInput(int n) {
        if (this.a) {
            int n2 = n;
            MovementView movementView = this;
            if (n2 == -6) {
                Game.player.addMoney(movementView.a.getMoney());
                MessageLog.getInstance().addMessage("You get " + movementView.a.getMoney() + " gold!");
                movementView.a = false;
                movementView.a.setOpen(true);
                return;
            }
            if (n2 != -7) return;
            Equipment equipment = movementView.a.getEquipment();
            if (equipment.getLevel() - 3 > Game.player.level) {
                MessageLog.getInstance().addMessage("Cannot wear " + movementView.a.getEquipment().name + "!");
                return;
            }
            Game.player.equip(equipment);
            MessageLog.getInstance().addMessage("Started using " + movementView.a.getEquipment().name + "!");
            movementView.a = false;
            movementView.a.setOpen(true);
            return;
        }
        if (n == 64) {
            this.move(Game.player.room.getSouth());
            return;
        }
        if (n == 2) {
            this.move(Game.player.room.getNorth());
            return;
        }
        if (n == 32) {
            this.move(Game.player.room.getEast());
            return;
        }
        if (n == 8) {
            this.move(Game.player.room.getEast());
            return;
        }
        if (n == 4) return;
        if (n == 512) {
            Game.showConsole = true;
            return;
        }
        if (n == -6) {
            Zone zone = Utils.getZoneForClassName(Game.player.room.getZone().getFallbackZone());
            Room room = (Room)zone.rooms.elementAt(0);
            if (Game.party.isActive()) {
                Game.party.movePartyLocally(room);
                Game.party.fallback();
                SoundPlayer.playCityMusic();
                return;
            }
            Game.player.moveTo(0, zone);
            SoundPlayer.playCityMusic();
            return;
        }
        if (n != -7) {
            if (n == 1024) {
                System.out.println("Starting party..");
                Logger.getInstance().debug("Starting party..");
                return;
            }
            if (n != 2048) return;
            Logger.getInstance().debug("Connecting to party leader..");
            System.out.println("Connecting to party leader..");
            return;
        }
        n = 0;
        Enumeration enumeration = Game.player.room.getThings().elements();
        Logger.getInstance().debug("Trying to open a chest.");
        while (true) {
            if (!enumeration.hasMoreElements()) {
                if (n != 0) return;
                System.out.println("No chest here.");
                return;
            }
            Thing thing = (Thing)enumeration.nextElement();
            if (thing instanceof Chest) {
                Chest chest = (Chest)thing;
                if (!chest.isOpen()) {
                    if (chest.getEquipment() != null) {
                        this.a = true;
                        this.a = chest;
                    } else {
                        chest.setOpen(true);
                        Game.player.addMoney(chest.getMoney());
                        MessageLog.getInstance().addMessage("You get " + chest.getMoney() + " gold!");
                    }
                }
                n = 1;
            }
            if (!(thing instanceof UsableThing)) continue;
            UsableThing usableThing = (UsableThing)thing;
            if (!usableThing.isUsed()) {
                usableThing.useThing();
            }
            n = 1;
        }
    }

    public void pointerReleasedEvent(int n, int n2) {
        if (n > 60 && n < 115 && n2 > 110) {
            this.checkInput(32);
        }
    }

    public void pointerPressedEvent(int n, int n2) {
    }
}

