/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.ability;

import fi.darkwood.Ability;
import fi.darkwood.Creature;
import fi.darkwood.Game;
import fi.darkwood.Monster;
import fi.darkwood.Player;
import fi.darkwood.ui.component.MessageLog;
import java.util.Enumeration;
import java.util.Random;

public abstract class DirectDamageAbility
extends Ability {
    public int test;

    public DirectDamageAbility(String string, String string2, int n) {
        super(string, string2, n);
    }

    public abstract int getAbilityRank();

    public boolean effect(Creature creature) {
        Creature creature2 = null;
        Creature creature3 = creature;
        Enumeration enumeration = Game.player.room.getCreatures().elements();
        while (enumeration.hasMoreElements()) {
            Creature creature4 = (Creature)enumeration.nextElement();
            if (!(creature4 instanceof Monster) || !creature4.isAlive()) continue;
            creature2 = creature4;
            break;
        }
        if (!creature3.isReadyToAct(this.getAbilitySlot())) {
            return false;
        }
        if (creature2 == null) {
            System.out.println("No target for strike!");
            return false;
        }
        if (creature3.mana < this.getManaCost(creature3, creature2)) {
            if (creature.getId() == Game.player.getId()) {
                MessageLog.getInstance().addMessage("Not enough energy!");
            }
            return false;
        }
        creature3.addAbilityCooldown(this.getCooldownInRounds(), this.getAbilitySlot());
        int n = this.getDamage(creature3, creature2);
        if (creature3 instanceof Player) {
            creature = (Player)creature3;
            ((Player)creature).setAbilityInvokeAnimationFrameSequence();
        }
        creature3.reduceMana(this.getManaCost(creature3, creature2));
        if (n < 0) {
            n = 0;
        }
        creature2.harm(n, true);
        creature2.addAbilityEffect(this.getTargetVisualEffect());
        Game.party.sendVisualEffect(creature2.getId(), this.getTargetVisualEffect());
        if (this.getSelfVisualEffect() != null) {
            creature3.addAbilityEffect(this.getSelfVisualEffect());
            Game.party.sendVisualEffect(creature3.getId(), this.getSelfVisualEffect());
        }
        return true;
    }

    public String getDescription() {
        Player player = Game.player;
        return "Inflicts around " + this.getDamage(player, player) + " damage to one opponent for " + this.getManaCost(player, player) + " mana.";
    }

    public abstract int getDamage(Creature var1, Creature var2);

    public abstract int getManaCost(Creature var1, Creature var2);

    public abstract double getCooldownInRounds();

    static {
        new Random(System.currentTimeMillis());
    }
}

