/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood.level.four;

import fi.darkwood.EquipmentFactory;
import fi.darkwood.Game;
import fi.darkwood.GameConstants;
import fi.darkwood.Potion;
import fi.darkwood.Zone;
import fi.darkwood.level.five.quest.QuestKillBarbarianBoss;
import fi.darkwood.level.four.quest.QuestKillSpiders;
import fi.darkwood.room.CityRoom;
import fi.darkwood.room.MapRoom;
import fi.darkwood.room.Room;
import fi.darkwood.room.RoomFactory;
import fi.darkwood.room.ShopRoom;

public class MountainPassCityZone
extends Zone {
    private RoomFactory a;
    public MapRoom maproom;

    public MountainPassCityZone() {
        super("Mountain pass", "/images/background/tier4/mountain_pass.png");
        this.firstQuest = new QuestKillSpiders();
        this.allQuestsDoneMessage = Game.player.completedQuests.contains(new QuestKillBarbarianBoss()) ? "The queen has left a message that you are to venture over the mountains, towards the great desert to the east." : "The queen has sent an urgent message that the barbarians have attacked the Kingdom from the north. You are to go there and fight this horde.";
        this.a = new RoomFactory();
        Room room = (CityRoom)this.a.constructCityEntrance(this, "center", "/images/background/tier4/mountain_pass.png");
        ((CityRoom)room).setSpriteImage("/images/background/tier4/Mountain pass girl 13x16 6 frames.png", 13, 113, 115);
        ((CityRoom)room).setSpriteFrameTime(new int[]{10, 2, 10, 2, 10, 2});
        this.maproom = (MapRoom)this.a.constructMapRoomSouth(this, this.entrance, "Map");
        this.maproom.setCoordinates(401, 289, "/images/map/icons/mountain pass.png");
        this.a.constructStatRoomNorth(this, this.entrance, "Trainer", "trainer");
        this.a.constructTavernRoomEast(this, this.entrance, "Tavern", "tavern");
        room = this.a.constructShopRoomWest(this, this.entrance, "Smithy", "shop");
        ((ShopRoom)room).setWelcomeText("Welcome to the Mountain Pass town smithy. Here you may buy new equipment and replenish potions.");
        int n = GameConstants.getArmorTypeforClass(Game.player.characterClass);
        EquipmentFactory equipmentFactory = EquipmentFactory.getInstance();
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(15, 1, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(18, 1, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(19, 1, n, 2));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(16, 2, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(19, 2, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(16, 3, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(16, 0, n, 1));
        ((ShopRoom)room).addItem(equipmentFactory.createEquipment(19, 0, n, 1));
        ((ShopRoom)room).addItem(new Potion());
    }

    public void resetZone() {
        this.maproom.zones.removeAllElements();
        this.maproom.addZone("/fi/darkwood/level/four/Mine.xml", 430, 245, this.getClass().getName(), "/images/map/icons/dungeon (castle).png");
        if (Game.player.completedQuests.contains(new QuestKillBarbarianBoss())) {
            this.maproom.addZone("/fi/darkwood/level/four/RoadToExpeditionCamp.xml", 547, 299, this.getClass().getName(), "/images/map/icons/expedition camp.png");
        }
        this.maproom.addZone("/fi/darkwood/level/four/SpiderCave.xml", 430, 334, this.getClass().getName(), "/images/map/icons/caves.png");
        this.maproom.addZone("/fi/darkwood/level/four/PartyMines.xml", 408, 373, this.getClass().getName(), "/images/map/icons/dungeon (castle).png");
        this.maproom.addZone("/fi/darkwood/level/four/RoadToCapital.xml", 319, 391, this.getClass().getName(), "/images/map/icons/city capital.png");
        this.maproom.addZone("/fi/darkwood/level/four/RoadToSnowKeep.xml", 306, 261, this.getClass().getName(), "/images/map/icons/snow_keep.png");
    }

    public String getDescription() {
        return "Mountain pass";
    }
}

