/*
 * Decompiled with CFR 0.152.
 */
package fi.darkwood;

import fi.darkwood.Buff;
import fi.darkwood.DarkwoodGraphics;
import fi.darkwood.Game;
import fi.darkwood.GameConstants;
import fi.darkwood.Monster;
import fi.darkwood.Player;
import fi.darkwood.Thing;
import fi.darkwood.Zone;
import fi.darkwood.ability.AbilityVisualEffect;
import fi.darkwood.room.CityRoom;
import fi.darkwood.room.Room;
import fi.darkwood.room.ShopRoom;
import fi.darkwood.room.StatRoom;
import fi.darkwood.ui.component.CombatText;
import fi.darkwood.ui.component.MessageLog;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class Creature
extends Thing {
    public static final int[] CREATURE_TYPE_FLAGS = new int[]{1, 2, 4, 8, 16};
    public static final int ANIMAL = 0;
    public static final int UNDEAD = 1;
    public static final int HUMANOID = 2;
    public static final int DEMON = 3;
    public static final int CONSTRUCT = 4;
    public int creatureType = 0;
    public Random random;
    public int level;
    public int health;
    public int maxHealth;
    public boolean dead;
    public int mana;
    public int maxMana;
    public int strength;
    public int dexterity;
    public int constitution;
    public int willpower;
    public int stunRounds;
    public int[] abilityCooldowns = new int[4];
    public double attackCoolDownRounds;
    private int a;
    public int framesLeftToResetAnimation = 0;
    public int frameOffset = 0;
    public int experience;
    public int money;
    public int armorClass;
    public Vector textEvents = new Vector();
    public Vector graphicsEffects = new Vector();
    public Vector buffs = new Vector();
    private float a;
    private int c = 10;
    private int d = 0;
    private Enumeration a;
    private Buff a = 0.0f;

    public Creature(String string, String string2, int n, int n2) {
        super(string, string2, n2);
        this.level = n;
        this.random = new Random(System.currentTimeMillis());
        this.a = 0.0f;
    }

    public void setCreatureType(int n) {
        this.creatureType |= CREATURE_TYPE_FLAGS[n];
    }

    public boolean isType(int n) {
        return (this.creatureType & CREATURE_TYPE_FLAGS[n]) != 0;
    }

    public double getPersonalAttackCooldown() {
        return 15.0 - (double)this.dexterity * 0.02;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    public boolean isStunned() {
        return this.stunRounds > 0;
    }

    public int getAbilityCooldown(int n) {
        return this.abilityCooldowns[n];
    }

    public boolean isReadyToAct(int n) {
        return this.abilityCooldowns[n] <= 0 && this.stunRounds <= 0 && this.isAlive();
    }

    public boolean isReadyToAttack() {
        return this.attackCoolDownRounds <= 0.0 && this.stunRounds <= 0 && this.isAlive();
    }

    public void regen() {
        --this.c;
        if (this.c > 0) {
            return;
        }
        this.c = 10;
        if (this.health < this.maxHealth) {
            this.health += this.maxHealth / 50;
            if (this.health > this.maxHealth) {
                this.health = this.maxHealth;
            }
        }
        if (this.mana < this.maxMana) {
            this.mana += this.maxMana / 25;
            if (this.mana > this.maxMana) {
                this.mana = this.maxMana;
            }
        }
        if (this.dead && this.health > 0) {
            this.dead = false;
        }
    }

    public void addHealthChange(String string) {
        this.textEvents.addElement(new CombatText(this, string, System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10));
    }

    public void addAbilityEffect(AbilityVisualEffect abilityVisualEffect) {
        abilityVisualEffect.reset();
        this.graphicsEffects.addElement(abilityVisualEffect);
    }

    public void reduceMana(int n) {
        this.mana -= n;
        Game.party.sendToAll("reducemana:" + this.getId() + "/" + n);
    }

    public void harm(int n) {
        this.harm(n, false);
    }

    public void harm(int n, boolean bl) {
        this.health -= n;
        if (this.health < 0) {
            this.bury();
        }
        if (!bl) {
            this.textEvents.addElement(new CombatText(this, n + "", System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10));
        } else {
            this.textEvents.addElement(new CombatText(this, n + "", System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10_YELLOW));
        }
        Game.party.sendToAll("damage:" + this.getId() + "/" + n);
    }

    public int harm(float f) {
        int n = (int)f;
        this.a += f - (float)n;
        if (this.a > 1.0f) {
            ++n;
            this.a -= 1.0f;
        }
        this.harm(n);
        return n;
    }

    public void heal(int n) {
        if (this.dead && !(this instanceof Player)) {
            return;
        }
        this.health += n;
        if (this.health > this.maxHealth) {
            this.health = this.maxHealth;
        }
        this.textEvents.addElement(new CombatText(this, "Healed " + n + "!", System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10_GREEN));
        Game.party.sendToAll("heal:" + this.getId() + "/" + n);
        if (this.dead && this instanceof Player && this.health > 0) {
            this.dead = false;
            this.textEvents.addElement(new CombatText(this, "Revived!", System.currentTimeMillis(), DarkwoodGraphics.FONT_ARIAL10_GREEN));
        }
    }

    public void stun(int n) {
        this.stunRounds += n;
    }

    public void addMoney(int n) {
        this.money += n;
    }

    public void bury() {
        Enumeration enumeration = this.room.getCreatures().elements();
        while (enumeration.hasMoreElements()) {
            Creature creature = (Creature)enumeration.nextElement();
            if (creature == this || !this.isHostile(creature)) continue;
            creature.awardKill(this);
        }
        this.dead = true;
    }

    public void moveTo(int n, Zone object) {
        Object object2 = this.room;
        ((Room)object2).removeThing(this);
        Object object3 = (Room)((Zone)object).rooms.elementAt(n);
        ((Room)object3).addThing(this);
        if (this != Game.player) {
            return;
        }
        object3 = MessageLog.getInstance();
        object = this.room.getCreatures().elements();
        while (object.hasMoreElements()) {
            object2 = (Creature)object.nextElement();
            if (object2 == this || !this.isHostile((Creature)object2) || !((Creature)object2).isAlive()) continue;
            String string = "You encounter " + ((Creature)object2).name + " [" + ((Creature)object2).level + "]";
            if (object2 instanceof Monster && ((Monster)object2).isElite()) {
                string = string + " (elite)";
            }
            ((MessageLog)object3).addMessage(string);
            System.out.println(((Creature)object2).name + " id: " + ((Creature)object2).getId());
        }
    }

    public boolean isHostileInRoom() {
        Enumeration enumeration = this.room.getCreatures().elements();
        while (enumeration.hasMoreElements()) {
            Creature creature = (Creature)enumeration.nextElement();
            if (creature == this || !this.isHostile(creature) || !creature.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void addAbilityCooldown(double d, int n) {
        int n2 = (int)(d * 15.0);
        int n3 = n;
        this.abilityCooldowns[n3] = this.abilityCooldowns[n3] + n2;
        Game.party.sendToAll("actioncooldown:" + this.getId() + "/" + (int)d + "," + n);
    }

    public void addAttackCoolDown(double d) {
        this.attackCoolDownRounds += d;
    }

    public void setFramesLeftToResetAnimation(int n) {
        this.framesLeftToResetAnimation = n;
    }

    public void setFrameOffset(int n) {
        this.frameOffset = n;
    }

    public int getDefense() {
        return 0;
    }

    public double getDamage() {
        return 0.0;
    }

    public int getExperienceWorth() {
        Monster monster;
        int n = 10 * this.level;
        if (this instanceof Monster && (monster = (Monster)this).isElite()) {
            n = (int)((double)n * 1.5);
        }
        return n;
    }

    public int getExpRequiredForNextLevel() {
        int n = GameConstants.levelCost(this.level);
        if (Game.player.characterClass == 1) {
            n *= 3;
        }
        return n;
    }

    public boolean isHostile(Creature creature) {
        return this.hates(creature) || creature.hates(this);
    }

    public abstract int getId();

    public abstract boolean hates(Creature var1);

    public void resetCoolDowns() {
        this.stunRounds = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        this.abilityCooldowns = nArray;
        this.attackCoolDownRounds = 0.0;
    }

    public void tick() {
        if (this.a > 14) {
            this.checkBuffExpiration();
            this.a = 0;
        } else {
            ++this.a;
        }
        if (this.room instanceof CityRoom || this.room instanceof StatRoom || this.room instanceof ShopRoom) {
            this.regen();
        }
        if (!this.isAlive()) {
            return;
        }
        if (this.attackCoolDownRounds > 0.0) {
            this.attackCoolDownRounds -= 1.0;
        }
        if (this.stunRounds > 0) {
            --this.stunRounds;
        }
        this.reduceCooldowns();
    }

    public void reduceCooldowns() {
        this.d = 0;
        while (this.d < 4) {
            if (this.abilityCooldowns[this.d] > 0) {
                int n = this.d;
                this.abilityCooldowns[n] = this.abilityCooldowns[n] - 1;
            }
            ++this.d;
        }
    }

    public void restartBuffs() {
        this.a = this.buffs.elements();
        while (this.a.hasMoreElements()) {
            this.a = (Buff)this.a.nextElement();
            this.a.applyEffect();
        }
    }

    public void addBuff(Buff buff) {
        this.buffs.addElement(buff);
    }

    public void checkBuffExpiration() {
        this.a = this.buffs.elements();
        while (this.a.hasMoreElements()) {
            this.a = (Buff)this.a.nextElement();
            if (!this.a.checkExpire()) continue;
            this.buffs.removeElement(this.a);
        }
    }

    public abstract void awardKill(Creature var1);
}

