/*
 * Decompiled with CFR 0.152.
 */
import GameFiles.Character.InventoryArray;
import GameFiles.Character.Player;
import GameFiles.Instances.World;
import GameFiles.Items.Item;
import java.util.Vector;
import javax.microedition.rms.RecordStore;

public class DataProcessor {
    RecordStore recordStore;

    public boolean SaveGame(Player player, short[] sArray) {
        int n = 0;
        long l = System.currentTimeMillis();
        if (player != null && sArray != null) {
            this.DestroyPlayerSaveData();
            n += this.SavePlayerProperties(player);
            n += this.SavePlayerInventory(player.getInventory());
            System.out.println("TimeSave: " + (System.currentTimeMillis() - l));
            System.gc();
            if ((n += this.SaveEnvironementVariables(sArray)) == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean SaveWorld(World world) {
        int n = 0;
        long l = System.currentTimeMillis();
        if (world != null) {
            this.DestroyWorldSaveData();
            n += this.SaveWorldMap(world.getMap());
            System.gc();
            n += this.SavePositionTable(world.getVillagePositionTable(), "Village");
            System.gc();
            n += this.SavePositionTable(world.getRuinPositionTable(), "Ruin");
            System.gc();
            n += this.SavePositionTable(world.getDungeonPositionTable(), "Dungeon");
            System.gc();
            n += this.SaveWorldInstanceArray("Village", world.getVillageArray());
            System.gc();
            n += this.SaveWorldInstanceArray("Ruin", world.getRuinArray());
            System.gc();
            System.out.println("TimeSave: " + (System.currentTimeMillis() - l));
            System.gc();
            if ((n += this.SaveWorldInstanceArray("Dungeon", world.getDungeonArray())) == 0) {
                return true;
            }
        }
        return false;
    }

    public Player LoadPlayer() {
        long l = System.currentTimeMillis();
        Player player = this.LoadPlayerProperties();
        player.setInventory(this.LoadInventoryArray());
        System.out.println("TimeLoadPlayer: " + (System.currentTimeMillis() - l));
        System.gc();
        if (player != null && player.getInventory() != null) {
            return player;
        }
        return null;
    }

    public World LoadWorld() {
        long l = System.currentTimeMillis();
        byte[][] byArray = this.LoadWorldMap();
        byte[][][] byArray2 = this.LoadWorldInstanceArray("Village");
        short[][] sArray = this.LoadPositionTable("Village");
        byte[][][] byArray3 = this.LoadWorldInstanceArray("Dungeon");
        short[][] sArray2 = this.LoadPositionTable("Dungeon");
        byte[][][] byArray4 = this.LoadWorldInstanceArray("Ruin");
        short[][] sArray3 = this.LoadPositionTable("Ruin");
        System.out.println("TimeLoadWorld: " + (System.currentTimeMillis() - l));
        System.gc();
        if (byArray != null && byArray2 != null && sArray != null && byArray3 != null && sArray2 != null && byArray4 != null && sArray3 != null) {
            return new World(0, byArray, byArray2, sArray, byArray3, sArray2, byArray4, sArray3, "Karlinghar");
        }
        return null;
    }

    public short[] LoadEnvironementVariables() {
        short[] sArray = this.LoadEnvironementVariablez();
        if (sArray != null) {
            return sArray;
        }
        return null;
    }

    private int SavePlayerProperties(Player player) {
        if (this.Open("RoguelikeMobilePlayerProperties")) {
            try {
                String[] stringArray = player.PlayerToString();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.recordStore.addRecord(stringArray[i].getBytes(), 0, stringArray[i].length());
                }
                this.recordStore.closeRecordStore();
                System.out.println("Done saving player data");
                return 0;
            }
            catch (Exception exception) {
                System.out.println("Player Save Properties Error: " + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private Player LoadPlayerProperties() {
        if (this.Open("RoguelikeMobilePlayerProperties")) {
            Player player = new Player();
            try {
                String string = "";
                for (int i = 1; i < this.recordStore.getNumRecords(); ++i) {
                    string = this.ByteToString(this.recordStore.getRecord(i));
                    String[] stringArray = this.Split(string, ':');
                    if (stringArray[0].equals("Lv")) {
                        player.setLevel(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("Ex")) {
                        player.setCurrentExp(Long.parseLong(stringArray[1]));
                    } else if (stringArray[0].equals("Us")) {
                        player.setUndividedSkillpoints(Short.parseShort(stringArray[1]));
                    } else if (stringArray[0].equals("Mh")) {
                        player.setMaxHitPoints(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("Hp")) {
                        player.setCurrentHitpoints(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("In")) {
                        player.setIntelligenceLevel(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("Ds")) {
                        player.setDefenceSkillLevel(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("As")) {
                        player.setAttackSkillLevel(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("St")) {
                        player.setStrenghtLevel(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("De")) {
                        player.setDefence(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("Go")) {
                        player.setGold(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("Mk")) {
                        player.setMonstersKilled(Integer.parseInt(stringArray[1]));
                    } else if (stringArray[0].equals("Ip")) {
                        player.setItemsPickedUp(Integer.parseInt(stringArray[1]));
                    }
                    System.gc();
                }
                this.recordStore.closeRecordStore();
                System.out.println("Done loading player properties");
                return player;
            }
            catch (Exception exception) {
                System.out.println("Player Load Properties Error: " + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int SavePlayerInventory(InventoryArray inventoryArray) {
        if (this.Open("RoguelikeMobilePlayerInventory")) {
            try {
                int n;
                String string = "";
                Item[] itemArray = inventoryArray.GetAll();
                string = "EQUIPED_ITEMS";
                this.recordStore.addRecord(string.getBytes(), 0, string.length());
                for (n = 0; n < inventoryArray.getEquipedArray().length; ++n) {
                    if (inventoryArray.getEquipedArray()[n] == null) continue;
                    string = inventoryArray.getEquipedArray()[n].ItemToString();
                    this.recordStore.addRecord(string.getBytes(), 0, string.length());
                }
                string = "INVENTORY_ITEMS";
                this.recordStore.addRecord(string.getBytes(), 0, string.length());
                for (n = 0; n < itemArray.length; ++n) {
                    if (itemArray == null) continue;
                    string = itemArray[n].ItemToString();
                    this.recordStore.addRecord(string.getBytes(), 0, string.length());
                }
                string = "END";
                this.recordStore.addRecord(string.getBytes(), 0, string.length());
                this.recordStore.closeRecordStore();
                System.out.println("Done saving Items");
                return 0;
            }
            catch (Exception exception) {
                System.out.println("Player Save Inventory Error: " + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public void DestroyAllData() {
        try {
            RecordStore.deleteRecordStore((String)"RoguelikeMobilePlayerInventory");
            RecordStore.deleteRecordStore((String)"RoguelikeMobilePlayerProperties");
            RecordStore.deleteRecordStore((String)"RoguelikeMobileWorldMap");
            RecordStore.deleteRecordStore((String)"VillageInstanceArray");
            RecordStore.deleteRecordStore((String)"DungeonInstanceArray");
            RecordStore.deleteRecordStore((String)"RuinInstanceArray");
            RecordStore.deleteRecordStore((String)"VillagePositionTable");
            RecordStore.deleteRecordStore((String)"DungeonPositionTable");
            RecordStore.deleteRecordStore((String)"RuinPositionTable");
            RecordStore.deleteRecordStore((String)"EnvironementVariables");
        }
        catch (Exception exception) {
            System.out.println("Destroy All" + exception.toString());
        }
    }

    public void DestroyWorldSaveData() {
        try {
            RecordStore.deleteRecordStore((String)"VillagePositionTable");
            RecordStore.deleteRecordStore((String)"DungeonPositionTable");
            RecordStore.deleteRecordStore((String)"RuinPositionTable");
            RecordStore.deleteRecordStore((String)"RoguelikeMobileWorldMap");
            RecordStore.deleteRecordStore((String)"VillageInstanceArray");
            RecordStore.deleteRecordStore((String)"DungeonInstanceArray");
            RecordStore.deleteRecordStore((String)"RuinInstanceArray");
            RecordStore.deleteRecordStore((String)"VillagePositionTable");
            RecordStore.deleteRecordStore((String)"DungeonPositionTable");
            RecordStore.deleteRecordStore((String)"RuinPositionTable");
        }
        catch (Exception exception) {
            System.out.println("Destroy Save" + exception.toString());
        }
    }

    public void DestroyPlayerSaveData() {
        try {
            RecordStore.deleteRecordStore((String)"RoguelikeMobilePlayerInventory");
            RecordStore.deleteRecordStore((String)"RoguelikeMobilePlayerProperties");
            RecordStore.deleteRecordStore((String)"EnvironementVariables");
        }
        catch (Exception exception) {
            System.out.println("Destroy World" + exception.toString());
        }
    }

    private InventoryArray LoadInventoryArray() {
        if (this.Open("RoguelikeMobilePlayerInventory")) {
            InventoryArray inventoryArray = new InventoryArray(20);
            try {
                Item item = new Item();
                int n = 0;
                boolean bl = false;
                int n2 = 1;
                while (true) {
                    String[] stringArray;
                    if ((stringArray = this.Split(this.ByteToString(this.recordStore.getRecord(n2)), ','))[0].equals("EQUIPED_ITEMS")) {
                        bl = false;
                    } else if (stringArray[0].equals("INVENTORY_ITEMS")) {
                        bl = true;
                    } else {
                        if (stringArray[0].equals("END")) {
                            this.recordStore.closeRecordStore();
                            System.out.println("Done loading player items");
                            return inventoryArray;
                        }
                        item = new Item(Byte.parseByte(stringArray[0]), stringArray[1], Short.parseShort(stringArray[2]), Short.parseShort(stringArray[3]), Short.parseShort(stringArray[4]), Short.parseShort(stringArray[5]), Short.parseShort(stringArray[6]), Short.parseShort(stringArray[7]), Short.parseShort(stringArray[8]), Short.parseShort(stringArray[9]), Short.parseShort(stringArray[10]), 0, 0, 0);
                        if (!bl) {
                            inventoryArray.AddItem(item);
                            inventoryArray.AddItemToEquipedInventory(item, n);
                            ++n;
                        }
                        if (bl) {
                            inventoryArray.AddItem(item);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                System.out.println("Player load Inventory Error: " + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String[] Split(String string, char c) {
        int n;
        Vector<String> vector = new Vector<String>(20);
        char[] cArray = string.toCharArray();
        String string2 = "";
        string = null;
        System.gc();
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == c) {
                vector.addElement(string2);
                string2 = "";
                continue;
            }
            string2 = string2 + cArray[n];
        }
        vector.addElement(string2);
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private String ByteToString(byte[] byArray) {
        return new String(byArray);
    }

    private boolean Open(String string) {
        try {
            this.recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Recordstore Open Error:" + exception.getMessage());
            return false;
        }
    }

    private int SaveWorldMap(byte[][] byArray) {
        if (this.Open("RoguelikeMobileWorldMap")) {
            try {
                String string = byArray.length + "";
                this.recordStore.addRecord(string.getBytes(), 0, string.length());
                for (int i = 0; i < byArray.length; ++i) {
                    this.recordStore.addRecord(byArray[i], 0, byArray[i].length);
                }
                this.recordStore.closeRecordStore();
                System.out.println("Done Saving World Map");
                return 0;
            }
            catch (Exception exception) {
                System.out.println("Map Save Error:" + exception.getMessage());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private byte[][] LoadWorldMap() {
        if (this.Open("RoguelikeMobileWorldMap")) {
            try {
                int n = Integer.parseInt(this.ByteToString(this.recordStore.getRecord(1)));
                byte[][] byArray = new byte[n][n];
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = this.recordStore.getRecord(i + 2);
                }
                this.recordStore.closeRecordStore();
                System.out.println("Done Loading World Map");
                return byArray;
            }
            catch (Exception exception) {
                System.out.println("Map Load Error:" + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private int SaveWorldInstanceArray(String string, byte[][][] byArray) {
        if (this.Open(string + "InstanceArray")) {
            try {
                String string2 = "" + byArray.length;
                this.recordStore.addRecord(string2.getBytes(), 0, string2.length());
                for (int i = 0; i < byArray.length; ++i) {
                    string2 = byArray[i].length + "";
                    for (int j = 0; j < byArray[i].length; ++j) {
                        string2 = string2 + "|" + byArray[i][j][0] + "," + byArray[i][j][1];
                    }
                    this.recordStore.addRecord(string2.getBytes(), 0, string2.length());
                }
                System.out.println("Done Saving " + string + "InstanceArray");
                this.recordStore.closeRecordStore();
                return 0;
            }
            catch (Exception exception) {
                System.out.println(string + " InstanceArray Save Error: " + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private byte[][][] LoadWorldInstanceArray(String string) {
        if (this.Open(string + "InstanceArray")) {
            try {
                String string2 = this.ByteToString(this.recordStore.getRecord(1));
                byte[][][] byArrayArray = new byte[Integer.parseInt(string2)][][];
                for (int i = 2; i < byArrayArray.length + 2; ++i) {
                    string2 = this.ByteToString(this.recordStore.getRecord(i));
                    String[] stringArray = this.Split(string2, '|');
                    byte[][] byArray = new byte[Integer.parseInt(stringArray[0])][2];
                    for (int j = 1; j < stringArray.length; ++j) {
                        String[] stringArray2 = this.Split(stringArray[j], ',');
                        byArray[j - 1][0] = Byte.parseByte(stringArray2[0]);
                        byArray[j - 1][1] = Byte.parseByte(stringArray2[1]);
                    }
                    byArrayArray[i - 2] = byArray;
                }
                System.out.println("Done Loading " + string + "InstanceArray");
                this.recordStore.closeRecordStore();
                return byArrayArray;
            }
            catch (Exception exception) {
                System.out.println(string + "InstanceArray Save Error: " + exception.toString());
            }
        }
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private short[][] LoadPositionTable(String string) {
        if (this.Open(string + "PositionTable")) {
            try {
                String[] stringArray = this.Split(this.ByteToString(this.recordStore.getRecord(1)), ',');
                short[][] sArray = new short[Integer.parseInt(stringArray[0])][4];
                for (int i = 2; i < sArray.length + 2; ++i) {
                    stringArray = this.Split(this.ByteToString(this.recordStore.getRecord(i)), ',');
                    sArray[i - 2][0] = Short.parseShort(stringArray[0]);
                    sArray[i - 2][1] = Short.parseShort(stringArray[1]);
                    sArray[i - 2][2] = Short.parseShort(stringArray[2]);
                    sArray[i - 2][3] = Short.parseShort(stringArray[3]);
                }
                System.out.println("Done loading " + string + "Position Table");
                this.recordStore.closeRecordStore();
                return sArray;
            }
            catch (Exception exception) {
                System.out.println(string + "PositionTable load Error: " + exception.toString());
                try {
                    this.recordStore.closeRecordStore();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private int SavePositionTable(short[][] sArray, String string) {
        if (this.Open(string + "PositionTable")) {
            try {
                String string2 = "" + sArray.length;
                this.recordStore.addRecord(string2.getBytes(), 0, string2.length());
                for (int i = 0; i < sArray.length; ++i) {
                    string2 = sArray[i][0] + "," + sArray[i][1] + "," + sArray[i][2] + "," + sArray[i][3];
                    this.recordStore.addRecord(string2.getBytes(), 0, string2.length());
                }
                this.recordStore.closeRecordStore();
                System.out.println("Done saving " + string + "Position Table");
                return 0;
            }
            catch (Exception exception) {
                System.out.println(string + "PositionTable Save Error: " + exception.toString());
                try {
                    this.recordStore.closeRecordStore();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return 1;
    }

    private int SaveEnvironementVariables(short[] sArray) {
        if (this.Open("EnvironementVariables")) {
            try {
                String string = "";
                string = string + sArray[0] + ",";
                string = string + sArray[1] + ",";
                string = string + sArray[2] + ",";
                string = string + sArray[3];
                this.recordStore.addRecord(string.getBytes(), 0, string.length());
                this.recordStore.closeRecordStore();
                System.out.println("Done saving EnvironementVariables");
                return 0;
            }
            catch (Exception exception) {
                System.out.println("Environement Variables Save Error: " + exception.toString());
                try {
                    this.recordStore.closeRecordStore();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return 1;
    }

    private short[] LoadEnvironementVariablez() {
        if (this.Open("EnvironementVariables")) {
            try {
                short[] sArray = new short[4];
                String[] stringArray = this.Split(this.ByteToString(this.recordStore.getRecord(1)), ',');
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = Short.parseShort(stringArray[i]);
                }
                System.out.println("Done Loading EnvironementVariables");
                this.recordStore.closeRecordStore();
                return sArray;
            }
            catch (Exception exception) {
                System.out.println("Environement Variables Load Error: " + exception.toString());
                try {
                    this.recordStore.closeRecordStore();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

