/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Generators;

import GameFiles.Items.ArmorData;
import GameFiles.Items.CloseCombatItemData;
import GameFiles.Items.ClutterData;
import GameFiles.Items.Item;
import GameFiles.Items.ItemData;
import GameFiles.Items.PotionsData;
import GameFiles.Items.ValueableData;
import java.util.Random;

public class ItemGenerator {
    Random random = new Random();

    public Item GenerateRandomItem(int n, boolean bl) {
        if (this.random.nextInt(100) < 45 || !bl) {
            switch (this.random.nextInt(5)) {
                case 0: {
                    return this.ReconstructItem(this.GenerateCloseCombatItem(n));
                }
                case 1: {
                    return this.ReconstructItem(this.GenerateArmour(n));
                }
                case 2: {
                    return this.ReconstructItem(this.GeneratePotion(n));
                }
                case 3: {
                    return this.ReconstructItem(this.GenerateValueable(n));
                }
                case 4: {
                    return this.ReconstructItem(this.GenerateClutter(n));
                }
            }
            return this.ReconstructItem(this.GenerateClutter(n));
        }
        return new Item(1, "\u0422\u0440\u0443\u043f", 0, 0, 0, 0, (short)this.random.nextInt(n * 2 + 1), 0, (short)(this.random.nextInt(10) + 1), 1, 1, 0, 0, 0);
    }

    private short[] GenerateArmour(int n) {
        short[] sArray;
        sArray = new short[]{3, (short)this.random.nextInt(1000), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 90), this.GenerateEffect(n, 90), this.GenerateEffect(n, 0), -1, (short)(this.random.nextInt(40) + 1), this.GenerateValue(sArray, false)};
        return sArray;
    }

    private short[] GenerateCloseCombatItem(int n) {
        short[] sArray = new short[12];
        sArray[0] = 0;
        sArray[1] = (short)this.random.nextInt(1000);
        sArray[2] = this.GenerateEffect(n, 90);
        sArray[3] = this.GenerateEffect(n, 40);
        sArray[4] = this.GenerateEffect(n, 90);
        sArray[5] = this.GenerateEffect(n, 40);
        sArray[6] = this.GenerateEffect(n, 40);
        sArray[7] = this.GenerateEffect(n, 0);
        sArray[8] = -1;
        sArray[9] = (short)(this.random.nextInt(20) + 1);
        sArray[10] = this.GenerateValue(sArray, false);
        return sArray;
    }

    private short[] GeneratePotion(int n) {
        short[] sArray;
        sArray = new short[]{1, (short)this.random.nextInt(1000), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 90), (short)(this.random.nextInt(40) + 1), (short)(this.random.nextInt(1) + 1), this.GenerateValue(sArray, false)};
        return sArray;
    }

    private short[] GenerateValueable(int n) {
        short[] sArray;
        sArray = new short[]{2, (short)this.random.nextInt(1000), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 40), this.GenerateEffect(n, 0), -1, (short)(this.random.nextInt(10) + 1), this.GenerateValue(sArray, true)};
        return sArray;
    }

    private short[] GenerateClutter(int n) {
        short[] sArray;
        sArray = new short[]{4, (short)this.random.nextInt(1000), this.GenerateEffect(n, 2), this.GenerateEffect(n, 2), this.GenerateEffect(n, 2), this.GenerateEffect(n, 2), this.GenerateEffect(n, 2), this.GenerateEffect(n, 2), -1, (short)(this.random.nextInt(15) + 1), this.GenerateValue(sArray, false)};
        return sArray;
    }

    private short GenerateValue(short[] sArray, boolean bl) {
        int n;
        int n2 = 0;
        short s = 0;
        for (n = 2; n < 8; ++n) {
            n2 += sArray[n];
        }
        s = (short)(n2 * this.random.nextInt(8) + 2);
        if (s < 0) {
            return 0;
        }
        if (bl) {
            n = this.random.nextInt(1000);
            s = n < 800 ? (short)this.random.nextInt(200) : (n > 800 && n < 950 ? (short)(this.random.nextInt(200) + 200) : (n > 950 && n < 999 ? (short)(this.random.nextInt(400) + 400) : (short)(this.random.nextInt(800) + 800)));
        }
        return s;
    }

    private short GenerateEffect(int n, int n2) {
        int n3;
        short s = 0;
        int n4 = 4;
        for (n3 = 0; n3 < n; ++n3) {
            n4 += n3 / 10 + 1;
        }
        if (this.random.nextInt(100) < n2) {
            n3 = this.random.nextInt(1001);
            s = n3 < 750 ? (short)this.random.nextInt(1 + n4 / 4) : (n3 > 750 && n3 < 925 ? (short)(this.random.nextInt(1 + n4 / 2) + (n4 / 4 + 1)) : (n3 > 925 && n3 < 999 ? (short)(this.random.nextInt(1 + n4) + n4 / 2) : (short)(this.random.nextInt(1 + n4 * 3) + n4 + 1)));
            if (this.random.nextInt(100) > 70) {
                s = (short)(s * -1);
            }
        }
        return s;
    }

    public Item ReconstructItem(short[] sArray) {
        byte by = (byte)sArray[0];
        short s = sArray[1];
        short s2 = sArray[2];
        short s3 = sArray[3];
        short s4 = sArray[4];
        short s5 = sArray[5];
        short s6 = sArray[6];
        short s7 = sArray[7];
        short s8 = sArray[8];
        short s9 = sArray[9];
        short s10 = sArray[10];
        return new Item(by, this.ReconstructItemName(sArray), s2, s3, s4, s5, s7, s6, s8, s9, s10, 0, 0, 0);
    }

    private int ReconstructID(short[] sArray) {
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            n += sArray[i];
        }
        return n;
    }

    private String ReconstructItemName(short[] sArray) {
        String string = "";
        ItemData itemData = sArray[0] == 0 ? new CloseCombatItemData() : (sArray[0] == 1 ? new PotionsData() : (sArray[0] == 2 ? new ValueableData() : (sArray[0] == 3 ? new ArmorData() : (sArray[0] == 4 ? new ClutterData() : new ClutterData()))));
        int n = 0;
        for (int i = 0; i < sArray.length; ++i) {
            n += sArray[i];
        }
        if (n < 0) {
            n *= -1;
        }
        if (n % 41 > 50 && sArray[0] != 4) {
            string = string + itemData.GetAdjective1(n) + " ";
        }
        if (n % 2 == 0 && sArray[0] != 4) {
            string = string + itemData.GetAdjective2(n) + " ";
        }
        string = string + itemData.GetDescription(sArray[1]) + " ";
        string = string + "of " + this.RebuildName(sArray);
        return string;
    }

    private String RebuildName(short[] sArray) {
        char[] cArray = new char[]{'A', 'E', 'I', 'O', 'U', 'Y'};
        char[] cArray2 = new char[]{'B', 'C', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Z'};
        boolean bl = false;
        String string = "";
        if (sArray[1] % 2 == 0) {
            bl = true;
        }
        for (int i = 0; i < sArray[1] % 5 + 3 && i < sArray.length - 1; ++i) {
            string = bl ? (i == 0 ? string + cArray[Math.abs(sArray[i] + sArray[i + 1]) % (cArray.length - 1)] : string + Character.toLowerCase(cArray[Math.abs(sArray[i] + sArray[i + 1]) % (cArray.length - 1)])) : (i == 0 ? string + cArray2[Math.abs(sArray[i]) % (cArray2.length - 1)] : string + Character.toLowerCase(cArray2[Math.abs(sArray[i] + sArray[i + 1]) % (cArray2.length - 1)]));
            bl = !bl;
        }
        return string;
    }

    public Item[] GetStartItems(int n) {
        Item[] itemArray = new Item[]{new Item(0, "\u041f\u0440\u0438\u043c\u0438\u0442\u0438\u0432\u043d\u044b\u0439 \u041c\u0435\u0447", 2, 0, 2, 0, 0, 0, 0, 1, 1, 0, 0, 0), new Item(1, "\u0412\u044b\u043f\u0438\u0432\u043a\u0430", 0, 0, 0, 0, (short)(n * 2), 0, 20, 1, 1, 0, 0, 0)};
        return itemArray;
    }
}

