/*
 * Decompiled with CFR 0.152.
 */
package GameFiles.Instances;

import GameFiles.Character.Player;
import GameFiles.Instances.CombatInstance;
import GameFiles.Items.Item;
import GameFiles.NPCS.NPC;
import java.util.Random;

public class Village
extends CombatInstance {
    public Village(short s, byte[][] byArray, String string, NPC[] nPCArray, Item[] itemArray) {
        super(s, byArray, string, nPCArray, itemArray);
        this.symbol = new char[]{'-', '-', '#', '~', '=', '$', '/', 'T', '*', 'V', '\"', '@'};
        this.symbolDescription = new String[]{"\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u0437\u0435\u043b\u0435\u043d\u043e\u0439 \u0442\u0440\u0430\u0432\u0435", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u043a\u0430\u043c\u0435\u043d\u043d\u043e\u043c\u0443 \u043f\u043e\u043b\u0443", "\u0412\u044b \u0441\u0442\u043e\u043b\u043a\u043d\u0443\u043b\u0438\u0441\u044c \u0441\u043e \u0441\u0442\u0435\u043d\u043e\u0439", "\u0412\u044b \u043f\u043b\u0430\u0432\u0430\u0435\u0442\u0435 \u0432 \u0447\u0438\u0441\u0442\u043e\u043c \u043f\u0440\u0443\u0434\u0443", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u043f\u043e\u043b\u044e", "\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b", "\u0412\u044b \u043e\u0442\u043a\u0440\u044b\u043b\u0438 \u0434\u0432\u0435\u0440\u044c", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e\u0434 \u043a\u0440\u0430\u0441\u0438\u0432\u044b\u043c \u0434\u0435\u0440\u0435\u0432\u043e\u043c", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043c\u0438\u043c\u043e \u043a\u0443\u0441\u0442\u043e\u0432", "V", "\u0412\u044b \u0438\u0434\u0435\u0442\u0435 \u043f\u043e \u043f\u043e\u043b\u044e \u0441 \u043f\u0448\u0435\u043d\u0438\u0446\u0435\u0439", "\u0421\u0430\u043c"};
        this.clip = new char[]{'#', 'V', '@'};
        this.colorTable = new int[]{0x228B22, 3092785, 0xC1CDCD, 2003199, 13468991, 16766720, 13468991, 65280, 65280, 0xF0F0F0, 16766720, 0xFFFFFF};
    }

    public char getInstanceSymbol(byte by, int n, int n2) {
        if (this.symbol[by] != 'V') {
            return this.symbol[by];
        }
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
            return this.npcArray[i].getSymbol();
        }
        return 'U';
    }

    public String getSymbolDescription(byte by, int n, int n2) {
        if (this.symbolDescription[by].equals("V")) {
            for (int i = 0; i < this.npcArray.length; ++i) {
                if (this.npcArray[i] == null || this.npcArray[i].getXPos() != n || this.npcArray[i].getYPos() != n2) continue;
                return this.npcArray[i].DescribeMe();
            }
        } else {
            if (this.symbolDescription[by].equals("\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u044b")) {
                return this.itemArray.GetItemOn(n, n2).DescribeMe();
            }
            return this.symbolDescription[by];
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e";
    }

    public void MoveNPC(Player player) {
        Random random = new Random();
        for (int i = 0; i < this.npcArray.length; ++i) {
            if (this.npcArray[i] == null || Math.abs(player.getXPos() - this.npcArray[i].getXPos()) >= 20 || Math.abs(player.getYPos() - this.npcArray[i].getYPos()) >= 20) continue;
            if (this.npcArray[i].getMoved() == 0) {
                int n = random.nextInt(4);
                this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = this.npcArray[i].getCurrentlyOn();
                switch (n) {
                    case 0: {
                        if (this.npcArray[i].getXPos() > 10 && !this.IsClipped(this.npcArray[i].getXPos() - 1, this.npcArray[i].getYPos())) {
                            this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() - 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos() + 1, this.npcArray[i].getYPos()) || this.npcArray[i].getXPos() >= this.map[0].length - 10) break;
                        this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() + 1));
                        break;
                    }
                    case 1: {
                        if (this.npcArray[i].getXPos() < this.map[0].length - 10 && !this.IsClipped(this.npcArray[i].getXPos() + 1, this.npcArray[i].getYPos())) {
                            this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() + 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos() - 1, this.npcArray[i].getYPos()) || this.npcArray[i].getXPos() <= 10) break;
                        this.npcArray[i].setXPos((short)(this.npcArray[i].getXPos() - 1));
                        break;
                    }
                    case 2: {
                        if (this.npcArray[i].getYPos() < this.map.length - 10 && !this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() + 1)) {
                            this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() + 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() - 1) || this.npcArray[i].getYPos() <= 10) break;
                        this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() - 1));
                        break;
                    }
                    case 3: {
                        if (this.npcArray[i].getYPos() > 10 && !this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() - 1)) {
                            this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() - 1));
                            break;
                        }
                        if (this.IsClipped(this.npcArray[i].getXPos(), this.npcArray[i].getYPos() + 1) || this.npcArray[i].getYPos() >= this.map.length - 10) break;
                        this.npcArray[i].setYPos((short)(this.npcArray[i].getYPos() + 1));
                    }
                }
                this.npcArray[i].setCurrentlyOn(this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()]);
                this.map[this.npcArray[i].getYPos()][this.npcArray[i].getXPos()] = 9;
                this.npcArray[i].setMoved(this.npcArray[i].getMayMove());
                continue;
            }
            this.npcArray[i].setMoved((short)(this.npcArray[i].getMoved() - 1));
        }
    }
}

