/*
 * Decompiled with CFR 0.152.
 */
package mobilespicker;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mobilespicker.Config;
import mobilespicker.MyCanvas;
import mobilespicker.Spicker;
import mobilespicker.SplashListener;

public class SplashScreen
extends MyCanvas {
    SplashListener listener;
    int color;
    boolean fin;
    private int[] rawInt;
    private Graphics mGraphics;
    private Image mBufferImage;

    public SplashScreen(Image i, int c) {
        this.color = c;
        this.fin = false;
        this.mBufferImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.mGraphics = this.mBufferImage.getGraphics();
        this.rawInt = new int[i.getWidth() * i.getHeight()];
        i.getRGB(this.rawInt, 0, i.getWidth(), 0, 0, i.getWidth(), i.getHeight());
    }

    public void keyPressed(int keyCode) {
        this.fin = true;
        this.listener.splashFinished();
    }

    public void display() {
        this.startThread();
        Spicker.display.setCurrent((Displayable)this);
    }

    public void setListener(SplashListener l) {
        this.listener = l;
    }

    public void paint(Graphics g) {
        if (this.mBufferImage != null) {
            g.setColor(this.color);
            g.drawImage(this.mBufferImage, 0, 0, 20);
        }
    }

    public static void blend(int[] raw, int alphaValue) {
        int len = raw.length;
        int i = 0;
        while (i < len) {
            int a = 0;
            int color = raw[i] & 0xFFFFFF;
            a = alphaValue;
            raw[i] = color += (a <<= 24);
            ++i;
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            int i = 50;
            while (i < 250) {
                SplashScreen.blend(this.rawInt, i);
                Image fadingImage = Image.createRGBImage((int[])this.rawInt, (int)Config.SCREEN_WIDTH, (int)Config.SCREEN_HEIGHT, (boolean)true);
                this.mGraphics.setColor(0xFFFFFF);
                this.mGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.mGraphics.drawImage(fadingImage, 0, 10, 0);
                System.gc();
                this.repaint();
                System.gc();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ix) {
                    // empty catch block
                }
                i += 20;
            }
            this.stopThread();
            if (this.fin) continue;
            this.rawInt = null;
            this.mBufferImage = null;
            System.gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ic) {
                // empty catch block
            }
            this.listener.splashFinished();
        }
    }
}

