/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.GraphCanvas;
import graph.GraphViewer;
import graph.ProgressBarAlert;
import graph.core.PlotterWithFunctionEvaluation;
import graph.core.ProgressBar;
import graph.lang.Phrases;
import javax.microedition.lcdui.Displayable;

public class EvaluateFunction
implements Runnable {
    PlotterWithFunctionEvaluation plotter;
    Thread thisThread;

    public EvaluateFunction(PlotterWithFunctionEvaluation plotter) {
        this.plotter = plotter;
    }

    public void run() {
        try {
            this.thisThread = Thread.currentThread();
            ProgressBar.InvokeAble cancelTask = new ProgressBar.InvokeAble(){

                public void invoke() {
                    PlotterWithFunctionEvaluation.setRunning(false);
                    EvaluateFunction.this.thisThread.interrupt();
                }
            };
            ProgressBar.InvokeAble endTask = new ProgressBar.InvokeAble(){

                public void invoke() {
                    GraphCanvas graphCanvas = GraphViewer.graphCanvas;
                    CommandHandler.getInstance().setCurrentDisplayable((Displayable)graphCanvas);
                    graphCanvas.repaint();
                }
            };
            ProgressBarAlert progressBar = new ProgressBarAlert(Phrases.busy, Phrases.evaluating, 10, endTask);
            progressBar.setCancellable(true, cancelTask);
            progressBar.show(null);
            PlotterWithFunctionEvaluation.setRunning(true);
            this.plotter.enableInteractiveMode(true, progressBar);
            ((GraphCanvas)CommandHandler.getInstance().getDisplayable("graph.GraphCanvas")).repaint();
            progressBar.taskEnded();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandHandler.getInstance().alertException(e);
        }
    }
}

