/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.AboutForm;
import graph.AddSampleForm;
import graph.Calculator;
import graph.CommandHandler;
import graph.GraphCanvas;
import graph.GraphForm;
import graph.LanguageList;
import graph.MainMenu;
import graph.SampleList;
import graph.WelcomeScreen;
import graph.core.Sample;
import graph.core.SampleStore;
import graph.core.Settings;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class GraphViewer
extends MIDlet {
    static MainMenu mainMenu;
    static GraphCanvas graphCanvas;
    static GraphForm graphForm;
    static AboutForm graphAbout;
    static Calculator calculator;
    static SampleList sampleList;
    static AddSampleForm addSampleForm;
    private boolean paused = false;
    private static final String RECORD_STORE_NAME_CURRENT = "Current";

    public void startApp() {
        if (!this.paused) {
            this.showWelcomeScreen();
            boolean settingsLoaded = Settings.loadSettings();
            if (settingsLoaded) {
                this.init();
                this.loadCurrentSample();
            } else {
                Display display = Display.getDisplay((MIDlet)this);
                display.setCurrent((Displayable)new LanguageList(this));
                Settings.isChanged = true;
            }
        } else {
            this.paused = false;
        }
    }

    private void showWelcomeScreen() {
        Display display = Display.getDisplay((MIDlet)this);
        WelcomeScreen welcomeScreen = new WelcomeScreen();
        display.setCurrent((Displayable)welcomeScreen);
    }

    public void init() {
        mainMenu = new MainMenu();
        graphCanvas = new GraphCanvas();
        graphForm = new GraphForm();
        graphAbout = new AboutForm();
        calculator = new Calculator();
        sampleList = new SampleList();
        addSampleForm = new AddSampleForm();
        CommandHandler.getInstance().initialize(this);
        CommandHandler.getInstance().setCurrentDisplayable((Displayable)new WelcomeScreen((Displayable)mainMenu));
    }

    public void reinit() {
        graphCanvas.updateGraphForm();
        Sample currentSample = graphForm.getSample();
        this.init();
        graphForm.setSample(currentSample);
    }

    public void saveEverything() {
        Settings.saveSettings();
        graphCanvas.updateGraphForm();
        this.saveCurrentSample();
        SampleStore.getInstance().saveSamples();
    }

    private void saveCurrentSample() {
        RecordStore store = null;
        try {
            RecordStore.deleteRecordStore((String)RECORD_STORE_NAME_CURRENT);
        }
        catch (Exception e) {
            System.out.println("Warning: Record store Current doesn't exist yet.");
        }
        try {
            try {
                store = RecordStore.openRecordStore((String)RECORD_STORE_NAME_CURRENT, (boolean)true, (int)0, (boolean)true);
                byte[] bytes = graphForm.getSample().toByteArray();
                store.addRecord(bytes, 0, bytes.length);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadCurrentSample() {
        RecordStore store = null;
        try {
            try {
                store = RecordStore.openRecordStore((String)RECORD_STORE_NAME_CURRENT, (boolean)true, (int)0, (boolean)false);
                RecordEnumeration records = store.enumerateRecords(null, null, false);
                if (records.hasNextElement()) {
                    byte[] record = records.nextRecord();
                    graphForm.setSample(new Sample(record));
                }
            }
            catch (Exception e) {
                System.out.println("Warning: Record store Current doesn't exist yet.");
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroyApp(boolean b) {
        this.saveEverything();
    }

    public void pauseApp() {
        this.saveEverything();
        this.paused = true;
    }
}

