/*
 * Decompiled with CFR 0.152.
 */
package graph.core;

import graph.GraphCanvas;
import graph.core.Sample;
import graph.utils.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PlotterScreen {
    public static final double DEFAULT_ZOOM_FACTOR = 2.0;
    public static final double BIG_ZOOM_FACTOR = 4.0;
    public static final double DEFAULT_MOVE_SCREENS = 0.1;
    public static final double BIG_MOVE_SCREENS = 0.5;
    public static double xmin;
    public static double xmax;
    public static double ymin;
    public static double ymax;
    private int screenWidth;
    private int screenHeight;
    protected Image lastImage;
    public static double MOVE_SCREENS;
    public static double ZOOM_FACTOR;

    static {
        MOVE_SCREENS = 0.1;
        ZOOM_FACTOR = 2.0;
    }

    public PlotterScreen(Sample sample, int screenWidth, int screenHeight) {
        xmin = sample.xmin;
        xmax = sample.xmax;
        ymin = sample.ymin;
        ymax = sample.ymax;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public double getXMin() {
        return xmin;
    }

    public double getXMax() {
        return xmax;
    }

    public double getScreenWidthInCoordinate() {
        return xmax - xmin;
    }

    public double getScreenHeightInCoordinate() {
        return ymax - ymin;
    }

    public int getYScreenCoordinateOrigin() {
        return (int)(ymax / (ymax - ymin) * (double)this.screenHeight);
    }

    public int getXScreenCoordinateOrigin() {
        return (int)(-xmin / (xmax - xmin) * (double)this.screenWidth);
    }

    public int transformYCoordinateToScreen(double y) {
        if (y > ymax + 1000.0 || !Utils.isValidDouble(y)) {
            return -1000;
        }
        if (y < ymin - 1000.0) {
            return this.screenHeight + 1000;
        }
        return (int)((ymax - y) / (ymax - ymin) * (double)this.screenHeight);
    }

    public int transformXCoordinateToScreen(double x) {
        if (x > xmax + 1000.0) {
            return this.screenWidth + 1000;
        }
        if (x < xmin - 1000.0 || !Utils.isValidDouble(x)) {
            return -1000;
        }
        return (int)((x - xmin) / (xmax - xmin) * (double)this.screenWidth);
    }

    public double transformXCoordinateFromScreen(int x) {
        return (double)x * (xmax - xmin) / (double)this.screenWidth + xmin;
    }

    public double transformYCoordinateFromScreen(int y) {
        return (double)(this.screenHeight - y) * (ymax - ymin) / (double)this.screenHeight + ymin;
    }

    public int getNbRelevantXDecimals(int signFigures) {
        double xInterval = xmax - xmin;
        return Math.max(0, -Utils.logTenBase(xInterval) + signFigures);
    }

    public int getNbRelevantYDecimals(int signFigures) {
        double yInterval = ymax - ymin;
        return Math.max(0, -Utils.logTenBase(yInterval) + signFigures);
    }

    public String getXMinRounded(int signFigures) {
        return Utils.doubleToString(Utils.round(xmin, this.getNbRelevantXDecimals(signFigures)));
    }

    public String getXMaxRounded(int signFigures) {
        return Utils.doubleToString(Utils.round(xmax, this.getNbRelevantXDecimals(signFigures)));
    }

    public String getYMinRounded(int signFigures) {
        return Utils.doubleToString(Utils.round(ymin, this.getNbRelevantYDecimals(signFigures)));
    }

    public String getYMaxRounded(int signFigures) {
        return Utils.doubleToString(Utils.round(ymax, this.getNbRelevantYDecimals(signFigures)));
    }

    public String getXValueRounded(double x, int signFigures) {
        return Utils.doubleToString(Utils.round(x, this.getNbRelevantXDecimals(signFigures)));
    }

    public String getYValueRounded(double y, int signFigures) {
        return Utils.doubleToString(Utils.round(y, this.getNbRelevantYDecimals(signFigures)));
    }

    public boolean screenCoordinateIsOnScreen(int xscreen, int yscreen) {
        return xscreen >= 0 && xscreen < this.screenWidth && yscreen >= 0 && yscreen < this.screenHeight;
    }

    public boolean functionCoordinateIsOnScreen(double xValue, double yValue) {
        return this.screenCoordinateIsOnScreen(this.transformXCoordinateToScreen(xValue), this.transformYCoordinateToScreen(yValue));
    }

    public void setSize(int width, int height) {
        this.screenWidth = width;
        this.screenHeight = height;
        this.screenSizeChanged();
    }

    public void moveRight() {
        double step = MOVE_SCREENS * (xmax - xmin);
        xmin += step;
        xmax += step;
        this.screenSizeChanged();
    }

    public void moveLeft() {
        double step = MOVE_SCREENS * (xmax - xmin);
        xmin -= step;
        xmax -= step;
        this.screenSizeChanged();
    }

    public void moveUp() {
        double step = MOVE_SCREENS * (ymax - ymin);
        ymin += step;
        ymax += step;
        this.screenSizeChanged();
    }

    public void moveDown() {
        double step = MOVE_SCREENS * (ymax - ymin);
        ymin -= step;
        ymax -= step;
        this.screenSizeChanged();
    }

    public void moveFromTo(int xScreenFrom, int yScreenFrom, int newXScreen, int newYScreen) {
        double xStepCoordinate = this.transformXCoordinateFromScreen(xScreenFrom) - this.transformXCoordinateFromScreen(newXScreen);
        xmin += xStepCoordinate;
        xmax += xStepCoordinate;
        double yStepCoordinate = this.transformYCoordinateFromScreen(yScreenFrom) - this.transformYCoordinateFromScreen(newYScreen);
        ymin += yStepCoordinate;
        ymax += yStepCoordinate;
        this.screenSizeChanged();
    }

    public void zoomInRoundPoint(int xScreen, int yScreen) {
        double width = xmax - xmin;
        double newWidth = width / ZOOM_FACTOR;
        double xScreenCenter = this.transformXCoordinateFromScreen(xScreen);
        xmin = xScreenCenter - newWidth / 2.0;
        xmax = xScreenCenter + newWidth / 2.0;
        double height = ymax - ymin;
        double newHeight = height / ZOOM_FACTOR;
        double yScreenCenter = this.transformYCoordinateFromScreen(yScreen);
        ymin = yScreenCenter - newHeight / 2.0;
        ymax = yScreenCenter + newHeight / 2.0;
        this.screenSizeChanged();
    }

    public void zoomInHorizontal() {
        double width = xmax - xmin;
        double xScreenCenter = xmin + width / 2.0;
        double newWidth = width / ZOOM_FACTOR;
        xmin = xScreenCenter - newWidth / 2.0;
        xmax = xScreenCenter + newWidth / 2.0;
        this.screenSizeChanged();
    }

    public void zoomOutHorizontal() {
        double width = xmax - xmin;
        double xScreenCenter = xmin + width / 2.0;
        double newWidth = width * ZOOM_FACTOR;
        xmin = xScreenCenter - newWidth / 2.0;
        xmax = xScreenCenter + newWidth / 2.0;
        this.screenSizeChanged();
    }

    public void zoomOutVertical() {
        double height = ymax - ymin;
        double yScreenCenter = ymin + height / 2.0;
        double newHeight = height * ZOOM_FACTOR;
        ymin = yScreenCenter - newHeight / 2.0;
        ymax = yScreenCenter + newHeight / 2.0;
        this.screenSizeChanged();
    }

    public void zoomInVertical() {
        double height = ymax - ymin;
        double yScreenCenter = ymin + height / 2.0;
        double newHeight = height / ZOOM_FACTOR;
        ymin = yScreenCenter - newHeight / 2.0;
        ymax = yScreenCenter + newHeight / 2.0;
        this.screenSizeChanged();
    }

    public void resetZoom() {
        xmin = -10.0;
        xmax = 10.0;
        ymin = -10.0;
        ymax = 10.0;
        this.screenSizeChanged();
    }

    protected void screenSizeChanged() {
        GraphCanvas.setState(30, "PlotterScreen.screenSizeChanged()");
    }

    public Image getLastImage() {
        return this.lastImage;
    }

    public void setLastImage(Image lastImage) {
        this.lastImage = lastImage;
    }

    public void showLastImage(Graphics g) {
        if (this.lastImage != null) {
            g.drawImage(this.lastImage, 0, 0, 20);
        }
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    public void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }
}

