/*
 * Decompiled with CFR 0.152.
 */
package graph.utils;

import graph.core.CalculateException;
import graph.core.Settings;
import graph.eqn.Derivate;
import graph.eqn.Expression;
import graph.eqn.YDerivate;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Utils {
    public static final double round(double nb, int nbDecimals) {
        if (Double.isNaN(nb)) {
            return Double.NaN;
        }
        double factor = Utils.pow(10.0, nbDecimals);
        double numberToRound = nb * factor;
        double rounded = Math.floor(numberToRound + 0.5);
        return rounded / factor;
    }

    public static final double roundOnFiveTwoOrOne(double number) {
        double figure5;
        if (Double.isNaN(number)) {
            return Double.NaN;
        }
        int log = Utils.getNumberOfFiguresBeforeDecimalPoint(Math.abs(number));
        double factor = Utils.pow(10.0, -log + 1);
        double numberToRound = number * factor;
        double roundedNumber = Math.floor(numberToRound + 0.5);
        double figure1 = Utils.roundOnMultiples(10.0, roundedNumber);
        if (figure1 == 0.0) {
            figure1 = 1.0;
        }
        if ((figure5 = Utils.roundOnMultiples(5.0, roundedNumber)) == 0.0) {
            figure5 = 0.5;
        }
        double figure = Math.abs(figure5 - numberToRound) < Math.abs(figure1 - numberToRound) ? figure5 : figure1;
        if (Math.abs(2.0 - numberToRound) < Math.abs(figure - numberToRound)) {
            figure = 2.0;
        }
        return figure / factor;
    }

    public static final double roundOnMultiples(double base, double number) {
        double single = (long)((number + base / 2.0) / base);
        return single * base;
    }

    public static final double pow(double ground, double exp) {
        if (!Utils.isValidDouble(exp) || !Utils.isValidDouble(ground)) {
            return Double.NaN;
        }
        if (exp < 0.0) {
            return 1.0 / Utils.powRecursive(ground, -exp, 0, Settings.getMaxDepth());
        }
        return Utils.powRecursive(ground, exp, 0, Settings.getMaxDepth());
    }

    private static final double powRecursive(double ground, double exp, int depth, int maxDepth) {
        if (exp == 0.0) {
            return 1.0;
        }
        if (ground == 0.0) {
            return 0.0;
        }
        if (!Utils.isNatural(exp) && depth < maxDepth) {
            if (exp > 1.0) {
                return Utils.powRecursive(ground, Math.floor(exp), depth + 1, maxDepth) * Utils.powRecursive(ground, exp - Math.floor(exp), depth + 1, maxDepth);
            }
            ground = Math.sqrt(ground);
            return Utils.powRecursive(ground, exp *= 2.0, depth + 1, maxDepth);
        }
        return Utils.powerNatural(ground, (long)(exp + 0.5));
    }

    private static final double powerNatural(double ground, long power) {
        if (power < 0L || !Utils.isValidDouble(ground)) {
            return Double.NaN;
        }
        if (power == 0L) {
            return 1.0;
        }
        if (power == 1L) {
            return ground;
        }
        double halfPower = Utils.powerNatural(ground, power / 2L);
        if (power % 2L == 0L) {
            return halfPower * halfPower;
        }
        return ground * halfPower * halfPower;
    }

    public static final boolean isNatural(double number) {
        return number == Math.floor(number);
    }

    public static final int logTenBase(double number) {
        return (int)Utils.logNatural(10.0, number);
    }

    public static final double log(double base, double number) {
        if (number <= 0.0 || !Utils.isValidDouble(base) || !Utils.isValidDouble(number)) {
            return Double.NaN;
        }
        return Utils.logRecursive(base, number, 0);
    }

    private static final double logRecursive(double base, double number, int depth) {
        if (number == 1.0) {
            return 0.0;
        }
        if (depth > Settings.getMaxDepth()) {
            return Utils.logNatural(base, number);
        }
        if (number >= base) {
            return 1.0 + Utils.logRecursive(base, number / base, depth + 1);
        }
        if (number < 1.0) {
            return -1.0 + Utils.logRecursive(base, number * base, depth + 1);
        }
        return Utils.logRecursive(base, number * number, depth + 1) / 2.0;
    }

    public static final int getNumberOfFiguresBeforeDecimalPoint(double number) {
        int log = (int)Utils.logNatural(10.0, number);
        if (Utils.powerNatural(10.0, log) == number) {
            ++log;
        }
        return log;
    }

    public static final double logNatural(double base, double number) {
        if (number <= 0.0 || !Utils.isValidDouble(base) || !Utils.isValidDouble(number)) {
            return Double.NaN;
        }
        int counter = 0;
        if (number > 1.0) {
            while (number > 1.0) {
                ++counter;
                number /= base;
            }
        } else {
            ++counter;
            while (number <= 1.0) {
                --counter;
                number *= base;
            }
        }
        return counter;
    }

    /*
     * Unable to fully structure code
     */
    public static final String doubleToString(double a) {
        output = "" + a;
        if (output.indexOf(46) != -1) ** GOTO lbl5
        return output;
lbl-1000:
        // 1 sources

        {
            output = output.substring(0, output.length() - 1);
lbl5:
            // 2 sources

            ** while (output.substring((int)(output.length() - 1)).equals((Object)"0") && output.indexOf((int)69) == -1)
        }
lbl6:
        // 1 sources

        if (output.substring(output.length() - 1).equals(".")) {
            output = output.substring(0, output.length() - 1);
        }
        return var2_1;
    }

    public static final boolean hasOppositeSign(double a, double b) {
        return a > 0.0 && b <= 0.0 || a <= 0.0 && b > 0.0;
    }

    public static final boolean isValidDouble(double a) {
        return !Double.isInfinite(a) && !Double.isNaN(a);
    }

    public static final double faculty(double number) {
        if (!Utils.isValidDouble(number) || number < 0.0) {
            return Double.NaN;
        }
        if (number == 0.0) {
            return 0.0;
        }
        double result = 1.0;
        int i = 1;
        while ((double)i <= number) {
            result *= (double)i;
            ++i;
        }
        return result;
    }

    public static final double[][] resetMatrix(double[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix.length) {
                matrix[i][j] = Double.NaN;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static final double getNullpoint(Expression eqn, double leftMargin, double rightMargin, double precision) throws CalculateException {
        double functionRight;
        double functionLeft = eqn.getValue(leftMargin, 0.0);
        if (!Utils.hasOppositeSign(functionLeft, functionRight = eqn.getValue(rightMargin, 0.0))) {
            eqn.getValue(leftMargin, 0.0);
            eqn.getValue(rightMargin, 0.0);
            throw new CalculateException("No nullpoint found in the interval: [" + leftMargin + ", " + rightMargin + "]");
        }
        double interval = rightMargin - leftMargin;
        double middle = (leftMargin + rightMargin) / 2.0;
        if (interval < precision / 5.0) {
            return middle;
        }
        double functionMiddle = eqn.getValue(middle, 0.0);
        if (Utils.hasOppositeSign(functionLeft, functionMiddle)) {
            return Utils.getNullpoint(eqn, leftMargin, middle, precision);
        }
        return Utils.getNullpoint(eqn, middle, rightMargin, precision);
    }

    public static final double getXValueUsingNewtonApproximation(Expression expr, double xValue, int maxDepth, int currentDepth) throws CalculateException {
        if (currentDepth >= maxDepth) {
            return xValue;
        }
        Derivate derivate = new Derivate(expr);
        double newX = Utils.getXValueUsingNewtonApproximation(expr, xValue, maxDepth, currentDepth + 1);
        double quotient = newX - expr.getValue(newX, 0.0) / derivate.getFunctionValue(newX);
        return quotient;
    }

    public static final double getYValueUsingNewtonApproximationIterative(Expression expr, double xValue, double yStartValue, int nbRelevantDecimals) throws CalculateException {
        double y = yStartValue;
        int maxNbIterations = Settings.getMaxDepth();
        double precision = Utils.pow(0.1, nbRelevantDecimals);
        YDerivate derivate = new YDerivate(expr);
        int i = 0;
        while (i < maxNbIterations) {
            double newY;
            double differenceBetweenLastAndCurrentY;
            double noemer = derivate.getValue(xValue, y);
            if (noemer == 0.0 && i == 0) {
                y = yStartValue + 10.0;
                noemer = derivate.getValue(xValue, y);
            }
            if ((differenceBetweenLastAndCurrentY = Math.abs(y - (newY = y - expr.getValue(xValue, y) / noemer))) < precision) {
                y = newY;
                break;
            }
            if (i > 5 && differenceBetweenLastAndCurrentY > 0.1) {
                return Double.NaN;
            }
            y = newY;
            ++i;
        }
        return Utils.round(y, nbRelevantDecimals);
    }

    public static final int getNbOccurences(String string, char character) {
        int result = 0;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == character) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static final boolean doesnotContainAChar(String string, String notAllowedChars) {
        int i = 0;
        while (i < string.length()) {
            char currentChar = string.charAt(i);
            if (notAllowedChars.indexOf(currentChar) != -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String minlaatste(String string) {
        int i = string.length() - 1;
        if (i > 0) {
            return string.substring(0, i);
        }
        return "";
    }

    public static final void writeString(DataOutputStream dataOut, String string) throws IOException {
        dataOut.writeInt(string.length());
        dataOut.writeChars(string);
    }

    public static final String readString(DataInputStream dataIn) throws IOException {
        int length = dataIn.readInt();
        StringBuffer input = new StringBuffer(length);
        int i = 0;
        while (i < length) {
            input.append(dataIn.readChar());
            ++i;
        }
        return input.toString();
    }

    public static final String readString(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        DataInputStream dataIn = new DataInputStream(in);
        String result = Utils.readString(dataIn);
        return result;
    }
}

