/*
 * Decompiled with CFR 0.152.
 */
package graph;

import graph.CommandHandler;
import graph.Explorer;
import graph.GraphViewer;
import graph.MyDisplayable;
import graph.ProgressBarAlert;
import graph.core.Plotter;
import graph.core.Settings;
import graph.lang.Phrases;
import graph.utils.ImageUtils;
import graph.utils.Utils;
import java.util.Enumeration;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class SaveAsImageForm
extends Form
implements CommandListener,
ItemCommandListener,
MyDisplayable {
    private Command cancelCommand = new Command(Phrases.Cancel, 3, 0);
    private Command okCommand = new Command(Phrases.OK, 4, 0);
    private Command okItemCommand = new Command(Phrases.OK, 8, 0);
    private Command choiceDirCommand = new Command(Phrases.changeShort, Phrases.changePath, 1, -1);
    private String notAllowedChars = "\"*,\\/:;<>?|";
    private TextField nameField;
    private StringItem pathField;
    private TextField widthField;
    private TextField heightField;
    private StringItem okButton = new StringItem("", Phrases.OK, 2);
    private Plotter plotter;
    private Image image;
    private Runnable imageMakerRunnable = new Runnable(){

        public void run() {
            String name = SaveAsImageForm.this.nameField.getString();
            if (name.trim().length() == 0) {
                CommandHandler.getInstance().alertException(Phrases.emptyName);
            } else if (!Utils.doesnotContainAChar(name, SaveAsImageForm.this.notAllowedChars)) {
                CommandHandler.getInstance().alertException(Phrases.invalidName);
            } else {
                int imageHeight;
                int imageWidth;
                ProgressBarAlert progressBarAlert = new ProgressBarAlert(Phrases.busy, Phrases.creatingImage, -1, null);
                progressBarAlert.show(null);
                String fileURL = "file:///" + SaveAsImageForm.this.pathField.getText() + name + ".png";
                int oldScreenWidth = SaveAsImageForm.this.plotter.getScreenWidth();
                int oldScreenHeight = SaveAsImageForm.this.plotter.getScreenHeight();
                try {
                    imageWidth = Integer.parseInt(SaveAsImageForm.this.widthField.getString());
                    imageHeight = Integer.parseInt(SaveAsImageForm.this.heightField.getString());
                    Settings.saveImageWidth = imageWidth;
                    Settings.saveImageHeight = imageHeight;
                    Settings.isChanged = true;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                    imageWidth = oldScreenWidth;
                    imageHeight = oldScreenHeight;
                }
                SaveAsImageForm.this.image = Image.createImage((int)imageWidth, (int)imageHeight);
                SaveAsImageForm.this.plotter.setScreenWidth(imageWidth);
                SaveAsImageForm.this.plotter.setScreenHeight(imageHeight);
                Settings.setInternalPrecision(100);
                SaveAsImageForm.this.plotter.plot(SaveAsImageForm.this.image.getGraphics());
                SaveAsImageForm.this.plotter.setScreenWidth(oldScreenWidth);
                SaveAsImageForm.this.plotter.setScreenHeight(oldScreenHeight);
                try {
                    ImageUtils.saveImage(SaveAsImageForm.this.image, fileURL);
                    CommandHandler.getInstance().alertMessage(Phrases.saved, String.valueOf(Phrases.ImageSavedAs) + ": " + name, (Displayable)GraphViewer.graphCanvas);
                }
                catch (OutOfMemoryError e) {
                    CommandHandler.getInstance().alertException(String.valueOf(Phrases.errorWhileSavingImage) + ": " + Phrases.outOfMemoryError);
                }
                catch (SecurityException e) {
                    CommandHandler.getInstance().alertException(Phrases.errorWhileSavingImage, (Displayable)GraphViewer.graphCanvas);
                }
                catch (Throwable e) {
                    CommandHandler.getInstance().alertException(Phrases.errorWhileSavingImage);
                }
            }
        }
    };

    public SaveAsImageForm(Plotter plotter) {
        super(Phrases.saveAsImage);
        try {
            this.ndsInit(plotter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void ndsInit(Plotter plotter) throws Exception {
        this.plotter = plotter;
        this.nameField = new TextField(Phrases.name, "", 50, 524288);
        this.pathField = new StringItem(Phrases.path, this.getDefaultPath(), 0);
        this.widthField = new TextField(Phrases.imageWidth, "" + Settings.saveImageWidth, 3, 2);
        this.heightField = new TextField(Phrases.imageHeight, "" + Settings.saveImageHeight, 3, 2);
        this.setCommandListener(this);
        this.addCommand(this.okCommand);
        this.addCommand(this.cancelCommand);
        this.addCommand(this.choiceDirCommand);
        this.append((Item)this.nameField);
        this.append((Item)this.pathField);
        this.pathField.addCommand(this.choiceDirCommand);
        this.append((Item)this.widthField);
        this.append((Item)this.heightField);
        this.append((Item)this.okButton);
        this.okButton.setDefaultCommand(this.okItemCommand);
        this.okButton.setItemCommandListener((ItemCommandListener)this);
    }

    private String getDefaultPath() {
        if (Settings.defaultPath == null || Settings.defaultPath.length() == 0) {
            Enumeration roots = FileSystemRegistry.listRoots();
            String lastRoot = "";
            while (roots.hasMoreElements()) {
                lastRoot = roots.nextElement().toString();
            }
            return lastRoot;
        }
        return Settings.defaultPath;
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == this.okCommand || command == this.okItemCommand) {
            new Thread(this.imageMakerRunnable).start();
        } else if (command == this.cancelCommand) {
            CommandHandler.getInstance().goBack();
        } else if (command == this.choiceDirCommand) {
            CommandHandler.getInstance().setCurrentDisplayable((Displayable)new Explorer(this.pathField));
        }
    }

    public void commandAction(Command command, Item item) {
        this.commandAction(command, (Displayable)this);
    }

    public void show(Displayable previousDisplayable) {
    }

    public void hide(Displayable nextDisplayable) {
    }
}

