/*
 * Decompiled with CFR 0.152.
 */
package graph.eqn;

import graph.core.CalculateException;
import graph.core.Plotter;
import graph.core.Settings;
import graph.eqn.Equation;
import graph.eqn.Expression;
import graph.utils.Utils;

public class ComplexEquation
extends Equation {
    protected Expression expression;
    private static double DEFAULT_Y_STARTVALUE = 5.0;

    public ComplexEquation(Expression expression) {
        this.expression = expression;
    }

    public double getFunctionValue(double xValue) {
        try {
            return Utils.getYValueUsingNewtonApproximationIterative(this.expression, xValue, this.getYStartValue(), Settings.getNbDecimals());
        }
        catch (CalculateException e) {
            return Double.NaN;
        }
    }

    private double getYStartValue() {
        double startValue = Plotter.ymin + (Plotter.ymax - Plotter.ymin) / 2.0;
        if (Utils.isValidDouble(startValue)) {
            return startValue;
        }
        return DEFAULT_Y_STARTVALUE;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getFunctionAsString() {
        return String.valueOf(this.expression.getFunctionAsString()) + "=0";
    }
}

