/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;

public class App
extends MIDlet {
    public static App app;
    private static Runtime rt;
    private static Class appClass;
    public static Display display;
    public static Canvas canvas;
    static final int START_NONE = 0;
    static final int START_INITIALIZING = 1;
    static final int START_TOUCHING_CLASSES = 2;
    static final int START_STARTING = 3;
    static final int START_STARTED = 4;
    private static int started;
    public static long baseTime;
    public static int lastTime;
    public static int time;
    public static int gameTime;
    public static int touchClassesTime;
    public static int startupMemory;
    public static int imageMemory;
    public static int imageStartMem;
    public static long initialMemory;
    public static long peakMemoryUsage;
    public static String peakMemoryDesc;
    public static final Integer pausingLock;
    public static final int NOT_PAUSED = 0;
    public static final int PAUSING = 1;
    public static final int PAUSED = 2;
    public static int paused;
    public static final int UNSAFE_PAUSE_STATES = 82561;
    private static boolean inError;
    private static int[] imageIndex;
    private static int lastImageChunk;
    private static int lastImageIndex;
    private static InputStream lastImageStream;
    private static int seed;
    public static byte[] TBL_ENUMS_OSC_CYCLE;
    public static byte[] TBL_CANVAS_KEYSNUMERIC;
    public static byte[] TBL_COMBAT_WEAPONINFO;
    public static byte[] TBL_COMBAT_MONSTERSTATS;
    public static byte[] TBL_COMBAT_WEAPONDATA;
    public static byte[] TBL_MONSTER_WEAKNESS;
    public static byte[] TBL_MONSTER_COLORS;
    public static byte[] TBL_COCKTAIL_RECIPES;
    public static short[] TBL_COCKTAIL_NAMES;
    public static int[] TBL_COMBAT_COMBATMASKS;
    public static short[] TBL_GAME_LEVELNAMES;
    public static short[] TBL_COMBAT_MONSTERATTACKS;
    public static byte[] TBL_MEDALS;
    public static byte[] TBL_BOOKS;
    public static int[] TBL_RENDER_SINETABLE;

    protected void startApp() throws MIDletStateChangeException {
        if (started == 0) {
            started = 1;
            app = this;
            appClass = ((Object)((Object)this)).getClass();
            rt = Runtime.getRuntime();
            initialMemory = App.getMemFootprint();
            baseTime = System.currentTimeMillis();
            display = Display.getDisplay((MIDlet)this);
            App.touchClasses();
            canvas = new Canvas(this);
            display.setCurrent((Displayable)canvas);
            canvas.start();
        } else {
            App.unpause();
            if (started == 4) {
                Canvas.resume();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void pause(boolean bl) {
        Integer n = pausingLock;
        synchronized (n) {
            if (paused == 0) {
                paused = 1;
            } else if (paused == 2) {
                return;
            }
            if (bl) {
                try {
                    pausingLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unpause() {
        Integer n = pausingLock;
        synchronized (n) {
            if (paused == 2) {
                paused = 0;
                pausingLock.notifyAll();
            } else if (paused == 1) {
                paused = 0;
                pausingLock.notifyAll();
            }
        }
    }

    public static final void checkPausedState() {
        App.checkPausedState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkPausedState(int n) {
        if (n > 0) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (paused != 0) {
            Integer n2 = pausingLock;
            synchronized (n2) {
                if (paused == 1) {
                    paused = 2;
                    pausingLock.notifyAll();
                }
                if (paused == 2) {
                    try {
                        pausingLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void pauseApp() {
        App.pause((1 << Canvas.state & 0x14281) != 0);
        Sound.soundStop();
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        App.unpause();
        canvas.stop();
        Sound.soundStop();
        Game.unloadMapData();
        Render.shutdown();
        Canvas.freeRuntimeData();
    }

    public boolean startup() {
        int n = App.getUpTimeMs();
        try {
            gameTime = App.getUpTimeMs();
            startupMemory = App.getFreeMemory();
            if (!Canvas.startup()) {
                return false;
            }
            Canvas.updateLogos();
            Canvas.updateLogos();
            if (!Text.startup()) {
                return false;
            }
            Canvas.updateLogos();
            if (!Render.startup()) {
                return false;
            }
            Canvas.updateLogos();
            if (!TinyGL.startup(Render.screenWidth, Render.screenHeight)) {
                return false;
            }
            Canvas.updateLogos();
            if (!EntityDef.startup()) {
                return false;
            }
            Canvas.updateLogos();
            if (!Player.startup()) {
                return false;
            }
            Canvas.updateLogos();
            if (!MenuSystem.startup()) {
                return false;
            }
            Canvas.updateLogos();
            if (!Sound.startup()) {
                return false;
            }
            Canvas.updateLogos();
            if (!Game.startup()) {
                return false;
            }
            Canvas.updateLogos();
            ParticleSystem.startup();
            Canvas.updateLogos();
            if (!Combat.startup()) {
                return false;
            }
            int n2 = App.getFreeMemory();
            startupMemory -= n2;
            Canvas.updateLogos();
            Game.loadConfig();
            App.checkPausedState();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Canvas.clearEvents();
            while (!Canvas.skipIntro && Canvas.updateLogos()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                App.checkPausedState();
            }
            n = App.getUpTimeMs() - n;
            started = 4;
        }
        catch (Exception exception) {
            App.Error(exception, 57);
        }
        return true;
    }

    public static final void Error(Throwable throwable, int n) {
        TinyGL.pixels = null;
        Text.freeAllBuffers();
        System.gc();
        if (!inError) {
            inError = true;
            Text text = Text.getLargeBuffer();
            Text.resetTextArgs();
            Text.addTextArg(n);
            Text.composeText((short)1, (short)36, text);
            text.dehyphenate();
            if (throwable != null) {
                text.append(" (");
                text.append(throwable.toString());
                text.append(")");
            }
            Alert alert = new Alert("Error " + n + "!");
            alert.setType(AlertType.ERROR);
            alert.setTimeout(-2);
            StringBuffer stringBuffer = new StringBuffer(text.length());
            for (int i = 0; i < text.length(); ++i) {
                stringBuffer.append(text.charAt(i));
            }
            alert.setString(stringBuffer.toString());
            display.setCurrent((Displayable)alert);
            text.dispose();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    public static final void Error(int n) {
        App.Error(null, n);
    }

    public final void shutdown() {
        this.notifyDestroyed();
    }

    public static final void beginImageLoading() {
        imageStartMem = App.getFreeMemory();
        try {
            imageIndex = Resource.loadFileIndex("/images.idx");
            lastImageIndex = -1;
            lastImageChunk = -1;
            lastImageStream = null;
        }
        catch (Throwable throwable) {
            App.Error(throwable, 56);
        }
    }

    public static final void endImageLoading() {
        imageIndex = null;
        lastImageStream = null;
        System.gc();
        imageMemory += imageStartMem - App.getFreeMemory();
    }

    public static final void beginImageUnload() {
        imageStartMem = App.getFreeMemory();
    }

    public static final void endImageUnload() {
        imageMemory -= App.getFreeMemory() - imageStartMem;
    }

    public static final InputStream getResourceAsStream(String string) {
        App.checkPausedState();
        InputStream inputStream = appClass.getResourceAsStream(string);
        App.checkPausedState();
        App.checkPeakMemory(string);
        return inputStream;
    }

    public static final Image loadImageFromIndex(int n) {
        Image image = null;
        App.checkPausedState();
        try {
            InputStream inputStream;
            int n2 = imageIndex[n * 3 + 2];
            if (lastImageChunk != imageIndex[n * 3]) {
                lastImageChunk = imageIndex[n * 3];
                lastImageIndex = n;
                inputStream = lastImageStream = App.getResourceAsStream("images" + lastImageChunk + ".bin");
                App.checkPausedState();
                Resource.bufSkip(inputStream, imageIndex[n * 3 + 1], false);
                App.checkPausedState();
            } else {
                inputStream = lastImageStream;
                Resource.bufSkip(inputStream, imageIndex[n * 3 + 1] - imageIndex[lastImageIndex * 3 + 1] - imageIndex[lastImageIndex * 3 + 2], false);
                App.checkPausedState();
                lastImageIndex = n;
            }
            Resource.read(inputStream, n2);
            App.checkPausedState();
            System.gc();
            App.checkPausedState();
            int n3 = App.getFreeMemory();
            image = Image.createImage((byte[])Resource.ioBuffer, (int)0, (int)n2);
            int n4 = n3 - App.getFreeMemory();
            App.checkPausedState();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            App.Error(throwable, 56);
        }
        return image;
    }

    public static final int getUpTimeMs() {
        return (int)(System.currentTimeMillis() - baseTime);
    }

    public static final int getMemFootprint() {
        System.gc();
        return (int)(rt.totalMemory() - rt.freeMemory());
    }

    public static int getTotalMemory() {
        System.gc();
        return (int)rt.totalMemory();
    }

    public static int getFreeMemory() {
        System.gc();
        return (int)rt.freeMemory();
    }

    public static void checkPeakMemory(String string) {
        int n = App.getMemFootprint();
        if ((long)n > peakMemoryUsage) {
            peakMemoryUsage = n;
            peakMemoryDesc = string;
        }
    }

    public static int findLargestMemoryBlock() {
        int n = 0;
        int n2 = App.getFreeMemory();
        int n3 = 0;
        byte[] byArray = null;
        while (n2 - n3 > 1) {
            n = (n2 + n3) / 2;
            try {
                byArray = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            if (byArray != null) {
                byArray = null;
                System.gc();
                n3 = n;
                continue;
            }
            n2 = n;
        }
        return n;
    }

    public static int getFragmentSize() {
        return App.getFreeMemory() - App.findLargestMemoryBlock();
    }

    public static void loadRuntimeImages() {
        Canvas.updateLoadingBar(false);
        App.beginImageLoading();
        Canvas.imgMapCursor = App.loadImageFromIndex(1);
        Hud.imgDamageVignette = App.loadImageFromIndex(2);
        Hud.imgActions = App.loadImageFromIndex(9);
        Canvas.updateLoadingBar(false);
        Hud.imgBottomBarIcons = App.loadImageFromIndex(12);
        Canvas.updateLoadingBar(false);
        Hud.imgHudFill = App.loadImageFromIndex(13);
        Hud.imgPlayerFaces = App.loadImageFromIndex(14);
        Hud.imgIce = App.loadImageFromIndex(16);
        Hud.imgScope = App.loadImageFromIndex(28);
        ParticleSystem.imgGibs[2] = App.loadImageFromIndex(29);
        ParticleSystem.imgGibs[1] = App.loadImageFromIndex(31);
        ParticleSystem.imgGibs[0] = App.loadImageFromIndex(40);
        App.endImageLoading();
        Canvas.updateLoadingBar(false);
    }

    public static void freeRuntimeImages() {
        App.beginImageUnload();
        Canvas.imgMapCursor = null;
        Hud.imgDamageVignette = null;
        Hud.imgActions = null;
        Hud.imgBottomBarIcons = null;
        Hud.imgHudFill = null;
        Hud.imgPlayerFaces = null;
        Hud.imgScope = null;
        Hud.imgIce = null;
        ParticleSystem.imgGibs[2] = null;
        ParticleSystem.imgGibs[1] = null;
        ParticleSystem.imgGibs[0] = null;
        App.endImageUnload();
    }

    public static final short nextByte() {
        return (short)(App.nextInt() & 0xFF);
    }

    public static final int nextInt() {
        seed = 69069 * seed + 1;
        return seed & Integer.MAX_VALUE;
    }

    private static final void touchClasses() {
        touchClassesTime = App.getUpTimeMs();
        startupMemory = App.getFreeMemory();
        display.vibrate(0);
        System.gc();
        if (0 == Resource.touchMe + Canvas.touchMe + Combat.touchMe + CombatEntity.touchMe + Entity.touchMe + EntityDef.touchMe + EntityMonster.touchMe + Game.touchMe + GameSprite.touchMe + Hud.touchMe + LerpSprite.touchMe + MenuItem.touchMe + MenuSystem.touchMe + ParticleSystem.touchMe + Player.touchMe + Render.touchMe + ScriptThread.touchMe + Sound.touchMe + CardGames.touchMe + MayaCamera.touchMe) {
            started = 2;
        }
        System.gc();
        System.gc();
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray != null && stringArray.length > 0) {
            started = 2;
        }
        stringArray = null;
        System.gc();
        startupMemory -= App.getFreeMemory();
        touchClassesTime = App.getUpTimeMs() - touchClassesTime;
    }

    public static void loadTables() {
        TBL_COMBAT_WEAPONINFO = new byte[Resource.getNumTableBytes(1)];
        TBL_COMBAT_WEAPONDATA = new byte[Resource.getNumTableBytes(2)];
        TBL_COMBAT_MONSTERSTATS = new byte[Resource.getNumTableBytes(3)];
        TBL_CANVAS_KEYSNUMERIC = new byte[Resource.getNumTableBytes(5)];
        TBL_ENUMS_OSC_CYCLE = new byte[Resource.getNumTableBytes(6)];
        TBL_COMBAT_MONSTERATTACKS = new short[Resource.getNumTableShorts(0)];
        TBL_COMBAT_COMBATMASKS = new int[Resource.getNumTableInts(4)];
        TBL_GAME_LEVELNAMES = new short[Resource.getNumTableShorts(7)];
        TBL_MONSTER_COLORS = new byte[Resource.getNumTableBytes(8)];
        TBL_MONSTER_WEAKNESS = new byte[Resource.getNumTableBytes(12)];
        TBL_RENDER_SINETABLE = new int[Resource.getNumTableInts(9)];
        TBL_COCKTAIL_RECIPES = new byte[Resource.getNumTableBytes(10)];
        TBL_COCKTAIL_NAMES = new short[Resource.getNumTableShorts(11)];
        TBL_MEDALS = new byte[Resource.getNumTableBytes(13)];
        TBL_BOOKS = new byte[Resource.getNumTableBytes(14)];
        try {
            Resource.beginTableLoading();
            Resource.loadShortTable(TBL_COMBAT_MONSTERATTACKS, 0);
            Resource.loadByteTable(TBL_COMBAT_WEAPONINFO, 1);
            Resource.loadByteTable(TBL_COMBAT_WEAPONDATA, 2);
            Resource.loadByteTable(TBL_COMBAT_MONSTERSTATS, 3);
            Resource.loadIntTable(TBL_COMBAT_COMBATMASKS, 4);
            Resource.loadByteTable(TBL_CANVAS_KEYSNUMERIC, 5);
            Resource.loadByteTable(TBL_ENUMS_OSC_CYCLE, 6);
            Resource.loadShortTable(TBL_GAME_LEVELNAMES, 7);
            Resource.loadByteTable(TBL_MONSTER_COLORS, 8);
            Resource.loadIntTable(TBL_RENDER_SINETABLE, 9);
            Resource.loadByteTable(TBL_COCKTAIL_RECIPES, 10);
            Resource.loadShortTable(TBL_COCKTAIL_NAMES, 11);
            Resource.loadByteTable(TBL_MONSTER_WEAKNESS, 12);
            Resource.loadByteTable(TBL_MEDALS, 13);
            Resource.loadByteTable(TBL_BOOKS, 14);
            Resource.finishTableLoading();
        }
        catch (Exception exception) {
            App.Error(exception, 77);
        }
    }

    static {
        started = 0;
        baseTime = 0L;
        lastTime = 0;
        time = 0;
        gameTime = 0;
        touchClassesTime = 0;
        imageMemory = 0;
        imageStartMem = 0;
        peakMemoryUsage = 0L;
        pausingLock = new Integer(0);
        paused = 0;
        inError = false;
        seed = (int)System.currentTimeMillis();
    }
}

