/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

final class Entity {
    public static int touchMe = 1;
    public static final int ENTITY_FLAG_GIBBED = 65536;
    public static final int ENTITY_FLAG_TAKEDAMAGE = 131072;
    public static final int ENTITY_FLAG_ACTIVE = 262144;
    public static final int ENTITY_FLAG_GHOST = 524288;
    public static final int ENTITY_FLAG_LINKED = 0x100000;
    public static final int ENTITY_FLAG_HASFOUGHT = 0x200000;
    public static final int ENTITY_FLAG_DROPPED = 0x200000;
    public static final int ENTITY_FLAG_DIRTY = 0x400000;
    public static final int ENTITY_FLAG_CORPSE = 0x1000000;
    public static final int ENTITY_FLAG_DEATHFUNC = 0x2000000;
    public static final int ENTITY_FLAG_HURT = 0x4000000;
    public static final int ENTITY_FLAG_RAISETARGET = 0x8000000;
    public static final int ENTITY_FLAG_NOSNAP = 0x10000000;
    public static final int ENTITY_FLAG_DONT_BREATHE = 0x20000000;
    private static final int MAX_ARCH_VILE_REVIVE_RANGE = 102400;
    private static final int TURNS_BETWEEN_REVIVES = 4;
    EntityDef def;
    EntityMonster monster;
    Entity nextOnTile;
    Entity prevOnTile;
    short linkIndex;
    short name;
    int info;
    int param;
    public int[] lootSet = null;
    static final int DIR_BITS = 2;
    static final int NUM_DIRS = 4;
    static final int DIR_MASK = 3;
    static final int DIR_TABLE_SHIFT = 2;
    static final int PATH_BITS = 64;
    private static final int MAX_PATH_DEPTH = 8;
    private static final int MAX_DIST = 999999999;
    private static long curPath = 0L;
    private static int pathDepth = 0;
    private static int pathSearchDepth = 8;
    private static long closestPath = 0L;
    private static int closestPathDepth = 0;
    private static int closestPathDist = 999999999;
    private static final int LINE_OF_SIGHT_YES = 0;
    private static final int LINE_OF_SIGHT_NO = 1;
    private static final int LINE_OF_SIGHT_BOTH = 2;
    private static byte[] visitOrder = new byte[8];
    private static int[] visitDist = new int[8];
    private static int[] visitedTiles = new int[32];
    public static int[] baseVisitedTiles = new int[32];
    private static int lineOfSight = 2;
    private static int lineOfSightWeight = 0;
    private static Entity findEnt;
    private static Entity skipEnt;
    private static int interactClipMask;
    private static final int[] knockbackDelta;
    private static final Entity[] raiseTargets;
    private static final int[] pos;
    private static int[] tempSaveBuf;

    Entity() {
    }

    public void reset() {
        this.def = null;
        this.prevOnTile = null;
        this.nextOnTile = null;
        this.linkIndex = 0;
        this.info = 0;
        this.param = 0;
        this.monster = null;
        this.name = (short)-1;
        this.lootSet = null;
    }

    public void initspawn() {
        byte by = this.def.eType;
        byte by2 = this.def.eSubType;
        this.name = (short)(this.def.name | 0x400);
        int n = this.getSprite();
        int n2 = Render.mapSpriteInfo[n] & 0xFF;
        if (by == 2) {
            this.monster.ce = Combat.monsters[by2 * 3 + this.def.parm].clone();
            if (Game.difficulty == 4 || Game.difficulty == 2 && !this.isBoss()) {
                int n3 = this.monster.ce.getStat(1);
                n3 += n3 >> 2;
                this.monster.ce.setStat(1, n3);
                this.monster.ce.setStat(0, n3);
            }
            short s = 0;
            int n4 = 64;
            Render.mapSprites[Render.S_Z + n] = (short)(32 + Render.getHeight(Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n]));
            Render.relinkSprite(n);
            if ((by2 == 14 || by2 == 5) && this.def.parm == 0) {
                n4 = 42;
            }
            Render.mapSprites[Render.S_SCALEFACTOR + n] = n4;
            Render.mapSprites[Render.S_RENDERMODE + n] = s;
            this.info |= 0x20000;
            if (by2 == 15 || by2 == 16) {
                this.param = App.nextInt() % 3 + 3;
            }
        } else if (by == 7 && by2 != 3) {
            int n5 = n;
            Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] & 0xFFFEFFFF;
            if (n2 == 173) {
                Render.mapSprites[Render.S_SCALEFACTOR + n] = 32;
            }
        } else if (by == 10) {
            this.info |= 0x20000;
            if (by2 == 152) {
                Render.mapSprites[Render.S_Z + n] = (short)(Render.mapSprites[Render.S_Z + n] - 224);
            }
        } else if (this.def.eType == 9 && this.def.eSubType == 17) {
            this.info |= 0x420000;
        } else if (by == 3) {
            this.param = 1;
        }
        if (this.def.eType != 2 && this.def.eType != 9) {
            this.lootSet = null;
        } else {
            this.populateDefaultLootSet();
        }
    }

    public int getSprite() {
        return (this.info & 0xFFFF) - 1;
    }

    public boolean touched() {
        byte by = this.def.eType;
        if (by == 11 || by == 6) {
            if (this.touchedItem()) {
                Game.scriptStateVars[11] = this.def.tileIndex;
                Game.executeStaticFunc(11);
                if (this.isDroppedEntity()) {
                    Render.mapSprites[Render.S_ENT + this.getSprite()] = -1;
                    this.def = null;
                }
                return true;
            }
        } else if (by == 8) {
            if (!Player.isFamiliar) {
                if (this.def.eSubType == 1 && Player.buffs[9] == 0) {
                    Player.painEvent(null, false);
                    Player.pain(20, this, true);
                    Player.addStatusEffect(13, 5, 3);
                    Player.translateStatusEffects();
                } else if (this.def.eSubType == 0) {
                    Player.painEvent(null, false);
                    Player.pain(20, this, true);
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean touchedItem() {
        if (this.def.eSubType == 0) {
            int n = 1;
            if (this.isDroppedEntity()) {
                n = this.param;
            } else if (this.def.parm == 24) {
                n = 2 + App.nextInt() % 3;
            }
            if (!Player.give(this.def.eSubType, this.def.parm, n, false)) {
                Text text = Hud.getMessageBuffer(2);
                Text.resetTextArgs();
                Text.addTextArg((short)1, this.def.name);
                Text.composeText((short)0, (short)83, text);
                Hud.finishMessageBuffer();
                return false;
            }
            Text.resetTextArgs();
            if (this.def.eSubType == 0 && (this.def.parm == 19 || this.def.parm == 20)) {
                Text text = Hud.getMessageBuffer(3);
                Text.composeText((short)0, (short)84, text);
                Hud.repaintFlags |= 4;
            } else if (this.def.parm == 24) {
                Text text = Hud.getMessageBuffer(1);
                Text.resetTextArgs();
                Text.addTextArg(n);
                Text text2 = Text.getSmallBuffer();
                Text.composeText((short)1, this.def.longName, text2);
                Text.addTextArg(text2);
                Text.composeText((short)0, (short)86, text);
                text2.dispose();
            } else {
                Text text = Hud.getMessageBuffer(1);
                Text.addTextArg((short)1, this.def.longName);
                Text.composeText((short)0, (short)85, text);
            }
            Hud.finishMessageBuffer();
            if (!this.isDroppedEntity() && this.def.parm != 18) {
                Game.foundLoot(this.getSprite(), 1);
            }
        } else if (this.def.eSubType == 3) {
            int n = this.def.parm == 0 || this.def.parm == 2 ? 40 : 20;
            if (!Player.addHealth(n)) {
                Hud.addMessage((short)46, 2);
                return false;
            }
        } else if (this.def.eSubType == 2) {
            int n;
            if (this.isDroppedEntity()) {
                n = this.param;
            } else {
                n = 2 + App.nextInt() % 4;
                if (this.def.parm == 2) {
                    n &= 0xFFFFFFFE;
                }
            }
            if (!Player.give(2, this.def.parm, n, false)) {
                Hud.addMessage((short)87);
            } else {
                Text text = Hud.getMessageBuffer(1);
                Text.resetTextArgs();
                Text.addTextArg(n);
                Text text3 = Text.getSmallBuffer();
                Text.composeTextField(this.name, text3);
                Text.addTextArg(text3);
                Text.composeText((short)0, (short)86, text);
                Hud.finishMessageBuffer();
                text3.dispose();
                if (!this.isDroppedEntity()) {
                    Game.foundLoot(this.getSprite(), 1);
                }
            }
        } else if (this.def.eSubType == 1) {
            if (Player.weaponIsASentryBot(this.def.parm)) {
                if (Player.isFamiliar || Player.hasASentryBot()) return false;
                int n = this.isDroppedEntity() ? this.param : 100;
                Player.give(1, this.def.parm, 1, false);
                Player.ammo[7] = (short)n;
                Hud.addMessage((short)0, (short)223, 3);
            } else {
                Player.give(1, this.def.parm, 1, false);
                int n = this.def.parm * 9;
                if (Combat.weapons[n + 5] != 0) {
                    if ((1 << this.def.parm & 0x200) != 0) {
                        Player.give(2, Combat.weapons[n + 4], 8, true);
                    } else {
                        Player.give(2, Combat.weapons[n + 4], 10, true);
                    }
                }
                Text text = Hud.getMessageBuffer(1);
                Text.resetTextArgs();
                Text.addTextArg((short)1, this.def.longName);
                Text.composeText((short)0, (short)85, text);
                Hud.finishMessageBuffer();
                Player.showWeaponHelp(this.def.parm, false);
            }
            if (!this.isDroppedEntity()) {
                Game.foundLoot(this.getSprite(), 1);
            }
        }
        Game.remove(this);
        Sound.playSound(2);
        return true;
    }

    public boolean pain(int n, Entity entity) {
        boolean bl = false;
        int n2 = this.getSprite();
        if ((this.info & 0x20000) == 0) {
            return bl;
        }
        if (this.def.eType == 2) {
            int n3 = this.monster.ce.getStat(0);
            int n4 = this.monster.ce.getStat(1);
            n3 -= n;
            if (this.isBoss()) {
                int n5 = n4 >> 1;
                int n6 = n5 >> 1;
                int n7 = n4 - n6;
                if (n3 <= n7 && n3 + n > n7) {
                    boolean bl2 = bl = Game.executeStaticFunc(2) != 0;
                    if (n3 < n5) {
                        n3 = n5 + 1;
                    }
                } else if (n3 <= n5 && n3 + n > n5) {
                    boolean bl3 = bl = Game.executeStaticFunc(3) != 0;
                    if (n3 < n6) {
                        n3 = n6 + 1;
                    }
                } else if (n3 <= n6 && n3 + n > n6) {
                    boolean bl4 = bl = Game.executeStaticFunc(4) != 0;
                    if (n3 < 0) {
                        n3 = 1;
                    }
                }
                if (bl && (this.monster.flags & 0x20) != 0) {
                    Combat.animLoopCount = 1;
                }
            }
            if ((this.monster.flags & 4) != 0 && n3 <= 0) {
                n3 = 1;
            }
            this.monster.ce.setStat(0, n3);
            if (n3 > 0) {
                if (Combat.punchingMonster == 0 && 0 == (this.monster.monsterEffects & 2)) {
                    Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x6000;
                    this.monster.frameTime = App.time + 250;
                }
                if (Combat.attackerWeaponId != 2) {
                    this.monster.resetGoal();
                }
            } else if (0 == (this.monster.monsterEffects & 2)) {
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x6000;
                if (Combat.animLoopCount > 0) {
                    this.monster.frameTime = App.time + 250;
                }
                this.monster.frameTime = Combat.punchingMonster != 0 ? Combat.animEndTime + 200 : App.time + 250 + 200;
            }
        } else if (this.def.eType == 10) {
            byte by = this.def.eSubType;
            if (by == 1) {
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | 0x100;
                ParticleSystem.spawnParticles(2, -1, n2);
                Game.unlinkEntity(this);
            } else {
                if (by == 2 || by == 0) {
                    ParticleSystem.spawnParticles(2, -8421505, n2);
                } else if (by == 3) {
                    ParticleSystem.spawnParticles(1, -1, n2);
                    Canvas.turnEntityIntoWaterSpout(this);
                    return bl;
                }
                Game.remove(this);
                this.info |= 0x400000;
                int n8 = n2;
                Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] | 0x10000;
            }
        }
        return bl;
    }

    public void checkMonsterDeath(boolean bl, boolean bl2) {
        if (bl && (Player.weapons & 0x2000) != 0 && Combat.attackerWeaponId != 13) {
            Player.give(2, 6, 1);
        }
        if (this.monster != null) {
            if (bl2) {
                Sound.playSound(6);
            }
            if (bl) {
                int n = this.monster.ce.calcXP();
                if (this.isBoss()) {
                    n += 130;
                }
                Player.addXP(n);
            }
            if ((this.monster.flags & 0x80) == 0) {
                Player.fillMonsterStats();
                int[] nArray = Player.monsterStats;
                if (nArray[0] == nArray[1] && (Player.killedMonstersLevels & 1 << Canvas.loadMapID - 1) == 0) {
                    Player.showAchievementMessage(2);
                    Player.killedMonstersLevels |= 1 << Canvas.loadMapID - 1;
                }
            }
        }
    }

    public void died(boolean bl, Entity entity) {
        int n = this.getSprite();
        short s = Render.mapSprites[Render.S_X + n];
        short s2 = Render.mapSprites[Render.S_Y + n];
        int n2 = Render.mapSpriteInfo[n];
        if ((this.info & 0x20000) == 0 || this.monster != null && (this.monster.flags & 4) != 0) {
            return;
        }
        this.info &= 0xFFFDFFFF;
        byte by = this.def.eType;
        byte by2 = this.def.eSubType;
        if (by == 10) {
            Text.resetTextArgs();
            Text text = Text.getSmallBuffer();
            Text.composeTextField(this.name, text);
            Text.addTextArg(text);
            Hud.addMessage((short)89);
            text.dispose();
            Player.addXP(5);
            if (this.def.eSubType != 3 && this.def.eSubType != 2) {
                Game.destroyedObject(n);
            }
        } else if (by == 9) {
            n2 |= 0x10000;
            this.info |= 0x410000;
            this.info &= 0xFFF7FFFF;
            if (null != this.monster) {
                this.monster.monsterEffects = 0;
            }
            Player.counters[4] = Player.counters[4] + 1;
            Game.unlinkEntity(this);
        } else if (by == 2) {
            int n3;
            this.info |= 0x400000;
            this.monster.resetGoal();
            Game.snapLerpSprites(this.getSprite());
            n2 = n2 & 0xFFFF00FF | 0x7000;
            this.monster.frameTime = App.time;
            if ((this.info & 0x10000) != 0) {
                n2 |= 0x10000;
            } else {
                this.info |= 0x1020000;
                this.trimCorpsePile(s, s2);
            }
            if (0 != (this.monster.monsterEffects & 2) || 0 != (this.monster.monsterEffects & 1)) {
                this.monster.clearEffects();
            } else {
                this.monster.monsterEffects &= 0xFFFF801F;
                this.monster.monsterEffects |= 0x220220;
            }
            if (Game.difficulty == 4 && (this.monster.flags & 0x40) == 0) {
                n3 = 2 + App.nextInt() % 3;
                this.monster.monsterEffects &= 0xFFFE1FFB;
                this.monster.monsterEffects |= n3 << 13;
                this.monster.monsterEffects |= 4;
            }
            Game.deactivate(this);
            this.undoAttack();
            if (this.isBoss()) {
                Player.inCombat = false;
                Game.executeStaticFunc(5);
            } else if (by2 == 2 || by2 == 6) {
                Game.gsprite_allocAnim(241, s, s2, Render.mapSprites[Render.S_Z + n]);
                n2 |= 0x10000;
                Game.spawnDropItem(this);
            }
            this.checkMonsterDeath(bl, true);
            if ((this.info & 0x10000) != 0 || by2 == 2 || by2 == 6) {
                this.info = this.info & 0xFEFDFFFF | 0x10000;
                Game.unlinkEntity(this);
            }
            this.def = EntityDef.find(9, by2, this.def.parm);
            this.name = (short)(this.def.name | 0x400);
            Canvas.invalidateRect();
            if (Game.difficulty == 4 && (this.monster.flags & 0x40) == 0 && (this.info & 0x80000) == 0) {
                n3 = 2 + App.nextInt() % 3;
                this.monster.monsterEffects |= n3 << 13;
                this.monster.monsterEffects |= 4;
            } else if ((this.info & 0x80000) != 0) {
                n2 |= 0x10000;
                this.info |= 0x410000;
                this.info &= 0xFFF7FFFF;
                Player.counters[4] = Player.counters[4] + 1;
                Game.unlinkEntity(this);
                GameSprite gameSprite = Game.gsprite_allocAnim(241, Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n], Render.mapSprites[Render.S_Z + n] - 20);
                gameSprite.flags |= 0x400;
                gameSprite.startScale = (byte)96;
                gameSprite.destScale = (byte)127;
                gameSprite.scaleStep = 38;
            }
        }
        if ((this.info & 0x2000000) != 0) {
            Game.executeEntityFunc(this, this.deathByExplosion(entity));
            this.info &= 0xFDFFFFFF;
        }
        Render.mapSpriteInfo[n] = n2;
        Canvas.updateFacingEntity = true;
    }

    private boolean deathByExplosion(Entity entity) {
        return entity == Player.getPlayerEnt() && Player.ce.weapon == 11;
    }

    void aiCalcSimpleGoal(boolean bl) {
        if (this.def.eSubType == 10 && this.aiCalcArchVileGoal()) {
            return;
        }
        if (Player.buffs[11] > 0 && (1 << this.def.eSubType & 0x1F801) == 0) {
            this.monster.goalType = (byte)4;
            this.monster.goalParam = 1;
            return;
        }
        Entity entity = Game.entities[1];
        int n = this.aiWeaponForTarget(entity);
        boolean bl2 = false;
        if (n != -1) {
            this.monster.ce.weapon = n;
            bl2 = true;
        }
        if (bl2) {
            this.monster.goalType = (byte)3;
            this.monster.goalParam = 1;
            if ((1 << this.def.eSubType & 0x4604) != 0) {
                this.monster.flags = (short)(this.monster.flags | 1);
            }
        } else {
            this.monster.goalType = (byte)2;
            this.monster.goalParam = 1;
            if ((1 << this.def.eSubType & 0x4604) != 0) {
                this.monster.flags = (short)(this.monster.flags & 0xFFFFFFFE);
            }
        }
    }

    public boolean aiCalcArchVileGoal() {
        return this.findRaiseTarget(102400, 0, 0) != -1;
    }

    private void aiMoveToGoal() {
        byte by = this.monster.goalType;
        EntityMonster entityMonster = this.monster;
        if (by == 2 || by == 1 || by == 4 || by == 5) {
            this.aiGoal_MOVE();
        } else if (by == 3) {
            entityMonster.target = entityMonster.goalParam == 1 ? null : Game.entities[entityMonster.goalParam];
            this.attack();
        }
        if (this.def.eSubType == 13) {
            int n = this.getSprite();
            Game.scriptStateVars[9] = Render.mapSprites[Render.S_X + n];
            Game.scriptStateVars[10] = Render.mapSprites[Render.S_Y + n];
        }
    }

    private void aiChooseNewGoal(boolean bl) {
        byte by = this.def.eSubType;
        this.monster.resetGoal();
        this.aiCalcSimpleGoal(bl);
        if ((1 << by & 0x4604) != 0 && this.monster.goalType == 3) {
            this.monster.goalFlags = (byte)(this.monster.goalFlags | 8);
        }
    }

    private boolean aiIsValidGoal() {
        byte by = this.monster.goalType;
        if (this.monster.goalTurns >= 16 || by == 3 || by == 0) {
            return false;
        }
        if (by == 2) {
            Entity entity = Game.entities[this.monster.goalParam];
            if (this.monster.goalParam != 1) {
                int[] nArray = entity.calcPosition();
                Entity entity2 = Game.findMapEntity(nArray[0], nArray[1], 15535);
                if (entity.linkIndex != this.linkIndex && (entity2 == null || entity2 == entity)) {
                    return true;
                }
            }
        } else if (by == 1) {
            if (this.linkIndex != this.monster.goalX + this.monster.goalY * 32) {
                return true;
            }
        } else {
            if (by == 4 || by == 5) {
                return this.monster.goalTurns < this.monster.goalParam;
            }
            if (by == 6) {
                if (this.monster.goalTurns < this.monster.goalParam) {
                    return true;
                }
                if (this.monster.goalTurns == this.monster.goalParam) {
                    this.monster.resetGoal();
                    return false;
                }
            }
        }
        return false;
    }

    public boolean aiIsAttackValid() {
        EntityMonster entityMonster = this.monster;
        int n = entityMonster.ce.weapon;
        int[] nArray = this.calcPosition();
        Game.trace(nArray[0], nArray[1], Game.destX, Game.destY, this, 5295, 2);
        Entity entity = Game.traceEntity;
        if (entity != null) {
            boolean bl = Combat.weapons[n * 9 + 3] >= Combat.WorldDistToTileDist(this.distFrom(Game.destX, Game.destY));
            boolean bl2 = false;
            if (bl) {
                int n2 = nArray[0] - Game.destX;
                int n3 = nArray[1] - Game.destY;
                boolean bl3 = bl2 = !(n2 == 0 && n3 == 0 || n2 != 0 && n3 != 0);
            }
            if (entityMonster.target == null && entity.def.eType == 1 && bl && bl2) {
                return true;
            }
            if (entityMonster.target == entity && bl && bl2) {
                return true;
            }
        }
        return false;
    }

    public void aiThink(boolean bl) {
        EntityMonster entityMonster = this.monster;
        if ((entityMonster.flags & 0x400) != 0) {
            entityMonster.flags = (short)(entityMonster.flags & 0xFFFFFBFF);
        }
        if ((entityMonster.flags & 0x20) != 0) {
            return;
        }
        if (!this.aiIsValidGoal()) {
            this.aiChooseNewGoal(bl);
        }
        entityMonster.goalTurns = (byte)(entityMonster.goalTurns + 1);
        this.aiMoveToGoal();
    }

    private int aiWeaponForTarget(Entity entity) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = this.getSprite();
        if (entity.def.eType == 1) {
            n11 = Canvas.viewX;
            n10 = Canvas.viewY;
        } else {
            int n13 = entity.getSprite();
            n11 = Render.mapSprites[Render.S_X + n13];
            n10 = Render.mapSprites[Render.S_Y + n13];
        }
        int n14 = n11 - Render.mapSprites[Render.S_X + n12];
        int n15 = n10 - Render.mapSprites[Render.S_Y + n12];
        byte[] byArray = Combat.weapons;
        if (this.def.eSubType == 13) {
            if (n14 == 0 || n15 == 0) {
                int[] nArray = entity.calcPosition();
                Game.trace(Render.mapSprites[Render.S_X + n12], Render.mapSprites[Render.S_Y + n12], nArray[0], nArray[1], this, 4131, 2);
                if (Game.traceEntity == entity) {
                    return Combat.getMonsterField(this.def, 0);
                }
                return -1;
            }
            return -1;
        }
        if (this.def.eSubType == 15 || this.def.eSubType == 15) {
            if (this.param <= 0) {
                this.param = App.nextInt() % 3 + 3;
                n9 = 30;
                while (n9-- > 0) {
                    n8 = Render.mapSprites[Render.S_X + n12];
                    n7 = Render.mapSprites[Render.S_Y + n12];
                    n6 = 0;
                    n5 = 0;
                    while (n9-- > 0 && n6 == 0 && n5 == 0) {
                        n6 = App.nextInt() % 9 - 4;
                        n5 = App.nextInt() % 9 - 4;
                    }
                    n4 = n8 + (n6 << 6);
                    n3 = n7 + (n5 << 6);
                    Game.trace(n8, n7, n4, n3, this, 15535, 2);
                    if (Game.numTraceEntities != 0) continue;
                    ParticleSystem.spawnParticles(7, -1, n12);
                    Game.unlinkEntity(this);
                    Render.mapSprites[Render.S_X + n12] = (short)n4;
                    Render.mapSprites[Render.S_Y + n12] = (short)n3;
                    Render.mapSprites[Render.S_Z + n12] = (short)(Render.getHeight(n4, n3) + 32);
                    Game.linkEntity(this, n4 >> 6, n3 >> 6);
                    Render.relinkSprite(n12);
                    ParticleSystem.spawnParticles(7, -1, n12);
                    break;
                }
            } else {
                --this.param;
            }
        }
        if (n14 != 0 && n15 != 0) {
            if (this.def.eSubType == 10 || this.def.eSubType == 15 && this.def.parm != 0) {
                int n16;
                n9 = Combat.getMonsterField(this.def, this.def.eSubType == 15 ? 1 : 0);
                int n17 = n9 * 9;
                if (byArray[n17 + 2] <= (n16 = Combat.WorldDistToTileDist(entity.distFrom(Render.mapSprites[Render.S_X + n12], Render.mapSprites[Render.S_Y + n12]))) && byArray[n17 + 3] >= n16) {
                    int[] nArray = entity.calcPosition();
                    Game.trace(Render.mapSprites[Render.S_X + n12], Render.mapSprites[Render.S_Y + n12], nArray[0], nArray[1], this, 4131, 2);
                    if (Game.traceEntity == entity) {
                        return n9;
                    }
                }
                return -1;
            }
            return -1;
        }
        n9 = 0;
        Game.trace(Render.mapSprites[Render.S_X + n12], Render.mapSprites[Render.S_Y + n12], n11, n10, this, 5295, 2);
        if (Game.traceEntity != entity) {
            return -1;
        }
        n8 = n14;
        n7 = n15;
        if (n8 != 0) {
            n8 /= Math.abs(n14);
        }
        if (n7 != 0) {
            n7 /= Math.abs(n15);
        }
        Game.trace(Render.mapSprites[Render.S_X + n12] + n8 * 18, Render.mapSprites[Render.S_Y + n12] + n7 * 18, n11, n10, this, 15791, 2);
        n9 = Game.traceEntity == entity ? 1 : 0;
        n6 = Combat.getMonsterField(this.def, 0);
        n5 = Combat.getMonsterField(this.def, 1);
        if (n9 == 0) {
            if ((1 << n6 & 0x78002) != 0) {
                n6 = 0;
            }
            if ((1 << n5 & 0x78002) != 0) {
                n5 = 0;
            }
        }
        int n18 = -1;
        int n19 = -1;
        int n20 = Combat.WorldDistToTileDist(entity.distFrom(Render.mapSprites[Render.S_X + n12], Render.mapSprites[Render.S_Y + n12]));
        if (n6 == n5) {
            n5 = 0;
        }
        if (n6 != 0 && byArray[(n2 = n6 * 9) + 2] <= n20 && byArray[n2 + 3] >= n20) {
            n19 = n2;
        }
        if (n5 != 0 && byArray[(n2 = n5 * 9) + 2] <= n20 && byArray[n2 + 3] >= n20) {
            n18 = n2;
        }
        if (n6 == 18 || n5 == 18) {
            n4 = 1;
            n3 = Render.mapSprites[Render.S_X + n12] >> 6;
            int n21 = Render.mapSprites[Render.S_Y + n12] >> 6;
            do {
                if ((baseVisitedTiles[n21] & 1 << n3) != 0) {
                    n4 = 0;
                    break;
                }
                n3 += n8;
                n21 += n7;
            } while (--n20 > 0);
            if (n6 == 18 && n4 == 0) {
                n19 = -1;
            }
            if (n5 == 18 && n4 == 0) {
                n18 = -1;
            }
        }
        if (n18 != -1 && n19 != -1) {
            n = App.nextByte() <= Combat.getMonsterField(this.def, 2) ? n6 : n5;
        } else if (n18 != -1) {
            n = n5;
        } else if (n19 != -1) {
            n = n6;
        } else {
            return -1;
        }
        return n;
    }

    public LerpSprite aiInitLerp(int n) {
        int n2 = this.getSprite();
        LerpSprite lerpSprite = Game.allocLerpSprite(null, n2, true);
        lerpSprite.srcX = Render.mapSprites[Render.S_X + n2];
        lerpSprite.srcY = Render.mapSprites[Render.S_Y + n2];
        lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n2];
        lerpSprite.dstX = 32 + (this.monster.goalX << 6);
        lerpSprite.dstY = 32 + (this.monster.goalY << 6);
        lerpSprite.dstZ = 32 + Render.getHeight(lerpSprite.dstX, lerpSprite.dstY);
        lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + n2];
        lerpSprite.startTime = App.gameTime;
        lerpSprite.travelTime = n;
        lerpSprite.flags |= 0x11;
        this.monster.frameTime = App.time + n;
        lerpSprite.calcDist();
        this.monster.goalFlags = (byte)(this.monster.goalFlags | 1);
        return lerpSprite;
    }

    public void aiFinishLerp() {
        this.monster.goalFlags = (byte)(this.monster.goalFlags & 0xFFFFFFFE);
        if ((this.monster.flags & 0x1000) != 0) {
            this.monster.flags = (short)(this.monster.flags & 0xFFFFEFFF);
            this.info &= 0xEFFFFFFF;
        } else {
            this.aiReachedGoal_MOVE();
        }
    }

    private boolean checkLineOfSight(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 - n;
        int n7 = n4 - n2;
        if (n6 != 0 && n7 != 0) {
            return false;
        }
        if (n6 != 0) {
            n6 /= Math.abs(n6);
        }
        if (n7 != 0) {
            n7 /= Math.abs(n7);
        }
        while (n != n3 && n2 != n4) {
            if (null == Game.findMapEntity((n += n6) << 6, (n2 += n7) << 6, n5)) continue;
            return false;
        }
        return true;
    }

    private boolean calcPath(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n3 - n;
        int n12 = n4 - n2;
        int n13 = n11 * n11 + n12 * n12;
        byte[] byArray = visitOrder;
        int[] nArray = visitDist;
        int n14 = n2;
        visitedTiles[n14] = visitedTiles[n14] | 1 << n;
        boolean bl2 = this.checkLineOfSight(n, n2, n3, n4, n5 | 0x100);
        if (lineOfSight == 0 && !bl2 || lineOfSight == 1 && bl2) {
            n13 = bl ? (n13 -= 30) : (n13 += 30);
        }
        if (bl2) {
            n13 += lineOfSightWeight;
        }
        if (pathDepth > 0 && (!bl && n13 < closestPathDist || bl && n13 > closestPathDist)) {
            closestPath = curPath;
            closestPathDepth = pathDepth;
            closestPathDist = n13;
        }
        if (n == n3 && n2 == n4) {
            closestPath = curPath;
            closestPathDepth = pathDepth;
            closestPathDist = n13;
            return true;
        }
        if (pathDepth == pathSearchDepth) {
            return false;
        }
        int n15 = 0;
        byte[] byArray2 = Canvas.viewStepValues;
        int n16 = 4;
        byte by = (byte)(App.nextByte() & 3);
        while (--n16 >= 0) {
            by = (byte)(by + 1 & 3);
            n10 = n + (byArray2[by << 2] >> 6);
            n9 = n2 + (byArray2[(by << 2) + 1] >> 6);
            if (n9 < 0 || n9 >= 32 || n10 < 0 || n10 >= 32 || null != Game.findMapEntity(n10 << 6, n9 << 6, 256) || 0 != (visitedTiles[n9] & 1 << n10)) continue;
            byArray[n15] = by;
            n11 = n3 - n10;
            n12 = n4 - n9;
            nArray[n15] = n11 * n11 + n12 * n12;
            bl2 = this.checkLineOfSight(n10, n9, n3, n4, n5 | 0x100);
            if (lineOfSight == 0 && !bl2 || lineOfSight == 1 && bl2) {
                if (bl) {
                    int n17 = n15;
                    nArray[n17] = nArray[n17] - 30;
                } else {
                    int n18 = n15;
                    nArray[n18] = nArray[n18] + 30;
                }
            }
            if (bl2) {
                int n19 = n15;
                nArray[n19] = nArray[n19] + lineOfSightWeight;
            }
            ++n15;
        }
        for (n8 = 0; n8 < n15; ++n8) {
            for (n7 = 0; n7 < n15 - n8 - 1; ++n7) {
                n6 = nArray[n7] - nArray[n7 + 1];
                if ((bl || n6 <= 0) && (!bl || n6 >= 0)) continue;
                n10 = nArray[n7 + 1];
                nArray[n7 + 1] = nArray[n7];
                nArray[n7] = n10;
                n10 = byArray[n7 + 1];
                byArray[n7 + 1] = byArray[n7];
                byArray[n7] = (byte)n10;
            }
        }
        n8 = 0;
        n7 = 0;
        for (n6 = 0; n6 < n15; ++n6) {
            n8 |= (byArray[n6] & 3) << n7;
            n7 += 2;
        }
        for (int i = 0; i < n15; ++i) {
            n6 = n8 & 3;
            n8 >>= 2;
            n10 = n + (byArray2[n6 << 2] >> 6);
            n9 = n2 + (byArray2[(n6 << 2) + 1] >> 6);
            Game.trace((n << 6) + 32, (n2 << 6) + 32, (n10 << 6) + 32, (n9 << 6) + 32, skipEnt, n5, 16);
            if (findEnt != null && Game.traceEntity == findEnt) {
                closestPath = curPath;
                closestPathDepth = pathDepth;
                closestPathDist = n13;
                return true;
            }
            int n20 = interactClipMask;
            if (Game.traceEntity != null) {
                n20 = 1 << Game.traceEntity.def.eType;
            }
            if (n20 != 0 && (n20 & interactClipMask) == 0) continue;
            ++pathDepth;
            curPath >>= 2;
            curPath &= 0x3FFFFFFFFFFFFFFFL;
            curPath |= (long)n6 << 62;
            if (this.calcPath(n10, n9, n3, n4, n5, bl)) {
                return true;
            }
            --pathDepth;
            curPath <<= 2;
        }
        return false;
    }

    private boolean aiGoal_MOVE() {
        boolean bl;
        boolean bl2 = false;
        int n = this.getSprite();
        Game.snapLerpSprites(n);
        short s = Render.mapSprites[Render.S_X + n];
        short s2 = Render.mapSprites[Render.S_Y + n];
        closestPath = 0L;
        closestPathDepth = 0;
        closestPathDist = 999999999;
        curPath = 0L;
        pathDepth = 0;
        pathSearchDepth = 8;
        findEnt = null;
        skipEnt = this;
        lineOfSight = 2;
        lineOfSightWeight = 0;
        interactClipMask = 32;
        System.arraycopy(baseVisitedTiles, 0, visitedTiles, 0, visitedTiles.length);
        if (this.monster.goalType == 2 && this.monster.goalParam == 1) {
            findEnt = Game.entities[1];
            this.monster.goalX = Game.destX >> 6;
            this.monster.goalY = Game.destY >> 6;
            lineOfSightWeight = -4;
        } else if (this.monster.goalType == 5) {
            this.monster.goalX = Game.destX >> 6;
            this.monster.goalY = Game.destY >> 6;
            interactClipMask = 0;
            bl2 = true;
            lineOfSight = 1;
            pathSearchDepth = this.monster.goalParam;
        } else if (this.monster.goalType == 4) {
            this.monster.goalX = Game.destX >> 6;
            this.monster.goalY = Game.destY >> 6;
            bl2 = true;
            lineOfSight = 1;
        } else if (this.monster.goalType == 2) {
            findEnt = Game.entities[this.monster.goalParam];
            this.monster.goalX = Entity.findEnt.linkIndex % 32;
            this.monster.goalY = Entity.findEnt.linkIndex / 32;
        }
        if (bl2) {
            closestPathDist = 0;
        }
        if (!(bl = this.calcPath(s >> 6, s2 >> 6, this.monster.goalX, this.monster.goalY, 15535, bl2)) && closestPathDist < 999999999) {
            bl = true;
            curPath = closestPath;
            pathDepth = closestPathDepth;
        }
        if (bl && pathDepth > 0) {
            this.info &= 0xEFFFFFFF;
            int n2 = s + Canvas.viewStepValues[(int)(((curPath >>= 64 - pathDepth * 2) & 3L) << 2)];
            int n3 = s2 + Canvas.viewStepValues[(int)((curPath & 3L) << 2) + 1];
            this.monster.goalX = n2 >> 6;
            this.monster.goalY = n3 >> 6;
            Game.trace(s, s2, n2, n3, this, interactClipMask, 25);
            if (Game.numTraceEntities == 0) {
                Game.unlinkEntity(this);
                Game.linkEntity(this, n2 >> 6, n3 >> 6);
                int n4 = Math.min(s, n2) - 16;
                int n5 = Math.max(s, n2) + 16;
                int n6 = Math.min(s2, n3) - 16;
                int n7 = Math.max(s2, n3) + 16;
                if (!Render.cullBoundingBox(n4 << 4, n6 << 4, n5 << 4, n7 << 4, true)) {
                    this.info |= 0x10000000;
                }
                Game.interpolatingMonsters = true;
                if (this.def.eSubType == 14 && this.def.parm != 0 || this.def.eSubType == 13) {
                    this.aiInitLerp(500);
                } else {
                    this.aiInitLerp(275);
                }
            } else {
                this.monster.goalX = s >> 6;
                this.monster.goalY = s2 >> 6;
                if (Game.traceEntity.def.eType == 5) {
                    Game.performDoorEvent(0, Game.traceEntity, 2);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void aiReachedGoal_MOVE() {
        Entity entity;
        int n;
        EntityMonster entityMonster = this.monster;
        EntityDef entityDef = this.def;
        this.info &= 0xEFFFFFFF;
        if (entityMonster.goalType != 4 && entityMonster.goalType != 5 && ((1 << entityDef.eSubType & 0x180D0) != 0 || (1 << entityDef.eSubType & 0x4604) != 0 && 0 == (entityMonster.flags & 1)) && (n = this.aiWeaponForTarget(entity = Game.entities[1])) != -1) {
            entityMonster.target = entity == Game.entities[1] ? null : entity;
            entityMonster.ce.weapon = n;
            this.attack();
            return;
        }
        if ((1 << entityDef.eSubType & 0x4604) != 0) {
            entityMonster.flags = (short)(entityMonster.flags | 1);
        }
        if ((entityMonster.goalFlags & 0x10) != 0) {
            entityMonster.goalFlags = (byte)(entityMonster.goalFlags & 0xFFFFFFEF);
            this.aiCalcSimpleGoal(false);
            if (entityMonster.goalType == 1 || entityMonster.goalType == 2) {
                if (!Game.tileObstructsAttack(entityMonster.goalX, entityMonster.goalY)) {
                    this.aiGoal_MOVE();
                } else {
                    entityMonster.resetGoal();
                }
            }
        }
    }

    public int distFrom(int n, int n2) {
        int[] nArray = this.calcPosition();
        return Math.max((n - nArray[0]) * (n - nArray[0]), (n2 - nArray[1]) * (n2 - nArray[1]));
    }

    private void attack() {
        if ((this.monster.flags & 0x400) == 0) {
            this.monster.flags = (short)(this.monster.flags | 0x400);
            this.monster.nextAttacker = Game.combatMonsters;
            Game.combatMonsters = this;
        }
    }

    public void undoAttack() {
        if ((this.monster.flags & 0x400) == 0) {
            return;
        }
        this.monster.flags = (short)(this.monster.flags & 0xFFFFFBFF);
        int n = this.getSprite();
        int n2 = this.monster.ce.weapon;
        if (n2 == 18) {
            int n3 = n;
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF;
        }
        this.monster.resetGoal();
        Entity entity = Game.combatMonsters;
        Entity entity2 = null;
        while (entity != null && entity != this) {
            entity2 = entity;
            entity = entity.monster.nextAttacker;
        }
        if (entity2 != null) {
            entity2.monster.nextAttacker = this.monster.nextAttacker;
        } else if (Game.combatMonsters != null) {
            Game.combatMonsters = this.monster.nextAttacker;
        }
    }

    private void trimCorpsePile(int n, int n2) {
        Entity entity = Game.inactiveMonsters;
        if (entity != null) {
            int n3 = 0;
            do {
                int n4;
                if (Render.mapSprites[Render.S_X + (n4 = entity.getSprite())] != n || Render.mapSprites[Render.S_Y + n4] != n2 || (entity.info & 0x1010000) == 0 || (Render.mapSpriteInfo[n4] & 0x10000) != 0 || ++n3 < 3) continue;
                int n5 = n4;
                Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] | 0x10000;
                entity.info = entity.info & 0xFEFFFFFF | 0x10000;
                Game.unlinkEntity(entity);
            } while ((entity = entity.monster.nextOnList) != Game.inactiveMonsters);
        }
    }

    public void knockback(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = knockbackDelta;
        if (n3 == 0) {
            return;
        }
        if (this.def.eType == 1) {
            n7 = Game.destX;
            n6 = Game.destY;
            n5 = 13501;
        } else {
            n4 = this.getSprite();
            n7 = Render.mapSprites[Render.S_X + n4];
            n6 = Render.mapSprites[Render.S_Y + n4];
            n5 = 15535;
        }
        nArray[0] = n7 - n;
        nArray[1] = n6 - n2;
        if (nArray[0] != 0) {
            nArray[0] = nArray[0] / Math.abs(nArray[0]);
            Canvas.knockbackStart = n7;
            Canvas.knockbackWorldDist = Math.abs(64 * nArray[0] * n3);
        }
        if (nArray[1] != 0) {
            nArray[1] = nArray[1] / Math.abs(nArray[1]);
            Canvas.knockbackStart = n6;
            Canvas.knockbackWorldDist = Math.abs(64 * nArray[1] * n3);
        }
        n4 = n3;
        int n8 = n7 + 64 * nArray[0] * n4;
        int n9 = n6 + 64 * nArray[1] * n4;
        if ((n4 = this.getFarthestKnockbackDist(n7, n6, n8, n9, this, n5, 16, n3)) == 0 || nArray[0] == 0 && nArray[1] == 0) {
            return;
        }
        n8 = n7 + nArray[0] * n4 * 64 >> 6;
        n9 = n6 + nArray[1] * n4 * 64 >> 6;
        if (this.def.eType == 1) {
            if (this.def.eSubType != 1) {
                Canvas.knockbackX = nArray[0];
                Canvas.knockbackY = nArray[1];
                Canvas.knockbackDist = n4;
            }
        } else {
            this.monster.goalType = 1;
            this.monster.goalX = n8;
            this.monster.goalY = n9;
            this.monster.flags = (short)(this.monster.flags | 0x1000);
            LerpSprite lerpSprite = this.aiInitLerp(400);
            Game.unlinkEntity(this);
            Game.linkEntity(this, n8, n9);
            Game.interpolatingMonsters = true;
            Game.updateLerpSprite(lerpSprite);
        }
    }

    public final int getFarthestKnockbackDist(int n, int n2, int n3, int n4, Entity entity, int n5, int n6, int n7) {
        int n8 = n7;
        Game.trace(n, n2, n3, n4, entity, n5, n6);
        Entity entity2 = Game.traceEntity;
        if (entity2 != null) {
            int n9 = Game.traceFracs[0];
            n8 = n8 * n9 >> 14;
        }
        return n8;
    }

    public int findRaiseTarget(int n, int n2, int n3) {
        Entity entity = Game.inactiveMonsters;
        int[] nArray = this.calcPosition();
        int n4 = nArray[0];
        int n5 = nArray[1];
        if (this.param != 0) {
            --this.param;
            return -1;
        }
        int n6 = 0;
        if (entity != null) {
            Entity entity2;
            do {
                entity2 = entity.monster.nextOnList;
                int n7 = entity.getSprite();
                if ((entity.info & 0x10000) != 0 || (entity.info & 0x8000000) != 0 || (entity.info & 0x1000000) == 0 || entity.isBoss() || n2 != 0 && (entity.monster.flags & n2) == 0 || (entity.monster.flags & n3) != 0 || entity.distFrom(n4, n5) > n || Game.findMapEntity(Render.mapSprites[Render.S_X + n7], Render.mapSprites[Render.S_Y + n7], 15535) != null || Game.difficulty == 4 && 0 != (entity.monster.monsterEffects & 4)) continue;
                Entity.raiseTargets[n6++] = entity;
            } while ((entity = entity2) != Game.inactiveMonsters && n6 != 4);
            if (n6 != 0) {
                entity = raiseTargets[App.nextInt() % n6];
                entity.info |= 0x8000000;
                this.raiseTarget(entity.getIndex());
                this.param = 4;
                return entity.getIndex();
            }
        }
        return -1;
    }

    public void raiseTarget(int n) {
        Entity entity = Game.entities[n];
        int n2 = entity.getSprite();
        Text.resetTextArgs();
        Text text = Text.getSmallBuffer();
        Text.composeTextField(this.name, text);
        Text.addTextArg(text);
        text.dispose();
        if (Game.findMapEntity(Render.mapSprites[Render.S_X + n2], Render.mapSprites[Render.S_Y + n2], 15535) != null) {
            Hud.addMessage((short)92);
            entity.info &= 0xF7FFFFFF;
            return;
        }
        entity.resurrect(Render.mapSprites[Render.S_X + n2], Render.mapSprites[Render.S_Y + n2], Render.mapSprites[Render.S_Z + n2]);
        Game.activate(entity, false, false, true, true);
        Text text2 = Text.getSmallBuffer();
        Text.composeTextField(entity.name, text2);
        Text.addTextArg(text2);
        if (this.def.eType != 1) {
            Hud.addMessage((short)93);
        }
        text2.dispose();
    }

    public void resurrect(int n, int n2, int n3) {
        int n4 = this.getSprite();
        this.def = EntityDef.find(2, this.def.eSubType, this.def.parm);
        this.name = (short)(this.def.name | 0x400);
        this.monster.clearEffects();
        Render.mapSprites[Render.S_X + n4] = (short)n;
        Render.mapSprites[Render.S_Y + n4] = (short)n2;
        Render.mapSprites[Render.S_Z + n4] = (short)n3;
        int n5 = n4;
        Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] & 0xFFFC00FF;
        if ((App.nextInt() & 1) != 0) {
            int n6 = n4;
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] | 0x20000;
        }
        Render.relinkSprite(n4);
        this.info &= 0xF6FEFFFF;
        this.info |= 0x20000;
        CombatEntity combatEntity = this.monster.ce;
        this.initspawn();
        this.monster.ce = combatEntity;
        this.monster.ce.setStat(0, combatEntity.getStat(1));
        this.monster.flags = (short)(this.monster.flags & 0xFFFFEFFF);
        Game.unlinkEntity(this);
        Game.linkEntity(this, n >> 6, n2 >> 6);
        Canvas.updateFacingEntity = true;
        ParticleSystem.spawnParticles(1, -161512, n4);
    }

    public int[] calcPosition() {
        int n;
        int n2;
        if (this.def.eType == 0) {
            n2 = Game.traceCollisionX;
            n = Game.traceCollisionY;
        } else if (this.def.eType == 1) {
            n2 = Canvas.destX;
            n = Canvas.destY;
        } else if (this.def.eType == 2) {
            int n3 = this.getSprite();
            n2 = Render.mapSprites[Render.S_X + n3];
            n = Render.mapSprites[Render.S_Y + n3];
        } else {
            int n4 = this.getSprite();
            n2 = Render.mapSprites[Render.S_X + n4];
            n = Render.mapSprites[Render.S_Y + n4];
        }
        Entity.pos[0] = n2;
        Entity.pos[1] = n;
        return pos;
    }

    public boolean isBoss() {
        return this.def.eSubType >= 12 && this.def.eSubType <= 16 && (this.def.eSubType != 14 || this.def.parm != 0);
    }

    public boolean isHasteResistant() {
        return this.isBoss();
    }

    public boolean isDroppedEntity() {
        short s = this.getIndex();
        return s >= Game.firstDropIndex && s < Game.firstDropIndex + 16;
    }

    private boolean isBinaryEntity(int[] nArray) {
        boolean bl = false;
        if (this.def == null) {
            return false;
        }
        if (this.isDroppedEntity()) {
            return false;
        }
        switch (this.def.eType) {
            default: {
                return false;
            }
            case 6: 
            case 10: 
            case 11: {
                if (this.def.eSubType == 3) {
                    bl = false;
                    break;
                }
                if ((this.info & 0x100000) != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                int n = this.getSprite();
                bl = Render.mapSprites[Render.S_SCALEFACTOR + n] != 64;
                if (this.def.eSubType != 1 || null == nArray) break;
                nArray[1] = nArray[1] | 0x200000;
                break;
            }
            case 13: {
                int n = this.getSprite();
                int n2 = Render.mapSpriteInfo[n] & 0xFF;
                if (n2 != 168) break;
                if ((Render.mapSpriteInfo[n] & 0x10000) != 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                if (this.def.eSubType == 17) {
                    bl = this.param != 0;
                    break;
                }
                return false;
            }
            case 14: {
                if (this.def.eSubType == 7) {
                    bl = (this.info & 0x400000) != 0;
                    break;
                }
                return false;
            }
        }
        if (null != nArray) {
            nArray[0] = bl ? 1 : 0;
        }
        return true;
    }

    private boolean isNamedEntity(int[] nArray) {
        if (this.def == null || this.name == Text.STRINGID((short)1, this.def.name) || this.def.eType == 9) {
            return false;
        }
        nArray[0] = this.name;
        if (nArray[0] != -1) {
            return true;
        }
        App.Error(25);
        return false;
    }

    public void saveState(DataOutputStream dataOutputStream, int n) throws IOException {
        short[] sArray = Render.mapSprites;
        int[] nArray = Render.mapSpriteInfo;
        if ((n & 0x20000) != 0) {
            int[] nArray2 = tempSaveBuf;
            this.isNamedEntity(nArray2);
            dataOutputStream.writeShort((short)nArray2[0]);
        }
        if ((n & 0x80000) != 0) {
            return;
        }
        if (this.def.eType == 10 && this.def.eSubType == 1) {
            dataOutputStream.writeShort(sArray[Render.S_SCALEFACTOR + this.getSprite()]);
            return;
        }
        int n2 = this.getSprite();
        if (this.def.eType == 2 && (n & 0x200000) != 0) {
            dataOutputStream.writeByte(sArray[Render.S_X + n2] >> 3);
            dataOutputStream.writeByte(sArray[Render.S_Y + n2] >> 3);
            dataOutputStream.writeByte((nArray[n2] & 0xFF00) >> 8);
            dataOutputStream.writeShort(this.monster.flags);
            return;
        }
        dataOutputStream.writeByte(this.info >> 16 & 0xFF);
        if ((this.info & 0x10000) == 0) {
            dataOutputStream.writeByte((nArray[n2] & 0xFF0000) >> 16);
            dataOutputStream.writeByte((nArray[n2] & 0xFF00) >> 8);
            if (this.isDroppedEntity() || (Render.mapSpriteInfo[n2] & 0xF000000) == 0) {
                dataOutputStream.writeByte(sArray[Render.S_X + n2] >> 3);
                dataOutputStream.writeByte(sArray[Render.S_Y + n2] >> 3);
            }
            if (this.isDroppedEntity()) {
                dataOutputStream.writeInt(this.param);
            }
            if (!this.isDroppedEntity() && (Render.mapSpriteInfo[n2] & 0xF000000) != 0) {
                dataOutputStream.writeShort(this.linkIndex);
            }
        }
        if (this.monster != null) {
            dataOutputStream.writeShort(this.monster.flags);
            if ((this.info & 0x10000) == 0) {
                if ((this.monster.flags & 0x200) != 0) {
                    dataOutputStream.writeByte(sArray[Render.S_SCALEFACTOR + n2]);
                }
                if ((n & 0x100000) == 0) {
                    dataOutputStream.writeShort(this.monster.monsterEffects);
                    this.monster.ce.saveState(dataOutputStream, false);
                    this.monster.saveGoalState(dataOutputStream);
                }
            }
        } else if (this.isDroppedEntity()) {
            byte by = (byte)(this.def.eType | this.def.eSubType << 4);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeByte(this.def.parm);
            if ((n & 0x100000) != 0) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.lootSet != null) {
                    n5 = this.lootSet[0];
                    n4 = this.lootSet[1];
                    n3 = this.lootSet[2];
                }
                dataOutputStream.writeInt(n5);
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeInt(n3);
            }
            if (this.def.eType == 14 && this.def.eSubType == 6) {
                dataOutputStream.writeByte((nArray[n2] & 0xFF000000) >> 24);
            }
        } else {
            dataOutputStream.writeShort(sArray[Render.S_Z + n2]);
        }
    }

    public void loadState(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        if ((n & 0x20000) != 0) {
            this.name = dataInputStream.readShort();
        }
        int n6 = this.getSprite();
        int n7 = Render.mapSpriteInfo[n6] & 0xFF;
        if ((Render.mapSpriteInfo[n6] & 0x400000) != 0) {
            n7 += 257;
        }
        if ((n & 0x40000) != 0) {
            int n8 = n6;
            Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] & 0xFFFEFFFF;
            if ((n & 0x80000) != 0 && (this.info & 0x100000) == 0) {
                Game.linkEntity(this, Render.mapSprites[Render.S_X + n6] >> 6, Render.mapSprites[Render.S_Y + n6] >> 6);
            }
        } else {
            int n9 = n6;
            Render.mapSpriteInfo[n9] = Render.mapSpriteInfo[n9] | 0x10000;
            if ((this.info & 0x100000) != 0 && this.def.eType != 5 && (n7 < 140 || n7 > 143)) {
                Game.unlinkEntity(this);
            } else if (this.def.eType == 10 && this.def.eSubType != 3) {
                ++Game.destroyedObj;
            }
        }
        if ((n & 0x1000000) != 0) {
            this.info |= 0x2000000;
        }
        if (this.isBinaryEntity(null)) {
            this.restoreBinaryState(n);
            if ((n & 0x80000) != 0) {
                return;
            }
        }
        if (this.def != null && this.def.eType == 10 && this.def.eSubType == 1) {
            short s = dataInputStream.readShort();
            if (s != Render.mapSprites[Render.S_SCALEFACTOR + n6]) {
                Render.mapSprites[Render.S_SCALEFACTOR + n6] = s;
                this.info |= 0x400000;
            }
            return;
        }
        if ((n & 0x100000) != 0) {
            if ((n & 0x40000) == 0) {
                this.info |= 0x10000;
                if ((this.info & 0x100000) != 0) {
                    Game.unlinkEntity(this);
                }
            } else if ((n & 0x80000) != 0) {
                App.Error(5);
            }
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFF00FF | 0x7000;
            if (!this.isDroppedEntity()) {
                this.def = EntityDef.find(9, this.def.eSubType, this.def.parm);
            }
        }
        if (this.def != null && this.def.eType == 3) {
            this.param = (n & 0x200000) != 0 ? 1 : 0;
            this.param += (n & 0x4000000) != 0 ? 1 : 0;
        }
        if (this.monster != null) {
            if ((n & 0x800000) != 0) {
                this.monster.flags = (short)(this.monster.flags | 0x10);
                this.info |= 0x400000;
            }
            if ((n & 0x400000) != 0) {
                this.monster.flags = (short)(this.monster.flags | 0x80);
                this.info |= 0x400000;
            }
            if ((n & 0x8000000) != 0) {
                this.monster.flags = (short)(this.monster.flags | 0x800);
                this.info |= 0x400000;
            }
        }
        if ((n & 0x80000) != 0) {
            return;
        }
        if ((this.info & 0x100000) != 0) {
            Game.unlinkEntity(this);
        }
        n6 = this.getSprite();
        if (this.def != null && this.def.eType == 2 && (n & 0x200000) != 0) {
            short s = (short)((dataInputStream.readByte() & 0xFF) << 3);
            short s2 = (short)((dataInputStream.readByte() & 0xFF) << 3);
            int n10 = (dataInputStream.readByte() & 0xFF) << 8;
            Render.mapSprites[Render.S_X + n6] = s;
            Render.mapSprites[Render.S_Y + n6] = s2;
            Render.mapSprites[Render.S_Z + n6] = (short)(Render.getHeight(s, s2) + 32);
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFF00FF | n10;
            Render.relinkSprite(n6);
            if ((this.info & 0x100000) != 0) {
                Game.unlinkEntity(this);
            }
            if ((n & 0x40000) == 0) {
                Game.deactivate(this);
            } else {
                Game.linkEntity(this, s >> 6, s2 >> 6);
            }
            this.monster.flags = dataInputStream.readShort();
            if (this.monster.flags != 0 || n10 != 0) {
                this.info |= 0x400000;
            }
            return;
        }
        this.info = this.info & 0xFF00FFFF | (dataInputStream.readByte() & 0xFF) << 16;
        if ((this.info & 0x10000) == 0) {
            n5 = dataInputStream.readByte() & 0xFF;
            n4 = dataInputStream.readByte() & 0xFF;
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFF0000FF | n4 << 8 | n5 << 16;
            if (this.isDroppedEntity() || (Render.mapSpriteInfo[n6] & 0xF000000) == 0) {
                Render.mapSprites[Render.S_X + n6] = (short)(dataInputStream.readUnsignedByte() << 3);
                Render.mapSprites[Render.S_Y + n6] = (short)(dataInputStream.readUnsignedByte() << 3);
                if (this.monster != null || this.isDroppedEntity()) {
                    Render.mapSprites[Render.S_Z + n6] = (short)(Render.getHeight(Render.mapSprites[Render.S_X + n6], Render.mapSprites[Render.S_Y + n6]) + 32);
                }
                Render.relinkSprite(n6);
            }
            if (this.isDroppedEntity()) {
                this.param = dataInputStream.readInt();
            }
            this.linkIndex = !this.isDroppedEntity() && (Render.mapSpriteInfo[n6] & 0xF000000) != 0 ? dataInputStream.readShort() : (short)((Render.mapSprites[Render.S_X + n6] >> 6) + (Render.mapSprites[Render.S_Y + n6] >> 6) * 32);
            if (!((Render.mapSpriteInfo[n6] & 0xF000000) != 0xC000000 && (Render.mapSpriteInfo[n6] & 0xF000000) != 0x3000000 || this.def.eType != 13 && this.def.eType != 12)) {
                n3 = this.linkIndex % 32;
                n2 = this.linkIndex / 32;
                Render.mapSprites[Render.S_X + n6] = (short)((n3 << 6) + 32);
                Render.mapSprites[Render.S_Y + n6] = (short)((n2 << 6) + 32);
                Render.relinkSprite(n6);
            }
            if (n4 != 0) {
                this.info |= 0x400000;
            }
        }
        if ((n & 0x2000000) != 0) {
            this.info |= 0x80000;
        }
        if (this.monster != null) {
            this.monster.flags = dataInputStream.readShort();
            if ((this.info & 0x10000) == 0) {
                if ((this.monster.flags & 0x200) != 0) {
                    Render.mapSprites[Render.S_SCALEFACTOR + n6] = (short)dataInputStream.readUnsignedByte();
                }
                if ((n & 0x100000) != 0) {
                    this.info |= 0x1000000;
                } else {
                    this.monster.monsterEffects = dataInputStream.readShort();
                    this.monster.ce.loadState(dataInputStream, false);
                    this.monster.loadGoalState(dataInputStream);
                }
            }
            if ((this.info & 0x40000) != 0) {
                this.info &= 0xFFFBFFFF;
                Game.activate(this, false, false, false, true);
            }
            if ((this.info & 0x1000000) != 0) {
                this.def = EntityDef.find(9, this.def.eSubType, this.def.parm);
            }
        } else if (this.isDroppedEntity()) {
            int n11;
            int n12;
            int n13;
            n5 = dataInputStream.readByte();
            n4 = (byte)(n5 & 0xF);
            n3 = n5 >> 4 & 0xF;
            n2 = dataInputStream.readByte();
            this.def = EntityDef.find(n4, n3, n2);
            if (this.name == -1) {
                this.name = (short)(this.def.name | 0x400);
            }
            short s = this.def.tileIndex;
            if ((n & 0x100000) != 0) {
                s = EntityDef.find((int)2, (int)n3, (int)n2).tileIndex;
                n13 = dataInputStream.readInt();
                n12 = dataInputStream.readInt();
                n11 = dataInputStream.readInt();
                if (this.param == 0) {
                    this.populateDefaultLootSet();
                    this.lootSet[0] = n13;
                    this.lootSet[1] = n12;
                    this.lootSet[2] = n11;
                }
                this.info |= 0x1000000;
            }
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFFFF00 | s;
            Render.mapSprites[Render.S_ENT + n6] = this.getIndex();
            if (this.def.eType == 14 && this.def.eSubType == 6) {
                n13 = (dataInputStream.readByte() & 0xFF) << 24;
                int n14 = n6;
                Render.mapSpriteInfo[n14] = Render.mapSpriteInfo[n14] | n13;
                n12 = (Render.mapSpriteInfo[n6] & 0xF000000) != 0 ? 1 : 0;
                n11 = n12 != 0 ? 32 : 31;
                Render.mapSprites[Render.S_Z + n6] = (short)(Render.getHeight(Render.mapSprites[Render.S_X + n6], Render.mapSprites[Render.S_Y + n6]) + n11);
                Render.mapSprites[Render.S_SCALEFACTOR + n6] = 32;
                Render.relinkSprite(n6);
            }
        } else {
            Render.mapSprites[Render.S_Z + n6] = dataInputStream.readShort();
            Render.relinkSprite(n6);
        }
        if ((this.info & 0x100000) != 0) {
            if ((Render.mapSpriteInfo[n6] & 0xF000000) != 0) {
                Game.linkEntity(this, this.linkIndex % 32, this.linkIndex / 32);
            } else {
                Game.linkEntity(this, Render.mapSprites[Render.S_X + n6] >> 6, Render.mapSprites[Render.S_Y + n6] >> 6);
            }
        }
    }

    public int getSaveHandle(boolean bl) {
        int n;
        int[] nArray;
        int[] nArray2 = tempSaveBuf;
        nArray2[0] = 1;
        nArray2[1] = this.getIndex();
        boolean bl2 = this.isDroppedEntity();
        boolean bl3 = this.isBinaryEntity(nArray2);
        if (!((this.info & 0xFFFF) != 0 && this.def != null || bl3)) {
            return -1;
        }
        if (bl2 && (this.info & 0x100000) == 0) {
            return -1;
        }
        if (bl2 && bl && this.def.eType == 14 && this.def.eSubType == 6) {
            return -1;
        }
        boolean bl4 = nArray2[0] != 0;
        int n2 = nArray2[1];
        if (bl3 && bl4) {
            n2 |= 0x10000;
        }
        if (this.isNamedEntity(nArray = tempSaveBuf)) {
            n2 |= 0x20000;
        }
        if ((Render.mapSpriteInfo[n = this.getSprite()] & 0x10000) == 0) {
            n2 |= 0x40000;
        }
        if ((this.info & 0x2000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((this.info & 0x400000) == 0 && ((n2 |= 0x80000) & 0x20000) == 0 && this.def.eType == 7 && this.def.eSubType != 3) {
            return -1;
        }
        if ((this.info & 0x1010000) != 0) {
            n2 |= 0x100000;
        }
        if ((this.info & 0x80000) != 0) {
            n2 |= 0x2000000;
        }
        if ((this.info & 0x10000) != 0) {
            n2 &= 0xFFFBFFFF;
            n2 |= 0x100000;
        }
        if (this.def.eType == 3 && this.param != 0) {
            n2 |= 0x200000;
            if (this.param == 2) {
                n2 |= 0x4000000;
            }
        }
        if (this.monster != null) {
            if ((this.monster.flags & 0x10) != 0) {
                n2 |= 0x800000;
            }
            if ((this.monster.flags & 0x80) != 0) {
                n2 |= 0x400000;
            }
            if ((this.monster.flags & 0x800) != 0) {
                n2 |= 0x8000000;
            }
        }
        if (bl) {
            if (this.def.eType == 9 && this.def.eSubType != 17 && !bl2 && 0 == (this.monster.flags & 0x80)) {
                n2 = n2 & 0xFFFBFFFF | 0x80000;
            } else if (this.def.eType == 2) {
                n2 |= 0x200000;
            }
        }
        return n2;
    }

    private void restoreBinaryState(int n) {
        boolean bl = (n & 0x10000) != 0;
        switch (this.def.eType) {
            default: {
                return;
            }
            case 6: 
            case 10: 
            case 11: {
                if (this.def.eSubType == 3) {
                    if (!bl) break;
                    Canvas.turnEntityIntoWaterSpout(this);
                    break;
                }
                if (bl) {
                    Game.unlinkEntity(this);
                    Game.linkEntity(this, this.linkIndex % 32, this.linkIndex / 32);
                } else {
                    Game.unlinkEntity(this);
                }
                if (this.def.eSubType != 1 && this.def.eSubType != 2) break;
                int n2 = this.getSprite();
                if (bl) {
                    Game.unlinkEntity(this);
                    Game.linkEntity(this, this.linkIndex % 32, this.linkIndex / 32);
                    Render.relinkSprite(n2);
                    break;
                }
                int n3 = this.def.eSubType == 2 ? 3 : 1;
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | n3 << 8;
                Render.relinkSprite(n2);
                break;
            }
            case 5: {
                boolean bl2 = this.def.eSubType == 1;
                Game.setLineLocked(this, false);
                if (bl) {
                    Game.performDoorEvent(0, this, 0);
                } else {
                    Game.performDoorEvent(1, this, 0);
                }
                if ((n & 0x200000) == 0 && !bl2) break;
                Game.setLineLocked(this, (n & 0x200000) != 0);
                break;
            }
            case 13: {
                if (bl) {
                    Game.performDoorEvent(0, this, 0);
                    break;
                }
                Game.performDoorEvent(1, this, 0);
                break;
            }
            case 9: {
                if (!bl) break;
                ++this.param;
                this.lootSet = null;
            }
        }
    }

    public short getIndex() {
        for (short s = 0; s < Game.numEntities; s = (short)(s + 1)) {
            if (this != Game.entities[s]) continue;
            return s;
        }
        return -1;
    }

    public static void setMonsterClip(int n, int n2) {
        int n3 = n2;
        baseVisitedTiles[n3] = baseVisitedTiles[n3] | 1 << n;
    }

    public static void unsetMonsterClip(int n, int n2) {
        int n3 = n2;
        baseVisitedTiles[n3] = baseVisitedTiles[n3] & ~(1 << n);
    }

    public static boolean monsterClipExists(int n, int n2) {
        return (baseVisitedTiles[n2] >> n & 1) == 1;
    }

    void updateMonsterFX() {
        if (null != this.monster) {
            for (int i = 0; i < 5; ++i) {
                int n = this.monster.monsterEffects;
                int n2 = 1 << i;
                if ((n & n2) == 0) continue;
                int n3 = 5 + i * 4;
                int n4 = n >> n3 & 0xF;
                if (this.def.eType != 9 && (this.info & 0x20000) != 0) {
                    int n5 = 0;
                    if (n2 == 8) {
                        n5 = 4;
                        Text.resetTextArgs();
                        Text.addTextArg(n5);
                        Hud.addMessage((short)0, (short)94);
                    }
                    if (n2 == 1) {
                        n5 = 10;
                        Text.resetTextArgs();
                        Text.addTextArg(n5);
                        Hud.addMessage((short)0, (short)95);
                    } else if (n5 > 0) {
                        Text.resetTextArgs();
                        Text.addTextArg(n5);
                        Hud.addMessage((short)0, (short)71);
                    }
                    if (n5 > 0) {
                        this.pain(n5, null);
                        n = this.monster.monsterEffects;
                        if (this.monster.ce.getStat(0) <= 0) {
                            this.died(true, null);
                            n = this.monster.monsterEffects;
                            n &= 0xFFFF801F;
                            n |= 0x220220;
                            n4 = 1;
                        }
                    }
                }
                if (n4 == 0) {
                    n &= ~n2;
                } else {
                    n &= ~(15 << n3);
                    n |= --n4 << n3;
                }
                this.monster.monsterEffects = n;
            }
        }
    }

    public void populateDefaultLootSet() {
        this.lootSet = new int[3];
        if (this.def.eType == 9) {
            if (this.def.eSubType != 11) {
                this.lootSet[0] = 1089;
            }
        } else {
            switch (this.def.eSubType) {
                case 0: {
                    int n = this.getSprite() % 3 + 1;
                    if (this.def.parm == 1) {
                        n = this.getSprite() % 5 + 3;
                    } else if (this.def.parm == 2) {
                        n = this.getSprite() % 8 + 5;
                    }
                    this.lootSet[0] = 0x600 | n;
                    break;
                }
                case 6: {
                    this.lootSet[0] = 0x2100 | this.getSprite() % 5 + 3;
                    break;
                }
                case 8: {
                    this.lootSet[0] = 0x2140 | this.getSprite() % 3 + 1;
                    break;
                }
                case 9: {
                    this.lootSet[0] = 0x2140 | this.getSprite() % 3 + 3;
                    break;
                }
                case 11: {
                    this.lootSet[0] = 0x2040 | this.getSprite() % 6 + 6;
                    break;
                }
                default: {
                    this.lootSet[0] = 0x6000 | this.findRandomJokeItem();
                }
            }
        }
    }

    private int findRandomJokeItem() {
        int n = this.getSprite();
        int n2 = Canvas.loadMapID;
        switch (n2) {
            case 1: {
                switch (n % 5) {
                    case 0: {
                        return 180;
                    }
                    case 1: {
                        return 181;
                    }
                    case 2: {
                        return 182;
                    }
                    case 3: {
                        return 183;
                    }
                    case 4: {
                        return 184;
                    }
                }
            }
            case 2: {
                switch (n % 5) {
                    case 0: {
                        return 138;
                    }
                    case 1: {
                        return 139;
                    }
                    case 2: {
                        return 140;
                    }
                    case 3: {
                        return 141;
                    }
                    case 4: {
                        return 142;
                    }
                }
            }
            case 3: {
                switch (n % 5) {
                    case 0: {
                        return 118;
                    }
                    case 1: {
                        return 119;
                    }
                    case 2: {
                        return 120;
                    }
                    case 3: {
                        return 121;
                    }
                    case 4: {
                        return 122;
                    }
                }
            }
            case 4: {
                switch (n % 5) {
                    case 0: {
                        return 129;
                    }
                    case 1: {
                        return 130;
                    }
                    case 2: {
                        return 131;
                    }
                    case 3: {
                        return 132;
                    }
                    case 4: {
                        return 133;
                    }
                }
            }
            case 5: {
                switch (n % 5) {
                    case 0: {
                        return 127;
                    }
                    case 1: {
                        return 128;
                    }
                    case 2: {
                        return 129;
                    }
                    case 3: {
                        return 130;
                    }
                    case 4: {
                        return 131;
                    }
                }
            }
            case 6: {
                switch (n % 5) {
                    case 0: {
                        return 77;
                    }
                    case 1: {
                        return 78;
                    }
                    case 2: {
                        return 79;
                    }
                    case 3: {
                        return 80;
                    }
                    case 4: {
                        return 81;
                    }
                }
            }
            case 7: {
                switch (n % 5) {
                    case 0: {
                        return 23;
                    }
                    case 1: {
                        return 24;
                    }
                    case 2: {
                        return 25;
                    }
                    case 3: {
                        return 26;
                    }
                    case 4: {
                        return 27;
                    }
                }
            }
            case 8: {
                switch (n % 5) {
                    case 0: {
                        return 34;
                    }
                    case 1: {
                        return 35;
                    }
                    case 2: {
                        return 36;
                    }
                    case 3: {
                        return 37;
                    }
                    case 4: {
                        return 38;
                    }
                }
            }
            case 9: {
                switch (n % 5) {
                    case 0: {
                        return 15;
                    }
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 17;
                    }
                    case 3: {
                        return 18;
                    }
                    case 4: {
                        return 19;
                    }
                }
            }
            case 10: {
                switch (n % 5) {
                    case 0: {
                        return 9;
                    }
                    case 1: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 3: {
                        return 12;
                    }
                    case 4: {
                        return 13;
                    }
                }
            }
        }
        App.Error(117);
        return 0;
    }

    public void addToLootSet(int n, int n2, int n3) {
        if (this.lootSet != null && n3 > 0) {
            for (int i = 0; i < this.lootSet.length; ++i) {
                if (this.lootSet[i] != 0) continue;
                this.lootSet[i] = n << 12 | n2 << 6 | n3;
                return;
            }
        }
    }

    public boolean hasEmptyLootSet() {
        if (this.lootSet == null) {
            return true;
        }
        return this.lootSet[0] == 0;
    }

    static {
        knockbackDelta = new int[2];
        raiseTargets = new Entity[4];
        pos = new int[2];
        tempSaveBuf = new int[2];
    }
}

