/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.EOFException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.rms.RecordStoreException;

class GameManager
extends GameCanvas
implements Runnable {
    static final int MILLIS_PER_TICK = 200;
    static final int MAX_INV = 16;
    static final int STAND_INV = 8;
    static final int NORTH = 0;
    static final int EAST = 1;
    static final int SOUTH = 2;
    static final int WEST = 3;
    static final int GM_UP = 1;
    static final int GM_DOWN = 2;
    static final int GM_LEFT = 3;
    static final int GM_RIGHT = 4;
    static final int GM_FIRE = 5;
    static final int GM_LSIDE = 6;
    static final int GM_RSIDE = 7;
    private final DarkHorde_Midlet midlet;
    public final GameEffects gameEffects;
    public Dictionary dict;
    private Image splgfx;
    private Image invgfx;
    private Image inv2gfx;
    private Image bggfx;
    private Image menugfx;
    private Image MyImage;
    public View view;
    private int ticks = 0;
    public int status;
    public int tempStatus;
    private int option;
    public boolean[] options = new boolean[8];
    private int gameWidth;
    private int gameHeight;
    private boolean redrawBG;
    private boolean redrawAll = false;
    private boolean availBG;
    public byte[] invItem = new byte[16];
    private int[][] invSquareXY = new int[16][2];
    private int invSquareSize;
    private int itemX;
    private int itemY;
    private int itemCurrent;
    private int itemSelect;
    private boolean isGameOver = false;
    private volatile boolean isPaused = false;
    private volatile Thread animationThread = null;
    private static final Font GAME_FONT = Font.getFont((int)0, (int)0, (int)8);
    private static final int fontHeight = GAME_FONT.getHeight();
    public byte[] gameAction = new byte[32];
    public int gameActionCount;
    public int gameActionCurrent;
    public final int GM_MENU;
    public final int GM_NEW_GAME;
    public final int GM_PLAY;
    public final int GM_INV;
    public final int GM_DEAD;
    public final int GM_NEW_LEVEL;
    public final int GM_EOL;
    public final int GM_MAP;
    private boolean hasBeenShown = false;
    public int xEnd;
    public int yEnd;
    public int xMap;
    public int yMap;
    public int direction;
    public int HP;
    public int maxHP;
    public int iDex;
    public int iAtt;
    public int iDef;
    public byte gameLevel;
    public int showText;
    public int textTimer;
    public boolean clearText;
    public boolean showItem;
    public boolean clearItem;
    public boolean clrInvTxt;
    public boolean showHP;
    public boolean showHand;
    public int iHit;
    public int iRecovery;
    public int[][] showBlood = new int[4][2];
    public int compassDirec;
    public int rowBorder;
    public int colBorder;
    public byte[] itemDsc = new byte[]{1, 2, 3, 0, 0, 0, 0, 0, 4, 5, 6, 7, 0, 0, 0, 0, 8, 9, 10, 0, 0, 0, 0, 0, 11, 12, 13, 0, 0, 0, 0, 0, 14, 15, 16, 17, 0, 0, 0, 0, 18, 19, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 21, 22, 0, 0, 0, 0, 0, 0, 23, 24, 25, 26, 27, 28, 29, 0};
    public byte[] bStory;
    public String storyStr;
    public boolean bShowStory;
    public boolean bLoadQuik;
    public boolean bLoadGame;
    public boolean bEnd;
    public int c_startApp = 0;
    public int c_pauseApp = 0;
    public int c_hideNotify = 0;
    public int c_showNotify = 0;
    public int iLastKey = 0;
    public boolean bFireHeld = false;

    GameManager(DarkHorde_Midlet darkHorde_Midlet, GameEffects gameEffects) {
        super(true);
        this.GM_MENU = 0;
        this.GM_NEW_GAME = 1;
        this.GM_PLAY = 2;
        this.GM_INV = 3;
        this.GM_DEAD = 4;
        this.GM_NEW_LEVEL = 5;
        this.GM_EOL = 6;
        this.GM_MAP = 7;
        this.midlet = darkHorde_Midlet;
        this.gameEffects = gameEffects;
        this.setFullScreenMode(true);
        this.MyImage = this.gameEffects.getGfx("/1.png");
        this.gameWidth = this.getWidth();
        this.gameHeight = this.getHeight();
        if (this.gameHeight <= 65) {
            this.rowBorder = 0;
            this.colBorder = 0;
            this.itemX = 0;
            this.itemY = this.gameHeight - 12;
            this.availBG = false;
        } else {
            this.rowBorder = this.gameHeight - 180 >> 1;
            this.colBorder = this.gameWidth - 160 >> 1;
            this.itemX = this.colBorder + 132;
            this.itemY = this.rowBorder + 8 + 144;
            this.availBG = true;
        }
        this.invSquareSize = 24;
        int n = this.availBG ? 4 : 0;
        int n2 = this.availBG ? 0 : 18;
        int n3 = this.availBG ? 0 : 12;
        int n4 = 0;
        while (n4 < 4) {
            this.invSquareXY[n4 << 1][0] = this.colBorder + 4;
            this.invSquareXY[n4 << 1][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 1][0] = this.colBorder + 4 + (this.invSquareSize + n);
            this.invSquareXY[(n4 << 1) + 1][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 8][0] = this.colBorder + 10 + (this.invSquareSize + n << 1);
            this.invSquareXY[(n4 << 1) + 8][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            this.invSquareXY[(n4 << 1) + 9][0] = this.availBG ? 98 : 62;
            int[] nArray = this.invSquareXY[(n4 << 1) + 9];
            nArray[0] = nArray[0] + (this.colBorder + (this.invSquareSize + n));
            this.invSquareXY[(n4 << 1) + 9][1] = this.rowBorder + n + n + (this.invSquareSize + n) * n4;
            ++n4;
        }
        if (!this.availBG) {
            this.rowBorder = -5;
        }
        this.init(true, false);
    }

    void init(boolean bl, boolean bl2) {
        GameEffects.soundOn = this.midlet.soundOn;
        this.animationThread = null;
        this.isGameOver = false;
        this.isPaused = false;
        this.hasBeenShown = false;
        this.status = 1;
        this.ticks = 0;
        this.gameEffects.lightsOn();
        this.bLoadQuik = bl2;
        this.bLoadGame = !bl;
        this.gameActionCount = 0;
        this.gameActionCurrent = 0;
    }

    void setupView() {
        byte by = (byte)(this.gameLevel + 1 >> 1);
        if (this.view == null) {
            int n = 160;
            int n2 = 144;
            if (this.gameHeight == 65) {
                n = 96;
                n2 = 70;
            }
            this.view = new View(this, n, n2, this.colBorder, this.rowBorder);
            this.view.initTile();
            this.invgfx = this.gameEffects.getGfx("/i.png");
            this.inv2gfx = this.gameEffects.getGfx("/i2.png");
            this.bggfx = this.gameEffects.getGfx("/b.png");
            int n3 = 0;
            Image image = this.gameEffects.getGfx("/1.png");
            int[] nArray = new int[64 * 64];
            this.view.convertImage(0, image, nArray, 0 << 6);
            image = null;
            if (this.gameLevel <= 3) {
                image = this.gameEffects.getGfx("/1.png");
            } else {
                image = this.gameEffects.getGfx("/2.png");
                n3 = 1;
                this.view.bigMon = true;
            }
            int n4 = 1;
            while (n4 < 4) {
                this.view.convertImage(n4, image, nArray, n4 - n3 << 6);
                ++n4;
            }
            this.view.setColorDepth();
            this.view.init();
        }
        this.view.initLevel(by);
    }

    public void changeCont(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("DUNS");
        this.option = n;
        this.options[0] = bl;
        try {
            Settings.setValue(Settings.GM_CONT, bl, stringBuffer);
        }
        catch (RecordStoreException recordStoreException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (true) {
                long l;
                if (thread != this.animationThread) {
                    return;
                }
                long l2 = System.currentTimeMillis();
                if (this.isShown()) {
                    this.input();
                    if (!this.isPaused) {
                        this.tick();
                    }
                    this.draw();
                    this.flushGraphics();
                }
                if ((l = System.currentTimeMillis() - l2) < 200L) {
                    GameManager gameManager = this;
                    synchronized (gameManager) {
                        this.wait(200L - l);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void input() {
        int n;
        int n2 = this.getKeyStates();
        if (!((n2 & 4) == 0 || this.isPaused && this.isShown())) {
            this.gameAction[++this.gameActionCount & 0x1F] = 3;
        }
        if (!((n2 & 0x20) == 0 || this.isPaused && this.isShown())) {
            this.gameAction[++this.gameActionCount & 0x1F] = 4;
        }
        if ((n2 & 2) != 0) {
            if (this.isPaused && this.isShown()) {
                --this.option;
                n = 0;
                while (n < this.options.length) {
                    if (this.option < 0) {
                        this.option = this.options.length - 1;
                    }
                    if (this.option >= this.options.length) {
                        this.option = 0;
                    }
                    if (!this.options[this.option]) {
                        --this.option;
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                this.gameAction[++this.gameActionCount & 0x1F] = 1;
            }
        }
        if ((n2 & 0x40) != 0) {
            if (this.isPaused && this.isShown()) {
                ++this.option;
                n = 0;
                while (n < this.options.length) {
                    if (this.option < 0) {
                        this.option = this.options.length - 1;
                    }
                    if (this.option >= this.options.length) {
                        this.option = 0;
                    }
                    if (!this.options[this.option]) {
                        ++this.option;
                        ++n;
                        continue;
                    }
                    break;
                }
            } else {
                this.gameAction[++this.gameActionCount & 0x1F] = 2;
            }
        }
        if ((n2 & 0x100) != 0) {
            if (!this.bFireHeld) {
                this.gameAction[++this.gameActionCount & 0x1F] = 5;
            }
            this.bFireHeld = true;
        } else {
            this.bFireHeld = false;
        }
        if (!((n2 & 0x200) == 0 || this.isPaused && this.isShown())) {
            this.gameAction[++this.gameActionCount & 0x1F] = 6;
        }
        if (!((n2 & 0x400) == 0 || this.isPaused && this.isShown())) {
            this.gameAction[++this.gameActionCount & 0x1F] = 7;
        }
        if (!((n2 & 0x800) == 0 || this.isPaused && this.isShown())) {
            if (this.status == 2) {
                this.itemSelect = -1;
                this.itemCurrent = 0;
                this.status = 3;
            } else if (this.status == 3) {
                this.status = 7;
                this.ticks = 0;
                this.gameActionCount = this.gameActionCurrent;
            } else if (this.status == 7) {
                this.status = 2;
                this.ticks = 0;
                this.gameActionCount = this.gameActionCurrent;
            }
        }
        this.gameActionCount &= 0x1F;
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = true;
        }
    }

    public synchronized boolean isPaused() {
        return this.isPaused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        GameManager gameManager = this;
        synchronized (gameManager) {
            this.isPaused = false;
        }
        this.gameEffects.resume();
    }

    public void keyPressed(int n) {
        this.stop();
        this.midlet.hordeCanvasMenu(this.options[0], this.status != 0 && this.status != 1 && this.status != 4);
    }

    public void manHit(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            n2 = this.calcHit(n2, n4, this.iDef, 10, false, true);
        }
        this.HP -= n2;
        this.showHP = true;
        if (this.HP < 0) {
            this.HP = 0;
            this.changeCont(1, false);
            this.options[3] = false;
            this.status = 4;
            this.ticks = 0;
        }
        n = n - this.direction & 3;
        switch (n) {
            case 0: {
                this.showBlood[2][0] = n2;
                this.showBlood[2][1] = n3;
                break;
            }
            case 1: {
                this.showBlood[3][0] = n2;
                this.showBlood[3][1] = n3;
                break;
            }
            case 2: {
                this.showBlood[0][0] = n2;
                this.showBlood[0][1] = n3;
                break;
            }
            case 3: {
                this.showBlood[1][0] = n2;
                this.showBlood[1][1] = n3;
            }
        }
        if (n2 > 0) {
            this.gameEffects.playHit();
        }
    }

    public int calcHit(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = bl && this.view.scrolls[2] > 0 ? n - n3 >> 1 : 0;
        n = Util.getRandomInt(n5, n - (n3 = bl2 && this.view.scrolls[1] > 0 ? n3 + (n3 >> 1) : n3) + n5);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    String fromUTF8(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            block5: {
                int n4;
                block3: {
                    block4: {
                        n4 = byArray[n3] & 0xFF;
                        if (n4 < 128) break block3;
                        if (n4 >= 224) break block4;
                        n4 = (n4 & 0x1F) << 6;
                        n4 |= byArray[++n3] & 0x3F;
                        break block3;
                    }
                    n4 = (n4 & 0xF) << 12;
                    n4 |= (byArray[++n3] & 0x3F) << 6;
                    if ((n4 |= byArray[++n3] & 0x3F) == 65279) break block5;
                }
                cArray[n2++] = (char)n4;
            }
            ++n3;
        }
        return new String(cArray, 0, n2);
    }

    private void tick() {
        switch (this.status) {
            case 0: {
                this.stop();
                this.options[0] = false;
                this.midlet.hordeCanvasMenu(false, false);
                break;
            }
            case 1: {
                this.view = null;
                this.menugfx = null;
                this.gameLevel = 1;
                int n = 0;
                while (n < 16) {
                    this.invItem[n] = 0;
                    ++n;
                }
                this.HP = 32;
                this.maxHP = 63;
                this.iDex = 10;
                this.iDef = 5;
                this.iAtt = 6;
                this.status = 5;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.ticks = 0;
                break;
            }
            case 5: {
                if (!(this.ticks >= 50 && !this.bShowStory || this.bLoadQuik || this.bLoadGame)) {
                    if (this.ticks == 0) {
                        this.bStory = new byte[512];
                        this.bShowStory = true;
                        ++this.ticks;
                        try {
                            this.showItem = true;
                            DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(String.valueOf(String.valueOf(new StringBuffer("/").append(this.gameLevel).append(".txt")))));
                            dataInputStream.readFully(this.bStory);
                            dataInputStream.close();
                        }
                        catch (EOFException eOFException) {
                        }
                        catch (Exception exception) {
                            this.ticks = this.gameHeight << 2;
                            this.bShowStory = false;
                            this.showItem = false;
                        }
                        this.storyStr = this.fromUTF8(this.bStory);
                        break;
                    }
                    if (this.gameActionCount == this.gameActionCurrent) break;
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        --this.ticks;
                        if (this.ticks < 1) {
                            this.ticks = 1;
                        }
                        this.showItem = true;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2 && !this.bEnd) {
                        ++this.ticks;
                        this.showItem = true;
                    }
                    if (this.gameAction[this.gameActionCurrent] != 5) break;
                    this.ticks = 50;
                    this.bShowStory = false;
                    break;
                }
                if (this.gameLevel == 6) {
                    this.gameActionCurrent = this.gameActionCount;
                    this.status = 0;
                    this.ticks = 0;
                    break;
                }
                if (this.bLoadQuik || this.bLoadGame) {
                    Settings.getGame(this.bLoadQuik, this, null, false);
                }
                this.bStory = null;
                this.setupView();
                int n = 0;
                while (n < 4) {
                    this.showBlood[n][0] = 0;
                    this.showBlood[n][1] = 0;
                    ++n;
                }
                if ((this.bLoadQuik || this.bLoadGame) && this.status != 6) {
                    Settings.getGame(this.bLoadQuik, this, this.view, true);
                } else {
                    if (this.gameLevel != 1 || this.status == 6) {
                        n = 0;
                        while (n < 16) {
                            if (this.invItem[n] != 0) {
                                this.view.itemType[48 - 16 + n] = this.invItem[n];
                                this.view.itemX[48 - 16 + n] = 65;
                                this.invItem[n] = (byte)(48 - 16 + n + 1);
                            }
                            ++n;
                        }
                    }
                    this.iHit = -1;
                    this.iRecovery = 0;
                }
                this.view.createMap((this.bLoadQuik || this.bLoadGame) && this.status != 6);
                this.bLoadQuik = false;
                this.bLoadGame = false;
                this.itemCurrent = 0;
                this.itemSelect = -1;
                this.gameActionCount = 0;
                this.gameActionCurrent = 0;
                this.redrawBG = this.availBG;
                this.showHP = true;
                this.showText = 0;
                this.textTimer = 0;
                this.showItem = false;
                this.compassDirec = this.direction + 1 & 3;
                this.options[3] = true;
                this.options[0] = true;
                this.status = 2;
                break;
            }
            case 6: {
                ++this.ticks;
                if (this.ticks > 30 || this.gameActionCurrent != this.gameActionCount && this.ticks > 20) {
                    this.gameLevel = (byte)(this.gameLevel + 1);
                    this.view = null;
                    this.status = 5;
                    this.gameActionCount = 0;
                    this.gameActionCurrent = 0;
                    this.ticks = 0;
                    break;
                }
                this.gameActionCurrent = this.gameActionCount;
                break;
            }
            case 2: {
                int n = this.xMap;
                int n2 = this.yMap;
                int n3 = this.xMap;
                int n4 = this.yMap;
                if (this.iRecovery > 0) {
                    --this.iRecovery;
                }
                if (this.gameActionCurrent != this.gameActionCount) {
                    ++this.gameActionCurrent;
                    this.gameActionCurrent &= 0x1F;
                    if (this.gameAction[this.gameActionCurrent] == 1) {
                        if (this.direction == 0) {
                            --n4;
                        } else if (this.direction == 1) {
                            ++n3;
                        } else if (this.direction == 2) {
                            ++n4;
                        } else if (this.direction == 3) {
                            --n3;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 2) {
                        if (this.direction == 0) {
                            ++n4;
                        } else if (this.direction == 1) {
                            --n3;
                        } else if (this.direction == 2) {
                            --n4;
                        } else if (this.direction == 3) {
                            ++n3;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 6) {
                        if (this.direction == 0) {
                            --n3;
                        } else if (this.direction == 1) {
                            --n4;
                        } else if (this.direction == 2) {
                            ++n3;
                        } else if (this.direction == 3) {
                            ++n4;
                        }
                    }
                    if (this.gameAction[this.gameActionCurrent] == 7) {
                        if (this.direction == 0) {
                            ++n3;
                        } else if (this.direction == 1) {
                            ++n4;
                        } else if (this.direction == 2) {
                            --n3;
                        } else if (this.direction == 3) {
                            --n4;
                        }
                    }
                    if (!(this.xMap == n3 && this.yMap == n4 || this.view.moveCollision(n3, n4))) {
                        this.xMap = n3;
                        this.yMap = n4;
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 3) {
                        --this.direction;
                        if (this.direction < 0) {
                            this.direction = 3;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 4) {
                        ++this.direction;
                        if (this.direction > 3) {
                            this.direction = 0;
                        }
                        this.showText = 0;
                    }
                    if (this.gameAction[this.gameActionCurrent] == 5) {
                        n3 = this.xMap;
                        n4 = this.yMap;
                        if (this.direction == 0) {
                            --n4;
                        } else if (this.direction == 1) {
                            ++n3;
                        } else if (this.direction == 2) {
                            ++n4;
                        } else if (this.direction == 3) {
                            --n3;
                        }
                        int n5 = this.iRecovery != 0 ? 0 : this.view.attackMon(n3, n4, this.iAtt, this.iDex);
                        if (n5 == -1) {
                            if (!this.view.doorOpenClose(n3, n4)) {
                                this.showText = this.view.checkSpecial(this.xMap, this.yMap);
                                if (this.showText != 0) {
                                    this.textTimer = 30;
                                }
                                this.showItem = (this.view.mapItem[this.xMap][this.yMap] & 1) != 0;
                            }
                        } else if (this.iRecovery <= 0) {
                            this.iHit = n5;
                            this.iRecovery = this.iDex;
                            this.gameEffects.playSwoosh();
                        }
                    }
                }
                if (this.xMap == this.xEnd && this.yMap == this.yEnd) {
                    this.options[3] = false;
                    this.status = 6;
                    int n6 = 0;
                    while (n6 < 16) {
                        if (this.invItem[n6] != 0) {
                            this.invItem[n6] = this.view.itemType[this.invItem[n6] - 1];
                        }
                        if (this.invItem[n6] == 49) {
                            this.invItem[n6] = 0;
                        }
                        ++n6;
                    }
                    Settings.storeGame(true, this, this.view);
                    this.ticks = 0;
                    break;
                }
                if (this.xMap != n | this.yMap != n2) {
                    this.view.checkMap(n, n2, false);
                    this.showItem = this.view.checkMap(this.xMap, this.yMap, true);
                }
                this.view.doorUpdate();
                this.view.lineOfSite(this.xMap, this.yMap, this.direction);
                this.view.ai();
                break;
            }
            case 3: {
                if (this.gameActionCurrent == this.gameActionCount) break;
                ++this.gameActionCurrent;
                this.gameActionCurrent &= 0x1F;
                if (this.gameAction[this.gameActionCurrent] == 1) {
                    this.itemCurrent = this.itemCurrent == 0 || this.itemCurrent == 1 || this.itemCurrent == 8 || this.itemCurrent == 9 ? (this.itemCurrent += 6) : (this.itemCurrent -= 2);
                }
                if (this.gameAction[this.gameActionCurrent] == 2) {
                    this.itemCurrent = this.itemCurrent == 6 || this.itemCurrent == 7 || this.itemCurrent == 14 || this.itemCurrent == 15 ? (this.itemCurrent -= 6) : (this.itemCurrent += 2);
                }
                if (this.gameAction[this.gameActionCurrent] == 3) {
                    this.itemCurrent = (this.itemCurrent & 9) == 0 ? (this.itemCurrent += 9) : ((this.itemCurrent & 9) == 8 ? (this.itemCurrent -= 7) : --this.itemCurrent);
                }
                if (this.gameAction[this.gameActionCurrent] == 4) {
                    this.itemCurrent = (this.itemCurrent & 9) == 1 ? (this.itemCurrent += 7) : ((this.itemCurrent & 9) == 9 ? (this.itemCurrent -= 9) : ++this.itemCurrent);
                }
                if (this.gameAction[this.gameActionCurrent] != 5) break;
                if (this.itemSelect == -1) {
                    if (this.itemCurrent == 9) break;
                    this.itemSelect = this.itemCurrent;
                    break;
                }
                if (this.itemSelect == this.itemCurrent) {
                    if (this.itemCurrent == 12) {
                        this.showHand = true;
                    }
                    if (this.invItem[this.itemCurrent] == 0) {
                        this.itemSelect = -1;
                        break;
                    }
                    this.view.dropItem(this.xMap, this.yMap, this.invItem[this.itemCurrent] - 1, true);
                    this.showItem = true;
                    this.invItem[this.itemCurrent] = 0;
                    this.itemSelect = -1;
                    break;
                }
                if (this.itemCurrent == 12 || this.itemSelect == 12) {
                    this.showHand = true;
                }
                int n = this.invItem[this.itemSelect] == 0 ? -1 : this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 >> 3;
                int n7 = this.invItem[this.itemCurrent] == 0 ? -1 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 >> 3;
                boolean bl = true;
                if (this.itemCurrent >= 8 || this.itemSelect >= 8) {
                    if (n == 0 && this.itemCurrent != 8 && this.itemCurrent >= 8 || n7 == 0 && this.itemSelect != 8 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 1 && this.itemCurrent != 12 && this.itemCurrent >= 8 || n7 == 1 && this.itemSelect != 12 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 2 && this.itemCurrent != 11 && this.itemCurrent >= 8 || n7 == 2 && this.itemSelect != 11 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 3 && this.itemCurrent != 10 && this.itemCurrent >= 8 || n7 == 3 && this.itemSelect != 10 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 4 && this.itemCurrent != 13 && this.itemCurrent != 14 && this.itemCurrent >= 8 || n7 == 4 && this.itemSelect != 13 && this.itemSelect != 14 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 5 && this.itemCurrent != 9 && this.itemCurrent >= 8 || n7 == 5 && this.itemSelect != 9 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 6 || n7 == 6) {
                        bl = false;
                    }
                    if (n == 7 && this.itemCurrent != 15 && this.itemCurrent >= 8 || n7 == 7 && this.itemSelect != 15 && this.itemSelect >= 8) {
                        bl = false;
                    }
                    if (n == 8 && this.itemCurrent != 12 && this.itemCurrent >= 8 || n7 == 8 && this.itemSelect != 12 && this.itemSelect >= 8) {
                        bl = false;
                    }
                }
                if (!bl) break;
                if (this.itemCurrent == 9 && n == 5) {
                    if (this.HP < this.maxHP) {
                        this.invItem[this.itemSelect] = 0;
                        this.HP += 10;
                        if (this.HP > this.maxHP) {
                            this.HP = this.maxHP;
                        }
                        this.showHP = true;
                    }
                } else {
                    int n8;
                    int n9;
                    if (n >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8 || n7 >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8) {
                        n9 = this.itemCurrent >= 8 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7;
                        int n10 = n8 = this.itemCurrent >= 8 ? n : n7;
                        if (n8 == 0 || n8 == 7) {
                            this.iDef += this.view.helmet[n9 + n9];
                            this.iDex -= this.view.helmet[n9 + n9 + 1];
                        } else if (n8 == 1) {
                            this.iAtt += this.view.sword[n9 + n9];
                            this.iDex -= this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 2 || n8 == 3) {
                            this.iDef += this.view.sword[n9 + n9];
                            this.iDex -= this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 4) {
                            this.iAtt += this.view.ring[n9 + n9 + n9];
                            this.iDef += this.view.ring[n9 + n9 + n9 + 1];
                            this.iDex -= this.view.ring[n9 + n9 + n9 + 2];
                        }
                    }
                    if (n >= 0 && this.itemSelect >= 8 && this.itemCurrent < 8 || n7 >= 0 && this.itemCurrent >= 8 && this.itemSelect < 8) {
                        n9 = this.itemSelect >= 8 ? this.view.itemType[this.invItem[this.itemSelect] - 1] - 1 & 7 : this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1 & 7;
                        int n11 = n8 = this.itemSelect >= 8 ? n : n7;
                        if (n8 == 0 || n8 == 7) {
                            this.iDef -= this.view.helmet[n9 + n9];
                            this.iDex += this.view.helmet[n9 + n9 + 1];
                        } else if (n8 == 1) {
                            this.iAtt -= this.view.sword[n9 + n9];
                            this.iDex += this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 2 || n8 == 3) {
                            this.iDef -= this.view.sword[n9 + n9];
                            this.iDex += this.view.sword[n9 + n9 + 1];
                        } else if (n8 == 4) {
                            this.iAtt -= this.view.ring[n9 + n9 + n9];
                            this.iDef -= this.view.ring[n9 + n9 + n9 + 1];
                            this.iDex += this.view.ring[n9 + n9 + n9 + 2];
                        }
                    }
                    n9 = this.invItem[this.itemCurrent];
                    this.invItem[this.itemCurrent] = this.invItem[this.itemSelect];
                    this.invItem[this.itemSelect] = (byte)n9;
                }
                this.itemSelect = -1;
                break;
            }
            case 7: {
                ++this.ticks;
                if (this.ticks != 258) break;
                this.ticks = 2;
                break;
            }
            case 4: {
                int n = 0;
                while (n < this.view.xSize / 5) {
                    this.view.itemType[n] = this.ticks < 8 ? (byte)0 : (byte)(this.view.itemType[n] + Util.getRandomInt(0, 2));
                    ++n;
                }
                ++this.ticks;
                if (this.ticks < 60) break;
                this.gameActionCurrent = this.gameActionCount;
                this.status = 0;
                this.ticks = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void draw() {
        block98: {
            block99: {
                block100: {
                    var1_1 = this.getGraphics();
                    var1_1.setFont(GameManager.GAME_FONT);
                    if (this.isPaused && !this.redrawAll) break block98;
                    if (this.status == 6) {
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        var1_1.setColor(0, 0, 0);
                        if (this.ticks <= 8) {
                            var2_2 = 0;
                            while (var2_2 < this.view.xSize >> 3) {
                                if (this.ticks + (var2_2 << 3) < this.view.xSize) {
                                    var1_1.drawLine(this.colBorder + this.ticks + (var2_2 << 3), this.rowBorder, this.colBorder + this.ticks + (var2_2 << 3), this.rowBorder + this.view.ySize - 1);
                                }
                                ++var2_2;
                            }
                        } else {
                            var2_2 = 0;
                            var3_3 = 0;
                            while (var3_3 < this.view.totSecret) {
                                if (this.view.secretFound[var3_3] == 1) {
                                    ++var2_2;
                                }
                                ++var3_3;
                            }
                            var4_6 = new StringBuffer("");
                            var4_6.append(var2_2);
                            var4_6.append(this.dict.getString(Dictionary.OF));
                            var4_6.append(this.view.totSecret);
                            this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - (GameManager.fontHeight << 1), var4_6, 0);
                            var4_6 = null;
                            var4_6 = new StringBuffer(this.dict.getString(Dictionary.SECRETS_FOUND));
                            this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) - GameManager.fontHeight, var4_6, 0);
                            var4_6 = null;
                            var4_6 = new StringBuffer(this.dict.getString(Dictionary.LEVEL_COMPLETE));
                            this.drawSmallText(var1_1, this.gameWidth >> 1, this.rowBorder + (this.view.ySize >> 1) + GameManager.fontHeight, var4_6, 0);
                        }
                    } else if (this.status == 5 && this.ticks != 0) {
                        if (this.showItem) {
                            var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                            var1_1.setColor(0, 0, 0);
                            var1_1.fillRect(0, 0, this.gameWidth, this.gameHeight);
                            var1_1.setColor(255, 255, 255);
                        }
                        if (!this.isPaused && this.showItem) {
                            if (this.bStory == null) {
                                return;
                            }
                            var2_2 = 2;
                            var3_3 = GameManager.fontHeight - GameManager.fontHeight * this.ticks;
                            var4_7 = var2_2;
                            var5_14 = var3_3;
                            var6_15 = 0;
                            var7_19 = 0;
                            while (var6_15 < this.storyStr.length()) {
                                if (this.storyStr.charAt(var6_15) == ' ' || this.storyStr.charAt(var6_15) == '\n') {
                                    if (var4_7 + GameManager.GAME_FONT.stringWidth(this.storyStr.substring(var7_19, var6_15)) > this.gameWidth - 4) {
                                        var4_7 = var2_2;
                                        if ((var5_14 += GameManager.fontHeight) > this.gameHeight) break;
                                        if (this.storyStr.charAt(var7_19) == ' ' && var7_19 < var6_15) {
                                            ++var7_19;
                                        }
                                    }
                                    if (this.storyStr.charAt(var6_15) == ' ') {
                                        var1_1.drawString(this.storyStr.substring(var7_19, var6_15), var4_7, var5_14, 20);
                                        if ((var4_7 += GameManager.GAME_FONT.stringWidth(this.storyStr.substring(var7_19, var6_15))) == var2_2) {
                                            ++var6_15;
                                        }
                                    }
                                    if (this.storyStr.charAt(var6_15) == '\n') {
                                        if (var7_19 < var6_15) {
                                            var1_1.drawString(this.storyStr.substring(var7_19, var6_15 - 1), var4_7, var5_14, 20);
                                        }
                                        var4_7 = var2_2;
                                        if ((var5_14 += GameManager.fontHeight) > this.gameHeight) break;
                                    }
                                    var7_19 = ++var6_15;
                                }
                                ++var6_15;
                            }
                            this.bEnd = false;
                            if (var5_14 <= this.gameHeight - GameManager.fontHeight) {
                                this.bEnd = true;
                            }
                            this.showItem = false;
                        }
                    } else if (this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                        if (this.redrawBG) {
                            this.drawBackground(var1_1);
                        }
                        if (this.clrInvTxt) {
                            if (this.availBG) {
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(this.colBorder, 90, this.gameWidth - (this.colBorder << 1), 14);
                            }
                            this.clrInvTxt = false;
                        }
                        this.view.getMap(this.direction, this.xMap, this.yMap);
                        var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                        this.view.floorToView();
                        this.view.getRayCast();
                        this.view.doRayCast();
                        this.view.getObjectMap(this.direction);
                        this.view.showView(var1_1);
                        if (this.showItem) {
                            var1_1.setClip(this.itemX, this.itemY, 24, 20);
                            var1_1.drawImage(this.invgfx, this.itemX - 24, this.itemY - 124, 20);
                            this.clearItem = true;
                        } else if (this.clearItem) {
                            if (this.availBG) {
                                var1_1.setClip(this.itemX, this.itemY, 24, 20);
                                var1_1.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
                            }
                            this.clearItem = false;
                        }
                        if (this.iRecovery > 0) {
                            var2_2 = this.gameWidth - 16 >> 1;
                            var3_4 = (this.view.ySize - 16 >> 1) + this.view.yLoc;
                            var1_1.setClip(var2_2, var3_4, 16, 16);
                            var1_1.drawImage(this.invgfx, var2_2 - 48, var3_4 - 120, 20);
                            var4_8 = new StringBuffer("");
                            var4_8.append(this.iHit);
                            var1_1.setClip(var2_2 - 8, var3_4 - 9, 32, 32);
                            var1_1.setColor(255, 255, 255);
                            var1_1.drawString(var4_8.toString(), var2_2 + 8, var3_4 + 9 - (GameManager.fontHeight >> 1), 17);
                        }
                        if (this.compassDirec != this.direction || this.gameHeight == 65) {
                            this.compassDirec = this.direction;
                            var2_2 = this.view.xLoc + 83;
                            var3_4 = this.view.yLoc + this.view.ySize + 15;
                            var1_1.setClip(var2_2, var3_4, 13, 13);
                            var1_1.drawImage(this.bggfx, var2_2 -= this.compassDirec * 13, var3_4 - 32, 20);
                        }
                        if (this.showText != 0) {
                            var2_2 = this.availBG != false ? this.view.yLoc + this.view.ySize - (GameManager.fontHeight + 2) : this.gameHeight - 5;
                            var3_5 = new StringBuffer("");
                            var3_5.append(this.dict.getString(this.showText));
                            this.drawSmallText(var1_1, this.gameWidth >> 1, var2_2, var3_5, 0);
                            this.clrInvTxt = true;
                            if (this.textTimer == 0) {
                                this.showText = 0;
                            } else {
                                --this.textTimer;
                            }
                        }
                        var2_2 = this.view.xLoc + this.view.xSize - 12;
                        var3_3 = this.colBorder + 2;
                        var4_9 = 0;
                        while (var4_9 < this.view.scrolls.length) {
                            var1_1.setClip(var2_2, var3_3, 12, 12);
                            if (this.view.scrolls[var4_9] > 16 || (this.view.scrolls[var4_9] & 2) != 0) {
                                var1_1.drawImage(this.invgfx, var2_2 - (var4_9 & 1) * 12, var3_3 - (72 + (var4_9 >> 1) * 12), 20);
                            }
                            if (this.view.scrolls[var4_9] != 0) {
                                v0 = var4_9;
                                this.view.scrolls[v0] = (byte)(this.view.scrolls[v0] - 1);
                                var3_3 += 12;
                            }
                            ++var4_9;
                        }
                    } else if (this.status == 3) {
                        if (this.redrawBG) {
                            this.drawBackground(var1_1);
                        }
                        this.view.showView(var1_1);
                        this.drawInv(var1_1);
                    } else if (this.status == 4 && this.ticks != 0) {
                        var2_2 = 0;
                        while (var2_2 <= this.view.xSize / 5) {
                            var3_3 = var2_2 * 5 + this.colBorder;
                            var4_10 = var3_3 + 5;
                            var5_14 = this.availBG != false ? this.view.itemType[var2_2] + this.rowBorder : this.view.itemType[var2_2];
                            var6_15 = var5_14 - 5;
                            if (var6_15 < this.rowBorder) {
                                var1_1.setClip(var3_3, this.rowBorder, 5, var5_14 - this.rowBorder);
                            } else {
                                var1_1.setClip(var3_3, var6_15, 5, 5);
                            }
                            var1_1.drawImage(this.invgfx, var3_3 - 54, var6_15 - 110, 20);
                            ++var2_2;
                        }
                    }
                    if (this.status == 3 || this.status == 2 || this.status == 4 && this.ticks == 0 || this.status == 7 && this.ticks == 1) {
                        if (this.showHand && this.availBG) {
                            this.drawHand(var1_1);
                            this.showHand = false;
                        }
                        if (this.showHP || !this.availBG) {
                            if (this.availBG) {
                                var2_2 = this.view.xLoc + 4;
                                var3_3 = this.view.yLoc + this.view.ySize + 26;
                                var1_1.setClip(var2_2, var3_3, 32, 4);
                                if (this.HP > 0) {
                                    if (this.HP > 32) {
                                        var1_1.setColor(0, 255, 0);
                                    } else if (this.HP > 16) {
                                        var1_1.setColor(255, 255, 0);
                                    } else {
                                        var1_1.setColor(255, 0, 0);
                                    }
                                    var1_1.fillRect(var2_2, var3_3, this.HP >> 2, 4);
                                }
                                if (this.HP < 64) {
                                    var1_1.setColor(0, 0, 0);
                                    var1_1.fillRect(var2_2 + (this.HP >> 2), var3_3, 16 - (this.HP >> 2), 4);
                                }
                            } else if (this.status != 3) {
                                var1_1.setClip(0, 16, 16, 2);
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(0, 16, 16, 2);
                                if (this.HP > 32) {
                                    var1_1.setColor(0, 255, 0);
                                } else if (this.HP > 16) {
                                    var1_1.setColor(255, 255, 0);
                                } else {
                                    var1_1.setColor(255, 0, 0);
                                }
                                var1_1.fillRect(0, 16, this.HP >> 2, 4);
                            }
                            this.showHP = false;
                        }
                        if (this.status != 3) {
                            var2_2 = 4;
                            var3_3 = 0;
                            while (var3_3 < 4) {
                                if (this.showBlood[var3_3][1] > 0) {
                                    var4_11 = this.availBG != false ? this.view.xLoc + 4 : 0;
                                    var5_14 = this.availBG != false ? this.view.yLoc + this.view.ySize + 6 : 0;
                                    switch (var3_3) {
                                        case 0: {
                                            var5_14 -= var2_2;
                                            break;
                                        }
                                        case 1: {
                                            var4_11 += var2_2;
                                            break;
                                        }
                                        case 2: {
                                            var5_14 += var2_2;
                                            break;
                                        }
                                        case 3: {
                                            var4_11 -= var2_2;
                                        }
                                    }
                                    var1_1.setClip(var4_11, var5_14, 16, 16);
                                    if (this.showBlood[var3_3][1] == 1) {
                                        if (this.availBG) {
                                            var1_1.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
                                        }
                                    } else {
                                        var1_1.drawImage(this.invgfx, var4_11 - 48, var5_14 - 120, 20);
                                        var6_16 = new StringBuffer("");
                                        var6_16.append(this.showBlood[var3_3][0]);
                                        var1_1.setClip(var4_11 - 8, var5_14 - 9, 32, 32);
                                        var1_1.setColor(255, 255, 255);
                                        var1_1.drawString(var6_16.toString(), var4_11 + 8, var5_14 + 9 - (GameManager.fontHeight >> 1), 17);
                                    }
                                    v1 = this.showBlood[var3_3];
                                    v1[1] = v1[1] - 1;
                                    if (var3_3 == 2 && this.showBlood[var3_3][1] == 0) {
                                        this.showHP = true;
                                    }
                                }
                                ++var3_3;
                            }
                        }
                    }
                    if (this.status != 7) break block99;
                    var2_2 = 3;
                    var3_3 = this.view.xLoc + (this.view.xSize - 32 * var2_2 >> 2) * 3;
                    var4_12 = this.view.yLoc + (this.view.ySize - 32 * var2_2 >> 1);
                    if (var4_12 < 0) {
                        var4_12 = 0;
                    }
                    var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
                    if (this.ticks != 1) break block100;
                    var1_1.setColor(0, 128, 54);
                    var1_1.fillRect(var3_3, var4_12, 32 * 3, 32 * 3);
                    var5_14 = 0;
                    while (var5_14 <= 12) {
                        var1_1.setColor(0, 160, 54);
                        var1_1.drawLine(var3_3, var4_12 + (var5_14 << 3), var3_3 + 32 * 3, var4_12 + (var5_14 << 3));
                        var1_1.drawLine(var3_3 + (var5_14 << 3), var4_12, var3_3 + (var5_14 << 3), var4_12 + 32 * 3);
                        ++var5_14;
                    }
                    var6_17 = 0;
                    if (true) ** GOTO lbl311
                    do {
                        var7_19 = 0;
                        if (true) ** GOTO lbl308
                        do {
                            block101: {
                                block104: {
                                    block106: {
                                        block105: {
                                            block103: {
                                                block102: {
                                                    if ((this.view.mapItem[var7_19][var6_17] & 4) == 0) break block101;
                                                    var8_20 = this.view.mapOne[var7_19 + (var6_17 << 5)];
                                                    if ((var8_20 & 17) == 0) break block102;
                                                    if ((var8_20 & 17) == 17) {
                                                        var1_1.setColor(255, 255, 255);
                                                    } else {
                                                        var1_1.setColor(172, 211, 115);
                                                    }
                                                    var1_1.fillRect(var7_19 + var7_19 + var7_19 + var3_3, var6_17 + var6_17 + var6_17 + var4_12, var2_2, var2_2);
                                                    break block101;
                                                }
                                                if (var7_19 == 0) break block103;
                                                if (this.view.mapOne[var7_19 + (var6_17 << 5) - 1] != 0) break block104;
                                            }
                                            if (var7_19 == 32 - 1) break block105;
                                            if (this.view.mapOne[var7_19 + (var6_17 << 5) + 1] != 0) break block104;
                                        }
                                        if (var6_17 == 0) break block106;
                                        if (this.view.mapOne[var7_19 + (var6_17 << 5) - 32] != 0) break block104;
                                    }
                                    if (var6_17 == 32 - 1) break block101;
                                    if (this.view.mapOne[var7_19 + (var6_17 << 5) + 32] == 0) break block101;
                                }
                                var1_1.setColor(0, 0, 0);
                                var1_1.fillRect(var7_19 + var7_19 + var7_19 + var3_3, var6_17 + var6_17 + var6_17 + var4_12, var2_2, var2_2);
                            }
                            ++var7_19;
lbl308:
                            // 2 sources

                        } while (var7_19 < 32);
                        ++var6_17;
lbl311:
                        // 2 sources

                    } while (var6_17 < 32);
                }
                if ((this.ticks & 8) == 0) {
                    var1_1.setColor(0, 0, 255);
                } else {
                    var1_1.setColor(172, 211, 115);
                }
                var1_1.fillRect(this.xMap * var2_2 + var3_3, this.yMap * var2_2 + var4_12, var2_2, var2_2);
            }
            this.redrawAll = false;
        }
        if (this.isPaused) {
            var2_2 = 0;
            var3_3 = 0;
            while (var3_3 < this.options.length) {
                if (this.options[var3_3]) {
                    ++var2_2;
                }
                ++var3_3;
            }
            var4_13 = this.gameWidth >> 1;
            v2 = var5_14 = this.view != null ? (this.view.ySize >> 1) - (var2_2 * (GameManager.fontHeight + 1) >> 1) : (this.gameHeight >> 1) - ((var2_2 - 2) * (GameManager.fontHeight + 1) >> 1);
            if (this.view != null && this.view.yLoc > 0) {
                var5_14 += this.view.yLoc;
            }
            var1_1.setClip(0, 0, this.gameWidth, this.gameHeight);
            var1_1.setColor(0, 0, 0);
            var1_1.fillRect(var4_13 - 35, var5_14 - 3, 70, var2_2 * (GameManager.fontHeight + 1) + 4);
            var1_1.setColor(255, 255, 0);
            var1_1.drawRect(var4_13 - 35, var5_14 - 3, 70, var2_2 * (GameManager.fontHeight + 1) + 4);
            var3_3 = 0;
            while (var3_3 < this.options.length) {
                var6_18 = new StringBuffer(this.dict.getString(Dictionary.MENU_0 + var3_3));
                if (this.options[var3_3]) {
                    if (this.option == var3_3) {
                        this.drawSmallText(var1_1, var4_13, var5_14, var6_18, 1);
                        var5_14 += GameManager.fontHeight + 1;
                    } else {
                        this.drawSmallText(var1_1, var4_13, var5_14, var6_18, 0);
                        var5_14 += GameManager.fontHeight + 1;
                    }
                }
                ++var3_3;
            }
        }
    }

    void showOption(Graphics graphics, int n, int n2, StringBuffer stringBuffer) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.drawString(stringBuffer.toString(), n + 1, (n2 -= 2) + 1, 17);
        graphics.setColor(255, 255, 0);
        graphics.drawString(stringBuffer.toString(), n, n2, 17);
    }

    int drawSmallText(Graphics graphics, int n, int n2, StringBuffer stringBuffer, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (GAME_FONT.stringWidth(stringBuffer.toString()) > this.gameWidth - (this.colBorder << 1)) {
            n6 = 1;
            while (n5 < stringBuffer.length()) {
                if (stringBuffer.charAt(n5) != ' ') {
                    ++n5;
                    continue;
                }
                break;
            }
        } else {
            n5 = stringBuffer.length();
        }
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        int n7 = 0;
        while (n7 <= n6) {
            graphics.setColor(0, 0, 0);
            if (n7 == 0) {
                graphics.drawString(stringBuffer.toString().substring(n4, n5), n + 1, n2 + 1, 17);
            } else {
                graphics.drawString(stringBuffer.toString().substring(n5, stringBuffer.length()), n + 1, n2 + 1, 17);
            }
            switch (n3) {
                case 0: {
                    graphics.setColor(255, 255, 255);
                    break;
                }
                case 1: {
                    graphics.setColor(255, 255, 0);
                    break;
                }
                case 2: {
                    graphics.setColor(0, 255, 255);
                }
            }
            if (n7 == 0) {
                graphics.drawString(stringBuffer.toString().substring(n4, n5), n, n2, 17);
            } else {
                graphics.drawString(stringBuffer.toString().substring(n5, stringBuffer.length()), n, n2, 17);
            }
            n2 += fontHeight + 1;
            ++n7;
        }
        return n6 * (fontHeight + 1);
    }

    void drawBackground(Graphics graphics) {
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.gameWidth, this.gameHeight);
        graphics.setClip(0, this.view.ySize + this.rowBorder + 2, this.gameWidth, 32);
        if (this.availBG) {
            graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
            this.drawHand(graphics);
        }
        this.redrawBG = false;
    }

    void drawHand(Graphics graphics) {
        if (this.view == null) {
            return;
        }
        int n = this.colBorder + 25;
        int n2 = this.view.ySize + this.rowBorder + 6;
        graphics.setClip(n, n2, this.invSquareSize, this.invSquareSize);
        graphics.drawImage(this.bggfx, this.colBorder, this.view.ySize + this.rowBorder + 2, 20);
        if (this.invItem[12] != 0) {
            int n3 = this.view.itemType[this.invItem[12] - 1] - 1 >> 3;
            graphics.drawImage(this.invgfx, n - this.invSquareSize - (n3 & 1) * this.invSquareSize, n2 - (n3 >> 1) * this.invSquareSize, 20);
        } else {
            graphics.drawImage(this.invgfx, n, n2 - 2 * this.invSquareSize, 20);
        }
    }

    void drawInv(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < 16) {
            n2 = this.invSquareXY[n3][0];
            n = this.invSquareXY[n3][1];
            graphics.setClip(n2, n, this.invSquareSize, this.invSquareSize);
            if (this.itemSelect == n3) {
                graphics.drawImage(this.invgfx, n2, n - this.invSquareSize, 20);
            } else {
                graphics.drawImage(this.invgfx, n2, n, 20);
            }
            ++n3;
        }
        n2 = this.availBG ? 66 + this.view.xLoc : 60 + this.view.xLoc;
        n = this.availBG ? this.view.yLoc + 8 : 8;
        graphics.setClip(n2, n, 84, 108);
        graphics.drawImage(this.inv2gfx, n2, n, 20);
        n3 = 0;
        while (n3 < 16) {
            if (this.invItem[n3] != 0) {
                int n4 = this.view.itemType[this.invItem[n3] - 1] - 1 >> 3;
                n2 = this.invSquareXY[n3][0];
                n = this.invSquareXY[n3][1];
                graphics.setClip(n2, n, this.invSquareSize, this.invSquareSize);
                graphics.drawImage(this.invgfx, n2 - this.invSquareSize - (n4 & 1) * this.invSquareSize, n - (n4 >> 1) * this.invSquareSize, 20);
            }
            ++n3;
        }
        graphics.setClip(0, 0, this.gameWidth, this.gameHeight);
        n2 = this.invSquareXY[this.itemCurrent][0];
        n = this.invSquareXY[this.itemCurrent][1];
        graphics.setColor(255, 0, 0);
        graphics.drawRect(n2, n, this.invSquareSize - 1, this.invSquareSize - 1);
        n2 = this.gameWidth >> 1;
        int n5 = n = this.availBG ? this.view.yLoc + this.view.ySize - (fontHeight << 1) : this.gameHeight - 14;
        if (this.invItem[this.itemCurrent] != 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            StringBuffer stringBuffer2 = new StringBuffer("");
            int n6 = this.view.itemType[this.invItem[this.itemCurrent] - 1] - 1;
            int n7 = n6 >> 3;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            stringBuffer.append(this.dict.getString(this.itemDsc[n6] + Dictionary.TEXT_DEX));
            this.drawSmallText(graphics, n2, n, stringBuffer, 0);
            n6 &= 7;
            if (n7 == 0 || n7 == 7) {
                n9 += this.view.helmet[n6 + n6];
                n10 -= this.view.helmet[n6 + n6 + 1];
            } else if (n7 == 1) {
                n8 += this.view.sword[n6 + n6];
                n10 -= this.view.sword[n6 + n6 + 1];
            } else if (n7 == 2 || n7 == 3) {
                n9 += this.view.sword[n6 + n6];
                n10 -= this.view.sword[n6 + n6 + 1];
            } else if (n7 == 4) {
                n8 += this.view.ring[n6 + n6 + n6];
                n9 += this.view.ring[n6 + n6 + n6 + 1];
                n10 -= this.view.ring[n6 + n6 + n6 + 2];
            }
            n10 = -n10;
            if (n8 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_ATT));
                if (n8 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n8);
                stringBuffer2.append(" ");
            }
            if (n9 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEF));
                if (n9 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n9);
                stringBuffer2.append(" ");
            }
            if (n10 != 0) {
                stringBuffer2.append(this.dict.getString(Dictionary.TEXT_DEX));
                if (n10 > 0) {
                    stringBuffer2.append("+");
                }
                stringBuffer2.append(n10);
            }
            this.drawSmallText(graphics, n2, n += fontHeight, stringBuffer2, 0);
            this.clrInvTxt = true;
        }
    }
}

