/*
 * Decompiled with CFR 0.152.
 */
package GlomoReg;

import GlomoReg.GlomoConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.microedition.midlet.MIDlet;

public class GlomoUtil {
    private static Random rand = new Random();
    private static String hexChars = "0123456789ABCDEF";
    private static String base36Chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static final String[] split(String string, String string2) {
        System.out.println("=== split: separator=" + string + " str=" + string2);
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        n2 = 0;
        while ((n2 = string2.indexOf(string, n2) + 1) > 0) {
            ++n;
        }
        String[] stringArray = new String[n];
        n = 0;
        n2 = 0;
        while ((n2 = string2.indexOf(string, n2) + 1) > 0) {
            stringArray[n] = string2.substring(n3, n2 - 1);
            ++n;
            n3 = n2 - 1 + string.length();
        }
        stringArray[n] = string2.substring(n3);
        return stringArray;
    }

    public static final String format(String string, String[] stringArray) {
        return GlomoUtil.format(string, stringArray, '%');
    }

    public static final String format(String string, String[] stringArray, char c2) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        for (int k = 0; k < string.length(); ++k) {
            char c3 = string.charAt(k);
            if (c3 == c2) {
                if (k + 1 < string.length() && string.charAt(k + 1) == c2) {
                    stringBuffer.append(c3);
                    ++k;
                    continue;
                }
                stringBuffer.append(stringArray[n++]);
                continue;
            }
            stringBuffer.append(c3);
        }
        return stringBuffer.toString();
    }

    public static final String[] format(String[] stringArray, String[][] stringArray2) {
        String[] stringArray3 = new String[stringArray.length];
        for (int k = 0; k < stringArray.length; ++k) {
            stringArray3[k] = GlomoUtil.format(stringArray[k], stringArray2[k]);
        }
        return stringArray3;
    }

    public static final int getCheckSum(String string) {
        return GlomoUtil.getCheckSum(string, 0, 0);
    }

    public static final int getCheckSum(String string, int n) {
        return GlomoUtil.getCheckSum(string, n, 0);
    }

    public static final int getCheckSum(String string, int n, int n2) {
        int n3 = 0;
        if (n2 == 0) {
            for (int k = n; k < string.length(); ++k) {
                n3 = ((n3 << 1 | (n3 & 0x80) >> 7) & 0xFF ^ string.charAt(k) & 0xFF) & 0xFF;
            }
        }
        return n3;
    }

    public static final String extractCheckSum(String string, String string2) {
        int n = string2.indexOf(string);
        return n >= 0 ? string2.substring(0, n - 1) : string2;
    }

    public static String[] readResourceAsArr(MIDlet mIDlet, String string) {
        return GlomoUtil.readResourceAsArr(mIDlet, string, true);
    }

    public static String[] readResourceAsArr(MIDlet mIDlet, String string, boolean bl) {
        return GlomoUtil.split("\n", GlomoUtil.readResource(mIDlet, string, bl));
    }

    public static String readResource(MIDlet mIDlet, String string) {
        return GlomoUtil.readResource(mIDlet, string, true);
    }

    public static String readResource(MIDlet mIDlet, String string, boolean bl) {
        try {
            int n;
            InputStream inputStream = mIDlet.getClass().getResourceAsStream(string);
            String string2 = "";
            char[] cArray = new char[inputStream.available() / 2 - 1];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readChar();
            for (int k = 0; k < cArray.length; ++k) {
                cArray[k] = dataInputStream.readChar();
            }
            dataInputStream.close();
            dataInputStream = null;
            byteArrayInputStream.close();
            byteArrayInputStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            string2 = new String(cArray);
            String string3 = GlomoUtil.decrypt(string2, 0);
            return bl ? GlomoUtil.decrypt(string2, 0) : string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final int rnd(int n, int n2) {
        int n3 = Math.abs(rand.nextInt());
        return n3 % (n2 - n) + n;
    }

    public static final long generateRandomKey(int n) {
        if (n == 0) {
            int n2 = Integer.parseInt(GlomoConfig.distInfo.smsKeyVersion());
            int n3 = n2 == 0 ? 6 : 6;
            int n4 = 1;
            int n5 = 9;
            for (int k = 0; k < n3 - 1; ++k) {
                n4 *= 10;
                n5 = n5 * 10 + 9;
            }
            return GlomoUtil.rnd(n4, n5);
        }
        return 0L;
    }

    public static final String generateKeyOfType(int n, String string, long l) {
        if (GlomoConfig.versionInt() > 1) {
            int n2 = Integer.parseInt(GlomoConfig.distInfo.smsKeyVersion());
            String string2 = GlomoConfig.distInfo.channelId();
            String string3 = string2.substring(0, 2);
            String string4 = string2.substring(2, 5);
            return string + string3 + GlomoUtil.encryptLight(GlomoUtil.toBase36((l != 0L ? l : GlomoUtil.generateRandomKey(0)) * 10000L + Long.parseLong(string4) * 10L + (long)(n % 10), n2 == 0 ? 7 : 7), 2) + GlomoConfig.sms_key_version().substring(0, 1);
        }
        return string + GlomoConfig.distInfo.channelId() + GlomoUtil.encryptLight(GlomoUtil.toBase36((l != 0L ? l : GlomoUtil.generateRandomKey(0)) * 10000L + Long.parseLong(GlomoConfig.distInfo.id()) * 10L + (long)(n % 10), 7), 2) + GlomoConfig.sms_key_version().substring(0, 1);
    }

    public static byte[] encryptLightByte(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        if (n == 0) {
            int n2;
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray2[(n2 + 5) % byArray.length] = (byte)(0x25 ^ byArray[n2]);
            }
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray2[n2] = (byte)(byArray2[n2] ^ byArray2[(n2 + 2) % byArray.length]);
            }
        }
        return byArray2;
    }

    public static byte[] decryptLightByte(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        if (n == 0) {
            int n2;
            for (n2 = byArray.length - 1; n2 >= 0; --n2) {
                byArray[n2] = (byte)(byArray[n2] ^ byArray[(n2 + 2) % byArray.length]);
            }
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray2[n2] = (byte)(0x25 ^ byArray[(n2 + 5) % byArray.length]);
            }
        }
        return byArray2;
    }

    public static byte[] packDigits(String string) {
        if (string.length() % 2 == 1) {
            string = string + "0";
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int k = 0; k < byArray.length; ++k) {
            byArray[k] = (byte)(Byte.parseByte(string.substring(k * 2, k * 2 + 1)) + (byte)(Byte.parseByte(string.substring(k * 2 + 1, k * 2 + 2)) << 4));
        }
        return byArray;
    }

    public static String unpackDigits(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int k = 0; k < byArray.length; ++k) {
            stringBuffer.append(String.valueOf(hexChars.charAt(byArray[k] & 0xF)));
            stringBuffer.append(String.valueOf(hexChars.charAt(byArray[k] >> 4 & 0xF)));
        }
        return stringBuffer.toString();
    }

    public static String encryptLight(String string, int n) {
        if (string.length() == 0) {
            return string;
        }
        if (n == 0) {
            return new String(GlomoUtil.encryptLightByte(string.getBytes(), n));
        }
        if (n == 1) {
            return GlomoUtil.unpackDigits(GlomoUtil.encryptLightByte(GlomoUtil.packDigits(string), 0));
        }
        if (n == 2 && string.length() > 2) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 2));
            for (int k = 0; k < string.length() - 2; ++k) {
                stringBuffer.append(string.charAt(2 + (k + base36Chars.indexOf(string.charAt(1))) % (string.length() - 2)));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String decryptLight(String string, int n) {
        if (n == 0) {
            return new String(GlomoUtil.decryptLightByte(string.getBytes(), n));
        }
        if (n == 1) {
            return GlomoUtil.unpackDigits(GlomoUtil.decryptLightByte(GlomoUtil.packDigits(string), 0));
        }
        if (n == 2 && string.length() > 2) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 2));
            int n2 = string.length() - 2;
            for (int k = 0; k < n2; ++k) {
                stringBuffer.append(string.charAt(2 + (k + n2 - base36Chars.indexOf(string.charAt(1)) % n2) % n2));
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String toBase36(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        while (l > 0L) {
            stringBuffer.append(base36Chars.charAt((int)(l % 36L)));
            l /= 36L;
        }
        while (stringBuffer.length() < n) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public static long fromBase36(String string) {
        long l = 0L;
        long l2 = 1L;
        int n = 0;
        while (n < string.length()) {
            l += l2 * (long)base36Chars.indexOf(string.charAt(n));
            ++n;
            l2 *= 36L;
        }
        return l;
    }

    public static String decrypt(String string, int n) {
        int n2;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n3 = cArray.length + 1;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        for (n2 = 1; n2 < n3; ++n2) {
            cArray2[n2 - 1] = cArray[n2 - 1];
        }
        n4 = 1;
        while (n4 < n3) {
            n5 >>= 1;
            n4 = n4 << 1 | 1;
        }
        for (int k = n3 - (n4 >>= 1); k > 0; k -= cArray.length - n4 + (cArray.length - n4 > 0 ? 0 : 1)) {
            int n7 = 0;
            for (int i2 = 4; i2 <= n4 + 1 << 1; i2 += 2) {
                n2 = 0;
                n6 = 0;
                int n8 = 0;
                n5 = 1;
                int n9 = n4 + 1 >> 1;
                while (n2 <= n7) {
                    int n10;
                    if (n2 < n7 || (i2 >> 1) - 2 + (n7 << 1) - n6 - (n4 >> 1) > 0) {
                        n10 = n8 + ((((i2 >> 1) - 2 & n5) == 0 ? 1 : -1) * (n9 >> 1) + 2);
                    } else {
                        int n11;
                        char c2;
                        int n12 = k + (i2 >> 1) - 3;
                        char c3 = cArray2[k + (i2 >> 1) - 3];
                        cArray2[k - 1 - (n7 << 1) + n6 + (n4 >> 1)] = c3;
                        char c4 = cArray2[n12] = (char)(cArray2[n12] + (cArray2[k - 1 - (n7 << 1) + n6 + (n4 >> 1)] - c3));
                        if ((i2 >> 1) + (n7 << 1) - (n4 >> 1) - n6 - 2 == 0) {
                            c2 = '\u0000';
                        } else {
                            n11 = cArray2[k + (i2 >> 1) - 3] + 142;
                            c2 = cArray2[k + (i2 >> 1) - 3] = (char)((n11 % 10 + 10 + (k - 3) % 10) % 10 + n11 / 10 * 10 - 142);
                        }
                        n11 = cArray2[k - 1 - (n7 << 1) + n6 + (n4 >> 1)] + 142;
                        char c5 = (char)((n11 % 10 + 10 + (k - 3) % 10) % 10 + n11 / 10 * 10 - 142);
                        cArray2[k - 1 - (n7 << 1) + n6 + (n4 >> 1)] = c5;
                        n10 = c4 + c2 + c5;
                    }
                    n6 = n10;
                    ++n2;
                    n5 <<= 1;
                    n9 >>= 1;
                }
                n7 += i2 >> 1 == 2 << n7 ? 1 : 0;
            }
        }
        for (n2 = 1; n2 < n3; ++n2) {
            cArray[n2 - 1] = cArray2[n2 - 1];
        }
        return new String(cArray);
    }

    public static String dateToString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        return n + "-" + (n2 <= 10 ? "0" : "") + n2 + "-" + (n3 <= 10 ? "0" : "") + n3 + " " + (n4 <= 10 ? "0" : "") + n4 + ":" + (n5 <= 10 ? "0" : "") + n5 + ":" + (n6 <= 10 ? "0" : "") + n6 + "." + n7;
    }

    public static final String JAD(MIDlet mIDlet, String string) {
        try {
            String string2;
            String string3 = string2 = mIDlet.getAppProperty(string) == null ? "" : mIDlet.getAppProperty(string);
            if (string2.charAt(string2.length() - 1) == ';') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

