/*
 * Decompiled with CFR 0.152.
 */
package game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CustomFont {
    private int style;
    private int size;
    private int baseline;
    private int height;
    private int width;
    private Image image;

    public static CustomFont getFont(String inName, int inStyle, int inSize) {
        Image i;
        String filename = inName;
        try {
            i = Image.createImage((String)filename);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException("Could not locate font: " + filename + " : " + t);
        }
        return new CustomFont(i, inSize, inStyle);
    }

    private CustomFont(Image inImage, int inStyle, int inSize) {
        this.image = inImage;
        this.style = inStyle;
        this.size = inSize;
        try {
            this.height = this.image.getHeight();
            this.width = this.image.getWidth() / 256;
            this.baseline = this.calculateBaseline();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException("Specified font is invalid: " + t);
        }
    }

    private int calculateBaseline() {
        int result = this.height;
        int imageWidth = this.image.getWidth();
        int max = 0;
        int[] row = new int[imageWidth];
        this.image.getRGB(row, 0, 1, 0, 0, 1, 1);
        int background = row[0];
        int y = this.height / 2;
        while (y < this.height) {
            int total = 0;
            this.image.getRGB(row, 0, imageWidth, 0, y, imageWidth, 1);
            int x = 0;
            while (x < imageWidth) {
                if (row[x] != background) {
                    ++total;
                }
                ++x;
            }
            if (total > max) {
                max = total;
                result = y;
            }
            ++y;
        }
        return result;
    }

    public int charsWidth(char[] ch, int offset, int length) {
        return length * this.width;
    }

    public int charWidth(char ch) {
        return this.width;
    }

    public int getBaselinePosition() {
        return this.baseline;
    }

    public int getHeight() {
        return this.height;
    }

    public int stringWidth(String str) {
        return this.charsWidth(str.toCharArray(), 0, str.length());
    }

    public int substringWidth(String str, int offset, int len) {
        return this.charsWidth(str.toCharArray(), offset, len);
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isUnderlined() {
        return (this.style & 4) != 0;
    }

    public void drawChar(Graphics g, char character, int x, int y, int anchor) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        this.drawCharInternal(g, character, x, y, anchor);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public void drawChars(Graphics g, char[] data, int offset, int length, int x, int y, int anchor) {
        if ((anchor & 8) != 0) {
            x -= this.charsWidth(data, offset, length);
        } else if ((anchor & 1) != 0) {
            x -= this.charsWidth(data, offset, length) / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= this.height;
        } else if ((anchor & 2) != 0) {
            y -= this.height / 2;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int i = 0;
        while (i < length) {
            char c = data[offset + i];
            this.drawCharInternal(g, c, x, y, 0x10 | 4);
            x += this.width;
            ++i;
        }
        g.setClip(clipX, clipY, clipW, clipH);
    }

    private void drawCharInternal(Graphics g, char character, int x, int y, int anchor) {
        if ((this.style & 2) != 0) {
            g.setClip(x + 1, y, this.width, this.height / 2);
            g.drawImage(this.image, x - this.width * character + 1, y, anchor);
            g.setClip(x, y + this.height / 2, this.width, this.height / 2);
            g.drawImage(this.image, x - this.width * character, y, anchor);
            if ((this.style & 1) != 0) {
                g.setClip(x, y, this.width, this.height / 2);
                g.drawImage(this.image, x - this.width * character + 2, y, anchor);
                g.setClip(x, y + this.height / 2, this.width, this.height / 2);
                g.drawImage(this.image, x - this.width * character + 1, y, anchor);
            }
        } else {
            g.setClip(x, y, this.width, this.height);
            g.drawImage(this.image, x - this.width * character, y, anchor);
            if ((this.style & 1) != 0) {
                g.drawImage(this.image, x - this.width * character + 1, y, anchor);
            }
        }
        if ((this.style & 4) != 0) {
            g.drawLine(x, y + this.baseline + 2, x + this.width, y + this.baseline + 2);
        }
    }

    public void drawString(Graphics g, String str, int x, int y, int anchor) {
        this.drawChars(g, str.toCharArray(), 0, str.length(), x, y, anchor);
    }

    public void drawSubstring(Graphics g, String str, int offset, int len, int x, int y, int anchor) {
        this.drawChars(g, str.toCharArray(), offset, len, x, y, anchor);
    }
}

