/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameScreen;
import game.itemsClass;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class roomClass {
    public int roomID = -1;
    private int roomWidth;
    private int roomHeight;
    public boolean tiledMap;
    public boolean tiledAlpha;
    public int terrainX;
    public int terrainY;
    public TiledLayer terrain;
    public TiledLayer alphaTerrain;
    public Image roomAlpha;
    public Sprite spriteAlpha;
    public Image tileImages;
    public Image alphaTiles;
    public Image tileImagesAlpha;
    private int[][] mapArray;
    public itemsClass[] roomItemsNew;

    public roomClass(int _room) {
        this.setMap(_room);
    }

    public void resetSprites() {
        int i = 0;
        while (i < this.roomItemsNew.length) {
            this.roomItemsNew[i].erase();
            ++i;
        }
    }

    public void setMap(int roomNum) {
        int col;
        this.roomID = roomNum;
        System.out.println("creatingMap:" + roomNum);
        this.mapArray = GameScreen.data.roomMaps[this.roomID];
        this.roomWidth = this.mapArray[0].length;
        this.roomHeight = this.mapArray.length;
        String tileName = GameScreen.data.roomSprites[this.roomID][0];
        String alphaName = GameScreen.data.roomSprites[this.roomID][1];
        try {
            this.tileImages = Image.createImage((String)("/images/tiles/" + tileName + ".png"));
        }
        catch (IOException ioe) {
            System.out.println("errereer" + ioe.getMessage());
            ioe.printStackTrace();
        }
        if (tileName.charAt(0) != '_') {
            this.tiledMap = true;
            this.terrain = new TiledLayer(this.roomWidth, this.roomHeight, this.tileImages, 32, 32);
            int row = 0;
            while (row < this.roomHeight) {
                col = 0;
                while (col < this.roomWidth) {
                    this.terrain.setCell(col, row, this.mapArray[row][col] + 1);
                    ++col;
                }
                ++row;
            }
        } else {
            this.tiledMap = false;
            this.terrain = new TiledLayer(this.roomWidth, this.roomHeight, this.tileImages, this.tileImages.getWidth(), this.tileImages.getHeight());
            this.terrain.setCell(0, 0, 1);
        }
        try {
            this.tileImagesAlpha = Image.createImage((String)("/images/tiles/" + alphaName + ".png"));
        }
        catch (IOException ioe) {
            System.out.println("errereer" + ioe.getMessage());
            ioe.printStackTrace();
        }
        if (alphaName.charAt(0) != '_') {
            this.tiledMap = true;
            this.alphaTerrain = new TiledLayer(this.roomWidth, this.roomHeight, this.tileImagesAlpha, 32, 32);
            int row = 0;
            while (row < this.roomHeight) {
                col = 0;
                while (col < this.roomWidth) {
                    if (this.roomID == 16) {
                        this.alphaTerrain.setCell(col, row, GameScreen.data.room16_alpha[row][col] + 1);
                    } else {
                        this.alphaTerrain.setCell(col, row, this.mapArray[row][col] + 1);
                    }
                    ++col;
                }
                ++row;
            }
        } else {
            this.tiledMap = false;
            this.alphaTerrain = new TiledLayer(this.roomWidth, this.roomHeight, this.tileImagesAlpha, this.tileImagesAlpha.getWidth(), this.tileImagesAlpha.getHeight());
            this.alphaTerrain.setCell(0, 0, 1);
        }
        System.out.println("-roomAlpha created");
        this.roomItemsNew = null;
        this.roomItemsNew = new itemsClass[GameScreen.data.roomItems[this.roomID].length];
        int i = 0;
        while (i < GameScreen.data.roomItems[this.roomID].length) {
            this.roomItemsNew[i] = GameScreen.data.getItemNew(GameScreen.data.roomItems[this.roomID][i]);
            ++i;
        }
        this.roomInit();
    }

    public void roomInit() {
        int i = 0;
        while (i < this.roomItemsNew.length) {
            this.roomItemsNew[i].init();
            ++i;
        }
    }

    public void moveTerrain(int newX, int newY) {
        int item = 0;
        while (item < this.roomItemsNew.length) {
            this.roomItemsNew[item].setPosition(64 - newX, 64 - newY);
            ++item;
        }
        this.terrain.setPosition(64 - newX, 64 - newY);
        this.alphaTerrain.setPosition(64 - newX, 64 - newY);
    }

    public TiledLayer getTerrain() {
        return this.terrain;
    }

    public TiledLayer getAlphaTerrain() {
        return this.alphaTerrain;
    }

    public int setState(int itemID, int newState) {
        int ID = -1;
        int item = 0;
        while (item < this.roomItemsNew.length) {
            if (GameScreen.data.roomItems[this.roomID][item] == itemID) {
                this.roomItemsNew[item].setState(newState);
                ID = item;
                break;
            }
            ++item;
        }
        return ID;
    }

    public int checkItems(int boyPosX, int boyPosY) {
        int itemOver = -1;
        int item = 0;
        while (item < this.roomItemsNew.length) {
            if (this.roomItemsNew[item].hitTest(boyPosX, boyPosY)) {
                itemOver = item;
                break;
            }
            ++item;
        }
        return itemOver;
    }

    public void setRoomState(int newRoomState) {
        GameScreen.data.roomStates[this.roomID] = newRoomState;
    }

    public void render(Graphics g) {
        int item = 0;
        while (item < this.roomItemsNew.length) {
            this.roomItemsNew[item].render(g);
            ++item;
        }
    }
}

