/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DemoScreen
extends MyScreen {
    private Game game;
    private boolean exit = false;
    private short currImage;
    private Image[] image;
    private static final byte NUM_IMAGES = 4;
    private int counter;
    private static final short HOLDTIME = 45;

    public DemoScreen(Game midlet) {
        this.game = midlet;
        this.game.cmdY = (short)(this.game.y + this.game.render.getOriginalResHeight() - this.game.COMMANDH);
        this.exit = false;
        this.counter = 0;
        this.currImage = 0;
        this.Load();
    }

    public void Load() {
        try {
            this.image = new Image[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                this.image[i2] = Image.createImage((String)(Game.DATA_PATH + this.game.dpath + "demo" + i2 + ".png"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Free() {
        if (this.image != null) {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.image[i2] = null;
            }
            this.image = null;
        }
    }

    public void Render(Graphics g) {
        this.game.render.ClearScreen(g, 0, 0, 0);
        if (this.exit) {
            this.game.close();
            return;
        }
        if (this.counter != 0 || this.currImage == 0) {
            // empty if block
        }
        g.drawImage(this.image[this.currImage], this.game.wcenter - this.image[this.currImage].getWidth() / 2, this.game.hcenter - this.image[this.currImage].getHeight() / 2, 20);
        if (this.counter >= 45 && !this.game.popup.isActive) {
            if (this.currImage == 3) {
                this.game.drawCommand(g, (byte)2, (byte)2);
            } else {
                this.game.drawCommand(g, (byte)13, (byte)2);
            }
        }
        ++this.counter;
        if (this.counter >= 45) {
            this.counter = 45;
        }
    }

    public void keyReleased(int gameAction) {
        if (this.game.wipe.IsActive() || this.exit) {
            return;
        }
        switch (gameAction) {
            case 6: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                this.doNext();
            }
        }
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                break;
            }
            case '#': {
                this.doNext();
            }
        }
    }

    public void doNext() {
        if (this.counter < 45) {
            return;
        }
        this.counter = 0;
        this.currImage = (short)(this.currImage + 1);
        if (this.currImage >= 4) {
            this.exit = true;
        }
    }

    public void Process(int arg0) {
    }

    public void keyPressed(int arg0) {
    }

    public void commandAction(Command arg0, Displayable arg1) {
    }
}

