/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyColor;
import com.dvidearts.jengine.MyPoint;
import com.dvidearts.jengine.MySprite;
import com.dvidearts.jengine.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Player
extends Object {
    private Game game;
    public PATH[] path;
    public byte mAnimation = (byte)-1;
    public Image[] imgNormal = null;
    public Image[] imgStealth = null;
    public Image[] imgPowerUp = null;
    public short healthBarCounter;
    public short animate;
    public short health;
    public short stealthCounter;
    public short stealthTimer;
    public short destructionTimer;
    public short shockedGuard;
    public boolean dead;
    public boolean stealth;
    public boolean attacking;
    public boolean moving;
    public boolean poweredUp;
    public boolean following;
    public boolean inFollowRange;
    public MyPoint ptRing;
    public int RUN_SPEED;
    public byte id;
    public byte shotDelay;
    public byte shotDelayCounter;
    public byte direction;
    public byte specialAction;
    public Blood blood;
    public short targetIndex;
    public static final byte PATH_STEPS = 7;
    public static final byte PID_PUPPY = 0;
    public static final byte PID_KITTY = 1;
    public static final byte PID_CHICKEN = 2;
    public static final byte SPECIAL_NONE = 0;
    public static final byte SPECIAL_DIG = 1;
    public static final byte SPECIAL_STEALTH_ATTACK = 2;
    public static final byte SPECIAL_HACK = 3;
    public static final byte SPECIAL_FOLLOW = 4;
    public static final byte ANIM_STAND = 0;
    public static final byte ANIM_RUNLEFT = 1;
    public static final byte ANIM_RUNRIGHT = 2;
    public static final byte ANIM_RUNUP = 3;
    public static final byte ANIM_RUNDOWN = 4;
    public static final byte ANIM_DIG = 5;
    public static final byte ANIM_FIRE_DOWN = 6;
    public static final byte ANIM_FIRE_UP = 7;
    public static final byte ANIM_FIRE_LEFT = 8;
    public static final byte ANIM_FIRE_RIGHT = 9;
    public static final byte ANIM_DEATH = 10;
    public static final byte ANIM_CATFIGHT = 11;
    public static final byte ANIM_STUN_DOWN = 12;
    public static final byte ANIM_STUN_UP = 13;
    public static final byte ANIM_STUN_LEFT = 14;
    public static final byte ANIM_STUN_RIGHT = 15;
    public static final short[] FRAMES_STAND = new short[]{0};
    public static final short[] FRAMES_RUNRIGHT = new short[]{6, 7, 6, 8};
    public static final short[] FRAMES_RUNLEFT = new short[]{11, 10, 11, 9};
    public static final short[] FRAMES_RUNUP = new short[]{3, 4, 3, 5};
    public static final short[] FRAMES_RUNDOWN = new short[]{0, 1, 0, 2};
    public static final short[] FRAMES_DIG = new short[]{12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 0};
    public static final short[] FRAMES_CATFIGHT = new short[]{12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14, 12, 13, 14};
    public static final short[] FRAMES_FIRE_DOWN = new short[]{15, 15, 15, 15, 0};
    public static final short[] FRAMES_FIRE_UP = new short[]{16, 16, 16, 16, 3};
    public static final short[] FRAMES_FIRE_LEFT = new short[]{18, 18, 18, 18, 11};
    public static final short[] FRAMES_FIRE_RIGHT = new short[]{17, 17, 17, 17, 6};
    public static final short[] FRAMES_STUN_DOWN = new short[]{15};
    public static final short[] FRAMES_STUN_UP = new short[]{16};
    public static final short[] FRAMES_STUN_LEFT = new short[]{18};
    public static final short[] FRAMES_STUN_RIGHT = new short[]{17};
    public static final short[] FRAMES_DEATH = new short[]{19};

    public Player(Game g, byte ID) {
        this.game = g;
        this.path = new PATH[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            this.path[i2] = new PATH();
        }
        this.burned = true;
        this.following = false;
        this.poweredUp = false;
        this.shockedGuard = (short)-1;
        this.stealth = false;
        this.stealthTimer = 0;
        this.healthBarCounter = 0;
        int iw = 0;
        int ih = 0;
        this.health = this.game.sinfo[this.game.infoSlot].maxHealth;
        this.dead = false;
        this.id = ID;
        this.ptRing = new MyPoint();
        this.blood = new Blood(35);
        this.shotDelay = this.game.SHOTGUN_DELAY;
        this.RUN_SPEED = 6;
        try {
            switch (this.id) {
                case 0: {
                    this.imgNormal = MySprite.createImageArray(Image.createImage((String)(Game.DATA_PATH + "puppy.png")), this.game.PLAYER_SIZE, this.game.PLAYER_SIZE);
                    this.imgPowerUp = MySprite.createImageArray(Image.createImage((String)(Game.DATA_PATH + "puppypow.png")), this.game.PLAYER_SIZE, this.game.PLAYER_SIZE);
                    this.sprite = new MySprite(this.imgNormal);
                    break;
                }
                case 1: {
                    this.imgNormal = MySprite.createImageArray(Image.createImage((String)(Game.DATA_PATH + "kitty.png")), this.game.PLAYER_SIZE, this.game.PLAYER_SIZE);
                    this.imgStealth = MySprite.createImageArray(Image.createImage((String)(Game.DATA_PATH + "kitty2.png")), this.game.PLAYER_SIZE, this.game.PLAYER_SIZE);
                    this.sprite = new MySprite(this.imgNormal);
                    break;
                }
                case 2: {
                    this.imgNormal = MySprite.createImageArray(Image.createImage((String)(Game.DATA_PATH + "chicken.png")), this.game.PLAYER_SIZE, this.game.PLAYER_SIZE);
                    this.imgPowerUp = MySprite.createImageArray(Image.createImage((String)(Game.DATA_PATH + "chickenpow.png")), this.game.PLAYER_SIZE, this.game.PLAYER_SIZE);
                    this.sprite = new MySprite(this.imgNormal);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        iw = this.sprite.getWidth() / 10 * 3;
        ih = this.sprite.getHeight() / 10;
        this.sprite.defineCollisionRectangle(iw, ih * 6 + 5, -iw, -ih);
        this.setAnimation((byte)0);
        this.animate = 0;
        this.sprite.setOffset(this.game.x - this.sprite.getWidth() / 2, this.game.y - this.sprite.getHeight());
    }

    public void free() {
        super.free();
        MySprite.freeImageArray(this.imgNormal);
        MySprite.freeImageArray(this.imgStealth);
        MySprite.freeImageArray(this.imgPowerUp);
        this.ptRing = null;
        if (this.blood != null) {
            this.blood.free();
            this.blood = null;
        }
    }

    public void moveto(int ix, int iy) {
        super.moveto(ix, iy);
        this.resetPath();
    }

    public void resetPath() {
        for (int i2 = 0; i2 < 7; ++i2) {
            this.path[i2].x = (short)this.ptWorld.x;
            this.path[i2].y = (short)this.ptWorld.y;
        }
    }

    public void update(Game game, World world) {
        this.inFollowRange = false;
        if (game.popup.isActive) {
            super.update(game, world);
            return;
        }
        if (!game.playscreen.world.player[game.playscreen.world.currplayer].stealth && this.active && this.onscreen && this.health > 0 && !game.playscreen.world.poweredUp && !this.following && this.id != game.playscreen.world.player[game.playscreen.world.currplayer].id && this.ptWorld.getDistance(game.playscreen.world.player[game.playscreen.world.currplayer].ptWorld.x, game.playscreen.world.player[game.playscreen.world.currplayer].ptWorld.y, true) <= game.TILE_SIZE) {
            game.playscreen.world.player[game.playscreen.world.currplayer].specialAction = (byte)4;
            this.inFollowRange = true;
        }
        this.animate = (short)(this.animate + 1);
        if (this.animate > 1) {
            this.animate = 0;
        }
        if (this.poweredUp) {
            if (game.currframe % 2 == 0) {
                switch (this.id) {
                    case 0: {
                        this.sprite.swapImage(this.imgPowerUp);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.sprite.swapImage(this.imgPowerUp);
                    }
                }
            } else {
                switch (this.id) {
                    case 0: {
                        this.sprite.swapImage(this.imgNormal);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.sprite.swapImage(this.imgNormal);
                    }
                }
            }
            if (game.currframe % 2 == 0 && (this.destructionTimer = (short)(this.destructionTimer - 1)) < 0) {
                this.powerDown();
            }
        }
        switch (this.id) {
            case 0: {
                break;
            }
            case 1: {
                if (this.stealth && (this.stealthCounter = (short)(this.stealthCounter + 1)) > game.render.getMaxFramesPerSecond()) {
                    this.stealthCounter = 0;
                }
                if (game.currframe % 2 != 0 || (this.stealthTimer = (short)(this.stealthTimer - 1)) >= 0) break;
                this.stealthTimer = 0;
                break;
            }
        }
        if (this.health <= 0) {
            this.health = 0;
            if (!this.dead) {
                this.moving = false;
                this.healthBarCounter = 0;
                if (game.currmission >= 3) {
                    game.tempNumDeaths = (short)(game.tempNumDeaths + 1);
                }
                this.following = false;
                this.stealthTimer = 0;
                game.playscreen.world.hackingState = 0;
                this.attacking = false;
                if (this.poweredUp) {
                    this.powerDown();
                }
                this.setAnimation((byte)10);
                this.dead = true;
                if (game.playscreen.world.alarmCounter > 1) {
                    game.playscreen.world.alarmCounter = 1;
                }
            }
        }
        if (this.animate == 0) {
            switch (this.mAnimation) {
                case 5: {
                    this.moving = false;
                    this.sprite.nextFrame();
                    if (this.sprite.getFrame() != 0) break;
                    this.setAnimation((byte)0);
                    break;
                }
                case 11: {
                    this.moving = false;
                    this.sprite.nextFrame();
                    if (this.poweredUp || this.sprite.getFrame() != 0) break;
                    this.setAnimation((byte)0);
                    this.attacking = false;
                    if (this.stealthTimer != 0) break;
                    this.stealthTimer = game.sinfo[game.infoSlot].stealthMaxTime;
                }
            }
        }
        super.update(game, world);
    }

    private void startFollow() {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.id == this.game.playscreen.world.player[i2].id || !this.game.playscreen.world.player[i2].inFollowRange) continue;
            this.game.playscreen.world.player[i2].following = true;
        }
    }

    public void doAction() {
        int i2;
        if (this.game.sinfo[this.game.infoSlot].currlevel <= 4 || this.health <= 0 || this.attacking || this.game.playscreen.world.hackingState != 0) {
            return;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            if (!this.game.playscreen.world.player[i2].inFollowRange) continue;
            this.startFollow();
            return;
        }
        if (this.poweredUp) {
            if (this.id != 1) {
                this.startAttack();
            }
            return;
        }
        switch (this.id) {
            case 0: {
                if (this.specialAction == 1) {
                    if (this.mAnimation == 5) break;
                    this.setAnimation((byte)5);
                    break;
                }
                this.startAttack();
                break;
            }
            case 1: {
                if (this.game.playscreen.world.bossmode) break;
                if (this.specialAction == 2) {
                    this.startAttack();
                    break;
                }
                if (this.stealth) {
                    this.stealth = false;
                    this.sprite.swapImage(this.imgNormal);
                    break;
                }
                if (this.stealthTimer != 0) break;
                this.stealth = true;
                this.sprite.swapImage(this.imgStealth);
                this.stealthCounter = 0;
                for (i2 = 0; i2 < 3; ++i2) {
                    this.game.playscreen.world.player[i2].following = false;
                }
                break;
            }
            case 2: {
                if (this.game.playscreen.world.bossmode) break;
                for (i2 = 0; i2 < this.game.playscreen.world.numObjects; ++i2) {
                    if (!this.game.playscreen.world.object[i2].onscreen || this.game.playscreen.world.object[i2].burned || this.game.playscreen.world.object[i2].id != 25 || !this.sprite.collidesWith(this.game.playscreen.world.object[i2].ptScreen.x + this.game.playscreen.world.object[i2].sprite.colx, this.game.playscreen.world.object[i2].ptScreen.y + this.game.playscreen.world.object[i2].sprite.getHeight(), this.game.playscreen.world.object[i2].sprite.getWidth() + this.game.playscreen.world.object[i2].sprite.colw - this.game.playscreen.world.object[i2].sprite.colx, this.game.TILE_SIZE / 2)) continue;
                    this.specialAction = (byte)3;
                    this.game.playscreen.world.ptHackedComputerCell.set(this.game.playscreen.world.object[i2].ptCell.x, this.game.playscreen.world.object[i2].ptCell.y);
                    i2 = this.game.playscreen.world.numObjects - 1;
                    break;
                }
                if (this.specialAction == 3) {
                    this.game.playscreen.world.hackingState = 1;
                    break;
                }
                this.startAttack();
            }
        }
    }

    public void keyPressed(int gameAction) {
        switch (this.game.render.getInput()) {
            case '*': {
                break;
            }
            case '0': {
                this.powerUp();
                return;
            }
        }
        switch (gameAction) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                this.doAction();
            }
        }
    }

    public void powerUp() {
        if (this.health <= 0 || this.attacking || this.poweredUp || this.game.playscreen.world.bossmode) {
            return;
        }
        if (this.game.sinfo[this.game.infoSlot].numPowerUps <= 0) {
            this.game.sinfo[this.game.infoSlot].numPowerUps = 0;
            return;
        }
        this.game.sinfo[this.game.infoSlot].numPowerUps = (short)(this.game.sinfo[this.game.infoSlot].numPowerUps - 1);
        this.poweredUp = true;
        this.destructionTimer = this.game.sinfo[this.game.infoSlot].destructionMaxTime;
        this.game.playscreen.world.poweredUp = true;
        this.game.playscreen.world.powerUpCounter = (short)this.game.render.getMaxFramesPerSecond();
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.id != this.game.playscreen.world.player[i2].id) {
                this.game.playscreen.world.player[i2].following = false;
                this.game.playscreen.world.player[i2].sprite.setFrame(0);
            }
            this.game.playscreen.world.player[i2].resetPath();
        }
        switch (this.id) {
            case 0: {
                break;
            }
            case 1: {
                if (this.stealth) {
                    this.stealth = false;
                    this.sprite.swapImage(this.imgNormal);
                }
                this.setAnimation((byte)11);
                break;
            }
        }
    }

    public void powerDown() {
        this.game.playscreen.world.poweredUp = false;
        if (this.game.playscreen.world.completeCounter == 0) {
            // empty if block
        }
        this.poweredUp = false;
        this.destructionTimer = 0;
        switch (this.id) {
            case 0: {
                this.sprite.swapImage(this.imgNormal);
                break;
            }
            case 1: {
                this.setAnimation((byte)0);
                if (this.game.playscreen.world.completeCounter != 0) break;
                this.stealthTimer = this.game.sinfo[this.game.infoSlot].stealthMaxTime;
                break;
            }
            case 2: {
                this.sprite.swapImage(this.imgNormal);
            }
        }
    }

    public void control(World world) {
        int i2;
        this.specialAction = 0;
        this.moving = false;
        if (this.game.popup.isActive || this.health <= 0 || this.mAnimation == 5 || this.game.playscreen.world.hackingState != 0 || this.mAnimation == 11 && !this.poweredUp) {
            return;
        }
        block0 : switch (this.id) {
            case 0: {
                if (!this.attacking) break;
                if (this.sprite.getFrame() < this.sprite.getFrameSequenceLength() - 1) {
                    this.sprite.nextFrame();
                }
                if ((this.shotDelayCounter = (byte)(this.shotDelayCounter + 1)) <= this.shotDelay) break;
                this.stopAttack();
                if (!this.game.render.keySpace) break;
                this.startAttack();
                break;
            }
            case 1: {
                if (!this.stealth || this.game.sinfo[this.game.infoSlot].currlevel < 8) break;
                for (i2 = 0; i2 < this.game.playscreen.world.numGuards; ++i2) {
                    int dist;
                    if (!this.game.playscreen.world.guard[i2].onscreen || this.game.playscreen.world.guard[i2].state != 0 || (dist = this.ptWorld.getDistance(this.game.playscreen.world.guard[i2].ptWorld.x, this.game.playscreen.world.guard[i2].ptWorld.y, true)) >= this.game.TILE_SIZE / 2 * 3) continue;
                    this.targetIndex = (short)i2;
                    this.specialAction = (byte)2;
                    break block0;
                }
                break;
            }
            case 2: {
                if (!this.attacking || (this.shotDelayCounter = (byte)(this.shotDelayCounter + 1)) <= this.shotDelay) break;
                this.stopAttack();
            }
        }
        if (!this.attacking) {
            int speed = this.RUN_SPEED;
            if (this.id == 1) {
                if (this.stealth) {
                    --speed;
                } else if (this.poweredUp) {
                    speed -= 2;
                }
            }
            if (this.game.render.keyLeft) {
                this.moving = true;
                if (this.mAnimation != 11) {
                    this.setAnimation((byte)1);
                    if (this.animate == 0) {
                        this.sprite.nextFrame();
                    }
                }
                world.collide(this, -speed, 0);
            } else if (this.game.render.keyRight) {
                this.moving = true;
                if (this.mAnimation != 11) {
                    this.setAnimation((byte)2);
                    if (this.animate == 0) {
                        this.sprite.nextFrame();
                    }
                }
                world.collide(this, speed, 0);
            }
            if (this.game.render.keyUp) {
                world.collide(this, 0, -speed);
                if (!this.moving && this.mAnimation != 11) {
                    this.setAnimation((byte)3);
                    if (this.animate == 0) {
                        this.sprite.nextFrame();
                    }
                }
                this.moving = true;
            } else if (this.game.render.keyDown) {
                world.collide(this, 0, speed);
                if (!this.moving && this.mAnimation != 11) {
                    this.setAnimation((byte)4);
                    if (this.animate == 0) {
                        this.sprite.nextFrame();
                    }
                }
                this.moving = true;
            }
        }
        if (!this.moving) {
            if (!this.attacking && this.mAnimation != 11) {
                this.sprite.setFrame(0);
            }
        } else {
            for (i2 = 0; i2 < 6; ++i2) {
                this.path[i2].x = this.path[i2 + 1].x;
                this.path[i2].y = this.path[i2 + 1].y;
            }
            this.path[6].x = (short)this.ptWorld.x;
            this.path[6].y = (short)this.ptWorld.y;
        }
    }

    public void draw(Graphics g) {
        int y2;
        int x2;
        if (!this.onscreen || !this.active) {
            return;
        }
        switch (this.specialAction) {
            case 2: {
                x2 = this.ptScreen.x + this.sprite.getWidth() / 2 - this.game.playscreen.world.sprReaction.getWidth() / 2;
                y2 = this.ptScreen.y - this.game.playscreen.world.sprReaction.getHeight() / 10 * 9;
                this.game.playscreen.world.sprReaction.setFrame(3);
                this.game.playscreen.world.sprReaction.setPosition(x2, y2);
                this.game.playscreen.world.sprReaction.paint(g);
            }
        }
        if (this.inFollowRange) {
            x2 = this.ptScreen.x + this.sprite.getWidth() / 2 - this.game.playscreen.world.sprReaction.getWidth() / 2;
            y2 = this.ptScreen.y - this.game.playscreen.world.sprReaction.getHeight() / 10 * 9;
            this.game.playscreen.world.sprReaction.setFrame(5);
            this.game.playscreen.world.sprReaction.setPosition(x2, y2);
            this.game.playscreen.world.sprReaction.paint(g);
        }
        if (this.healthBarCounter > 0) {
            this.healthBarCounter = (short)(this.healthBarCounter - 1);
            int barH = this.sprite.getHeight() / 6;
            Utils.drawProgress(g, this.sprite.getX() + this.sprite.getXOffset(), this.sprite.getY() - this.sprite.getHeight() - barH, this.sprite.getWidth(), barH, this.health, this.game.sinfo[this.game.infoSlot].maxHealth, MyColor.BLACK, MyColor.RED, MyColor.WHITE);
        }
        super.draw(g);
    }

    public void reset() {
        this.healthBarCounter = 0;
        this.poweredUp = false;
        this.destructionTimer = 0;
        this.destructionTimer = 0;
        this.inFollowRange = false;
        this.following = false;
        this.poweredUp = false;
        this.shockedGuard = (short)-1;
        this.attacking = false;
        this.stealth = false;
        this.sprite.swapImage(this.imgNormal);
        this.dead = false;
        this.active = false;
        this.stealthTimer = 0;
        this.setAnimation((byte)0);
        this.health = this.game.sinfo[this.game.infoSlot].maxHealth;
        this.blood.reset();
    }

    public void setAnimation(byte newAnimation) {
        if (newAnimation == this.mAnimation) {
            return;
        }
        this.sprite.setFrame(0);
        this.ptRing.x = 0;
        this.ptRing.y = 0;
        switch (newAnimation) {
            case 0: {
                this.direction = 1;
                this.sprite.setFrameSequence(FRAMES_STAND);
                switch (this.id) {
                    case 0: {
                        this.ptRing.y = -(this.sprite.getHeight() / 8);
                    }
                }
                break;
            }
            case 1: {
                this.direction = (byte)2;
                this.sprite.setFrameSequence(FRAMES_RUNLEFT);
                switch (this.id) {
                    case 0: {
                        this.ptRing.x = this.sprite.getWidth() / 5;
                    }
                }
                break;
            }
            case 2: {
                this.direction = (byte)3;
                this.sprite.setFrameSequence(FRAMES_RUNRIGHT);
                switch (this.id) {
                    case 0: {
                        this.ptRing.x = -(this.sprite.getWidth() / 5);
                    }
                }
                break;
            }
            case 3: {
                this.direction = 0;
                this.sprite.setFrameSequence(FRAMES_RUNUP);
                break;
            }
            case 4: {
                this.direction = 1;
                this.sprite.setFrameSequence(FRAMES_RUNDOWN);
                switch (this.id) {
                    case 0: {
                        this.ptRing.y = -(this.sprite.getHeight() / 8);
                    }
                }
                break;
            }
            case 5: {
                this.sprite.setFrameSequence(FRAMES_DIG);
                this.ptRing.y = -(this.sprite.getHeight() / 8);
                break;
            }
            case 11: {
                this.sprite.setFrameSequence(FRAMES_CATFIGHT);
                this.ptRing.y = -(this.sprite.getHeight() / 8);
                break;
            }
            case 10: {
                this.sprite.setFrameSequence(FRAMES_DEATH);
                this.ptRing.y = -(this.sprite.getHeight() / 8);
                break;
            }
            case 6: {
                this.direction = 1;
                this.sprite.setFrameSequence(FRAMES_FIRE_DOWN);
                this.ptRing.y = -(this.sprite.getHeight() / 8);
                break;
            }
            case 7: {
                this.direction = 0;
                this.sprite.setFrameSequence(FRAMES_FIRE_UP);
                break;
            }
            case 8: {
                this.direction = (byte)2;
                this.sprite.setFrameSequence(FRAMES_FIRE_LEFT);
                this.ptRing.x = this.sprite.getWidth() / 5;
                break;
            }
            case 9: {
                this.direction = (byte)3;
                this.sprite.setFrameSequence(FRAMES_FIRE_RIGHT);
                this.ptRing.x = -(this.sprite.getWidth() / 5);
                break;
            }
            case 12: {
                this.direction = 1;
                this.sprite.setFrameSequence(FRAMES_STUN_DOWN);
                break;
            }
            case 13: {
                this.direction = 0;
                this.sprite.setFrameSequence(FRAMES_STUN_UP);
                break;
            }
            case 14: {
                this.direction = (byte)2;
                this.sprite.setFrameSequence(FRAMES_STUN_LEFT);
                break;
            }
            case 15: {
                this.direction = (byte)3;
                this.sprite.setFrameSequence(FRAMES_STUN_RIGHT);
            }
        }
        this.mAnimation = newAnimation;
    }

    private void shootBoss(int midY, int range) {
        if (this.game.playscreen.world.boss.shieldTimer == 0) {
            return;
        }
        if (this.game.playscreen.world.boss.onscreen && this.game.playscreen.world.boss.state != 0 && (this.direction == 3 && this.game.playscreen.world.boss.ptWorld.x >= this.ptWorld.x || this.direction == 2 && this.game.playscreen.world.boss.ptWorld.x <= this.ptWorld.x || this.direction == 0 && this.game.playscreen.world.boss.ptWorld.y <= this.ptWorld.y || this.direction == 1 && this.game.playscreen.world.boss.ptWorld.y >= this.ptWorld.y)) {
            boolean inLineOfFire = false;
            switch (this.direction) {
                case 2: 
                case 3: {
                    if ((midY - range > this.game.playscreen.world.boss.ptWorld.y || midY - range < this.game.playscreen.world.boss.ptWorld.y - this.game.playscreen.world.boss.sprite.getHeight()) && (midY + range < this.game.playscreen.world.boss.ptWorld.y - this.game.playscreen.world.boss.sprite.getHeight() || midY + range > this.game.playscreen.world.boss.ptWorld.y)) break;
                    inLineOfFire = true;
                    break;
                }
                case 0: 
                case 1: {
                    if ((this.ptWorld.x - range > this.game.playscreen.world.boss.ptWorld.x + this.game.playscreen.world.boss.sprite.getWidth() / 2 || this.ptWorld.x - range < this.game.playscreen.world.boss.ptWorld.x - this.game.playscreen.world.boss.sprite.getWidth() / 2) && (this.ptWorld.x + range < this.game.playscreen.world.boss.ptWorld.x - this.game.playscreen.world.boss.sprite.getWidth() / 2 || this.ptWorld.x + range > this.game.playscreen.world.boss.ptWorld.x + this.game.playscreen.world.boss.sprite.getWidth() / 2)) break;
                    inLineOfFire = true;
                }
            }
            if (inLineOfFire && this.game.playscreen.world.isInLineOfSight(this, this.game.playscreen.world.boss, null)) {
                this.game.playscreen.world.boss.health = (short)(this.game.playscreen.world.boss.health - this.game.sinfo[this.game.infoSlot].shotgunDamage);
                this.game.playscreen.world.boss.blood.startDrop(this.game.playscreen.world.boss.ptWorld, this.game.TILE_SIZE / 6, this.game);
                this.game.playscreen.world.splat.startDrop(this.game.playscreen.world.boss.ptWorld.x, this.game.playscreen.world.boss.ptWorld.y - this.game.playscreen.world.boss.sprite.getHeight() / 2, this.game.TILE_SIZE / 6, this.game);
            }
        }
    }

    private void shootWorldObject(int midY, int range) {
        for (int w = 0; w < this.game.playscreen.world.numObjects; ++w) {
            if (this.game.playscreen.world.object[w].id != 23 && this.game.playscreen.world.object[w].id != 1 && this.game.playscreen.world.object[w].id != 50 || this.game.playscreen.world.object[w].burned || !this.game.playscreen.world.object[w].onscreen || !(this.direction == 3 && this.game.playscreen.world.object[w].ptWorld.x + this.game.playscreen.world.object[w].sprite.getWidth() >= this.ptWorld.x || this.direction == 2 && this.game.playscreen.world.object[w].ptWorld.x <= this.ptWorld.x || this.direction == 0 && this.game.playscreen.world.object[w].ptWorld.y <= this.ptWorld.y) && (this.direction != 1 || this.game.playscreen.world.object[w].ptWorld.y < this.ptWorld.y)) continue;
            Object o = new Object(this.game.playscreen.world.object[w]);
            o.ptWorld.set(o.ptWorld.x + o.sprite.getWidth() / 2, o.ptWorld.y);
            if (this.game.playscreen.world.isInLineOfSight(this, o, this.game.playscreen.world.object[w])) {
                switch (this.direction) {
                    case 2: 
                    case 3: {
                        if ((midY - range > this.game.playscreen.world.object[w].ptWorld.y || midY - range < this.game.playscreen.world.object[w].ptWorld.y - this.game.playscreen.world.object[w].sprite.getHeight()) && (midY + range < this.game.playscreen.world.object[w].ptWorld.y - this.game.playscreen.world.object[w].sprite.getHeight() || midY + range > this.game.playscreen.world.object[w].ptWorld.y)) break;
                        this.game.playscreen.world.burnObject(this.game.playscreen.world.object[w]);
                        break;
                    }
                    case 0: 
                    case 1: {
                        if ((this.ptWorld.x - range > this.game.playscreen.world.object[w].ptWorld.x + this.game.playscreen.world.object[w].sprite.getWidth() || this.ptWorld.x - range < this.game.playscreen.world.object[w].ptWorld.x) && (this.ptWorld.x + range < this.game.playscreen.world.object[w].ptWorld.x || this.ptWorld.x + range > this.game.playscreen.world.object[w].ptWorld.x + this.game.playscreen.world.object[w].sprite.getWidth())) break;
                        this.game.playscreen.world.burnObject(this.game.playscreen.world.object[w]);
                    }
                }
            }
            o.free();
            o = null;
        }
    }

    private void shootGuard(int midY, int range) {
        for (int i2 = 0; i2 < this.game.playscreen.world.numGuards; ++i2) {
            if (!this.game.playscreen.world.guard[i2].onscreen || this.game.playscreen.world.guard[i2].state == 6) continue;
            int dist = this.ptWorld.getDistance(this.game.playscreen.world.guard[i2].ptWorld.x, this.game.playscreen.world.guard[i2].ptWorld.y, true);
            if (this.direction == 3 && this.game.playscreen.world.guard[i2].ptWorld.x >= this.ptWorld.x || this.direction == 2 && this.game.playscreen.world.guard[i2].ptWorld.x <= this.ptWorld.x || this.direction == 0 && this.game.playscreen.world.guard[i2].ptWorld.y <= this.ptWorld.y || this.direction == 1 && this.game.playscreen.world.guard[i2].ptWorld.y >= this.ptWorld.y) {
                boolean inLineOfFire = false;
                switch (this.direction) {
                    case 2: 
                    case 3: {
                        if ((midY - range > this.game.playscreen.world.guard[i2].ptWorld.y || midY - range < this.game.playscreen.world.guard[i2].ptWorld.y - this.game.playscreen.world.guard[i2].sprite.getHeight()) && (midY + range < this.game.playscreen.world.guard[i2].ptWorld.y - this.game.playscreen.world.guard[i2].sprite.getHeight() || midY + range > this.game.playscreen.world.guard[i2].ptWorld.y)) break;
                        inLineOfFire = true;
                        break;
                    }
                    case 0: 
                    case 1: {
                        if ((this.ptWorld.x - range > this.game.playscreen.world.guard[i2].ptWorld.x + this.game.playscreen.world.guard[i2].sprite.getWidth() / 2 || this.ptWorld.x - range < this.game.playscreen.world.guard[i2].ptWorld.x - this.game.playscreen.world.guard[i2].sprite.getWidth() / 2) && (this.ptWorld.x + range < this.game.playscreen.world.guard[i2].ptWorld.x - this.game.playscreen.world.guard[i2].sprite.getWidth() / 2 || this.ptWorld.x + range > this.game.playscreen.world.guard[i2].ptWorld.x + this.game.playscreen.world.guard[i2].sprite.getWidth() / 2)) break;
                        inLineOfFire = true;
                    }
                }
                if (inLineOfFire && this.game.playscreen.world.isInLineOfSight(this, this.game.playscreen.world.guard[i2], null)) {
                    this.game.playscreen.world.guard[i2].health = dist < this.game.TILE_SIZE * 2 ? (short)(this.game.playscreen.world.guard[i2].health - (this.game.sinfo[this.game.infoSlot].shotgunDamage + 15)) : (short)(this.game.playscreen.world.guard[i2].health - this.game.sinfo[this.game.infoSlot].shotgunDamage);
                    this.game.playscreen.world.guard[i2].healthBarCounter = (short)50;
                    this.game.playscreen.world.guard[i2].blood.startDrop(this.game.playscreen.world.guard[i2].ptWorld, this.game.TILE_SIZE / 6, this.game);
                    this.game.playscreen.world.splat.startDrop(this.game.playscreen.world.guard[i2].ptWorld.x, this.game.playscreen.world.guard[i2].ptWorld.y - this.game.playscreen.world.guard[i2].sprite.getHeight() / 2, this.game.TILE_SIZE / 6, this.game);
                    if (this.game.playscreen.world.guard[i2].state != 9 && this.game.playscreen.world.guard[i2].state != 2 && this.game.playscreen.world.guard[i2].state != 1) {
                        this.game.playscreen.world.guard[i2].startAlert(this.id);
                    } else if (this.game.playscreen.world.guard[i2].state == 2) {
                        this.game.playscreen.world.guard[i2].targetID = this.id;
                    }
                }
            }
            if (!this.game.playscreen.world.guard[i2].onscreen || this.game.playscreen.world.guard[i2].state == 9 || this.game.playscreen.world.guard[i2].state == 2 || this.game.playscreen.world.guard[i2].state == 1 || dist >= this.game.TILE_SIZE * 7) continue;
            this.game.playscreen.world.guard[i2].startAlert(this.id);
        }
    }

    public void startAttack() {
        if (this.attacking) {
            return;
        }
        block0 : switch (this.id) {
            case 0: {
                if (!this.game.playscreen.world.bossmode && !this.poweredUp && this.game.sinfo[this.game.infoSlot].numBullets == 0) {
                    this.shotDelayCounter = 0;
                    return;
                }
                this.attacking = true;
                this.shotDelayCounter = 0;
                if (!this.poweredUp && !this.game.playscreen.world.bossmode) {
                    this.game.sinfo[this.game.infoSlot].numBullets = (short)(this.game.sinfo[this.game.infoSlot].numBullets - 1);
                    if (this.game.sinfo[this.game.infoSlot].numBullets < 0) {
                        this.game.sinfo[this.game.infoSlot].numBullets = 0;
                    }
                }
                if (this.poweredUp) {
                    this.game.playscreen.world.startRocket(this.ptWorld, this.direction);
                    for (int i2 = 0; i2 < this.game.playscreen.world.numGuards; ++i2) {
                        if (!this.game.playscreen.world.guard[i2].onscreen || this.game.playscreen.world.guard[i2].state == 6) continue;
                        int dist = this.ptWorld.getDistance(this.game.playscreen.world.guard[i2].ptWorld.x, this.game.playscreen.world.guard[i2].ptWorld.y, true);
                        if (this.game.playscreen.world.guard[i2].state == 9 || this.game.playscreen.world.guard[i2].state == 2 || this.game.playscreen.world.guard[i2].state == 1 || dist >= this.game.TILE_SIZE * 8) continue;
                        this.game.playscreen.world.guard[i2].startAlert(this.id);
                    }
                } else {
                    int range = 0;
                    int midY = this.ptWorld.y - this.sprite.getHeight() / 2;
                    if (this.game.playscreen.world.bossmode) {
                        this.shootBoss(midY, range);
                    } else {
                        this.shootGuard(midY, range);
                        this.shootWorldObject(midY, range);
                    }
                }
                switch (this.mAnimation) {
                    case 3: {
                        this.setAnimation((byte)7);
                        this.sprite.setFrame(0);
                        break;
                    }
                    case 1: {
                        this.setAnimation((byte)8);
                        this.sprite.setFrame(0);
                        break;
                    }
                    case 2: {
                        this.setAnimation((byte)9);
                        this.sprite.setFrame(0);
                        break;
                    }
                    case 0: 
                    case 4: {
                        this.setAnimation((byte)6);
                        this.sprite.setFrame(0);
                    }
                }
                break;
            }
            case 1: {
                if (this.specialAction == 2) {
                    this.specialAction = 0;
                    this.stealth = false;
                    this.sprite.swapImage(this.imgNormal);
                    this.game.playscreen.world.guard[this.targetIndex].targetID = this.id;
                    this.game.playscreen.world.guard[this.targetIndex].helpCall();
                    this.game.playscreen.world.guard[this.targetIndex].blood.startDrop(this.game.playscreen.world.guard[this.targetIndex].ptWorld, this.game.TILE_SIZE / 6, this.game);
                    this.game.playscreen.world.guard[this.targetIndex].health = 0;
                    this.game.sinfo[this.game.infoSlot].stealthKills = (short)(this.game.sinfo[this.game.infoSlot].stealthKills + 1);
                    this.setAnimation((byte)11);
                    this.attacking = true;
                }
                return;
            }
            case 2: {
                this.attacking = true;
                this.shotDelayCounter = 0;
                switch (this.mAnimation) {
                    case 3: {
                        this.setAnimation((byte)13);
                        this.sprite.setFrame(0);
                        break;
                    }
                    case 1: {
                        this.setAnimation((byte)14);
                        this.sprite.setFrame(0);
                        break;
                    }
                    case 2: {
                        this.setAnimation((byte)15);
                        this.sprite.setFrame(0);
                        break;
                    }
                    case 0: 
                    case 4: {
                        this.setAnimation((byte)12);
                        this.sprite.setFrame(0);
                    }
                }
                if (this.shockedGuard >= 0) break;
                for (int i3 = 0; i3 < this.game.playscreen.world.numGuards; ++i3) {
                    if (!this.game.playscreen.world.guard[i3].onscreen || this.game.playscreen.world.guard[i3].state == 6 || this.game.playscreen.world.guard[i3].state == 7) continue;
                    int dist = this.ptWorld.getDistance(this.game.playscreen.world.guard[i3].ptWorld.x, this.game.playscreen.world.guard[i3].ptWorld.y, true);
                    if (!(this.direction == 3 && this.game.playscreen.world.guard[i3].ptWorld.x >= this.ptWorld.x || this.direction == 2 && this.game.playscreen.world.guard[i3].ptWorld.x <= this.ptWorld.x || this.direction == 0 && this.game.playscreen.world.guard[i3].ptWorld.y <= this.ptWorld.y) && (this.direction != 1 || this.game.playscreen.world.guard[i3].ptWorld.y < this.ptWorld.y) || dist >= this.game.TILE_SIZE * 2 || !this.game.playscreen.world.isInLineOfSight(this, this.game.playscreen.world.guard[i3], null)) continue;
                    this.shockedGuard = (short)i3;
                    this.game.playscreen.world.guard[i3].shocked = true;
                    if (this.poweredUp) {
                        this.game.playscreen.world.guard[i3].explode = true;
                    } else {
                        this.game.playscreen.world.guard[i3].health = (short)(this.game.playscreen.world.guard[i3].health - this.game.sinfo[this.game.infoSlot].taserDamage);
                        if (this.game.playscreen.world.guard[i3].health <= 0) {
                            this.game.sinfo[this.game.infoSlot].taserKills = (short)(this.game.sinfo[this.game.infoSlot].taserKills + 1);
                        }
                        this.game.playscreen.world.guard[i3].healthBarCounter = (short)100;
                    }
                    i3 = this.game.playscreen.world.numGuards - 1;
                    break block0;
                }
                break;
            }
        }
    }

    public void stopAttack() {
        this.attacking = false;
        switch (this.id) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.shockedGuard <= -1) break;
                if (!this.game.playscreen.world.guard[this.shockedGuard].explode) {
                    this.game.playscreen.world.guard[this.shockedGuard].shocked = false;
                    this.game.playscreen.world.guard[this.shockedGuard].state = (byte)7;
                }
                this.game.playscreen.world.guard[this.shockedGuard].counter = 0;
                this.game.playscreen.world.guard[this.shockedGuard].targetID = this.id;
                this.shockedGuard = (short)-1;
            }
        }
        switch (this.mAnimation) {
            case 7: 
            case 13: {
                this.setAnimation((byte)3);
                this.sprite.setFrame(0);
                break;
            }
            case 8: 
            case 14: {
                this.setAnimation((byte)1);
                this.sprite.setFrame(0);
                break;
            }
            case 9: 
            case 15: {
                this.setAnimation((byte)2);
                this.sprite.setFrame(0);
                break;
            }
            case 6: 
            case 12: {
                this.setAnimation((byte)0);
                this.sprite.setFrame(0);
            }
        }
    }

    public boolean follow(MyPoint p, int speed, boolean nextFrame) {
        this.moving = false;
        if (p.x < this.ptWorld.x) {
            this.moving = true;
            this.ptWorld.x = this.ptWorld.x - p.x < speed ? (int)((short)p.x) : (this.ptWorld.x -= speed);
            this.setAnimation((byte)1);
        } else if (p.x > this.ptWorld.x) {
            this.moving = true;
            this.ptWorld.x = p.x - this.ptWorld.x < speed ? (int)((short)p.x) : (this.ptWorld.x += speed);
            this.setAnimation((byte)2);
        }
        if (p.y < this.ptWorld.y) {
            this.ptWorld.y = this.ptWorld.y - p.y < speed ? (int)((short)p.y) : (this.ptWorld.y -= speed);
            if (!this.moving) {
                this.setAnimation((byte)3);
            }
        } else if (p.y > this.ptWorld.y) {
            this.ptWorld.y = p.y - this.ptWorld.y < speed ? (int)((short)p.y) : (this.ptWorld.y += speed);
            if (!this.moving) {
                this.setAnimation((byte)4);
            }
        }
        if (nextFrame && this.animate == 0) {
            this.sprite.nextFrame();
        }
        if (this.ptWorld.getDistance(p.x, p.y, true) <= speed) {
            this.ptWorld.set(p.x, p.y);
            return true;
        }
        if (!nextFrame && this.animate == 0) {
            this.sprite.nextFrame();
        }
        return false;
    }

    class PATH {
        short x;
        short y;
        short frame;
        byte animation;

        PATH() {
        }
    }
}

