/*
 * Decompiled with CFR 0.152.
 */
import com.dvidearts.jengine.MyPoint;
import com.dvidearts.jengine.MySprite;
import com.dvidearts.jengine.Utils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Boss
extends Object {
    Game game;
    private byte mAnimation;
    private byte damage;
    public short animate;
    public short health;
    public short maxhealth;
    public short shotDelayCounter;
    public short shotDelay;
    public short shieldTimer;
    public short numPressurePressed;
    public short shieldDownTime;
    public boolean dead;
    public Blood blood;
    public MyPoint ptStart;
    public MyPoint ptTarget;
    public byte id;
    public byte state;
    public byte direction;
    public byte targetID;
    private short counter;
    private short points;
    private short handTimer;
    private short speed;
    private short attackCounter;
    private short targetTime;
    private short startAttackX1;
    private short startAttackX2;
    public Image imgCrosshair;
    public static final byte PISTOL_DELAY = 15;
    public static final byte SHOTGUN_DELAY = 18;
    public static final byte MGUN_DELAY = 2;
    public static final short SHOW_HEALTH_TIME = 60;
    public static final byte WALK_SPEED = 4;
    public static final byte MAX_PRESSURE = 2;
    public static final short RESTTIME = 40;
    public static final short MIN_ATTACK_TIME = 100;
    public static final byte STATE_DEAD = 0;
    public static final byte STATE_RESTING = 1;
    public static final byte STATE_TARGETING = 2;
    public static final byte STATE_ATTACK = 3;
    public static final byte ANIM_STAND = 0;
    public static final byte ANIM_RUNLEFT = 1;
    public static final byte ANIM_RUNRIGHT = 2;
    public static final byte ANIM_RUNUP = 3;
    public static final byte ANIM_RUNDOWN = 4;
    public static final byte ANIM_TARGETING = 5;
    public static final short[] FRAMES_STAND = new short[]{0};
    private short[] FRAMES_RUNRIGHT = null;
    private short[] FRAMES_RUNLEFT = null;
    private short[] FRAMES_RUNUP = null;
    private short[] FRAMES_RUNDOWN = null;
    private short[] FRAMES_TARGETING = null;

    public Boss(Game g, byte ID, int x2, int y2) {
        this.game = g;
        this.id = ID;
        this.targetID = 0;
        this.targetTime = (short)80;
        this.shieldDownTime = (short)200;
        this.reset();
        this.ptStart = new MyPoint();
        this.ptStart.set(x2, y2);
        this.ptTarget = new MyPoint();
        this.numPressurePressed = 0;
        this.blood = new Blood(30);
        this.game.sprShield.setOffset(0, 0);
        try {
            int ih;
            int iw;
            this.imgCrosshair = Image.createImage((String)(Game.DATA_PATH + "crosshair.png"));
            switch (this.id) {
                case 1: {
                    this.FRAMES_RUNRIGHT = new short[4];
                    this.FRAMES_RUNRIGHT[0] = 1;
                    this.FRAMES_RUNRIGHT[1] = 2;
                    this.FRAMES_RUNRIGHT[2] = 1;
                    this.FRAMES_RUNRIGHT[3] = 3;
                    this.FRAMES_RUNLEFT = this.FRAMES_RUNRIGHT;
                    this.FRAMES_RUNDOWN = this.FRAMES_RUNRIGHT;
                    this.FRAMES_RUNUP = this.FRAMES_RUNDOWN;
                    this.speed = (short)(this.game.TILE_SIZE / 8);
                    this.damage = (byte)4;
                    this.points = (short)5000;
                    this.shotDelay = (short)15;
                    this.maxhealth = (short)600;
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "chinchan.png")), this.game.CHINCHANW, this.game.CHINCHANH);
                    break;
                }
                case 2: {
                    this.FRAMES_RUNDOWN = new short[1];
                    this.FRAMES_RUNDOWN[0] = 1;
                    this.FRAMES_RUNLEFT = FRAMES_STAND;
                    this.FRAMES_RUNRIGHT = FRAMES_STAND;
                    this.FRAMES_RUNUP = this.FRAMES_RUNRIGHT;
                    this.speed = (short)(this.game.TILE_SIZE / 5);
                    this.damage = 1;
                    this.points = (short)6000;
                    this.shotDelay = (short)15;
                    this.maxhealth = (short)750;
                    this.targetTime = (short)100;
                    this.shieldDownTime = (short)250;
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "pengowin.png")), this.game.PENGOWINW, this.game.PENGOWINH);
                    break;
                }
                case 3: {
                    this.FRAMES_RUNLEFT = new short[1];
                    this.FRAMES_RUNLEFT[0] = 2;
                    this.FRAMES_RUNRIGHT = new short[1];
                    this.FRAMES_RUNRIGHT[0] = 3;
                    this.FRAMES_RUNDOWN = new short[2];
                    this.FRAMES_RUNDOWN[0] = 0;
                    this.FRAMES_RUNDOWN[1] = 1;
                    this.FRAMES_RUNUP = FRAMES_STAND;
                    this.speed = (short)(this.game.TILE_SIZE / 4);
                    this.damage = (byte)2;
                    this.points = (short)6000;
                    this.shotDelay = (short)15;
                    this.maxhealth = (short)900;
                    this.targetTime = (short)100;
                    this.shieldDownTime = (short)200;
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "kangarooboss.png")), this.game.KANGAROOW, this.game.KANGAROOH);
                    break;
                }
                case 4: {
                    this.FRAMES_RUNRIGHT = new short[4];
                    this.FRAMES_RUNRIGHT[0] = 1;
                    this.FRAMES_RUNRIGHT[1] = 2;
                    this.FRAMES_RUNRIGHT[2] = 3;
                    this.FRAMES_RUNRIGHT[3] = 4;
                    this.FRAMES_RUNLEFT = this.FRAMES_RUNRIGHT;
                    this.FRAMES_RUNDOWN = this.FRAMES_RUNRIGHT;
                    this.FRAMES_RUNUP = this.FRAMES_RUNDOWN;
                    this.speed = (short)(this.game.TILE_SIZE / 10);
                    this.damage = (byte)3;
                    this.points = (short)7000;
                    this.shotDelay = (short)15;
                    this.maxhealth = (short)1100;
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "madcow.png")), this.game.MADCOWW, this.game.MADCOWH);
                    break;
                }
                case 5: {
                    this.FRAMES_RUNRIGHT = new short[2];
                    this.FRAMES_RUNRIGHT[0] = 2;
                    this.FRAMES_RUNRIGHT[1] = 3;
                    this.FRAMES_RUNLEFT = new short[1];
                    this.FRAMES_RUNLEFT[0] = 1;
                    this.FRAMES_RUNDOWN = FRAMES_STAND;
                    this.FRAMES_RUNUP = FRAMES_STAND;
                    this.speed = (short)(this.game.TILE_SIZE / 10);
                    this.damage = (byte)2;
                    this.points = (short)8000;
                    this.shotDelay = (short)15;
                    this.shieldDownTime = (short)270;
                    this.maxhealth = (short)1200;
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "borisbear.png")), this.game.BORISBEARW, this.game.BORISBEARH);
                    break;
                }
                case 6: {
                    this.FRAMES_RUNRIGHT = new short[1];
                    this.FRAMES_RUNRIGHT[0] = 2;
                    this.FRAMES_RUNDOWN = new short[2];
                    this.FRAMES_RUNDOWN[0] = 1;
                    this.FRAMES_RUNDOWN[1] = 2;
                    this.FRAMES_RUNLEFT = FRAMES_STAND;
                    this.FRAMES_RUNUP = FRAMES_STAND;
                    this.speed = (short)(this.game.TILE_SIZE / 5);
                    this.damage = (byte)4;
                    this.points = (short)9000;
                    this.shotDelay = (short)15;
                    this.maxhealth = (short)1300;
                    this.targetTime = (short)100;
                    this.shieldDownTime = (short)200;
                    this.game.sprShield.setOffset(0, -this.game.TILE_SIZE);
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "zulumonkey.png")), this.game.ZULUMONKEYW, this.game.ZULUMONKEYH);
                    iw = this.sprite.getWidth() / 10 * 4;
                    ih = this.sprite.getHeight() / 10;
                    this.sprite.defineCollisionRectangle(iw, ih * 4, -iw, -ih * 4);
                    this.sprite.setOffset(this.game.x - this.sprite.getWidth() / 2, this.game.y + -this.sprite.getHeight() / 10 * 8);
                    break;
                }
                case 7: {
                    this.FRAMES_RUNRIGHT = new short[4];
                    this.FRAMES_RUNRIGHT[0] = 2;
                    this.FRAMES_RUNRIGHT[1] = 3;
                    this.FRAMES_RUNRIGHT[2] = 4;
                    this.FRAMES_RUNRIGHT[3] = 5;
                    this.FRAMES_TARGETING = new short[1];
                    this.FRAMES_TARGETING[0] = 1;
                    this.FRAMES_RUNLEFT = this.FRAMES_RUNRIGHT;
                    this.FRAMES_RUNDOWN = this.FRAMES_RUNRIGHT;
                    this.FRAMES_RUNUP = this.FRAMES_RUNDOWN;
                    this.speed = (short)(this.game.TILE_SIZE / 7);
                    this.damage = (byte)8;
                    this.points = (short)10000;
                    this.shotDelay = (short)15;
                    this.maxhealth = (short)2000;
                    this.shieldDownTime = (short)170;
                    this.sprite = new MySprite(Image.createImage((String)(Game.DATA_PATH + "bincamel.png")), this.game.BINCAMELW, this.game.BINCAMELH);
                }
            }
            this.sortOffset = (short)(this.sprite.getHeight() / 3);
            if (this.id != 6) {
                iw = this.sprite.getWidth() / 10 * 4;
                ih = this.sprite.getHeight() / 10;
                this.sprite.setOffset(this.game.x - this.sprite.getWidth() / 2, this.game.y - this.sprite.getHeight());
                this.sprite.defineCollisionRectangle(iw, ih * 8, -iw, -ih);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setAnimation((byte)0);
        this.moveto(this.ptStart);
        this.health = this.maxhealth;
        this.startRest();
    }

    public void reset() {
        this.setAnimation((byte)0);
        this.health = this.maxhealth;
        this.animate = 0;
        this.counter = 0;
        this.dead = false;
        this.mAnimation = (byte)-1;
        this.shotDelayCounter = 0;
        this.state = 1;
        this.active = true;
        this.shieldTimer = 0;
    }

    public void free() {
        super.free();
        this.imgCrosshair = null;
        this.ptTarget = null;
        this.ptStart = null;
        if (this.blood != null) {
            this.blood.free();
            this.blood = null;
        }
        if (this.FRAMES_RUNRIGHT != null) {
            this.FRAMES_RUNRIGHT = null;
        }
        if (this.FRAMES_RUNLEFT != null) {
            this.FRAMES_RUNLEFT = null;
        }
        if (this.FRAMES_RUNUP != null) {
            this.FRAMES_RUNUP = null;
        }
        if (this.FRAMES_RUNDOWN != null) {
            this.FRAMES_RUNDOWN = null;
        }
        if (this.FRAMES_TARGETING != null) {
            this.FRAMES_TARGETING = null;
        }
    }

    public boolean track(MyPoint p, int speed, boolean nextFrame) {
        short cellid;
        boolean moving = false;
        int tx = this.ptWorld.x;
        int ty = this.ptWorld.y;
        if (p.x < this.ptWorld.x) {
            moving = true;
            this.ptWorld.x = this.ptWorld.x - p.x < speed ? (int)((short)p.x) : (this.ptWorld.x -= speed);
            this.setAnimation((byte)1);
            super.update(this.game, this.game.playscreen.world);
            cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y));
            if (this.game.playscreen.world.collideSolid(cellid, this, true)) {
                this.ptWorld.x = tx;
                this.game.playscreen.world.translate();
                super.update(this.game, this.game.playscreen.world);
            }
        } else if (p.x > this.ptWorld.x) {
            moving = true;
            this.ptWorld.x = p.x - this.ptWorld.x < speed ? (int)((short)p.x) : (this.ptWorld.x += speed);
            this.setAnimation((byte)2);
            super.update(this.game, this.game.playscreen.world);
            cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y));
            if (this.game.playscreen.world.collideSolid(cellid, this, true)) {
                this.ptWorld.x = tx;
                this.game.playscreen.world.translate();
                super.update(this.game, this.game.playscreen.world);
            }
        }
        if (p.y < this.ptWorld.y) {
            this.ptWorld.y = this.ptWorld.y - p.y < speed ? (int)((short)p.y) : (this.ptWorld.y -= speed);
            if (!moving) {
                moving = true;
                this.setAnimation((byte)3);
            }
            super.update(this.game, this.game.playscreen.world);
            cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y));
            if (this.game.playscreen.world.collideSolid(cellid, this, true)) {
                this.ptWorld.y = ty;
                this.game.playscreen.world.translate();
                super.update(this.game, this.game.playscreen.world);
            }
        } else if (p.y > this.ptWorld.y) {
            this.ptWorld.y = p.y - this.ptWorld.y < speed ? (int)((short)p.y) : (this.ptWorld.y += speed);
            if (!moving) {
                moving = true;
                this.setAnimation((byte)4);
            }
            super.update(this.game, this.game.playscreen.world);
            cellid = this.game.playscreen.world.groundMap.getCell(this.game.playscreen.world.groundMap.getColumn(this.ptWorld.x), this.game.playscreen.world.groundMap.getRow(this.ptWorld.y));
            if (this.game.playscreen.world.collideSolid(cellid, this, true)) {
                this.ptWorld.y = ty;
                this.game.playscreen.world.translate();
                super.update(this.game, this.game.playscreen.world);
            }
        }
        if (nextFrame) {
            if (!moving) {
                switch (this.id) {
                    case 1: {
                        this.setAnimation((byte)4);
                    }
                }
            }
            this.sprite.nextFrame();
        }
        if (this.ptWorld.getDistance(p.x, p.y, true) <= speed) {
            this.ptWorld.set(p.x, p.y);
            return true;
        }
        return false;
    }

    public void dropShields(World world) {
        if (this.shieldTimer > 0) {
            return;
        }
        if (this.numPressurePressed >= 2) {
            this.shieldTimer = this.shieldDownTime;
            for (int o = 0; o < world.numObjects; ++o) {
                if (world.object[o].id != 49) continue;
                world.object[o].active = false;
            }
        }
    }

    public void update(Game game, World world) {
        super.update(game, world);
        if (game.popup.isActive) {
            return;
        }
        this.move(world);
        this.animate = (short)(this.animate + 1);
        if (this.animate > 1) {
            this.animate = 0;
        }
        if (this.shieldTimer > 0) {
            this.shieldTimer = (short)(this.shieldTimer - 1);
            if (this.shieldTimer <= 0) {
                this.shieldTimer = 0;
                int tileBorder = 2;
                int bulletShield = 0;
                if (this.id == 5) {
                    bulletShield = 3;
                }
                for (int o = 0; o < world.numObjects; ++o) {
                    if (world.object[o].id != 49) continue;
                    world.object[o].active = true;
                    world.object[o].burned = false;
                    this.numPressurePressed = 0;
                    int r = Utils.RandNum(tileBorder, world.groundMap.getRows() - tileBorder - bulletShield);
                    int c2 = Utils.RandNum(tileBorder, world.groundMap.getColumns() - tileBorder);
                    int startx = c2 * game.TILE_SIZE;
                    int starty = r * game.TILE_SIZE + game.TILE_SIZE;
                    world.object[o].moveto(startx, starty);
                    world.object[o].ptCell.set(c2, r);
                }
            }
        }
        if (this.health <= 0) {
            this.health = 0;
            this.shieldTimer = 0;
            if (!this.dead) {
                this.state = 0;
                this.dead = true;
                game.sinfo[game.infoSlot].score += (long)this.points;
                this.setAnimation((byte)0);
            }
            return;
        }
    }

    public void draw(Graphics g) {
        if (!this.onscreen) {
            return;
        }
        super.draw(g);
        if (this.shieldTimer == 0) {
            int sx = this.ptScreen.x + this.sprite.getWidth() / 2 - this.game.sprShield.getWidth() / 2;
            int sy = this.ptScreen.y + this.sprite.getHeight() / 2 - this.game.sprShield.getHeight() / 2;
            if (this.numPressurePressed < 1) {
                this.game.sprShield.setFrame(0);
                this.game.sprShield.setPosition(sx, sy);
                this.game.sprShield.paint(g);
            }
            if (this.numPressurePressed < 2) {
                this.game.sprShield.setFrame(1);
                this.game.sprShield.setPosition(sx, sy);
                this.game.sprShield.paint(g);
            }
        }
        if (this.health <= 0) {
            int x2 = this.ptScreen.x + this.sprite.getWidth() / 2 - this.game.playscreen.world.sprReaction.getWidth() / 2;
            int y2 = this.ptScreen.y - this.game.playscreen.world.sprReaction.getHeight() / 10 * 6;
            this.game.playscreen.world.sprReaction.setFrame(4);
            this.game.playscreen.world.sprReaction.setPosition(x2, y2 - this.handTimer);
            this.game.playscreen.world.sprReaction.paint(g);
        }
        this.handTimer = (short)(this.handTimer - 1);
        if (this.handTimer <= 0) {
            this.handTimer = (short)10;
        }
    }

    public void startRest() {
        this.state = 1;
        this.counter = 0;
        this.setAnimation((byte)0);
    }

    public void startAttack() {
        this.state = (byte)3;
        this.counter = 0;
        switch (this.id) {
            case 1: 
            case 7: {
                this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                this.attackCounter = (short)100;
                break;
            }
            case 2: {
                this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                this.attackCounter = (short)3;
                this.moveto(this.ptTarget.x, this.ptStart.y - this.game.TILE_SIZE);
                break;
            }
            case 3: {
                this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                this.attackCounter = (short)3;
                this.startAttackX1 = (short)(this.game.x + this.game.playscreen.world.groundMap.getX() - this.game.TILE_SIZE);
                this.startAttackX2 = (short)(this.game.x + this.game.playscreen.world.groundMap.getX() + this.game.playscreen.world.groundMap.getWidth() + this.game.TILE_SIZE);
                if (this.attackCounter % 2 == 0) {
                    this.moveto(this.startAttackX1, this.ptTarget.y);
                    break;
                }
                this.moveto(this.startAttackX2, this.ptTarget.y);
                break;
            }
            case 4: {
                this.attackCounter = (short)100;
                this.moveto(this.ptTarget);
                break;
            }
            case 5: {
                this.attackCounter = (short)100;
                break;
            }
            case 6: {
                this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                this.attackCounter = (short)100;
                this.moveto(this.ptTarget.x, this.startAttackX1);
            }
        }
        this.setAnimation((byte)0);
    }

    public void startTargeting() {
        this.state = (byte)2;
        this.counter = 0;
        this.targetID = (byte)Utils.RandNum(0, 2);
        this.setAnimation((byte)0);
    }

    private void Attack() {
        boolean nextFrame = false;
        switch (this.id) {
            case 1: 
            case 7: {
                this.attackCounter = (short)(this.attackCounter - 1);
                if (this.attackCounter < 0) {
                    this.attackCounter = 0;
                }
                boolean bl = nextFrame = this.game.currframe % 8 == 0;
                if (nextFrame) {
                    for (byte i2 = 0; i2 < 3; ++i2) {
                        if (this.ptWorld.getDistance(this.game.playscreen.world.player[i2].ptWorld.x, this.game.playscreen.world.player[i2].ptWorld.y, true) > this.game.TILE_SIZE * 2) continue;
                        this.game.playscreen.world.player[i2].health = (short)(this.game.playscreen.world.player[i2].health - this.damage);
                        this.game.playscreen.world.player[i2].blood.startDrop(this.game.playscreen.world.player[i2].ptWorld, this.game.TILE_SIZE / 6, this.game);
                        if (i2 == this.game.playscreen.world.currplayer) continue;
                        this.game.playscreen.world.player[i2].healthBarCounter = (short)100;
                    }
                }
                if (this.id == 7) {
                    this.setAnimation((byte)4);
                }
                if (!this.track(this.ptTarget, this.speed, nextFrame) || this.attackCounter != 0) break;
                this.startRest();
                break;
            }
            case 2: {
                boolean bl = nextFrame = this.game.currframe % 8 == 0;
                if (this.ptWorld.y == this.ptStart.y - this.game.TILE_SIZE) {
                    // empty if block
                }
                for (byte i3 = 0; i3 < 3; ++i3) {
                    if (this.ptWorld.getDistance(this.game.playscreen.world.player[i3].ptWorld.x, this.game.playscreen.world.player[i3].ptWorld.y, true) > this.game.TILE_SIZE * 2) continue;
                    if (this.game.currframe % 2 == 0) {
                        this.game.playscreen.world.player[i3].health = (short)(this.game.playscreen.world.player[i3].health - this.damage);
                    }
                    if (nextFrame) {
                        this.game.playscreen.world.player[i3].blood.startDrop(this.game.playscreen.world.player[i3].ptWorld, this.game.TILE_SIZE / 6, this.game);
                    }
                    if (i3 == this.game.playscreen.world.currplayer) continue;
                    this.game.playscreen.world.player[i3].healthBarCounter = (short)100;
                }
                this.moveto(this.ptWorld.x, this.ptWorld.y + this.speed);
                if (this.ptWorld.y > this.game.playscreen.world.groundMap.getHeight()) {
                    this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                    this.moveto(this.ptTarget.x, this.ptStart.y - this.game.TILE_SIZE);
                    this.attackCounter = (short)(this.attackCounter - 1);
                    if (this.attackCounter < 0) {
                        this.attackCounter = 0;
                    }
                }
                this.setAnimation((byte)4);
                if (this.attackCounter != 0) break;
                this.startRest();
                this.moveto(this.ptStart);
                break;
            }
            case 3: {
                boolean bl = nextFrame = this.game.currframe % 8 == 0;
                if (this.ptWorld.x == this.startAttackX1 || this.ptWorld.x == this.startAttackX2) {
                    // empty if block
                }
                for (byte i4 = 0; i4 < 3; ++i4) {
                    if (this.ptWorld.getDistance(this.game.playscreen.world.player[i4].ptWorld.x, this.game.playscreen.world.player[i4].ptWorld.y, true) > this.game.TILE_SIZE * 2) continue;
                    if (this.game.currframe % 3 == 0) {
                        this.game.playscreen.world.player[i4].health = (short)(this.game.playscreen.world.player[i4].health - this.damage);
                    }
                    if (nextFrame) {
                        this.game.playscreen.world.player[i4].blood.startDrop(this.game.playscreen.world.player[i4].ptWorld, this.game.TILE_SIZE / 6, this.game);
                    }
                    if (i4 == this.game.playscreen.world.currplayer) continue;
                    this.game.playscreen.world.player[i4].healthBarCounter = (short)100;
                }
                if (this.attackCounter % 2 == 0) {
                    this.moveto(this.ptWorld.x + this.speed, this.ptWorld.y);
                    if (this.ptWorld.x > this.startAttackX2) {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        this.moveto(this.startAttackX2, this.ptTarget.y);
                        this.attackCounter = (short)(this.attackCounter - 1);
                        if (this.attackCounter < 0) {
                            this.attackCounter = 0;
                        }
                    }
                    this.setAnimation((byte)2);
                } else {
                    this.moveto(this.ptWorld.x - this.speed, this.ptWorld.y);
                    if (this.ptWorld.x < this.startAttackX1) {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        this.moveto(this.startAttackX1, this.ptTarget.y);
                        this.attackCounter = (short)(this.attackCounter - 1);
                        if (this.attackCounter < 0) {
                            this.attackCounter = 0;
                        }
                    }
                    this.setAnimation((byte)1);
                }
                if (this.attackCounter != 0) break;
                this.startRest();
                this.moveto(this.ptStart);
                break;
            }
            case 4: {
                this.setAnimation((byte)2);
                this.attackCounter = (short)(this.attackCounter - 1);
                if (this.attackCounter < 0) {
                    this.attackCounter = 0;
                }
                if (this.game.currframe % 5 == 0) {
                    for (byte i5 = 0; i5 < 3; ++i5) {
                        if (this.ptWorld.getDistance(this.game.playscreen.world.player[i5].ptWorld.x, this.game.playscreen.world.player[i5].ptWorld.y, true) > this.game.TILE_SIZE * 2) continue;
                        this.game.playscreen.world.player[i5].health = (short)(this.game.playscreen.world.player[i5].health - this.damage);
                        this.game.playscreen.world.player[i5].blood.startDrop(this.game.playscreen.world.player[i5].ptWorld, this.game.TILE_SIZE / 6, this.game);
                        if (i5 == this.game.playscreen.world.currplayer) continue;
                        this.game.playscreen.world.player[i5].healthBarCounter = (short)100;
                    }
                }
                if (this.attackCounter % 4 == 0) {
                    this.sprite.nextFrame();
                }
                if (this.attackCounter != 0) break;
                this.startRest();
                break;
            }
            case 5: {
                this.setAnimation((byte)2);
                this.attackCounter = (short)(this.attackCounter - 1);
                if (this.attackCounter < 0) {
                    this.attackCounter = 0;
                }
                if (this.game.currframe % 8 == 0) {
                    for (byte i6 = 0; i6 < 3; ++i6) {
                        if (!this.game.playscreen.world.isInLineOfSight(this, this.game.playscreen.world.player[i6], null)) continue;
                        this.game.playscreen.world.player[i6].health = (short)(this.game.playscreen.world.player[i6].health - this.damage);
                        this.game.playscreen.world.player[i6].blood.startDrop(this.game.playscreen.world.player[i6].ptWorld, this.game.TILE_SIZE / 6, this.game);
                        if (i6 == this.game.playscreen.world.currplayer) continue;
                        this.game.playscreen.world.player[i6].healthBarCounter = (short)100;
                    }
                }
                if (this.attackCounter % 4 == 0) {
                    this.sprite.nextFrame();
                }
                if (this.attackCounter != 0) break;
                this.startRest();
                break;
            }
            case 6: {
                int range = this.game.TILE_SIZE * 3 / 2;
                if (this.game.currframe % 7 == 0) {
                    for (byte i7 = 0; i7 < 3; ++i7) {
                        if (this.ptWorld.x - range > this.game.playscreen.world.player[i7].ptWorld.x || this.ptWorld.x + range < this.game.playscreen.world.player[i7].ptWorld.x) continue;
                        this.game.playscreen.world.player[i7].health = (short)(this.game.playscreen.world.player[i7].health - this.damage);
                        this.game.playscreen.world.player[i7].blood.startDrop(this.game.playscreen.world.player[i7].ptWorld, this.game.TILE_SIZE / 6, this.game);
                        if (i7 == this.game.playscreen.world.currplayer) continue;
                        this.game.playscreen.world.player[i7].healthBarCounter = (short)100;
                    }
                }
                if ((this.attackCounter = (short)(this.attackCounter - 1)) < 0) {
                    this.attackCounter = 0;
                }
                this.setAnimation((byte)4);
                if (this.attackCounter % 2 == 0) {
                    this.sprite.nextFrame();
                }
                if (this.attackCounter != 0) break;
                this.startRest();
                this.moveto(this.ptStart);
            }
        }
    }

    private void Targeting() {
        block11: {
            block10: {
                if (this.counter >= this.targetTime) break block10;
                switch (this.id) {
                    case 7: {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        this.setAnimation((byte)5);
                        break;
                    }
                    case 2: {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        this.moveto(this.ptTarget.x, this.ptStart.y);
                        break;
                    }
                    case 3: {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        this.setAnimation((byte)4);
                        if (this.game.currframe % 3 == 0) {
                            this.sprite.nextFrame();
                            break;
                        }
                        break block11;
                    }
                    case 4: {
                        if (this.counter < this.targetTime - 10) {
                            this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                            break;
                        }
                        break block11;
                    }
                    case 5: {
                        this.setAnimation((byte)1);
                        break;
                    }
                    case 6: {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        this.startAttackX1 = (short)(this.game.y + this.game.playscreen.world.groundMap.getY() + this.sprite.getHeight() - this.game.TILE_SIZE * 1);
                        this.moveto(this.ptTarget.x, this.startAttackX1);
                        this.setAnimation((byte)2);
                        break;
                    }
                    default: {
                        this.ptTarget.set(this.game.playscreen.world.player[this.targetID].ptWorld.x, this.game.playscreen.world.player[this.targetID].ptWorld.y);
                        break;
                    }
                }
                break block11;
            }
            this.startAttack();
            return;
        }
    }

    private void Rest() {
        if (this.counter >= 40) {
            this.startTargeting();
        }
    }

    public void move(World world) {
        if (this.health <= 0) {
            return;
        }
        switch (this.state) {
            case 1: {
                this.Rest();
                break;
            }
            case 3: {
                this.Attack();
                break;
            }
            case 2: {
                this.Targeting();
            }
        }
        this.counter = (short)(this.counter + 1);
        if (this.counter > 1000) {
            this.counter = (short)1000;
        }
    }

    public void setAnimation(byte newAnimation) {
        if (newAnimation == this.mAnimation) {
            return;
        }
        this.sprite.setFrame(0);
        switch (newAnimation) {
            case 0: {
                this.sprite.setFrameSequence(FRAMES_STAND);
                this.direction = 1;
                break;
            }
            case 1: {
                this.sprite.setFrameSequence(this.FRAMES_RUNLEFT);
                this.direction = (byte)2;
                break;
            }
            case 2: {
                this.sprite.setFrameSequence(this.FRAMES_RUNRIGHT);
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.sprite.setFrameSequence(this.FRAMES_RUNUP);
                this.direction = 0;
                break;
            }
            case 4: {
                this.sprite.setFrameSequence(this.FRAMES_RUNDOWN);
                this.direction = 1;
                break;
            }
            case 5: {
                this.sprite.setFrameSequence(this.FRAMES_TARGETING);
                this.direction = 1;
            }
        }
        this.mAnimation = newAnimation;
    }
}

