/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.jengine;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MediaManager {
    public static final byte TONE1 = 60;
    public static final byte TONE2 = 80;
    public static final byte TONE3 = 90;
    public static final byte TONE4 = 100;
    private Player midiPlayer = null;
    private Player wavPlayer = null;
    private boolean mute = false;
    private byte currtrack = (byte)-1;
    private String[] midiurl;
    private String[] wavurl;

    MediaManager(String[] waves, String[] midi) {
        this.midiurl = midi;
        this.wavurl = waves;
    }

    Player Init(String url) {
        Player player = null;
        String ctype = MediaManager.guessContentType(url);
        if (ctype.length() > 0) {
            InputStream is = this.getClass().getResourceAsStream(url);
            try {
                is.reset();
            }
            catch (Exception e) {
                System.out.println("is.reset(): Failed");
            }
            try {
                player = Manager.createPlayer((InputStream)is, (String)ctype);
            }
            catch (Exception e) {
                System.out.println("Failed to create player");
                this.free(player);
            }
        }
        return player;
    }

    private static String guessContentType(String url) {
        String ctype = "";
        if (url.endsWith("mid")) {
            ctype = "audio/midi";
        } else if (url.endsWith("wav")) {
            ctype = "audio/x-wav";
        } else if (url.endsWith("jts")) {
            ctype = "audio/x-tone-seq";
        } else if (url.endsWith("mpeg")) {
            ctype = "video/mpeg";
        } else if (url.endsWith("gif")) {
            ctype = "image/gif";
        } else {
            System.out.println("Cannot guess content type from URL: " + url);
        }
        return ctype;
    }

    void free(Player player) {
        if (player != null) {
            try {
                if (player.getState() == 400) {
                    player.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (player.getState() == 300) {
                    player.deallocate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (player.getState() == 200 || player.getState() == 100) {
                    player.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        player = null;
    }

    void playWav(byte id) {
        if (this.mute) {
            return;
        }
        this.free(this.wavPlayer);
        this.wavPlayer = this.Init(this.wavurl[id]);
        if (this.wavPlayer != null) {
            try {
                this.wavPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void playMidi(byte id) {
        if (this.mute || this.currtrack == id) {
            return;
        }
        this.free(this.midiPlayer);
        this.midiPlayer = this.Init(this.midiurl[id]);
        if (this.midiPlayer != null) {
            this.midiPlayer.setLoopCount(-1);
            try {
                this.midiPlayer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currtrack = id;
        }
    }

    void stopWav() {
        if (this.wavPlayer != null) {
            try {
                if (this.wavPlayer.getState() == 400) {
                    this.wavPlayer.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void stopMidi() {
        if (this.midiPlayer != null) {
            try {
                if (this.midiPlayer.getState() == 400) {
                    this.midiPlayer.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void setPosition(Player player, int pos) {
        if (player != null) {
            try {
                player.setMediaTime((long)pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void destroy() {
        this.free(this.midiPlayer);
        this.free(this.wavPlayer);
    }

    void stopAllSounds() {
        this.currtrack = (byte)-1;
        this.stopWav();
        this.stopMidi();
    }

    void mute(boolean m) {
        this.mute = m;
        if (m) {
            this.stopAllSounds();
        }
    }

    boolean isMute() {
        return this.mute;
    }

    void PlayNote(int note, int vol) {
        if (this.mute) {
            return;
        }
        try {
            Manager.playTone((int)note, (int)100, (int)vol);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

