/*
 * Decompiled with CFR 0.152.
 */
package com.dvidearts.jengine;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        int i2 = 0;
        while (i2 < this.delimiters.length()) {
            char c2 = this.delimiters.charAt(i2);
            if (m < c2) {
                m = c2;
            }
            ++i2;
        }
        this.maxDelimChar = m;
    }

    public StringTokenizer(String str, String delim, boolean returnDelims) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int position = startPos;
        while (!this.retDelims && position < this.maxPosition) {
            char c2 = this.str.charAt(position);
            if (c2 > this.maxDelimChar || this.delimiters.indexOf(c2) < 0) break;
            ++position;
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c2;
        int position = startPos;
        while (position < this.maxPosition) {
            c2 = this.str.charAt(position);
            if (c2 <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0) break;
            ++position;
        }
        if (this.retDelims && startPos == position && (c2 = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c2) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition) {
            if ((currpos = this.skipDelimiters(currpos)) >= this.maxPosition) break;
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

