/*
 * Decompiled with CFR 0.152.
 */
package cityKnights;

import cityKnights.AlertForm;
import cityKnights.Game;
import cityKnights.SplashScreen;
import cityKnights.Starter;
import cityKnights.common.LoadGame;
import cityKnights.common.OpponentCanvas;
import cityKnights.common.ScoreEntry;
import cityKnights.common.Scores;
import cityKnights.common.SoundSelect;
import cityKnights.common.StoreGameForm;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public final class MenuCanvas
extends Canvas
implements CommandListener {
    Starter starter;
    Game game = null;
    public Command newGameCommand;
    public Command quitCommand;
    public Command helpCommand;
    public Command highScoresCommand;
    public Command storeCommand;
    public Command loadCommand;
    public Command continueCommand;
    public Command aboutCommand;
    public Command soundCommand;
    public static boolean soundOn = true;
    public static String help = "Use 4 to move left\nUse 6 to move right\nUse 2 to jump up\nUse 3 to jump to the right\nUse 1 to jump to the left\nUse 8 to crouch\nUse 5 to strike\nUse 9 to kick\nUse 2+9 to jump+kick\nUse 8+5 to crouch+strike";

    public MenuCanvas(Starter starter) {
        this.starter = starter;
        this.quitCommand = new Command("EXIT", 6, 6);
        this.continueCommand = new Command("Resume", 4, 1);
        this.newGameCommand = new Command("NEW GAME", 1, 1);
        this.loadCommand = new Command("LOAD GAME", 1, 2);
        this.storeCommand = new Command("STORE GAME", 4, 2);
        this.highScoresCommand = new Command("HIGH SCORES", 1, 4);
        this.helpCommand = new Command("HELP", 1, 6);
        this.aboutCommand = new Command("ABOUT", 1, 5);
        this.soundCommand = new Command("SOUND", 1, 3);
        this.addMainCommands();
        this.setCommandListener(this);
    }

    private void addMainCommands() {
        this.addCommand(this.quitCommand);
        this.addCommand(this.continueCommand);
        this.addCommand(this.newGameCommand);
        this.addCommand(this.loadCommand);
        this.addCommand(this.storeCommand);
        this.addCommand(this.highScoresCommand);
        this.addCommand(this.helpCommand);
        this.addCommand(this.aboutCommand);
        this.addCommand(this.soundCommand);
    }

    private void removeMainCommands() {
        this.removeCommand(this.continueCommand);
        this.removeCommand(this.storeCommand);
        this.removeCommand(this.newGameCommand);
        this.removeCommand(this.loadCommand);
        this.removeCommand(this.highScoresCommand);
        this.removeCommand(this.helpCommand);
        this.removeCommand(this.aboutCommand);
        this.removeCommand(this.soundCommand);
        this.removeCommand(this.quitCommand);
    }

    public void setGame(Game game) {
        this.game = game;
        if (game != null && !game.gameOver) {
            this.addCommand(this.continueCommand);
            this.addCommand(this.storeCommand);
        } else {
            this.removeCommand(this.continueCommand);
            this.removeCommand(this.storeCommand);
        }
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.game != null) {
            graphics.setColor(64, 64, 64);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(0xFFFFFF);
            if (this.game.gameOver) {
                graphics.drawString("Game Over", n / 2, n2 / 2 - 20, 65);
                graphics.drawString("Score: " + new Integer(Game.sfStatus.score).toString(), n / 2, n2 / 2 + 20, 65);
            } else {
                graphics.drawString("Game Paused", n / 2, n2 / 2, 65);
            }
        } else {
            graphics.drawImage(SplashScreen.flash, n / 2, n2 / 2, 3);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 6) {
            this.starter.exitMidlet();
        } else if (command == this.continueCommand) {
            Starter.setDisplayable((Displayable)this.game);
            this.game.resumeGame();
        } else if (command == this.newGameCommand) {
            OpponentCanvas opponentCanvas = new OpponentCanvas(this.starter);
            Starter.setDisplayable((Displayable)opponentCanvas);
        } else if (command == this.helpCommand) {
            this.showHelp();
        } else if (command == this.highScoresCommand) {
            MenuCanvas.showScores();
        } else if (command == this.loadCommand) {
            LoadGame loadGame = new LoadGame((Displayable)this, this.starter);
            Starter.setDisplayable((Displayable)loadGame);
        } else if (command == this.aboutCommand) {
            this.showAbout();
        } else if (command == this.soundCommand) {
            SoundSelect soundSelect = new SoundSelect((Displayable)this);
            Starter.setDisplayable((Displayable)soundSelect);
        } else if (command == this.storeCommand) {
            Starter.setDisplayable((Displayable)new StoreGameForm(this.game, this.starter));
        }
    }

    public void showHelp() {
        AlertForm alertForm = new AlertForm("HELP");
        alertForm.append(help);
        Starter.setDisplayable((Displayable)alertForm);
    }

    public void showAbout() {
        AlertForm alertForm = new AlertForm("ABOUT");
        alertForm.append("Version: 1.0\nCopyright: Tracebit Ltd");
        Starter.setDisplayable((Displayable)alertForm);
    }

    public static void showScores() {
        AlertForm alertForm = new AlertForm("HIGH SCORES");
        Scores scores = Starter.scores;
        if (scores != null) {
            String string = "Max Scores:\n";
            int n = 0;
            while (n < scores.size()) {
                ScoreEntry scoreEntry = (ScoreEntry)scores.elementAt(n);
                alertForm.append("" + (n + 1) + "." + scoreEntry.name + "  " + scoreEntry.score + "\n");
                ++n;
            }
        }
        Starter.setDisplayable((Displayable)alertForm);
    }
}

