/*
 * Decompiled with CFR 0.152.
 */
package bluetooth1;

import bluetooth1.ClientConnectionHandler;
import bluetooth1.ClientConnectionHandlerListener;
import bluetooth1.ClientInterface;
import java.io.IOException;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.bluetooth.LocalDevice;
import javax.microedition.io.Connector;

public class Client
implements ClientConnectionHandlerListener,
Runnable {
    ClientConnectionHandler handler;
    private L2CAPConnectionNotifier connectionNotifier = null;
    private int sendMessageId = 0;
    private volatile boolean aborting;
    private String url;
    public ClientInterface delegate;

    public Client(ClientInterface canvas, String url) {
        this.url = url;
        this.delegate = canvas;
        String deviceName = null;
        try {
            deviceName = LocalDevice.getLocalDevice().getFriendlyName();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.delegate.setDeviceName(deviceName);
        Thread thread = new Thread(this);
        thread.start();
    }

    public void close() {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    public void sendData(byte[] data) {
        try {
            Integer id = new Integer(++this.sendMessageId);
            this.handler.queueMessageForSending(id, data);
        }
        catch (IllegalArgumentException e) {
            String string = "IllegalArgumentException while trying to send a message: " + e.getMessage();
        }
    }

    public void handleStreamsOpen() {
        this.delegate.setDeviceConnection(true);
        System.out.println("Handle Stream Opened");
    }

    public void handleStreamsOpenError(String errorMessage) {
        this.handler = null;
        System.out.println("Handle Stream Open Error");
    }

    public void handleReceivedMessage(byte[] messageBytes) {
        this.delegate.messageToClient(messageBytes);
    }

    public void handleQueuedMessageWasSent(Integer id) {
    }

    public void handleClose() {
        this.handler = null;
        System.out.println("Client Handler Closed");
    }

    public void handleErrorClose(String errorMessage) {
        this.handler = null;
        System.out.println("Client Handler Closed");
    }

    public void run() {
        block7: {
            String errorMessage;
            this.aborting = false;
            try {
                this.connectionNotifier = (L2CAPConnectionNotifier)Connector.open((String)this.url);
            }
            catch (IOException e) {
                errorMessage = "Error while starting ConnectionService: " + e.getMessage();
                this.aborting = true;
            }
            catch (SecurityException e) {
                errorMessage = "SecurityException while starting ConnectionService: " + e.getMessage();
                this.aborting = true;
            }
            if (!this.aborting) {
                try {
                    L2CAPConnection connection = this.connectionNotifier.acceptAndOpen();
                    if (!this.aborting) {
                        this.handler = new ClientConnectionHandler(connection, this);
                        this.handler.start();
                    }
                }
                catch (IOException e) {
                    if (this.aborting) break block7;
                    String string = "IOException occurred during accept and open: " + e.getMessage();
                }
            }
        }
    }
}

