/*
 * Decompiled with CFR 0.152.
 */
package bluetooth1;

import game.DisplayableCanvas;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

public class ServiceDiscoveryList
implements DiscoveryListener,
Runnable {
    private static final int WAIT_MILLIS = 500;
    private final UUID uuid;
    public final DisplayableCanvas canvas;
    private final int sdTransMax;
    private final int inquiryAccessCode;
    private DiscoveryAgent discoveryAgent;
    private volatile boolean inquiryInProgress = false;
    private volatile int numServiceSearchesInProgress = 0;
    private volatile boolean aborting = false;
    public volatile Thread thread;
    private Vector unsearchedRemoteDevices = new Vector();
    private Vector transIds = new Vector();
    private Vector transIdNames = new Vector();
    private Hashtable matchingServiceRecords = new Hashtable();
    private int numConnectionsAlreadyOpen = 0;

    public ServiceDiscoveryList(DisplayableCanvas canvas, String uuidString, int inquiryAccessCode) {
        this.canvas = canvas;
        this.uuid = new UUID(uuidString, false);
        this.inquiryAccessCode = inquiryAccessCode;
        this.sdTransMax = 1;
        try {
            this.discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            this.start();
        }
        catch (BluetoothStateException e) {
            System.out.println("eeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee");
        }
        this.startSearch();
    }

    public synchronized void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void abort() {
        this.aborting = true;
        this.thread = null;
        this.setInquiryInProgress(false);
        this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
        System.out.println("Search is cancelled");
    }

    private synchronized void setInquiryInProgress(boolean bool) {
        this.inquiryInProgress = bool;
    }

    private void startSearch() {
        this.unsearchedRemoteDevices.removeAllElements();
        Enumeration keys = this.matchingServiceRecords.keys();
        while (keys.hasMoreElements()) {
            this.matchingServiceRecords.remove(keys.nextElement());
        }
        try {
            LocalDevice dev = LocalDevice.getLocalDevice();
            this.canvas.deviceName = dev.getFriendlyName();
            dev.setDiscoverable(0);
            if (this.discoveryAgent == null) {
                this.discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            }
            boolean dd = this.discoveryAgent.startInquiry(this.inquiryAccessCode, (DiscoveryListener)this);
            this.setInquiryInProgress(true);
        }
        catch (Exception e) {
            System.out.println("startSearch():error:" + e.getMessage());
        }
    }

    public void openConnection(String key) {
        ServiceRecord rec = (ServiceRecord)this.matchingServiceRecords.get(key);
        if (rec != null) {
            this.canvas.serviceDiscoveryListOpen(rec);
        }
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        System.out.println("==========deviceDiscovered=============");
        boolean isPhone = deviceClass.getMajorDeviceClass() == 512;
        boolean isEmulator = false;
        if ((isPhone || isEmulator) && !this.unsearchedRemoteDevices.contains(remoteDevice)) {
            this.unsearchedRemoteDevices.addElement(remoteDevice);
        }
    }

    public void inquiryCompleted(int discoveryType) {
        this.setInquiryInProgress(false);
        if (discoveryType == 5) {
            System.out.println("INQUIRY_TERMINATED");
        } else if (discoveryType == 0) {
            System.out.println("INQUIRY_COMPLETED");
        } else if (discoveryType == 7) {
            System.out.println("INQUIRY_ERROR");
        }
        System.out.println("00000000000000000000000000");
        if (this.unsearchedRemoteDevices.size() == 0) {
            System.out.println("11111111111111111111111111111");
        }
    }

    public void servicesDiscovered(int transId, ServiceRecord[] serviceRecords) {
        if (serviceRecords.length == 1) {
            RemoteDevice device = serviceRecords[0].getHostDevice();
            String name = "";
            try {
                name = device.getFriendlyName(true);
            }
            catch (Exception e) {
                name = device.getBluetoothAddress();
            }
            if (!this.matchingServiceRecords.containsKey(name)) {
                this.matchingServiceRecords.put(name, serviceRecords[0]);
                this.canvas.keys.addElement(name);
            }
        }
    }

    public void serviceSearchCompleted(int transId, int responseCode) {
        --this.numServiceSearchesInProgress;
        for (int i = 0; i < this.transIds.size(); ++i) {
            Integer pendingId = (Integer)this.transIds.elementAt(i);
            if (pendingId != transId) continue;
            this.transIds.removeElement(pendingId);
            this.transIdNames.removeElementAt(i);
            break;
        }
        if (this.inquiryInProgress || this.transIds.size() != 0 || this.matchingServiceRecords.size() == 0) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        while (this.thread == currentThread) {
            ServiceDiscoveryList serviceDiscoveryList = this;
            synchronized (serviceDiscoveryList) {
                if (this.thread != currentThread) {
                    break;
                }
                if (!this.inquiryInProgress) {
                    if (this.canvas.keys.size() == 0 && this.unsearchedRemoteDevices.size() == 0) {
                        this.discoveryAgent.cancelInquiry((DiscoveryListener)this);
                        System.out.println("run");
                        this.startSearch();
                    } else {
                        this.doServiceSearch();
                    }
                }
                if (this.inquiryInProgress || this.numServiceSearchesInProgress > 0) {
                    // empty if block
                }
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doServiceSearch() {
        if (this.unsearchedRemoteDevices.size() > 0 && this.numServiceSearchesInProgress < this.sdTransMax) {
            ServiceDiscoveryList serviceDiscoveryList = this;
            synchronized (serviceDiscoveryList) {
                RemoteDevice device = (RemoteDevice)this.unsearchedRemoteDevices.elementAt(0);
                UUID[] uuids = new UUID[]{this.uuid};
                try {
                    String deviceName = device.getFriendlyName(true);
                    int[] attrSet = null;
                    ++this.numServiceSearchesInProgress;
                    int transId = this.discoveryAgent.searchServices(attrSet, uuids, device, (DiscoveryListener)this);
                    this.transIds.addElement(new Integer(transId));
                    if (deviceName == null) {
                        this.transIdNames.addElement("NONAME");
                    } else {
                        this.transIdNames.addElement(deviceName);
                    }
                    this.unsearchedRemoteDevices.removeElementAt(0);
                }
                catch (BluetoothStateException e) {
                    --this.numServiceSearchesInProgress;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }
}

