/*
 * Decompiled with CFR 0.152.
 */
package docobj;

import math.MathEx;

public class PlotRect {
    private int screenWidth;
    private int screenHeight;
    public double xCenter;
    public double yCenter;
    public double zoom;
    public double aspect;

    public PlotRect(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
        this.xCenter = 0.0;
        this.yCenter = 0.0;
        this.zoom = 30.0;
        this.aspect = 1.0;
    }

    public double xMin() {
        return this.xCenter - (double)(this.screenWidth >> 1) / this.zoom;
    }

    public double xMax() {
        return this.xCenter + (double)(this.screenWidth >> 1) / this.zoom;
    }

    public double xSpan() {
        return (double)this.screenWidth / this.zoom;
    }

    public double yMin() {
        return this.yCenter - (double)(this.screenHeight >> 1) / (this.zoom * this.aspect);
    }

    public double yMax() {
        return this.yCenter + (double)(this.screenHeight >> 1) / (this.zoom * this.aspect);
    }

    public double ySpan() {
        return (double)this.screenHeight / (this.zoom * this.aspect);
    }

    public int xToView(double d) {
        return (this.screenWidth >> 1) + (int)MathEx.round((d - this.xCenter) * this.zoom);
    }

    public int yToView(double d) {
        return (this.screenHeight >> 1) - (int)MathEx.round((d - this.yCenter) * this.zoom * this.aspect);
    }
}

