/*
 * Decompiled with CFR 0.152.
 */
package spl.gamestore.moregames;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Image;
import spl.gamestore.common.GameStore;
import spl.gamestore.common.Params;
import spl.gamestore.moregames.MoreGamesModule;

public class HelperThread
extends Thread
implements Params {
    public static final byte REQUEST_ALL_DATA = 0;
    public static final byte REQUEST_GAME_DATA = 1;
    public static final byte REQUEST_SCREENSHOT = 2;
    public static final byte INIT_MODULE = 4;
    public static final byte RESULT_OK = 0;
    public static final byte RESULT_INCORRECT_SETTINGS = 1;
    public static final byte RESULT_LOW_MEMORY = 2;
    public static byte currentOperation = (byte)-1;
    private MoreGamesModule gsModuleMoreGames;
    private final Object lock = new Object();
    private String serverLink;
    private String catalogueVersion;
    private String contentSize;
    public boolean currentOperationAborted = false;
    public Vector tasksQueue = new Vector();
    public Object[] gameDownloading = null;
    public String link = null;
    public static final int HTTP_TIMEOUT = 40000;
    public static final int SMS_SENDING_TIMEOUT = 10000;
    public int timer;
    public int bytesLoaded;
    public int bytesNeedToDownload;
    public boolean isRunning = true;

    public void setServerLink(String serverLink) {
        this.serverLink = serverLink;
        if (this.serverLink != null) {
            String host;
            if (this.serverLink.indexOf("http://") == -1) {
                this.serverLink = "http://" + this.serverLink;
            }
            if ((host = this.serverLink.substring(7, this.serverLink.length())).indexOf("/") == -1) {
                this.serverLink = this.serverLink + "/";
            } else if (host.indexOf("/") != host.length() - 1 && host.charAt(host.length() - 1) == '/') {
                this.serverLink = this.serverLink.substring(0, this.serverLink.length() - 1);
            }
        }
    }

    public void setCatalogueVersion(String catalogueVersion) {
        this.catalogueVersion = catalogueVersion;
    }

    public void setContentSize(String contentSize) {
        this.contentSize = contentSize;
    }

    public HelperThread(MoreGamesModule gsModuleMore) {
        this.gsModuleMoreGames = gsModuleMore;
    }

    public HelperThread(MoreGamesModule gsModuleMore, String serverLink, String catalogueVersion, String contentSize) {
        this.gsModuleMoreGames = gsModuleMore;
        this.serverLink = serverLink;
        if (this.serverLink.charAt(this.serverLink.length() - 1) != '/') {
            this.serverLink = this.serverLink + "/";
        }
        this.catalogueVersion = catalogueVersion;
        this.contentSize = contentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewTask(byte newOperation, Object data) {
        Object object = this.lock;
        synchronized (object) {
            Object[] task = new Object[]{new Byte(newOperation), data};
            if (newOperation == 0) {
                this.tasksQueue.insertElementAt(task, 0);
            } else {
                this.tasksQueue.addElement(task);
            }
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAllTasks() {
        Object object = this.lock;
        synchronized (object) {
            this.tasksQueue = null;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            this.bytesLoaded = 0;
            HttpConnection conn = null;
            FilterInputStream dis = null;
            FilterOutputStream dos = null;
            try {
                Object object = this.lock;
                synchronized (object) {
                    while (this.tasksQueue != null && this.tasksQueue.size() == 0) {
                        this.lock.wait();
                    }
                }
                object = this.lock;
                synchronized (object) {
                    block55: {
                        if (this.tasksQueue != null) break block55;
                        return;
                    }
                    Object[] task = (Object[])this.tasksQueue.elementAt(0);
                    this.tasksQueue.removeElementAt(0);
                    byte operation = (Byte)task[0];
                    if (operation == 1 || operation == 2) {
                        this.gameDownloading = (Object[])task[1];
                        if (this.gameDownloading == null) {
                            throw new Exception();
                        }
                    }
                    this.gsModuleMoreGames.helperTaskStarted(operation, this.gameDownloading);
                    this.timer = 40000;
                    currentOperation = operation;
                }
                if (currentOperation == 4) {
                    this.gsModuleMoreGames.loadResources();
                    continue;
                }
                conn = (HttpConnection)Connector.open((String)this.serverLink, (int)3);
                if (this.timer < 0) {
                    throw new Exception();
                }
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/octet-stream");
                dos = conn.openDataOutputStream();
                ((DataOutputStream)dos).writeByte(currentOperation);
                ((DataOutputStream)dos).writeUTF(this.catalogueVersion);
                if (currentOperation == 0) {
                    ((DataOutputStream)dos).writeUTF(GameStore.lang);
                    ((DataOutputStream)dos).writeUTF(this.contentSize);
                } else if (currentOperation == 1) {
                    ((DataOutputStream)dos).writeUTF((String)this.gameDownloading[0]);
                    ((DataOutputStream)dos).writeUTF(GameStore.lang);
                    ((DataOutputStream)dos).writeUTF(this.contentSize);
                } else if (currentOperation == 2) {
                    ((DataOutputStream)dos).writeUTF((String)this.gameDownloading[0]);
                    ((DataOutputStream)dos).writeUTF(this.contentSize);
                }
                int rc = conn.getResponseCode();
                if (rc == 200) {
                    dis = conn.openDataInputStream();
                    this.bytesNeedToDownload = this.readInt((DataInputStream)dis);
                    long heapFreeSize = Runtime.getRuntime().freeMemory();
                    if (heapFreeSize <= (long)this.bytesNeedToDownload) {
                        this.gsModuleMoreGames.freeOldImages();
                        heapFreeSize = Runtime.getRuntime().freeMemory();
                    }
                    if (heapFreeSize <= (long)this.bytesNeedToDownload) {
                        if (currentOperation == 2) {
                            this.gameDownloading[5] = this.gsModuleMoreGames.imgBroken;
                        }
                        if (currentOperation == 0 && this.gsModuleMoreGames.state == 7 || currentOperation == 1 && this.gsModuleMoreGames.state == 8 || currentOperation == 2 && this.gsModuleMoreGames.state == 3) {
                            this.gsModuleMoreGames.lastHelperOperation = currentOperation;
                            this.gsModuleMoreGames.lastHelperResult = (byte)2;
                        }
                        throw new Exception("aborted");
                    }
                    if (currentOperation == 0) {
                        Object[] categoriesArr = (Object[])this.readObjectFromServer((DataInputStream)dis);
                        if (this.currentOperationAborted) {
                            throw new Exception("aborted");
                        }
                        Object[] gamesArr = (Object[])this.readObjectFromServer((DataInputStream)dis);
                        if (this.currentOperationAborted) {
                            throw new Exception("aborted");
                        }
                        String nav = (String)this.readObjectFromServer((DataInputStream)dis);
                        if (this.currentOperationAborted) {
                            throw new Exception("aborted");
                        }
                        Object[] categoriesContent = (Object[])this.readObjectFromServer((DataInputStream)dis);
                        if (this.currentOperationAborted) {
                            throw new Exception("aborted");
                        }
                        this.gsModuleMoreGames.mergeData(gamesArr, categoriesArr, nav, categoriesContent);
                    } else if (currentOperation == 1) {
                        Object o = this.readObjectFromServer((DataInputStream)dis);
                        if (this.currentOperationAborted) {
                            throw new Exception("aborted");
                        }
                        if ("".equals(o)) {
                            this.gameDownloading[2] = null;
                            this.gameDownloading[5] = null;
                        } else {
                            Object[] newGame = (Object[])o;
                            if (this.gsModuleMoreGames.games.containsKey(newGame[0])) {
                                Object[] oldGame = (Object[])this.gsModuleMoreGames.games.get(newGame[0]);
                                if (newGame[3] == null || newGame[3].equals("")) {
                                    newGame[3] = oldGame[3];
                                }
                                if (newGame[4] == null || newGame[4].equals("")) {
                                    newGame[4] = oldGame[4];
                                }
                                if ("".equals(newGame[2])) {
                                    newGame[2] = null;
                                }
                                if ("".equals(newGame[5]) || "not".equals(newGame[5])) {
                                    newGame[5] = null;
                                }
                            }
                            this.gsModuleMoreGames.games.put(newGame[0], newGame);
                        }
                    } else {
                        Object screenshot = this.readObjectFromServer((DataInputStream)dis);
                        this.gameDownloading[5] = "not".equals(screenshot) ? null : screenshot;
                    }
                    this.gsModuleMoreGames.lastHelperOperation = currentOperation;
                    this.gsModuleMoreGames.lastHelperResult = 0;
                    continue;
                }
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
                if ("aborted".equals(e.getMessage())) continue;
                this.gsModuleMoreGames.lastHelperOperation = currentOperation;
                this.gsModuleMoreGames.lastHelperResult = 1;
            }
            finally {
                currentOperation = (byte)-1;
                this.currentOperationAborted = false;
                try {
                    if (dos != null) {
                        dos.close();
                    }
                    if (dis != null) {
                        dis.close();
                    }
                    if (conn == null) continue;
                    conn.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Object readObjectFromServer(DataInputStream dis) throws IOException {
        block13: {
            byte[] buffer = new byte[1];
            try {
                dis.read(buffer, 0, 1);
                byte type = buffer[0];
                if (type == 0) {
                    dis.readUnsignedShort();
                    return dis.readUTF();
                }
                int length = this.readInt(dis);
                this.bytesLoaded += 5;
                if (type == 0 || type == 1 || type == 2) {
                    byte[] data = new byte[length];
                    for (int i = 0; i < data.length; ++i) {
                        dis.read(buffer, 0, 1);
                        data[i] = buffer[0];
                        ++this.bytesLoaded;
                    }
                    if (type == 0) {
                        return new String(data, 0, length, "UTF-8");
                    }
                    if (type == 1) {
                        Image image = null;
                        if (data.length > 2) {
                            try {
                                image = Image.createImage((byte[])data, (int)0, (int)length);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        return image;
                    }
                    if (type == 2) {
                        return data;
                    }
                    break block13;
                }
                if (type == 3) {
                    int arraySize = this.readInt(dis);
                    this.bytesLoaded += 4;
                    Object[] array = new Object[arraySize];
                    for (int i = 0; i < arraySize; ++i) {
                        array[i] = this.readObjectFromServer(dis);
                    }
                    return array;
                }
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    public int readInt(DataInputStream dis) throws IOException {
        byte[] buffer = new byte[1];
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dis.read(buffer, 0, 1);
            data[i] = buffer[0];
        }
        int result = (data[0] & 0xFF) << 24;
        result += (data[1] & 0xFF) << 16;
        result += (data[2] & 0xFF) << 8;
        return result += data[3] & 0xFF;
    }
}

