/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class PNGList
implements GameConstants {
    public static final byte IMAGE_FP_IDLE = 0;
    public static final byte IMAGE_FP_SERVE = 3;
    public static final byte IMAGE_FP_NORTH = 8;
    public static final byte IMAGE_FP_EAST = 12;
    public static final byte IMAGE_FP_SOUTH = 18;
    public static final byte IMAGE_FP_WEST = 22;
    public static final byte IMAGE_FP_RS = 28;
    public static final byte IMAGE_FP_LS = 30;
    public static final byte IMAGE_BP_IDLE = 32;
    public static final byte IMAGE_BP_SERVE = 35;
    public static final byte IMAGE_BP_NORTH = 40;
    public static final byte IMAGE_BP_EAST = 44;
    public static final byte IMAGE_BP_SOUTH = 50;
    public static final byte IMAGE_BP_WEST = 54;
    public static final byte IMAGE_BP_RS = 60;
    public static final byte IMAGE_BP_LS = 62;
    public static final byte IMAGE_TMP = 64;
    Image[] source = new Image[70];
    Image imgBack = null;
    Image fontSoft = null;
    Image fontSoft1 = null;
    Image font = null;
    Image font1 = null;
    Image offScreen = null;
    Image[] fontImage8 = new Image[2];
    Image[] fontImage9 = new Image[8];
    Image[] fontImage11 = new Image[3];
    Image[] bgBorders = new Image[6];
    final int[][] FPWEARMAP = new int[][]{{0xDBDBFF, 0xDBDBFF, 9386, 9386}, {14399146, 14399146, 0xB6B6AA, 0xB6B6AA}, {14389760, 14389760, 18688, 18688}, {0xB60000, 0xB60000, 9386, 9386}};
    final int[][] FPSKINMAP = new int[][]{{9596160, 16758442, 14389845}, {0, 7162112, 4793344}, {0, 11955456, 9586944}, {0, 16749056, 11955456}};
    InputStream is;
    int[] offset = null;
    int lPos = 0;
    String strChunkFile;
    boolean bBWMode;
    int[] fromColorMap;
    int[] toColorMap;
    int nColorMapSize;
    int[] crc_table;

    public void LoadImage(String chunkFile, int nIndex, int fontSize) {
        int tmpnIndex = nIndex;
        nIndex = 0;
        this.openChunkFile(chunkFile);
        switch (fontSize) {
            case 0: {
                if (tmpnIndex == 0) {
                    this.initMapping(false);
                    this.registerMap(0xAA0000, 0xAA0000);
                } else if (tmpnIndex == 1) {
                    this.initMapping(false);
                    this.registerMap(0xAA0000, 351141);
                } else if (tmpnIndex == 2) {
                    this.initMapping(false);
                    this.registerMap(0xAA0000, 0x669900);
                } else if (tmpnIndex == 3) {
                    this.initMapping(false);
                    this.registerMap(0xAA0000, 0x404141);
                } else if (tmpnIndex == 4) {
                    this.initMapping(false);
                    this.registerMap(0xAA0000, 13212416);
                } else if (tmpnIndex == 5) {
                    this.initMapping(false);
                    this.registerMap(0xAA0000, 0);
                }
                byte[] buffer = new byte[this.offset[nIndex + 1] - this.offset[nIndex]];
                this.loadChunk(nIndex, buffer);
                if (this.nColorMapSize > 0 || this.bBWMode) {
                    this.changeColors(buffer);
                }
                if (tmpnIndex == 0) {
                    this.bgBorders[0] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 1) {
                    this.bgBorders[1] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 2) {
                    this.bgBorders[2] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 3) {
                    this.bgBorders[3] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 4) {
                    this.bgBorders[4] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 5) {
                    this.bgBorders[5] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                buffer = null;
                break;
            }
            case 8: {
                if (tmpnIndex == 0) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0);
                } else if (tmpnIndex == 1) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0xFFFFFF);
                }
                byte[] buffer = new byte[this.offset[nIndex + 1] - this.offset[nIndex]];
                this.loadChunk(nIndex, buffer);
                if (this.nColorMapSize > 0 || this.bBWMode) {
                    this.changeColors(buffer);
                }
                if (tmpnIndex == 0) {
                    this.fontImage8[0] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 1) {
                    this.fontImage8[1] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                buffer = null;
                break;
            }
            case 9: {
                if (tmpnIndex == 0) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0);
                } else if (tmpnIndex == 1) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0xFFFFFF);
                } else if (tmpnIndex == 2) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0xFFFF00);
                } else if (tmpnIndex == 3) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0x980008);
                } else if (tmpnIndex == 4) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 5089779);
                } else if (tmpnIndex == 5) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 4371296);
                } else if (tmpnIndex == 6) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0x989898);
                } else if (tmpnIndex == 7) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 14456858);
                }
                byte[] buffer = new byte[this.offset[nIndex + 1] - this.offset[nIndex]];
                this.loadChunk(nIndex, buffer);
                if (this.nColorMapSize > 0 || this.bBWMode) {
                    this.changeColors(buffer);
                }
                if (tmpnIndex == 0) {
                    this.fontImage9[0] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 1) {
                    this.fontImage9[1] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 2) {
                    this.fontImage9[2] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 3) {
                    this.fontImage9[3] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 4) {
                    this.fontImage9[4] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 5) {
                    this.fontImage9[5] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 6) {
                    this.fontImage9[6] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 7) {
                    this.fontImage9[7] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 8) {
                    this.fontImage9[8] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                buffer = null;
                break;
            }
            case 11: {
                if (tmpnIndex == 0) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0);
                } else if (tmpnIndex == 1) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0xFFFFFF);
                } else if (tmpnIndex == 2) {
                    this.initMapping(false);
                    this.registerMap(0xFFFFFF, 0xFF0000);
                }
                byte[] buffer = new byte[this.offset[nIndex + 1] - this.offset[nIndex]];
                this.loadChunk(nIndex, buffer);
                if (this.nColorMapSize > 0 || this.bBWMode) {
                    this.changeColors(buffer);
                }
                if (tmpnIndex == 0) {
                    this.fontImage11[0] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 1) {
                    this.fontImage11[1] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                if (tmpnIndex == 2) {
                    this.fontImage11[2] = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
                }
                buffer = null;
            }
        }
        System.gc();
        this.releaseMap();
        this.closeChunkFile();
    }

    public int getFileSize(int nIndex) {
        return this.offset[nIndex + 1] - this.offset[nIndex];
    }

    public void openChunkFile(String fn) {
        this.strChunkFile = fn + ".msr";
        try {
            this.is = this.getClass().getResourceAsStream(this.strChunkFile);
            int nSize = this.readInt() + 1;
            this.offset = new int[nSize];
            for (int i = 0; i < nSize; ++i) {
                this.offset[i] = this.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lPos = this.offset[0];
    }

    public void loadChunkImage(int nChunkIndex, int nImageIndex) {
        this.source[nImageIndex] = null;
        this.source[nImageIndex] = this.loadChunkImage(nChunkIndex);
    }

    public void loadChunk(int nIndex, byte[] buffer) {
        try {
            if (this.lPos <= this.offset[nIndex]) {
                if (this.lPos < this.offset[nIndex]) {
                    this.fastSkip(this.offset[nIndex] - this.lPos);
                }
            } else {
                this.is.close();
                this.is = this.getClass().getResourceAsStream(this.strChunkFile);
                this.fastSkip(this.offset[nIndex]);
            }
            this.is.read(buffer);
            this.lPos = this.offset[nIndex + 1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fastSkip(int nOffset) {
        byte[] skipbuffer = new byte[1000];
        try {
            while (nOffset > 0) {
                int d = nOffset > 1000 ? 1000 : nOffset;
                this.is.read(skipbuffer, 0, d);
                nOffset -= d;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        skipbuffer = null;
        System.gc();
    }

    public Image loadChunkImage(int nIndex) {
        byte[] buffer = new byte[this.offset[nIndex + 1] - this.offset[nIndex]];
        this.loadChunk(nIndex, buffer);
        Image rtnImage = Image.createImage((byte[])buffer, (int)0, (int)buffer.length);
        buffer = null;
        System.gc();
        return rtnImage;
    }

    public void initMapping(boolean bBlackWhite) {
        this.bBWMode = bBlackWhite;
        this.releaseMap();
        this.make_crc_table();
    }

    public void registerMap(int fromColor, int toColor) {
        if (this.fromColorMap == null) {
            this.fromColorMap = new int[7];
            this.toColorMap = new int[7];
        }
        this.fromColorMap[this.nColorMapSize] = fromColor;
        this.toColorMap[this.nColorMapSize++] = toColor;
    }

    public void releaseMap() {
        this.fromColorMap = null;
        this.toColorMap = null;
        this.nColorMapSize = 0;
        this.crc_table = null;
        this.bBWMode = false;
    }

    void changeColors(byte[] buffer) {
        int nPos;
        int posPLTE = nPos = this.findPos(buffer, "PLTE");
        int nColors = RMS.readInt(buffer, nPos - 4) / 3;
        nPos += 4;
        int i = 0;
        while (i < nColors) {
            boolean bChanged = false;
            int cSrc = RMS.readInt(buffer, nPos) >>> 8;
            for (int j = 0; j < this.nColorMapSize; ++j) {
                if (cSrc != this.fromColorMap[j]) continue;
                buffer[nPos] = (byte)(this.toColorMap[j] >>> 16 & 0xFF);
                buffer[nPos + 1] = (byte)(this.toColorMap[j] >>> 8 & 0xFF);
                buffer[nPos + 2] = (byte)(this.toColorMap[j] & 0xFF);
                bChanged = true;
                break;
            }
            if (!bChanged && this.bBWMode) {
                int c = ((cSrc >>> 16 & 0xFF) + (cSrc >>> 8 & 0xFF) + (cSrc & 0xFF)) / 3;
                buffer[nPos] = (byte)c;
                buffer[nPos + 1] = (byte)c;
                buffer[nPos + 2] = (byte)c;
            }
            ++i;
            nPos += 3;
        }
        int CRC = this.crc(buffer, posPLTE, nColors * 3 + 4);
        RMS.writeInt(buffer, posPLTE + nColors * 3 + 4, CRC);
    }

    int findPos(byte[] target, String str) {
        return this.findPos(target, str.getBytes());
    }

    int findPos(byte[] target, byte[] obj) {
        for (int i = 0; i < target.length; ++i) {
            int c = 0;
            while (target[i + c] == obj[c]) {
                if (++c != obj.length) continue;
                return i;
            }
        }
        return -1;
    }

    void make_crc_table() {
        this.crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            for (int k = 0; k < 8; ++k) {
                if ((c & 1) == 1) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            this.crc_table[n] = c;
        }
    }

    int update_crc(int crc, byte[] buf, int start, int len) {
        int c = crc;
        for (int n = 0; n < len; ++n) {
            c = this.crc_table[(c ^ buf[n + start]) & 0xFF] ^ c >>> 8;
        }
        return c;
    }

    int crc(byte[] buf, int start, int len) {
        return ~this.update_crc(-1, buf, start, len);
    }

    int readInt() throws Exception {
        int nW = 0;
        byte[] iobuffer = new byte[4];
        this.is.read(iobuffer);
        nW = iobuffer[0] & 0xFF;
        nW += (iobuffer[1] & 0xFF) << 8;
        nW += (iobuffer[2] & 0xFF) << 16;
        nW += (iobuffer[3] & 0xFF) << 24;
        iobuffer = null;
        return nW;
    }

    public void closeChunkFile() {
        this.offset = null;
        try {
            this.is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }
}

