/*
 * Decompiled with CFR 0.152.
 */
import client.ClientConnectionHandler;
import client.ClientConnectionHandlerListener;
import client.ConnectionService;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.LocalDevice;
import javax.microedition.lcdui.Canvas;

public class BluetoothClientPlayer
extends Player
implements ClientConnectionHandlerListener {
    private static final String SECURITY = ";authenticate=false;authorize=false;encrypt=false;name=btl2capEcho";
    private static final String SERVICE_URL = "btl2cap://localhost:4af244c22f8f46d6b8ba64595b0fd7e1;authenticate=false;authorize=false;encrypt=false;name=btl2capEcho";
    private ConnectionService ConnectionService = null;
    private ClientConnectionHandler clientHandler = null;
    private boolean isConnected = false;
    private int sendMessageId = 0;
    private boolean messageSend = false;
    private boolean waitForSending = true;
    private WaitingMenu waitingMenu;

    public BluetoothClientPlayer(WaitingMenu waitingMenu) {
        super(Player.RIVAL_DEPENDED);
        this.waitingMenu = waitingMenu;
        try {
            LocalDevice.getLocalDevice().setDiscoverable(10390323);
        }
        catch (BluetoothStateException bluetoothStateException) {
            // empty catch block
        }
        this.ConnectionService = new ConnectionService(SERVICE_URL, this);
    }

    public void play(int keyCode) {
        if (Menu.leftOrRightSoft(keyCode, (Canvas)this.canvas) == 6 || Menu.leftOrRightSoft(keyCode, (Canvas)this.canvas) == 7) {
            this.myManager.pause();
        }
    }

    public void handleAcceptAndOpen(ClientConnectionHandler handler) {
        this.clientHandler = handler;
        handler.start();
    }

    public void handleStreamsOpen(ClientConnectionHandler handler) {
        this.isConnected = true;
    }

    public void handleStreamsOpenError(ClientConnectionHandler handler, String errorMessage) {
        this.messageSend = false;
        this.myManager.exitFromGame();
    }

    public void handleReceivedMessage(ClientConnectionHandler handler, byte[] messageBytes) {
        if (messageBytes[0] == 77) {
            this.canvas.toCursor.setVisible(true);
            this.canvas.setCursorPos(messageBytes[1], messageBytes[2]);
            this.canvas.setCursor(this.type);
            this.canvas.setCursorPos(messageBytes[3], messageBytes[4]);
            this.canvas.movePiece();
            this.myManager.changeTurn();
            this.rival.rivalMove();
        } else if (messageBytes[0] == 76) {
            this.myManager.exitFromGame();
        } else if (messageBytes[0] == 67) {
            System.out.println("Message recive " + messageBytes.length);
            this.waitingMenu.serverIsFound(messageBytes);
        }
    }

    public void handleQueuedMessageWasSent(ClientConnectionHandler handler, Integer id) {
        this.messageSend = true;
        this.waitForSending = false;
    }

    public void handleClose(ClientConnectionHandler handler) {
        this.myManager.exitFromGame();
    }

    public void handleErrorClose(ClientConnectionHandler handler, String errorMessage) {
        this.myManager.exitFromGame();
    }

    public void handleError(ClientConnectionHandler hander, String errorMessage) {
        this.myManager.exitFromGame();
    }

    public void closePlayer() {
        this.messageSend = false;
        this.waitForSending = false;
        if (this.clientHandler != null) {
            this.clientHandler.close();
        }
        this.clientHandler = null;
        this.isConnected = false;
    }

    public void cancelWaitingForServer() {
        this.ConnectionService.close();
    }

    public void rivalLeave() {
        byte[] sendData = new byte[]{76};
        Integer id = new Integer(++this.sendMessageId);
        this.clientHandler.queueMessageForSending(id, sendData);
    }

    public boolean rivalMove() {
        Integer id = new Integer(++this.sendMessageId);
        byte[] sendData = new byte[7];
        sendData[0] = 77;
        sendData[1] = (byte)this.canvas.fromCursor.getColumn();
        sendData[2] = (byte)this.canvas.fromCursor.getRaw();
        sendData[3] = (byte)this.canvas.toCursor.getColumn();
        sendData[4] = (byte)this.canvas.toCursor.getRaw();
        sendData[5] = 0;
        this.waitForSending = true;
        this.clientHandler.queueMessageForSending(id, sendData);
        while (this.waitForSending) {
        }
        return this.messageSend;
    }

    public boolean getIsConnect() {
        return this.isConnected;
    }

    public void setCursorColor() {
        this.canvas.toCursor.setVisible(false);
        if (this.type == 1) {
            this.canvas.fromCursor.setFrame(0);
            this.canvas.toCursor.setFrame(0);
        } else {
            this.canvas.fromCursor.setFrame(1);
            this.canvas.toCursor.setFrame(1);
        }
        this.canvas.drawCanvas();
    }
}

