/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import server.ServerConnectionHandler;
import server.ServerConnectionHandlerListener;

public class BluetoothServerPlayer
extends Player
implements ServerConnectionHandlerListener {
    private int sendMessageId = 0;
    private ServiceDiscoveryMenu listener;
    private ServerConnectionHandler serverHandler = null;
    private boolean isConnected = false;
    private boolean messageSend = false;
    private boolean waitForSending = true;

    public BluetoothServerPlayer(ServiceDiscoveryMenu list) {
        super(Player.RIVAL_DEPENDED);
        this.listener = list;
    }

    public void setServerHandler(ServerConnectionHandler handler) {
        this.serverHandler = handler;
    }

    public void play(int keyCode) {
        if (Menu.leftOrRightSoft(keyCode, (Canvas)this.canvas) == 6 || Menu.leftOrRightSoft(keyCode, (Canvas)this.canvas) == 7) {
            this.myManager.pause();
        }
    }

    public void handleOpen(ServerConnectionHandler handler) {
        this.listener.clientIsFound();
        this.isConnected = true;
    }

    public void handleOpenError(ServerConnectionHandler handler, String errorMessage) {
        this.myManager.exitFromGame();
    }

    public void handleReceivedMessage(ServerConnectionHandler handler, byte[] messageBytes) {
        if (messageBytes[0] == 76) {
            this.myManager.exitFromGame();
        }
        if (messageBytes[0] == 77) {
            this.canvas.toCursor.setVisible(true);
            this.canvas.setCursorPos(messageBytes[1], messageBytes[2]);
            this.canvas.setCursor(this.type);
            this.canvas.setCursorPos(messageBytes[3], messageBytes[4]);
            this.canvas.movePiece();
            this.myManager.changeTurn();
            this.rival.rivalMove();
        }
    }

    public void handleQueuedMessageWasSent(ServerConnectionHandler handler, Integer id) {
        this.messageSend = true;
        this.waitForSending = false;
    }

    public void handleClose(ServerConnectionHandler handler) {
        this.myManager.exitFromGame();
    }

    public void handleErrorClose(ServerConnectionHandler handler, String errorMessage) {
        this.myManager.exitFromGame();
    }

    public void closePlayer() {
        this.messageSend = false;
        this.waitForSending = false;
        if (this.serverHandler != null) {
            this.serverHandler.close();
        }
        this.serverHandler = null;
        this.isConnected = false;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void rivalLeave() {
        byte[] sendData = new byte[]{76};
        Integer id = new Integer(++this.sendMessageId);
        this.serverHandler.queueMessageForSending(id, sendData);
    }

    public boolean rivalMove() {
        Integer id = new Integer(++this.sendMessageId);
        byte[] sendData = new byte[7];
        sendData[0] = 77;
        sendData[1] = (byte)this.canvas.fromCursor.getColumn();
        sendData[2] = (byte)this.canvas.fromCursor.getRaw();
        sendData[3] = (byte)this.canvas.toCursor.getColumn();
        sendData[4] = (byte)this.canvas.toCursor.getRaw();
        sendData[6] = 0;
        this.waitForSending = true;
        this.serverHandler.queueMessageForSending(id, sendData);
        while (this.waitForSending) {
        }
        return this.messageSend;
    }

    public void sendmessage(byte[] sendMe) {
        Integer id = new Integer(++this.sendMessageId);
        this.serverHandler.queueMessageForSending(id, sendMe);
    }

    public void setCursorColor() {
        this.canvas.toCursor.setVisible(false);
        if (this.type == 1) {
            this.canvas.fromCursor.setFrame(0);
            this.canvas.toCursor.setFrame(0);
        } else {
            this.canvas.fromCursor.setFrame(1);
            this.canvas.toCursor.setFrame(1);
        }
        this.canvas.drawCanvas();
    }
}

