/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import pieces.Bishop;
import pieces.King;
import pieces.Knight;
import pieces.Pawn;
import pieces.Piece;
import pieces.Queen;
import pieces.Rook;

public class PlayCanvas
extends GameCanvas {
    private Graphics graphics;
    private LayerManager pieceManager;
    public final Board board;
    public AAChess midlet;
    public Cursor fromCursor;
    public Cursor toCursor;
    public static Image rookBlack;
    public static Image knightBlack;
    public static Image bishopBlack;
    public static Image queenBlack;
    public static Image kingBlack;
    public static Image pawnBlack;
    public static Image rookWhite;
    public static Image knightWhite;
    public static Image bishopWhite;
    public static Image queenWhite;
    public static Image kingWhite;
    public static Image pawnWhite;
    public static Image boardTiles;
    public static Image cursorImage;
    public static int tilesSize;
    private PlayerManager playerManager = null;

    public PlayCanvas(AAChess midlet) {
        super(false);
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.graphics = this.getGraphics();
        this.graphics.setClip(0, 0, this.getWidth(), this.getHeight() + 500);
        this.pieceManager = new LayerManager();
        this.board = new Board(boardTiles);
        this.fromCursor = new Cursor(cursorImage);
        this.toCursor = new Cursor(cursorImage);
        this.fromCursor.setVisible(false);
        this.loadPieces(midlet.record.readGameMap());
        this.pieceManager.append((Layer)this.toCursor);
        this.pieceManager.append((Layer)this.fromCursor);
        this.pieceManager.append((Layer)this.board);
        this.drawCanvas();
    }

    public void setPlayerManager(PlayerManager playerManager) {
        this.playerManager = playerManager;
    }

    private void loadPieces(int[][] loadMe) {
        this.board.setCastleRights(this.midlet.record.getCastleRight());
        int j = 0;
        while (j < 8) {
            int i = 0;
            while (i < 8) {
                switch (loadMe[j][i]) {
                    case 1: {
                        this.addPiece(new Pawn(this.board, i, j, 1));
                        break;
                    }
                    case 2: {
                        this.addPiece(new Rook(this.board, i, j, 1));
                        break;
                    }
                    case 3: {
                        this.addPiece(new Knight(this.board, i, j, 1));
                        break;
                    }
                    case 4: {
                        this.addPiece(new Bishop(this.board, i, j, 1));
                        break;
                    }
                    case 5: {
                        this.addPiece(new Queen(this.board, i, j, 1));
                        break;
                    }
                    case 6: {
                        this.addPiece(new King(this, i, j, 1));
                        break;
                    }
                    case 7: {
                        this.addPiece(new Pawn(this.board, i, j, 0));
                        break;
                    }
                    case 8: {
                        this.addPiece(new Rook(this.board, i, j, 0));
                        break;
                    }
                    case 9: {
                        this.addPiece(new Knight(this.board, i, j, 0));
                        break;
                    }
                    case 10: {
                        this.addPiece(new Bishop(this.board, i, j, 0));
                        break;
                    }
                    case 11: {
                        this.addPiece(new Queen(this.board, i, j, 0));
                        break;
                    }
                    case 12: {
                        this.addPiece(new King(this, i, j, 0));
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    public void drawCanvas() {
        this.pieceManager.paint(this.graphics, 0, 0);
        this.flushGraphics();
    }

    public void addPiece(Piece addMe) {
        this.board.map[addMe.getRaw()][addMe.getColumn()] = addMe;
        this.pieceManager.insert((Layer)addMe, 0);
    }

    public void removePiece(int xPos, int yPos) {
        this.pieceManager.remove((Layer)this.board.map[yPos][xPos]);
        this.board.map[yPos][xPos] = null;
    }

    public void moveTo(int fromColumn, int fromRaw, int toColumn, int toRaw) {
        Piece moveMe = this.board.map[fromRaw][fromColumn];
        this.pieceManager.insert((Layer)moveMe, 0);
        int startX = fromColumn * this.board.getCellWidth();
        int startY = fromRaw * this.board.getCellHeight();
        int endX = toColumn * this.board.getCellWidth();
        int endY = toRaw * this.board.getCellHeight();
        int dy = endY - startY;
        int dx = endX - startX;
        int delta = 0;
        int lastPos = 0;
        int newPos = 0;
        if (Math.abs(dx) > Math.abs(dy)) {
            int moveStep = 0;
            while (Math.abs(moveStep) < Math.abs(dx)) {
                newPos = moveStep * dy / dx;
                lastPos = (moveStep - delta) * dy / dx;
                moveMe.moveRefPixelPos(delta, newPos - lastPos);
                this.drawCanvas();
                delta = dx > 0 ? 4 : -4;
                moveStep += delta;
            }
            if (this.board.map[toRaw][toColumn] != null) {
                this.pieceManager.remove((Layer)this.board.map[toRaw][toColumn]);
            }
            moveMe.setPiecePos(toColumn, toRaw);
        } else {
            int moveStep = 0;
            while (Math.abs(moveStep) < Math.abs(dy)) {
                newPos = moveStep * dx / dy;
                lastPos = (moveStep - delta) * dx / dy;
                moveMe.moveRefPixelPos(newPos - lastPos, delta);
                this.drawCanvas();
                delta = dy > 0 ? 4 : -4;
                moveStep += delta;
            }
            if (this.board.map[toRaw][toColumn] != null) {
                this.pieceManager.remove((Layer)this.board.map[toRaw][toColumn]);
            }
            moveMe.setPiecePos(toColumn, toRaw);
        }
    }

    public void movePiece() {
        int fromCol = this.fromCursor.getColumn();
        int fromRaw = this.fromCursor.getRaw();
        int toCol = this.toCursor.getColumn();
        int toRaw = this.toCursor.getRaw();
        this.moveTo(fromCol, fromRaw, toCol, toRaw);
        this.midlet.record.movePiece(fromCol, fromRaw, toCol, toRaw);
        if (toRaw == 7 && this.board.map[toRaw][toCol].getPieceName() == 1) {
            this.removePiece(toCol, toRaw);
            this.addPiece(new Queen(this.board, toCol, toRaw, 1));
            this.midlet.record.changePiece(toCol, toRaw, 5);
        } else if (toRaw == 0 && this.board.map[toRaw][toCol].getPieceName() == 7) {
            this.removePiece(toCol, toRaw);
            this.addPiece(new Queen(this.board, toCol, toRaw, 0));
            this.midlet.record.changePiece(toCol, toRaw, 11);
        } else if (this.board.map[toRaw][toCol].getPieceName() == 6) {
            this.board.blackCanCastleLeft = false;
            this.board.blackCanCastleRight = false;
            this.board.saveCastleRight(this.midlet.record);
            if (Math.abs(toCol - fromCol) == 2) {
                int direction = toCol - fromCol > 0 ? 1 : -1;
                int rookCol = direction > 0 ? 7 : 0;
                this.moveTo(rookCol, fromRaw, toCol - direction, toRaw);
                this.midlet.record.movePiece(rookCol, fromRaw, toCol - direction, toRaw);
            }
            this.board.blackKingCol = toCol;
            this.board.blackKingRaw = toRaw;
        } else if (this.board.map[toRaw][toCol].getPieceName() == 12) {
            this.board.whiteCanCastleLeft = false;
            this.board.whiteCanCastleRight = false;
            this.board.saveCastleRight(this.midlet.record);
            if (Math.abs(toCol - fromCol) == 2) {
                int direction = toCol - fromCol > 0 ? 1 : -1;
                int rookCol = direction > 0 ? 7 : 0;
                this.moveTo(rookCol, fromRaw, toCol - direction, toRaw);
                this.midlet.record.movePiece(rookCol, fromRaw, toCol - direction, toRaw);
            }
            this.board.whiteKingCol = toCol;
            this.board.whiteKingRaw = toRaw;
        } else if (this.board.map[toRaw][toCol].getPieceName() == 8) {
            if (fromCol == 7 && fromRaw == 7) {
                this.board.whiteCanCastleRight = false;
                this.board.saveCastleRight(this.midlet.record);
            } else if (fromCol == 0 && fromRaw == 7) {
                this.board.whiteCanCastleLeft = false;
                this.board.saveCastleRight(this.midlet.record);
            }
        } else if (this.board.map[toRaw][toCol].getPieceName() == 2) {
            if (fromCol == 7 && fromRaw == 0) {
                this.board.blackCanCastleRight = false;
                this.board.saveCastleRight(this.midlet.record);
            } else if (fromCol == 0 && fromRaw == 0) {
                this.board.blackCanCastleLeft = false;
                this.board.saveCastleRight(this.midlet.record);
            }
        }
        this.resetCursor();
    }

    public boolean isLegalMove() {
        Piece moveMe = this.board.map[this.fromCursor.getRaw()][this.fromCursor.getColumn()];
        boolean pieceCanMove = moveMe.isLegalMove(this.toCursor.getColumn(), this.toCursor.getRaw(), false);
        boolean moveCauseMate = King.isMate(this.board, moveMe.getType(), moveMe.getColumn(), moveMe.getRaw(), this.toCursor.getColumn(), this.toCursor.getRaw());
        return pieceCanMove && !moveCauseMate;
    }

    public boolean isFull(int X, int Y) {
        return this.board.map[Y][X] != null;
    }

    public boolean moveCursor(int X, int Y) {
        int goToColumn = this.toCursor.getColumn() + X;
        int goToRaw = this.toCursor.getRaw() + Y;
        if (goToColumn >= 0 && goToColumn < 8 && goToRaw >= 0 && goToRaw < 8) {
            this.toCursor.setCursorPos(goToColumn, goToRaw);
            this.drawCanvas();
            return true;
        }
        return false;
    }

    public boolean setCursorPos(int X, int Y) {
        if (X >= 0 && X < 8 && Y >= 0 && Y < 8) {
            this.resetCursor();
            this.toCursor.setCursorPos(X, Y);
            this.drawCanvas();
            return true;
        }
        return false;
    }

    public boolean setCursor(int turn) {
        Piece MoveMe = this.board.map[this.toCursor.getRaw()][this.toCursor.getColumn()];
        if (MoveMe != null && MoveMe.getType() == turn) {
            this.fromCursor.setCursorPos(this.toCursor.getColumn(), this.toCursor.getRaw());
            this.fromCursor.setVisible(true);
            return true;
        }
        return false;
    }

    public void resetCursor() {
        this.fromCursor.setVisible(false);
        this.drawCanvas();
    }

    public boolean isCursorSet() {
        return this.fromCursor.isVisible();
    }

    protected void keyPressed(int keyCode) {
        if (this.playerManager != null) {
            this.playerManager.keyPressed(keyCode);
        }
    }

    public static void setPieceImage(int screenWidth) {
        tilesSize = screenWidth / 8;
        boardTiles = AAChess.scaleImage(AAChess.createImage("/board_tiles.png"), tilesSize * 4, tilesSize);
        Image pieceImage = AAChess.createImage("/pieces.png");
        int pieceHeight = pieceImage.getHeight() / 2;
        int pieceWidth = pieceImage.getWidth() / 6;
        rookBlack = Image.createImage((Image)pieceImage, (int)0, (int)0, (int)pieceWidth, (int)pieceHeight, (int)0);
        knightBlack = Image.createImage((Image)pieceImage, (int)pieceWidth, (int)0, (int)pieceWidth, (int)pieceHeight, (int)0);
        bishopBlack = Image.createImage((Image)pieceImage, (int)(pieceWidth * 2), (int)0, (int)pieceWidth, (int)pieceHeight, (int)0);
        queenBlack = Image.createImage((Image)pieceImage, (int)(pieceWidth * 3), (int)0, (int)pieceWidth, (int)pieceHeight, (int)0);
        kingBlack = Image.createImage((Image)pieceImage, (int)(pieceWidth * 4), (int)0, (int)pieceWidth, (int)pieceHeight, (int)0);
        pawnBlack = Image.createImage((Image)pieceImage, (int)(pieceWidth * 5), (int)0, (int)pieceWidth, (int)pieceHeight, (int)0);
        rookWhite = Image.createImage((Image)pieceImage, (int)0, (int)pieceHeight, (int)pieceWidth, (int)pieceHeight, (int)0);
        knightWhite = Image.createImage((Image)pieceImage, (int)pieceWidth, (int)pieceHeight, (int)pieceWidth, (int)pieceHeight, (int)0);
        bishopWhite = Image.createImage((Image)pieceImage, (int)(pieceWidth * 2), (int)pieceHeight, (int)pieceWidth, (int)pieceHeight, (int)0);
        queenWhite = Image.createImage((Image)pieceImage, (int)(pieceWidth * 3), (int)pieceHeight, (int)pieceWidth, (int)pieceHeight, (int)0);
        kingWhite = Image.createImage((Image)pieceImage, (int)(pieceWidth * 4), (int)pieceHeight, (int)pieceWidth, (int)pieceHeight, (int)0);
        pawnWhite = Image.createImage((Image)pieceImage, (int)(pieceWidth * 5), (int)pieceHeight, (int)pieceWidth, (int)pieceHeight, (int)0);
        rookBlack = AAChess.scaleImage(rookBlack, tilesSize + 10, tilesSize + 10);
        knightBlack = AAChess.scaleImage(knightBlack, tilesSize + 10, tilesSize + 10);
        bishopBlack = AAChess.scaleImage(bishopBlack, tilesSize + 10, tilesSize + 10);
        queenBlack = AAChess.scaleImage(queenBlack, tilesSize + 10, tilesSize + 10);
        kingBlack = AAChess.scaleImage(kingBlack, tilesSize + 10, tilesSize + 10);
        pawnBlack = AAChess.scaleImage(pawnBlack, tilesSize + 10, tilesSize + 10);
        rookWhite = AAChess.scaleImage(rookWhite, tilesSize + 10, tilesSize + 10);
        knightWhite = AAChess.scaleImage(knightWhite, tilesSize + 10, tilesSize + 10);
        bishopWhite = AAChess.scaleImage(bishopWhite, tilesSize + 10, tilesSize + 10);
        queenWhite = AAChess.scaleImage(queenWhite, tilesSize + 10, tilesSize + 10);
        kingWhite = AAChess.scaleImage(kingWhite, tilesSize + 10, tilesSize + 10);
        pawnWhite = AAChess.scaleImage(pawnWhite, tilesSize + 10, tilesSize + 10);
        cursorImage = AAChess.createScaledImage("/cursor.png", tilesSize * 2, tilesSize);
    }

    public GameRecords getGameRecord() {
        return this.midlet.record;
    }
}

