/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import server.ServerConnectionHandler;

class ServiceDiscoveryMenu
implements DiscoveryListener,
Runnable,
MenuListener {
    private BluetoothServerPlayer bluetoothPlayer;
    private final UUID uuid;
    private final int sdTransMax;
    private final int inquiryAccessCode;
    private DiscoveryAgent discoveryAgent;
    private volatile boolean inquiryInProgress = false;
    private volatile int numServiceSearchesInProgress = 0;
    private volatile Thread thread;
    private AAChess midlet;
    private KeyPlayer keyPlayer;
    private String gameName;
    private GameRecords gameRecord;
    private Menu menu;
    private Vector unsearchedRemoteDevices = new Vector();
    private Vector transIds = new Vector();
    private Hashtable matchingServiceRecords = new Hashtable();
    private final String SEARCH_COMMAND;
    private final String STOP_COMMAND;
    private final String BACK_COMMADN;

    ServiceDiscoveryMenu(String uuidString, int inquiryAccessCode, AAChess midlet, KeyPlayer keyPlayer, String gameName) {
        this.SEARCH_COMMAND = "Search";
        this.STOP_COMMAND = "Stop";
        this.BACK_COMMADN = "Back";
        this.uuid = new UUID(uuidString, false);
        this.inquiryAccessCode = inquiryAccessCode;
        this.midlet = midlet;
        this.menu = midlet.menu;
        this.keyPlayer = keyPlayer;
        this.gameName = gameName;
        this.gameRecord = midlet.record;
        this.sdTransMax = 1;
        try {
            this.discoveryAgent = LocalDevice.getLocalDevice().getDiscoveryAgent();
            this.menu.setCommands("Search", "Back");
            this.start();
        }
        catch (BluetoothStateException e) {
            this.serviceDiscoveryListFatalError("Couldn't get a discovery agent: '" + e.getMessage() + "'");
        }
    }

    public synchronized void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void abort() {
        this.thread = null;
    }

    private synchronized void setInquiryInProgress(boolean bool) {
        this.inquiryInProgress = bool;
    }

    public void CommandAction(int keyCode) {
        if (this.menu.getLeftCommand() == "Search" && keyCode == 6 && !this.inquiryInProgress && this.numServiceSearchesInProgress == 0) {
            this.unsearchedRemoteDevices.removeAllElements();
            Enumeration keys = this.matchingServiceRecords.keys();
            while (keys.hasMoreElements()) {
                this.matchingServiceRecords.remove(keys.nextElement());
            }
            while (this.menu.size() > 0) {
                this.menu.removeRoot(0);
            }
            try {
                LocalDevice dev = LocalDevice.getLocalDevice();
                dev.setDiscoverable(0);
                this.discoveryAgent.startInquiry(this.inquiryAccessCode, (DiscoveryListener)this);
                this.setInquiryInProgress(true);
                this.menu.setCommands("Stop", "Back");
            }
            catch (BluetoothStateException e) {
                this.menu.setCommands("Search", "Back");
                this.serviceDiscoveryListError("Error during startInquiry: '" + e.getMessage() + "'");
            }
        } else if (this.menu.getLeftCommand() == "Stop" && keyCode == 6) {
            if (this.cancelPendingSearches()) {
                this.setInquiryInProgress(false);
                this.menu.setCommands("Search", "Back");
            }
        } else if (keyCode == 8 && this.menu.size() > 0) {
            int selectedIndex = this.menu.getSelectedRoot();
            String key = this.menu.readData(selectedIndex, 0);
            ServiceRecord rec = (ServiceRecord)this.matchingServiceRecords.get(key);
            this.serviceDiscoveryListOpen(rec);
        } else if (this.menu.getRightCommand() == "Back" && keyCode == 7) {
            this.abort();
            this.serviceDiscoveryListBackRequest();
        }
    }

    boolean cancelPendingSearches() {
        boolean everythingCancelled = true;
        if (this.inquiryInProgress) {
            if (this.discoveryAgent.cancelInquiry((DiscoveryListener)this)) {
                this.setInquiryInProgress(false);
            } else {
                everythingCancelled = false;
            }
        }
        int i = 0;
        while (i < this.transIds.size()) {
            Integer pendingId = (Integer)this.transIds.elementAt(i);
            if (this.discoveryAgent.cancelServiceSearch(pendingId.intValue())) {
                this.transIds.removeElement(pendingId);
            } else {
                everythingCancelled = false;
            }
            ++i;
        }
        return everythingCancelled;
    }

    public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
        boolean isPhone = deviceClass.getMajorDeviceClass() == 512;
        boolean isEmulator = false;
        if (isPhone || isEmulator) {
            this.unsearchedRemoteDevices.addElement(remoteDevice);
        }
    }

    public void inquiryCompleted(int discoveryType) {
        this.setInquiryInProgress(false);
        if (this.unsearchedRemoteDevices.size() == 0) {
            this.menu.setCommands("Search", "Back");
            this.serviceDiscoveryListError("No matching Bluetooth devices were found that run the desired service");
        }
    }

    public void servicesDiscovered(int transId, ServiceRecord[] serviceRecords) {
        if (serviceRecords.length == 1) {
            RemoteDevice device = serviceRecords[0].getHostDevice();
            String name = device.getBluetoothAddress();
            if (!this.matchingServiceRecords.containsKey(name)) {
                this.matchingServiceRecords.put(name, serviceRecords[0]);
                this.menu.appendRoot(name, 1);
            }
        } else {
            this.serviceDiscoveryListError("Error: Unexpected number (" + serviceRecords.length + ") of service records " + "in servicesDiscovered callback, transId=" + transId);
        }
    }

    public void serviceSearchCompleted(int transId, int responseCode) {
        --this.numServiceSearchesInProgress;
        int i = 0;
        while (i < this.transIds.size()) {
            Integer pendingId = (Integer)this.transIds.elementAt(i);
            if (pendingId == transId) {
                this.transIds.removeElement(pendingId);
                break;
            }
            ++i;
        }
        if (!this.inquiryInProgress && this.transIds.size() == 0) {
            this.menu.setCommands("Search", "Back");
            if (this.matchingServiceRecords.size() == 0) {
                this.serviceDiscoveryListError("No matching services found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        while (this.thread == currentThread) {
            ServiceDiscoveryMenu serviceDiscoveryMenu = this;
            synchronized (serviceDiscoveryMenu) {
                if (this.thread != currentThread) {
                    break;
                }
                if (!this.inquiryInProgress) {
                    this.doServiceSearch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doServiceSearch() {
        if (this.unsearchedRemoteDevices.size() > 0 && this.numServiceSearchesInProgress < this.sdTransMax) {
            ServiceDiscoveryMenu serviceDiscoveryMenu = this;
            synchronized (serviceDiscoveryMenu) {
                RemoteDevice device = (RemoteDevice)this.unsearchedRemoteDevices.elementAt(0);
                UUID[] uuids = new UUID[]{this.uuid};
                try {
                    int[] attrSet = null;
                    ++this.numServiceSearchesInProgress;
                    int transId = this.discoveryAgent.searchServices(attrSet, uuids, device, (DiscoveryListener)this);
                    this.transIds.addElement(new Integer(transId));
                    this.unsearchedRemoteDevices.removeElementAt(0);
                }
                catch (BluetoothStateException e) {
                    --this.numServiceSearchesInProgress;
                    this.serviceDiscoveryListError("Error, could not perform service search: '" + e.getMessage());
                }
            }
        }
    }

    public void serviceDiscoveryListFatalError(String errorMessage) {
        this.serviceDiscoveryListBackRequest();
    }

    public void serviceDiscoveryListError(String errorMessage) {
        this.serviceDiscoveryListBackRequest();
    }

    public void serviceDiscoveryListOpen(ServiceRecord rec) {
        this.abort();
        this.bluetoothPlayer = new BluetoothServerPlayer(this);
        ServerConnectionHandler newHandler = new ServerConnectionHandler(this.bluetoothPlayer, rec, 0);
        this.bluetoothPlayer.setServerHandler(newHandler);
        newHandler.start();
    }

    public void clientIsFound() {
        if (this.gameRecord.gameStore == null) {
            this.gameRecord.createNewGame(this.gameName, this.keyPlayer.type, 2);
        } else {
            this.gameRecord.setPlayer2Type(2);
        }
        this.bluetoothPlayer.sendmessage(this.gameRecord.getPortableGame());
        PlayCanvas canvas = new PlayCanvas(this.midlet);
        new PlayerManager(this.keyPlayer, this.bluetoothPlayer, canvas, this.midlet);
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)canvas);
    }

    public void serviceDiscoveryListBackRequest() {
        this.menu.gotoStartGameMenu();
        this.abort();
    }

    public void selectNo() {
    }

    public void selectYes() {
    }
}

