/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Canvas;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.TextMessage;

public class SmsPlayer
extends Player
implements Runnable,
MessageListener {
    private final String VALID_CHAR;
    private String MESSAGE_HEADER = "Chess Move Code :";
    private final String SMS_PROTOCOL;
    private String rivalTell;
    private String rivalMoveCode;
    private MessageConnection connection;
    private MessageReader reader;
    private MessageWriter writer;
    private boolean abortReader = false;
    private boolean isServer = false;
    private GameRecords record;

    public SmsPlayer(String tell, int smsOption, GameRecords record) {
        super(Player.RIVAL_DEPENDED);
        this.VALID_CHAR = "0123456789abcdefghijklmnopqrstuvwxyz";
        this.SMS_PROTOCOL = "sms://";
        this.record = record;
        this.rivalTell = tell;
        this.isServer = smsOption != 0;
        new Thread(this).start();
        this.reader = new MessageReader();
        this.writer = new MessageWriter();
    }

    public void play(int keyCode) {
        if (Menu.leftOrRightSoft(keyCode, (Canvas)this.canvas) == 6 || Menu.leftOrRightSoft(keyCode, (Canvas)this.canvas) == 7) {
            this.myManager.pause();
        }
    }

    public void sendLastMove() {
        this.rivalMoveCode = new String(this.record.getLastMove());
        this.writer.sendSMS();
    }

    public boolean rivalMove() {
        this.rivalMoveCode = this.getBoardCode();
        this.rivalMoveCode = String.valueOf(this.rivalMoveCode) + "0123456789abcdefghijklmnopqrstuvwxyz".charAt(this.canvas.fromCursor.getColumn());
        this.rivalMoveCode = String.valueOf(this.rivalMoveCode) + "0123456789abcdefghijklmnopqrstuvwxyz".charAt(this.canvas.fromCursor.getRaw());
        this.rivalMoveCode = String.valueOf(this.rivalMoveCode) + "0123456789abcdefghijklmnopqrstuvwxyz".charAt(this.canvas.toCursor.getColumn());
        this.rivalMoveCode = String.valueOf(this.rivalMoveCode) + "0123456789abcdefghijklmnopqrstuvwxyz".charAt(this.canvas.toCursor.getRaw());
        this.record.setLastMove(this.rivalMoveCode.getBytes());
        this.writer.sendSMS();
        return true;
    }

    private String getBoardCode() {
        int code = 1;
        String mapCode = "";
        int j = 0;
        while (j < 8) {
            int i = 0;
            while (i < 8) {
                if (this.canvas.board.map[j][i] != null) {
                    code = code + i + j * 8;
                }
                ++i;
            }
            ++j;
        }
        mapCode = String.valueOf(mapCode) + "0123456789abcdefghijklmnopqrstuvwxyz".charAt(code % "0123456789abcdefghijklmnopqrstuvwxyz".length());
        mapCode = String.valueOf(mapCode) + "0123456789abcdefghijklmnopqrstuvwxyz".charAt((code /= "0123456789abcdefghijklmnopqrstuvwxyz".length()) % "0123456789abcdefghijklmnopqrstuvwxyz".length());
        System.out.println(mapCode);
        return mapCode;
    }

    public void doMoving(String moveCode) {
        String messagePart = moveCode.substring(0, 2);
        if (this.getBoardCode().equals(messagePart)) {
            messagePart = moveCode.substring(2, moveCode.length());
            int fromCol = "0123456789abcdefghijklmnopqrstuvwxyz".indexOf(messagePart.charAt(0));
            int fromRaw = "0123456789abcdefghijklmnopqrstuvwxyz".indexOf(messagePart.charAt(1));
            int toCol = "0123456789abcdefghijklmnopqrstuvwxyz".indexOf(messagePart.charAt(2));
            int toRaw = "0123456789abcdefghijklmnopqrstuvwxyz".indexOf(messagePart.charAt(3));
            this.canvas.setCursorPos(fromCol, fromRaw);
            this.canvas.setCursor(this.type);
            this.canvas.setCursorPos(toCol, toRaw);
            if (this.canvas.isLegalMove()) {
                this.canvas.movePiece();
                this.myManager.changeTurn();
            }
        }
    }

    public void run() {
        try {
            this.connection = this.isServer ? (MessageConnection)Connector.open((String)"sms://:5000") : (MessageConnection)Connector.open((String)("sms://" + this.rivalTell));
            this.connection.setMessageListener((MessageListener)this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void notifyIncomingMessage(MessageConnection conn) {
        if (conn == this.connection) {
            this.reader.handleReceiveMessage();
        }
    }

    public void closePlayer() {
        this.abortReader = true;
        try {
            this.connection.setMessageListener(null);
            this.connection.close();
            this.myManager.exitFromGame();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setCursorColor() {
        this.canvas.toCursor.setVisible(false);
        if (this.type == 1) {
            this.canvas.fromCursor.setFrame(0);
            this.canvas.toCursor.setFrame(0);
        } else {
            this.canvas.fromCursor.setFrame(1);
            this.canvas.toCursor.setFrame(1);
        }
        this.canvas.drawCanvas();
    }

    private class MessageWriter
    implements Runnable {
        private MessageWriter() {
        }

        public void run() {
            try {
                TextMessage msg = (TextMessage)SmsPlayer.this.connection.newMessage("text");
                msg.setPayloadText(String.valueOf(SmsPlayer.this.MESSAGE_HEADER) + SmsPlayer.this.rivalMoveCode);
                if (SmsPlayer.this.isServer) {
                    msg.setAddress("sms://" + SmsPlayer.this.rivalTell + ":5000");
                }
                SmsPlayer.this.connection.send((Message)msg);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void sendSMS() {
            new Thread(this).start();
        }
    }

    private class MessageReader
    implements Runnable {
        private int pendingMessages = 0;

        public MessageReader() {
            SmsPlayer.this.abortReader = false;
            new Thread(this).start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!SmsPlayer.this.abortReader) {
                MessageReader messageReader = this;
                synchronized (messageReader) {
                    if (this.pendingMessages == 0) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    --this.pendingMessages;
                }
                try {
                    TextMessage receivedMessage = (TextMessage)SmsPlayer.this.connection.receive();
                    String messageText = receivedMessage.getPayloadText();
                    String messagePart = messageText.substring(SmsPlayer.this.MESSAGE_HEADER.length(), messageText.length());
                    System.out.println("messageBody :" + messagePart);
                    SmsPlayer.this.doMoving(messagePart);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public synchronized void handleReceiveMessage() {
            ++this.pendingMessages;
            this.notify();
        }
    }
}

