/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientConnectionHandlerListener;
import client.ConnectionService;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.bluetooth.L2CAPConnection;

public class ClientConnectionHandler
implements Runnable {
    private static final int WAIT_MILLIS = 250;
    private final ClientConnectionHandlerListener listener;
    private final Hashtable sendMessages = new Hashtable();
    private L2CAPConnection connection;
    int transmitMTU = 0;
    private volatile boolean aborting;

    public ClientConnectionHandler(ConnectionService ConnectionService2, L2CAPConnection connection, ClientConnectionHandlerListener listener) {
        this.connection = connection;
        this.listener = listener;
        this.aborting = false;
    }

    ClientConnectionHandlerListener getListener() {
        return this.listener;
    }

    public synchronized void start() {
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.aborting) {
            Object object = this;
            synchronized (object) {
                this.aborting = true;
            }
            object = this.sendMessages;
            synchronized (object) {
                this.sendMessages.notify();
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                    object = this;
                    synchronized (object) {
                        this.connection = null;
                        this.transmitMTU = 0;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMessageForSending(Integer id, byte[] data) {
        if (data.length > this.transmitMTU) {
            throw new IllegalArgumentException("Message too long: limit is " + this.transmitMTU + " bytes");
        }
        Hashtable hashtable = this.sendMessages;
        synchronized (hashtable) {
            this.sendMessages.put(id, data);
            this.sendMessages.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        try {
            this.transmitMTU = this.connection.getTransmitMTU();
            writer = new Writer(this);
            writeThread = new Thread(writer);
            writeThread.start();
            this.listener.handleStreamsOpen(this);
            if (true) ** GOTO lbl47
        }
        catch (IOException e) {
            this.close();
            this.listener.handleStreamsOpenError(this, e.getMessage());
            return;
        }
        do {
            ready = false;
            try {
                ready = this.connection.ready();
            }
            catch (IOException e) {
                this.close();
                this.listener.handleClose(this);
            }
            length = 0;
            try {
                if (ready) {
                    mtuLength = this.connection.getReceiveMTU();
                    if (mtuLength <= 0) continue;
                    buffer = new byte[mtuLength];
                    length = this.connection.receive(buffer);
                    readData = new byte[length];
                    System.arraycopy(buffer, 0, readData, 0, length);
                    this.listener.handleReceivedMessage(this, readData);
                    continue;
                }
                try {
                    mtuLength = this;
                    synchronized (mtuLength) {
                        this.wait(250L);
                    }
                }
                catch (InterruptedException mtuLength) {}
            }
            catch (IOException e) {
                this.close();
                if (length == 0) {
                    this.listener.handleClose(this);
                    continue;
                }
                this.listener.handleErrorClose(this, e.getMessage());
            }
lbl47:
            // 7 sources

        } while (!this.aborting);
    }

    private class Writer
    implements Runnable {
        private final ClientConnectionHandler handler;

        Writer(ClientConnectionHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ClientConnectionHandler.this.aborting) {
                Enumeration e = ClientConnectionHandler.this.sendMessages.keys();
                if (e.hasMoreElements()) {
                    Integer id = (Integer)e.nextElement();
                    byte[] sendData = (byte[])ClientConnectionHandler.this.sendMessages.get(id);
                    try {
                        ClientConnectionHandler.this.connection.send(sendData);
                        ClientConnectionHandler.this.sendMessages.remove(id);
                        ClientConnectionHandler.this.listener.handleQueuedMessageWasSent(this.handler, id);
                    }
                    catch (IOException ex) {
                        ClientConnectionHandler.this.close();
                        ClientConnectionHandler.this.listener.handleErrorClose(this.handler, ex.getMessage());
                    }
                }
                Hashtable hashtable = ClientConnectionHandler.this.sendMessages;
                synchronized (hashtable) {
                    if (ClientConnectionHandler.this.sendMessages.isEmpty()) {
                        try {
                            ClientConnectionHandler.this.sendMessages.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

