/*
 * Decompiled with CFR 0.152.
 */
package pieces;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public abstract class Piece
extends Sprite {
    public static final byte BLACK_PAWN = 1;
    public static final byte BLACK_ROOK = 2;
    public static final byte BLACK_KNIGHT = 3;
    public static final byte BLACK_BISHOP = 4;
    public static final byte BLACK_QUEEN = 5;
    public static final byte BLACK_KING = 6;
    public static final byte WHITE_PAWN = 7;
    public static final byte WHITE_ROOK = 8;
    public static final byte WHITE_KNIGHT = 9;
    public static final byte WHITE_BISHOP = 10;
    public static final byte WHITE_QUEEN = 11;
    public static final byte WHITE_KING = 12;
    public static final int WHITE = 0;
    public static final int BLACK = 1;
    private int column;
    private int raw;
    protected Board myBoard;
    private int type;

    public Piece(Image image, Board board, int X, int Y, int color) {
        super(image);
        this.myBoard = board;
        this.column = X;
        this.raw = Y;
        this.type = color;
        this.defineReferencePixel(this.getWidth() / 2, this.getHeight());
        this.setPiecePos(X, Y);
    }

    public abstract boolean isLegalMove(int var1, int var2, boolean var3);

    public void setPiecePos(int X, int Y) {
        this.myBoard.map[this.raw][this.column] = null;
        this.myBoard.map[Y][X] = this;
        this.column = X;
        this.raw = Y;
        int xPos = this.myBoard.getCellWidth() * this.column + this.myBoard.getCellWidth() / 2;
        int yPos = this.myBoard.getCellHeight() * (this.raw + 1 + 1);
        this.setRefPixelPosition(xPos, yPos);
    }

    public void moveRefPixelPos(int dx, int dy) {
        this.setRefPixelPosition(this.getRefPixelX() + dx, this.getRefPixelY() + dy);
    }

    public int getColumn() {
        return this.column;
    }

    public int getRaw() {
        return this.raw;
    }

    public int getType() {
        return this.type;
    }

    public int getPieceName() {
        return 0;
    }

    public boolean isLineFree(int toColumn, int toRaw) {
        block8: {
            int j;
            int i;
            int deltaY;
            int deltaX;
            block7: {
                deltaX = Math.abs(toColumn - this.column);
                deltaY = Math.abs(toRaw - this.raw);
                if (deltaX != 0 && deltaY != 0 && deltaX != deltaY) {
                    return false;
                }
                if (toColumn != this.column) {
                    int n = deltaX = toColumn - this.column > 0 ? 1 : -1;
                }
                if (toRaw != this.raw) {
                    deltaY = toRaw - this.raw > 0 ? 1 : -1;
                }
                i = this.column;
                j = this.raw;
                if (deltaX == 0) break block7;
                i += deltaX;
                j += deltaY;
                while (i != toColumn) {
                    if (this.myBoard.map[j][i] != null) {
                        return false;
                    }
                    i += deltaX;
                    j += deltaY;
                }
                break block8;
            }
            if (deltaY == 0) break block8;
            i += deltaX;
            j += deltaY;
            while (j != toRaw) {
                if (this.myBoard.map[j][i] != null) {
                    return false;
                }
                i += deltaX;
                j += deltaY;
            }
        }
        return true;
    }
}

