/*
 * Decompiled with CFR 0.152.
 */
public class LoadGameMenu
implements MenuListener {
    private GameRecords gameRecords;
    private Menu menu;
    private int deleteMeIndex;

    public LoadGameMenu(AAChess midlet) {
        this.menu = midlet.menu;
        this.gameRecords = midlet.record;
        this.updateList();
        this.setCommands();
    }

    public void CommandAction(int keyCode) {
        if (keyCode == 6 && this.menu.size() > 0) {
            this.deleteMeIndex = this.menu.getSelectedRoot();
            this.menu.gotoAreUSureMenu("delete '" + this.menu.readData(this.menu.getSelectedRoot(), 0) + "' ?");
        } else if (keyCode == 7) {
            this.menu.gotoTopMenu();
        } else if (keyCode == 8 && this.menu.size() > 0) {
            this.gameRecords.openGame(this.menu.readData(this.menu.getSelectedRoot(), 0));
            this.menu.gotoStartGameMenu();
        }
    }

    public void updateList() {
        String[] gameList = this.gameRecords.getAllGameNames();
        int i = 0;
        while (i < gameList.length) {
            if (!gameList[i].equals("S_E_T")) {
                this.menu.appendRoot(gameList[i], 1);
            }
            ++i;
        }
    }

    private void setCommands() {
        if (this.menu.size() > 0) {
            this.menu.setCommands("Delete", "Back");
        } else {
            this.menu.setCommands("", "Back");
        }
    }

    public void selectYes() {
        this.menu.gotoLoadGameMenu();
        this.gameRecords.deleteGame(this.menu.readData(this.deleteMeIndex, 0));
        this.menu.removeRoot(this.deleteMeIndex);
        this.setCommands();
    }

    public void selectNo() {
        this.menu.gotoLoadGameMenu();
    }
}

