/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientConnectionHandler;
import java.io.IOException;
import javax.bluetooth.L2CAPConnection;
import javax.bluetooth.L2CAPConnectionNotifier;
import javax.microedition.io.Connector;

public class ConnectionService
implements Runnable {
    private final BluetoothClientPlayer listener;
    private final String url;
    private L2CAPConnectionNotifier connectionNotifier = null;
    private volatile boolean aborting;

    public ConnectionService(String url, BluetoothClientPlayer listener) {
        this.url = url;
        this.listener = listener;
        Thread thread = new Thread(this);
        thread.start();
    }

    public String getClientURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.aborting) {
            ConnectionService connectionService = this;
            synchronized (connectionService) {
                this.aborting = true;
            }
            try {
                this.connectionNotifier.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void run() {
        this.aborting = false;
        try {
            this.connectionNotifier = (L2CAPConnectionNotifier)Connector.open((String)this.url);
        }
        catch (IOException e) {
            this.aborting = true;
        }
        catch (SecurityException e) {
            this.aborting = true;
        }
        try {
            L2CAPConnection connection = this.connectionNotifier.acceptAndOpen();
            if (!this.aborting) {
                ClientConnectionHandler handler = new ClientConnectionHandler(this, connection, this.listener);
                this.listener.handleAcceptAndOpen(handler);
                this.connectionNotifier.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

