/*
 * Decompiled with CFR 0.152.
 */
package pieces;

import pieces.Piece;

public class King
extends Piece {
    public PlayCanvas canvas;

    public King(PlayCanvas canvas, int column, int raw, int type) {
        super(type == 1 ? PlayCanvas.kingBlack : PlayCanvas.kingWhite, canvas.board, column, raw, type);
        this.canvas = canvas;
        if (type == 1) {
            this.myBoard.blackKingCol = column;
            this.myBoard.blackKingRaw = raw;
        } else {
            this.myBoard.whiteKingCol = column;
            this.myBoard.whiteKingRaw = raw;
        }
    }

    public boolean isLegalMove(int toColumn, int toRaw, boolean forCapture) {
        int rookCol;
        Piece rook;
        int direction;
        if (this.myBoard.map[toRaw][toColumn] != null && this.getType() == this.myBoard.map[toRaw][toColumn].getType()) {
            return false;
        }
        if (Math.abs(toRaw - this.getRaw()) <= 1 && Math.abs(toColumn - this.getColumn()) <= 1) {
            return true;
        }
        int n = direction = toColumn - this.getColumn() > 0 ? 1 : -1;
        boolean castleRight = direction == -1 && this.getType() == 1 ? this.myBoard.blackCanCastleLeft : (direction == -1 && this.getType() == 0 ? this.myBoard.whiteCanCastleLeft : (direction == 1 && this.getType() == 1 ? this.myBoard.blackCanCastleRight : this.myBoard.whiteCanCastleRight));
        if (castleRight && toRaw == this.getRaw() && Math.abs(toColumn - this.getColumn()) == 2 && (rook = this.myBoard.map[toRaw][rookCol = toColumn - this.getColumn() > 0 ? 7 : 0]) != null && (rook.getPieceName() == 8 || rook.getPieceName() == 2) && this.isLineFree(rookCol, toRaw) && !King.isMate(this.myBoard, this.getType(), 0, 0, 0, 0) && !King.isMate(this.myBoard, this.getType(), this.getColumn(), toRaw, this.getColumn() + direction, toRaw)) {
            return !forCapture;
        }
        return false;
    }

    public int getPieceName() {
        if (this.getType() == 1) {
            return 6;
        }
        return 12;
    }

    public static boolean isMate(Board board, int type, int fromCol, int fromRaw, int toCol, int toRaw) {
        int kingCol;
        int kingRaw;
        if (type == 1) {
            kingRaw = board.blackKingRaw;
            kingCol = board.blackKingCol;
        } else {
            kingRaw = board.whiteKingRaw;
            kingCol = board.whiteKingCol;
        }
        Piece capturePiece = board.map[toRaw][toCol];
        board.map[toRaw][toCol] = board.map[fromRaw][fromCol];
        if (fromCol != toCol || fromRaw != toRaw) {
            board.map[fromRaw][fromCol] = null;
        }
        if (kingRaw == fromRaw && kingCol == fromCol) {
            kingRaw = toRaw;
            kingCol = toCol;
        }
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 8) {
                Piece piece = board.map[j][i];
                if (piece != null && piece.getType() != type && piece.isLegalMove(kingCol, kingRaw, true)) {
                    board.map[fromRaw][fromCol] = board.map[toRaw][toCol];
                    board.map[toRaw][toCol] = capturePiece;
                    return true;
                }
                ++j;
            }
            ++i;
        }
        board.map[fromRaw][fromCol] = board.map[toRaw][toCol];
        board.map[toRaw][toCol] = capturePiece;
        return false;
    }
}

