/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;

public class Game {
    public static final byte GameIsPlaying = 0;
    public static final byte GameFinished = 1;
    public static final byte GameShowScore = 2;
    public static final byte GamePaused = 3;
    public static final byte GameNeedEnterName = 4;
    public byte gameState;
    private static GameCanvas gameCanvas;
    private int gameType;
    private int gameDifficulty;
    public int prePausedGameTime;
    public long startTime;
    public static long addTime;
    public static long bonusTime;
    private int counter;
    World world;
    private int blinkCounter = 0;
    private char[] playerNameChars;
    private int currentCharSelection;
    private boolean needEnterName = true;
    private int scrollingDirection = 0;
    private Graphics gameGr;
    public static boolean keyPause;
    private static final int SOFTKEYS_OFFSET_X = 5;
    private static final int SOFTKEYS_OFFSET_Y = 5;
    private static final int PAUSE_BORDER_OFFSET_X = 18;
    private static final int PAUSE_BORDER_OFFSET_Y = 54;
    private static final int PAUSE_BORDER_HEIGHT = 120;
    private static final int CONGRAT_BORDER_OFFSET_Y = 45;
    private static final int CONGRAT_BORDER_HEIGHT = 160;
    private static final int GAME_FINISHED_OFFSET_Y = 90;
    private static final int GAME_FINISHED_HEIGHT = 90;

    public byte getGameState() {
        return this.gameState;
    }

    public boolean getNeedEnterName() {
        return this.needEnterName;
    }

    public Game(int gameType, int gameDifficulty, boolean isContinue) {
        try {
            keyPause = false;
            this.startTime = 0L;
            bonusTime = 0L;
            this.prePausedGameTime = 0;
            this.gameType = gameType;
            this.gameDifficulty = gameDifficulty;
            this.world = new World(gameType, gameDifficulty);
            addTime = 0L;
            this.gameGr = null;
            GameCanvas.getInstance.setLoadingProgress(80);
            this.gameState = 0;
            this.playerNameChars = GameCanvas.getLastPlayerName();
            this.currentCharSelection = 0;
        }
        catch (Exception e) {
            GameCanvas.addError("Game.Game()", e);
        }
    }

    public void unloadImages() {
        if (this.world != null) {
            this.world.unloadImages();
        }
    }

    public void prepareForSave() {
        if (this.world != null) {
            while (true) {
                if (!World.pictureMoving) {
                    if (!World.willReturnHere) {
                        if (!World.wasSwap) break;
                    }
                }
                this.world.process();
            }
        }
    }

    public void save(DataOutputStream dos) {
        try {
            System.out.println("Game.save - writting...");
            dos.writeByte(this.gameType);
            dos.writeByte(this.gameDifficulty);
            dos.writeInt(this.world.score);
            dos.writeLong(this.world.timeLeft);
            dos.writeInt(this.prePausedGameTime);
            for (int i = 0; i < this.world.Pieces.length; ++i) {
                for (int j = 0; j < this.world.Pieces[i].length; ++j) {
                    dos.writeByte((byte)this.world.Pieces[i][j].nX);
                    dos.writeByte((byte)this.world.Pieces[i][j].nY);
                    dos.writeByte((byte)this.world.Pieces[i][j].type);
                    dos.writeBoolean(this.world.Pieces[i][j].destroy);
                }
            }
            System.out.println("Game.save - wrote");
        }
        catch (Exception e) {
            System.out.println("Game.save error");
        }
    }

    public void load(DataInputStream dis) {
        try {
            System.out.println("Game.load - loading...");
            this.gameType = dis.readByte();
            this.gameDifficulty = dis.readByte();
            this.world.gameType = this.gameType;
            this.world.gameDifficulty = this.gameDifficulty;
            this.world.score = dis.readInt();
            this.world.timeLeft = dis.readLong();
            this.prePausedGameTime = dis.readInt();
            for (int i = 0; i < this.world.Pieces.length; ++i) {
                for (int j = 0; j < this.world.Pieces[i].length; ++j) {
                    this.world.Pieces[i][j].nX = dis.readByte();
                    this.world.Pieces[i][j].nY = dis.readByte();
                    this.world.Pieces[i][j].type = dis.readByte();
                    this.world.Pieces[i][j].destroy = dis.readBoolean();
                }
            }
            System.out.println("Game.load - loaded");
        }
        catch (Exception e) {
            System.out.println("Game.load error");
        }
    }

    public void draw(Graphics g, int width, int height) {
        if (this.gameGr == null) {
            this.gameGr = g;
        }
        try {
            if (this.gameState == 3) {
                keyPause = true;
                this.world.draw(g, width, height);
                this.drawPause(g, width, height);
                return;
            }
            if (this.gameState == 0) {
                this.world.draw(g, width, height);
                GameCanvas.drawSoftKeys(g, 5, 1);
            }
            if (this.gameState == 1) {
                keyPause = true;
                this.drawGameFinished(g, width, height);
            }
            if (this.gameState == 2) {
                keyPause = true;
                this.drawGameShowScore(g, width, height);
            }
            this.process();
        }
        catch (Exception e) {
            GameCanvas.addError("Game.draw", e);
        }
    }

    private void fillTriangle(Graphics g, int x, int y) {
        g.setColor(4286945);
        g.drawLine(x, y, x + 7, y);
        g.drawLine(x + 1, y + 1, x + 6, y + 1);
        g.drawLine(x + 2, y + 2, x + 5, y + 2);
        g.drawLine(x + 3, y + 3, x + 4, y + 3);
    }

    public void drawPause(Graphics g, int width, int height) {
        if (!Menu.drawMenuBorder(g, 18, 54, 120)) {
            return;
        }
        g.setColor(11591910);
        GameFont.drawString(Localization.extUpperCase(Localization.gameString[Localization.PAUSE][0]), g, 52, 0);
        int otstup = 52;
        int sizeBlock = GameCanvas.HEIGHT / 2 + Menu.imageMenu.getHeight() / 2 - otstup;
        int yCenterBlock = GameCanvas.HEIGHT / 2 + (otstup + sizeBlock / 2 - GameCanvas.HEIGHT / 2);
        int dy = GameFont.height(1);
        int heightInscription = Localization.gameString[Localization.PAUSE_TEXT].length * dy;
        int y = yCenterBlock - heightInscription / 2;
        int correct = 1;
        for (int i = 0; i < Localization.gameString[Localization.PAUSE_TEXT].length; ++i) {
            GameFont.drawString(Localization.extUpperCase(Localization.gameString[Localization.PAUSE_TEXT][i]), g, GameCanvas.WIDTH / 2 - GameFont.getStrWidth(Localization.extUpperCase(Localization.gameString[Localization.PAUSE_TEXT][i]), 1) / 2 - correct, y + dy * i, 1);
        }
        GameCanvas.drawSoftKeys(g, 0, 1);
        keyPause = false;
    }

    public void drawGameFinished(Graphics g, int width, int height) {
        String str = "";
        if (Menu.imageMainMenuBackground != null) {
            g.drawImage(Menu.imageMainMenuBackground, 0, 0, 20);
        } else if (this.world != null) {
            this.world.draw(g, width, height);
        }
        if (this.world.reason4EndGame == 0) {
            str = Localization.extUpperCase(Localization.gameString[Localization.NO_MORE_MOVES][0]);
        } else if (this.world.reason4EndGame == 1) {
            str = Localization.extUpperCase(Localization.gameString[Localization.TIME_IS_UP][0]);
        }
        String[] string = GameFont.transformString(str, 0, Menu.imageMenu.getWidth() - 10);
        Menu.needRollingScroll = false;
        Menu.drawMenuBorder(g, 18, 90, 90);
        g.setColor(11591910);
        int y = GameCanvas.HEIGHT / 2 - string.length * GameFont.height(0) / 2;
        int dy = GameFont.height(0);
        for (int i = 0; i < string.length; ++i) {
            GameFont.drawString(string[i], g, y + i * dy, 0);
        }
        keyPause = false;
    }

    public void drawGameShowScore(Graphics g, int width, int height) {
        if (Menu.imageMainMenuBackground != null) {
            g.drawImage(Menu.imageMainMenuBackground, 0, 0, 20);
        } else if (this.world != null) {
            this.world.draw(g, width, height);
        }
        if (!Menu.drawMenuBorder(g, 18, 45, 160)) {
            return;
        }
        int anc = 65;
        String str1 = Localization.extUpperCase(Localization.gameString[Localization.CONGRATULATIONS][0]);
        String str2 = Localization.extUpperCase(Localization.gameString[Localization.YOUR_SCORE_IS][0]);
        String str3 = Integer.toString(this.world.score);
        g.setColor(11591910);
        int y = 60;
        GameFont.drawString(str1, g, y, 1);
        GameFont.drawString(str2, g, y += 20, 1);
        GameFont.drawString(str3, g, y += 20, 1);
        int leftDrawString = 0;
        int rightDrawString = 5;
        if (this.needEnterName) {
            g.setColor(11591910);
            int x = width / 2;
            y += 30;
            if (GameFont.getStrWidth(Localization.extUpperCase(Localization.gameString[Localization.PLAYER_NAME][0]), 0) > GameCanvas.WIDTH - 32 - 10 + 2) {
                Menu.drawRunningString(g, Localization.extUpperCase(Localization.gameString[Localization.PLAYER_NAME][0]), 21, y, GameCanvas.WIDTH - 32 - 10, 0, 20, true);
            } else {
                GameFont.drawString(Localization.extUpperCase(Localization.gameString[Localization.PLAYER_NAME][0]), g, y, 0);
            }
            y += 25;
            int dx = GameFont.getStrWidth("W", 0);
            x = width / 2 - 7 * dx / 2 + 4;
            for (int i = 0; i < 7; ++i) {
                GameFont.drawString("" + this.playerNameChars[i], g, x + i * dx, y, 0);
            }
            ++this.blinkCounter;
            if (this.blinkCounter < 8) {
                GameFont.drawString("_", g, x + this.currentCharSelection * dx, y + 3, 0);
            } else if (this.blinkCounter > 10) {
                this.blinkCounter = 0;
            }
            rightDrawString = 1;
            leftDrawString = 0;
        }
        GameCanvas.drawSoftKeys(g, leftDrawString, rightDrawString);
        keyPause = false;
    }

    public boolean isGameFinished() {
        if (this.world == null) {
            return true;
        }
        return this.world.isFinished();
    }

    public void process() {
        if (this.scrollingDirection != 0) {
            if (this.counter == 10) {
                this.makeScrolling(this.scrollingDirection);
            }
            ++this.counter;
        }
        if (this.gameState == 0) {
            if (addTime != 0L) {
                bonusTime += addTime / (long)(GameCanvas.optionsGameDifficulty + 1);
            }
            addTime = 0L;
            this.world.timeLeft = (long)(120000 - (int)(System.currentTimeMillis() - this.startTime + (long)this.prePausedGameTime)) + bonusTime;
            if (this.world.timeLeft > 120000L) {
                this.startTime = System.currentTimeMillis();
                this.world.timeLeft = 120000L;
                bonusTime = 0L;
            }
            this.world.process();
            if (this.world.isFinished()) {
                this.gameState = 1;
                this.counter = 0;
            }
        }
        if (this.gameState == 1) {
            ++this.counter;
            if (this.counter == 83) {
                if (GameCanvas.canBeAdded(this.world.score, GameCanvas.currentGameType)) {
                    this.needEnterName = true;
                }
                Menu.needRollingScroll = true;
                this.gameState = (byte)2;
            }
        }
    }

    public int processKey(int keyCode, int gameAction, boolean isPressed) {
        if (!isPressed) {
            this.scrollingDirection = 0;
            return 0;
        }
        if (keyCode == 42) {
            return 0;
        }
        if (this.gameState == 2) {
            if (this.needEnterName) {
                if (gameAction == 2) {
                    --this.currentCharSelection;
                    if (this.currentCharSelection < 0) {
                        this.currentCharSelection = 6;
                    }
                }
                if (gameAction == 5) {
                    ++this.currentCharSelection;
                    if (this.currentCharSelection > 6) {
                        this.currentCharSelection = 0;
                    }
                }
                if (gameAction == 1) {
                    this.scrollingDirection = 1;
                    this.counter = 0;
                    this.makeScrolling(this.scrollingDirection);
                }
                if (gameAction == 6) {
                    this.scrollingDirection = -1;
                    this.counter = 0;
                    this.makeScrolling(this.scrollingDirection);
                }
                if (keyCode == -7 || keyCode == -11) {
                    this.playerNameChars[this.currentCharSelection] = 32;
                }
                if (keyCode == -6) {
                    String playerName = "";
                    for (int i = 0; i < 7; ++i) {
                        playerName = playerName + this.playerNameChars[i];
                    }
                    System.out.println("playerName = \"" + playerName + "\"");
                    if (playerName.compareTo("       ") == 0) {
                        playerName = Localization.gameString[Localization.DEFAULT_PLAYER_NAME][0];
                    }
                    System.out.println("playerName = \"" + playerName + "\"");
                    GameCanvas.addScore(playerName, this.world.score, this.world.gameType);
                    GameCanvas.saveSettings();
                    Menu.needRollingScroll = true;
                    return 1;
                }
            } else {
                if (keyCode == -6) {
                    Menu.needRollingScroll = true;
                    return 2;
                }
                if (keyCode == -7 || keyCode == -11) {
                    GameCanvas.saveSettings();
                    return 1;
                }
            }
            return 0;
        }
        if (this.gameState == 3) {
            if (keyCode == -7 || keyCode == -11) {
                return 1;
            }
            if (keyCode == -6) {
                this.resume();
                return 0;
            }
        }
        if (this.gameState == 0) {
            if (keyCode == -7 || keyCode == -11) {
                this.pause();
            }
            if (keyCode == 35) {
                this.world.showHint();
                return 0;
            }
            if (gameAction == 8 || keyCode == 53) {
                this.world.fire();
            }
            if (gameAction == 2 || keyCode == 52) {
                this.world.left();
            }
            if (gameAction == 5 || keyCode == 54) {
                this.world.right();
            }
            if (gameAction == 1 || keyCode == 50) {
                this.world.up();
            }
            if (gameAction == 6 || keyCode == 56) {
                this.world.down();
            }
        }
        return 0;
    }

    private void makeScrolling(int direction) {
        if (this.counter != 0) {
            this.counter = 5;
        }
        int n = this.currentCharSelection;
        this.playerNameChars[n] = (char)(this.playerNameChars[n] + direction);
        if (this.playerNameChars[this.currentCharSelection] == '!') {
            this.playerNameChars[this.currentCharSelection] = 65;
        }
        if (this.playerNameChars[this.currentCharSelection] == '[') {
            this.playerNameChars[this.currentCharSelection] = 32;
        }
        if (this.playerNameChars[this.currentCharSelection] == '\u001f') {
            this.playerNameChars[this.currentCharSelection] = 90;
        }
        if (this.playerNameChars[this.currentCharSelection] == '@') {
            this.playerNameChars[this.currentCharSelection] = 32;
        }
    }

    public void pause() {
        if (World.pictureMoving || !World.willReturnHere) {
            while (World.pictureMoving || World.willReturnHere) {
                this.world.process();
            }
        }
        this.scrollingDirection = 0;
        Menu.needRollingScroll = true;
        if (this.gameState == 0) {
            this.gameState = (byte)3;
            this.prePausedGameTime += (int)(System.currentTimeMillis() - this.startTime);
        }
        System.gc();
        World.pictureMoving = false;
        World.willReturnHere = false;
    }

    public void resume() {
        byte by = this.gameState = this.isGameFinished() ? (byte)1 : 0;
        if (this.world != null) {
            this.world.resume();
        }
        this.startTime = System.currentTimeMillis();
    }

    public void close() {
    }
}

