/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameFont {
    private static Image[] fontFP = new Image[138];
    private static Image[] fontFT = new Image[89];
    private static Image[] fontBIG = new Image[89];
    private static Image[] fontBUT = new Image[12];
    private static byte[] fontFT_adaptor = new byte[256];
    private static byte[] fontFP_adaptor = new byte[256];
    private static byte[] fontBIG_adaptor = new byte[256];
    private static byte[] fontBUT_adaptor = new byte[256];
    private static final String PATH_FP = "/fp";
    private static final String PATH_FT = "/ft";
    private static final String PATH_BUT = "/numbers";
    private static final int diesW = 9;
    public static final int fontFpH = 20;
    public static final int fontFtH = 15;
    private static final int FP_SPACE = 9;
    private static final int FT_SPACE = 6;
    private static final int FP_LET_SPACE = 0;
    private static final int FT_LET_SPACE = 0;
    private static final int FBIG_LET_SPACE = 1;
    public static final int FONT_FP_BASIC = 0;
    public static final int FONT_FT_BOLD = 1;
    public static GameFont getInstance;

    public void GameFont() {
        getInstance = this;
    }

    public static void initFont() {
        GameFont.readDataFile(PATH_FP, fontFP_adaptor, fontFP, 0);
        GameFont.readDataFile(PATH_FT, fontFT_adaptor, fontFT, 0);
        GameFont.readDataFile(PATH_BUT, fontBUT_adaptor, fontBUT, 0);
    }

    public static void readDataFile(String path, byte[] adaptor, Image[] img, int start_index) {
        InputStream is = new Object().getClass().getResourceAsStream(path);
        byte[] buff = new byte[]{};
        try {
            buff = new byte[is.available()];
            is.read(buff);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int img_numb = buff[0] & 0xFF;
        for (int i = 0; i < img_numb; ++i) {
            int shift = 2 + 5 * i;
            int istart = ((buff[3 + shift] & 0xFF) << 24) + ((buff[2 + shift] & 0xFF) << 16) + ((buff[1 + shift] & 0xFF) << 8) + (buff[shift] & 0xFF);
            shift = 2 + 5 * (i + 1);
            int iend = ((buff[3 + shift] & 0xFF) << 24) + ((buff[2 + shift] & 0xFF) << 16) + ((buff[1 + shift] & 0xFF) << 8) + (buff[shift] & 0xFF);
            adaptor[buff[5 * i + 1] & 0xFF] = (byte)(i + start_index);
            img[i + start_index] = Image.createImage((byte[])buff, (int)istart, (int)(iend - istart));
        }
        buff = null;
        System.out.println("Reading font " + path + " completed!");
    }

    public static int drawChar(Graphics g, int i, int x, int y, int font, boolean forward) {
        Image[] curr_font = null;
        byte[] curr_adaptor = null;
        int fontSpace = 0;
        int space_w = 0;
        i &= 0xFF;
        int anchor = forward ? 17 : 24;
        if (font == 0) {
            curr_font = fontFP;
            curr_adaptor = fontFP_adaptor;
            space_w = 9;
            fontSpace = 0;
        } else if (font == 1) {
            curr_font = fontFT;
            curr_adaptor = fontFT_adaptor;
            space_w = 6;
            fontSpace = 0;
        }
        if (i == 32) {
            return space_w;
        }
        if (i == 73 && font == 1) {
            fontSpace = 2;
        }
        if (i == 41) {
            x -= 2;
        }
        if (i == 47 && font == 1) {
            g.drawImage(fontFT[fontFP_adaptor[i] & 0xFF], x, y, anchor);
            return fontFT[fontFT_adaptor[i] & 0xFF].getWidth();
        }
        if (i == 35 || i == 42) {
            g.drawImage(fontBUT[fontBUT_adaptor[i] & 0xFF], x + 2, y + 1, anchor);
            return fontBUT[fontBUT_adaptor[i] & 0xFF].getWidth();
        }
        g.drawImage(curr_font[curr_adaptor[i] & 0xFF], x, y, anchor);
        return curr_font[curr_adaptor[i] & 0xFF].getWidth() + fontSpace;
    }

    public static void drawNameString(String s, Graphics g, int y, int font, int blinkCounter) {
        int w = 0;
        int width = GameFont.getStrWidth(s, font);
        int x = (GameCanvas.WIDTH - width) / 2;
        for (int i = 0; i < s.length(); ++i) {
            byte f = (byte)s.charAt(i);
            if (blinkCounter % 16 > 8 && i == Menu.currentCharSelection) {
                w += fontBIG[fontBIG_adaptor[i] & 0xFF].getWidth();
                continue;
            }
            w += GameFont.drawChar(g, f, x + w, y, font, true);
        }
    }

    public static void drawString(String s, Graphics g, int y, int font) {
        int width = GameFont.getStrWidth(s, font);
        if (width > GameCanvas.WIDTH) {
            width = GameCanvas.WIDTH;
        }
        GameFont.drawString(s, g, (GameCanvas.WIDTH - width) / 2, y, font);
    }

    public static void drawString(String s, Graphics g, int x, int y, int font) {
        int w = 0;
        x = font == 0 && w == 0 ? (x += 5) : (x += 4);
        for (int i = 0; i < s.length(); ++i) {
            byte f = (byte)s.charAt(i);
            w += GameFont.drawChar(g, f, x + w, y, font, true);
            if (font == 0) continue;
            ++w;
        }
    }

    public static void drawMenuString(String s, Graphics g, int offset_x, int y, int font) {
        int j = s.indexOf(95);
        String str = s.substring(j + 1);
        GameFont.drawString(str, g, (GameCanvas.WIDTH - GameFont.menuStrWidth(str, font)) / 2 + offset_x, y, font);
    }

    public static int height(int font) {
        if (font == 0) {
            return 20;
        }
        if (font == 1) {
            return 15;
        }
        return 0;
    }

    public static int getStrWidth(String s, int font) {
        int w = 0;
        Image[] img = null;
        byte[] adaptor = null;
        int space_w = 0;
        int let_space = 0;
        if (font == 0) {
            img = fontFP;
            adaptor = fontFP_adaptor;
            space_w = 9;
            let_space = 0;
        } else if (font == 1) {
            img = fontFT;
            adaptor = fontFT_adaptor;
            space_w = 6;
            let_space = 0;
            s = Localization.extUpperCase(s);
        }
        int tmpLetSpace = let_space;
        for (int i = 0; i < s.length(); i = (int)((byte)(i + 1))) {
            int f = s.charAt(i) & 0xFF;
            let_space = f == 73 && font == 1 ? 2 : tmpLetSpace;
            w = f == 32 ? (w += space_w) : (w += img[adaptor[f] & 0xFF].getWidth());
            if (font != 0) {
                ++w;
            }
            w += let_space;
        }
        return w;
    }

    public static int menuStrWidth(String s, int font) {
        int j = s.indexOf(95);
        return GameFont.getStrWidth(s.substring(j + 1), font);
    }

    public static String[] transformString(String str, int font, int width) {
        String cur_str = "";
        Vector<String> all = new Vector<String>();
        int start = 0;
        int end = 0;
        while (end != -1 && start < str.length()) {
            end = str.indexOf(" ", start);
            if (end == -1) {
                end = str.length() - 1;
            }
            if (GameFont.getStrWidth(cur_str + str.substring(start, end), font, false) <= width) {
                cur_str = cur_str + str.substring(start, end + 1);
                start = end + 1;
                continue;
            }
            cur_str = cur_str.substring(0, cur_str.length() - 1);
            all.addElement(cur_str);
            cur_str = "";
        }
        if (cur_str != "") {
            all.addElement(cur_str);
        }
        String[] res = new String[all.size()];
        for (int i = 0; i < all.size(); ++i) {
            res[i] = (String)all.elementAt(i);
        }
        return res;
    }

    public static int getStrWidth(String s, int font, boolean menu) {
        int w = 0;
        Image[] img = null;
        byte[] adaptor = null;
        int space_w = 0;
        int let_space = 0;
        if (font == 0) {
            img = fontFP;
            adaptor = fontFP_adaptor;
            space_w = 9;
            let_space = 0;
        } else if (font == 1) {
            img = fontFT;
            adaptor = fontFT_adaptor;
            space_w = 6;
        }
        int j = -1;
        if (menu) {
            j = s.indexOf(95);
        }
        for (int i = j + 1; i < s.length(); ++i) {
            int f = s.charAt(i) & 0xFF;
            w = f == 32 ? (w += space_w) : (w += img[adaptor[f] & 0xFF].getWidth());
            if (font != 0) {
                ++w;
            }
            w += let_space;
        }
        return w;
    }
}

