/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Menu {
    private static final byte STATE_SETTINGS = 12;
    private static final byte STATE_HI_SCORES = 13;
    private static final byte STATE_HELP = 14;
    private static final byte STATE_ABOUT = 15;
    private static final byte STATE_CHOICE_LEVEL = 16;
    private static final byte STATE_CONFIRM_EXIT = 17;
    private static final byte STATE_MAIN_MENU = 18;
    private static final byte STATE_CONFIRM_START = 19;
    private static final byte STATE_CONFIRM_RESET = 20;
    private static final byte STATE_TELL_A_FRIEND = 21;
    private static final byte STATE_MORE_GAMES = 22;
    private static final byte STATE_NAME_INPUT = 23;
    private static final byte STATE_UPLOAD = 24;
    private byte menuState;
    private boolean isAfterGameHS;
    private boolean hasContinue;
    private boolean paused = false;
    private static final int MENU_POS_NUM = 9;
    private static final int BORDER_OFFSET_X = 16;
    private static final int BORDER_OFFSET_Y = 40;
    private static final int BORDER_HEIGHT = 160;
    private static final int BORDER_OFFSET_INSIDE = 5;
    private static final int CONFIRM_BORDER_OFFSET_Y = 80;
    private static final int CONFIRM_BORDER_HEIGHT = 70;
    private static final int HEADER_OFFSET_Y = 12;
    private static final int DELTA_FONT_HEIGHT_OPTIONS = 6;
    private static final int DELTA_FONT_HEIGHT_HISCORES = -1;
    private static final int DELTA_FIRST_POSITION_HISCORES = 4;
    private static final int DELTA_GAMETYPE_POSITION = 2;
    private static final int FACTOR_SCROLL_HEIGHT = 10;
    private static final int ARROW_CORRECTION_OTPIONS = -1;
    private static final int ARROW_CORRECTION_HISCORES = -1;
    public static final int SK_OK = 0;
    public static final int SK_BACK = 1;
    public static final int SK_CANSEL = 2;
    public static final int SK_NONE = 5;
    public static final int QUANTITY_BUTTONS = 3;
    private int textHieght;
    private String curString;
    private int linesOnScreen;
    private int nLines;
    private int scrollingDirection = 0;
    private int counterScroll = 0;
    private int[] breaks;
    private int shiftStep = 3;
    private int shiftNum = 0;
    private int currentShiftText = 0;
    public static GameMidlet gameMidlet;
    private static GameCanvas gameCanvas;
    private int currentSelection;
    public static final int HI_SCORES_POS_NUM = 5;
    public static final int PLAYERNAME_LENGTH = 7;
    public static int user_highscore;
    public static int[] scores;
    public static long[] scorestime;
    private static char[] lastPlayerName;
    char[] playerNameChars;
    public static int currentCharSelection;
    public static int optionsGameType;
    public static int optionsGameDifficulty;
    public static boolean optionsSoundOn;
    public static boolean optionsMusicOn;
    private int currentHiScoresPage;
    private int maxLevelAvailable;
    private static final int INTRO_TIME = 66;
    private static int counter;
    private static final int MENU_ITEM_DOWN_OFFSET = 0;
    private static final int MENU_ITEM_TEXT_OFFSET = 10;
    private static final int TIME4SLIDE_FIRST = 30;
    private static final int TIME4SLIDE_ALL = 30;
    private static boolean isIntroShown;
    private boolean needDrawLeftArrowPressed = false;
    private boolean needDrawRightArrowPressed = false;
    private boolean needInitBreaks = true;
    private static boolean isKeysEnable;
    private int linesCounter;
    private static final int linesInSplashAnimation = 15;
    private static final int quantityStepAnimationMenuItem = 10;
    private static int stepAnimationMenuItem;
    private static int posYAnimationMenuItem;
    private static int posYMenuItem;
    private int prevGameType = 0;
    private int prevGameDifficulty = 0;
    private int prevGameLanguage = 0;
    public static final int YELLOW = 15394819;
    public static final int GOLD = 0xFFDD00;
    public static final int LIGHTBLUE = 11591910;
    public static final int THERMOMETER_BLUE = 2045527;
    public static final int THERMOMETER_RED = 14943493;
    public static final int THERMOMETER_ORANGE = 16556572;
    public static final int TEXT_COLOR = 11591910;
    public static boolean needRollingScroll;
    private static int rollCounter;
    private static int keysBlockCounter;
    private static final int KEYS_BLOCK_TIME = 4;
    private static final int ROLL_TIME_SLIDE = 4;
    public static Image imageMainMenuBackground;
    private static Image imageMenuItem;
    private static Image imageLeftArrowPressed;
    private static Image imageRightArrowPressed;
    private static Image imageLeftArrow;
    private static Image imageRightArrow;
    private static Image imageRollTop;
    public static Image imageMenu;
    public static Image[] iButtons;
    public static Image snowflake;
    private static int rollHeight;
    private boolean uploadOk = false;
    Random r = new Random(System.currentTimeMillis());
    private byte[] isf = new byte[GameCanvas.WIDTH / 2];
    private int[] xsf = new int[GameCanvas.WIDTH / 2];
    private int[] xnsf = new int[GameCanvas.WIDTH / 2];
    private int[] ysf = new int[GameCanvas.WIDTH / 2];
    private int[] xsfStep = new int[GameCanvas.WIDTH / 2];
    private int[] ysfStep = new int[GameCanvas.WIDTH / 2];
    private int[] xsfLimit = new int[GameCanvas.WIDTH / 2];
    int blinkCounter = 0;
    private boolean scrolling = false;
    private static int sizeWindow;
    private static int runningCounter;
    private static int runningDirection;
    private static String runningString;

    public byte getMenuState() {
        return this.menuState;
    }

    public void setCurrentSelection(int i) {
        this.currentSelection = i;
    }

    public Menu(boolean hasCont, GameMidlet gm) {
        this.hasContinue = hasCont;
        this.menuState = (byte)18;
        this.currentSelection = 0;
        this.currentHiScoresPage = 0;
        this.isAfterGameHS = false;
        this.maxLevelAvailable = GameCanvas.maxLevelAvailable[GameCanvas.optionsGameType];
        gameMidlet = gm;
        iButtons = new Image[3];
        this.breaks = new int[100];
        posYAnimationMenuItem = 0;
        this.linesCounter = GameCanvas.HEIGHT / 15 + 15;
        stepAnimationMenuItem = (GameCanvas.HEIGHT - 0) / 10;
        GameCanvas.getInstance.setLoadingProgress(40);
    }

    public void menuInit() {
        try {
            imageMainMenuBackground = GameCanvas.imageLogo;
            imageMenuItem = Image.createImage((String)"/mi");
            imageLeftArrowPressed = Image.createImage((String)"/arpl");
            imageRightArrowPressed = Image.createImage((String)"/arpr");
            GameCanvas.getInstance.setLoadingProgress(60);
            imageLeftArrow = Image.createImage((String)"/arl");
            imageRightArrow = Image.createImage((String)"/arr");
            try {
                snowflake = Image.createImage((String)"/sf1");
            }
            catch (Exception e) {
                snowflake = Image.createImage((int)1, (int)1);
            }
            try {
                for (int i = 0; i < 3; ++i) {
                    Menu.iButtons[i] = Image.createImage((String)("/bt" + String.valueOf(i)));
                }
            }
            catch (IOException ex) {
                System.err.println("btN.png not loaded");
            }
            GameCanvas.getInstance.setLoadingProgress(80);
            if (imageRollTop == null) {
                imageMenu = Image.createImage((String)"/menu");
                rollHeight = imageMenu.getHeight();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < GameCanvas.WIDTH / 2; ++i) {
            this.isf[i] = (byte)Math.abs(this.r.nextInt() % 3);
            this.xsf[i] = Math.abs(this.r.nextInt() % GameCanvas.WIDTH);
            this.xnsf[i] = this.xsf[i];
            this.ysf[i] = -5;
            this.xsfStep[i] = Math.abs(this.r.nextInt() % 2);
            this.xsfLimit[i] = Math.abs(this.r.nextInt() % 6) * 3;
            while (this.xsfLimit[i] == 0) {
                this.xsfLimit[i] = Math.abs(this.r.nextInt() % 6) * 3;
            }
            this.ysfStep[i] = Math.abs(this.r.nextInt() % 4);
            while (this.ysfStep[i] == 0) {
                this.ysfStep[i] = Math.abs(this.r.nextInt() % 4);
            }
        }
    }

    public void unloadImages() {
        imageMainMenuBackground = null;
        imageMenuItem = null;
        imageLeftArrowPressed = null;
        imageRightArrowPressed = null;
        imageLeftArrow = null;
        imageRightArrow = null;
    }

    public void setHiScoresState() {
        this.currentHiScoresPage = GameCanvas.optionsGameType;
        this.isAfterGameHS = true;
        this.menuState = (byte)13;
    }

    private void drawMoreGames(Graphics g) {
        g.drawString("More Games = " + Localization.gameString[Localization.MORE_GAMES_URL][0], 5, 5, 0);
    }

    public void draw(Graphics g) {
        ++counter;
        if (!isIntroShown) {
            this.showIntro(g);
            return;
        }
        if (GameCanvas.optionsMusicOn && GameCanvas.primeStart) {
            GameCanvas.soundPlayer.play(0, true, true);
            GameCanvas.primeStart = false;
        }
        if (GameCanvas.primeStart) {
            GameCanvas.primeStart = false;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GameCanvas.keyCodeQueueMarker = 0;
        }
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        g.drawImage(imageMainMenuBackground, 0, 0, 20);
        if (this.paused) {
            Menu.drawMenuBorder(g, 16, 80, 70);
            g.setColor(11591910);
            GameFont.drawString(Localization.gameString[Localization.PAUSE][0], g, GameCanvas.HEIGHT / 2 - GameFont.height(0) / 2, 0);
            GameCanvas.drawSoftKeys(g, 5, 1);
            return;
        }
        this.showSnowflakes(g);
        switch (this.menuState) {
            case 16: 
            case 18: {
                this.showMainMenu(g);
                break;
            }
            case 12: {
                this.showOptions(g);
                break;
            }
            case 13: {
                this.showHiScores(g);
                break;
            }
            case 14: 
            case 15: {
                this.showHelp(g);
                break;
            }
            case 19: {
                this.showConfirm(g);
                break;
            }
            case 17: {
                this.showConfirm(g);
                break;
            }
            case 20: {
                this.showConfirm(g);
            }
        }
    }

    private void showSnowflakes(Graphics g) {
        int k = Math.abs(this.r.nextInt() % (GameCanvas.WIDTH / 2));
        if (this.ysf[k] == -5) {
            this.ysf[k] = -4;
        }
        for (int i = 0; i < GameCanvas.WIDTH / 2; ++i) {
            if (this.ysf[i] <= -5) continue;
            if (this.isf[i] == 0) {
                g.drawImage(snowflake, this.xsf[i], this.ysf[i], 0);
            } else {
                g.setColor(255, 255, 255);
                g.fillRect(this.xsf[i], this.ysf[i], 2, 2);
            }
            int n = i;
            this.xsf[n] = this.xsf[n] + this.xsfStep[i];
            if (this.xsf[i] >= this.xnsf[i] + this.xsfLimit[i] || this.xsf[i] <= this.xnsf[i] - this.xsfLimit[i]) {
                this.xsfStep[i] = -this.xsfStep[i];
            }
            int n2 = i;
            this.ysf[n2] = this.ysf[n2] + this.ysfStep[i];
            if (this.ysf[i] < GameCanvas.HEIGHT) continue;
            this.isf[i] = (byte)Math.abs(this.r.nextInt() % 3);
            this.xsf[i] = Math.abs(this.r.nextInt() % GameCanvas.WIDTH);
            this.xnsf[i] = this.xsf[i];
            this.ysf[i] = -5;
            this.xsfStep[i] = Math.abs(this.r.nextInt() % 2);
            this.xsfLimit[i] = Math.abs(this.r.nextInt() % 6) * 3;
            while (this.xsfLimit[i] == 0) {
                this.xsfLimit[i] = Math.abs(this.r.nextInt() % 6) * 3;
            }
            this.ysfStep[i] = Math.abs(this.r.nextInt() % 4);
            while (this.ysfStep[i] == 0) {
                this.ysfStep[i] = Math.abs(this.r.nextInt() % 4);
            }
        }
    }

    private void showIntro(Graphics g) {
        if (counter < this.linesCounter + 10 + 1) {
            if (counter < this.linesCounter) {
                for (int i = 1; i <= 15; ++i) {
                    g.setClip(0, (counter - i) * 15, GameCanvas.WIDTH, i);
                    g.drawImage(imageMainMenuBackground, 0, 15 - i, 20);
                }
            } else {
                if ((posYAnimationMenuItem += stepAnimationMenuItem) >= GameCanvas.HEIGHT - imageMenuItem.getHeight() - 0) {
                    posYMenuItem = posYAnimationMenuItem = GameCanvas.HEIGHT - imageMenuItem.getHeight() - 0;
                }
                g.drawImage(imageMainMenuBackground, GameCanvas.WIDTH / 2, GameCanvas.HEIGHT / 2, 3);
                this.showSnowflakes(g);
                g.drawImage(imageMenuItem, GameCanvas.WIDTH / 2, posYAnimationMenuItem, 17);
            }
        } else {
            isIntroShown = true;
            System.gc();
        }
    }

    private void showMainMenu(Graphics g) {
        String drawString = this.currentString(this.currentSelection);
        g.drawImage(imageMenuItem, GameCanvas.WIDTH / 2, posYMenuItem, 17);
        if (this.needDrawLeftArrowPressed) {
            g.drawImage(imageLeftArrowPressed, (GameCanvas.WIDTH - imageMenuItem.getWidth()) / 2 + 4, posYMenuItem + 7, 20);
        }
        if (this.needDrawRightArrowPressed) {
            g.drawImage(imageRightArrowPressed, (GameCanvas.WIDTH + imageMenuItem.getWidth()) / 2 - 2, posYMenuItem + 9, 24);
        }
        g.setColor(11591910);
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        if (GameFont.getStrWidth(drawString, 0) <= imageMenuItem.getWidth() - imageMenuItem.getWidth() / 7 * 2 + 4) {
            GameFont.drawString(drawString, g, posYMenuItem + 10, 0);
        } else {
            Menu.drawRunningString(g, drawString, GameCanvas.WIDTH / 2 - imageMenuItem.getWidth() / 2 + imageMenuItem.getWidth() / 7 - 2, posYMenuItem + 10, imageMenuItem.getWidth() - imageMenuItem.getWidth() / 7 * 2 + 4, 0, 20, true);
        }
        GameCanvas.drawSoftKeys(g, 0, 1);
    }

    private void showOptions(Graphics g) {
        boolean mbPainted = Menu.drawMenuBorder(g, 16, 40, 160);
        if (!mbPainted) {
            return;
        }
        String[] drawString = new String[4];
        g.setColor(11591910);
        GameFont.drawString(Localization.gameString[Localization.SETTINGS][0], g, 52, 0);
        drawString[0] = Localization.extUpperCase(Localization.gameString[Localization.TYPE][0] + Localization.gameString[Localization.GAME_TYPES][GameCanvas.optionsGameType]);
        drawString[1] = Localization.extUpperCase(Localization.gameString[Localization.DIFFICULTY][0] + Localization.gameString[Localization.DIFFICULTY_TYPE][GameCanvas.optionsGameDifficulty]);
        drawString[2] = Localization.extUpperCase(Localization.gameString[Localization.LANGUAGE][0] + Localization.gameString[Localization.LANG][GameCanvas.optionsLanguage]);
        drawString[3] = Localization.extUpperCase(Localization.gameString[Localization.MUSIC][0] + ": " + Localization.gameString[Localization.SOUND_TYPES][GameCanvas.optionsMusicOn ? 0 : 1]);
        int dx = 4;
        int dy = GameFont.height(1) + 6;
        int y = 40 + GameFont.height(0) / 2 + 80 - 4 * dy / 2;
        boolean isSelectedStringToLarge = GameFont.getStrWidth(drawString[this.currentSelection], 1) > GameCanvas.WIDTH - 32 - 10 - imageLeftArrow.getWidth() - imageRightArrow.getWidth();
        int dxArrow = dx + (isSelectedStringToLarge ? GameCanvas.WIDTH - 32 - 12 - imageLeftArrow.getWidth() - imageRightArrow.getWidth() : GameFont.getStrWidth(drawString[this.currentSelection], 1)) / 2;
        g.drawImage(imageLeftArrow, GameCanvas.WIDTH / 2 - dxArrow, y + this.currentSelection * dy + -1, 24);
        g.drawImage(imageRightArrow, GameCanvas.WIDTH / 2 + dxArrow, y + this.currentSelection * dy + -1, 20);
        if (this.needDrawLeftArrowPressed) {
            g.drawImage(imageLeftArrowPressed, GameCanvas.WIDTH / 2 - dxArrow, y + this.currentSelection * dy + -1, 24);
        }
        if (this.needDrawRightArrowPressed) {
            g.drawImage(imageRightArrowPressed, GameCanvas.WIDTH / 2 + dxArrow, y + this.currentSelection * dy + -1, 20);
        }
        for (int i = 0; i < drawString.length; ++i) {
            if (GameFont.getStrWidth(drawString[i], 1) <= GameCanvas.WIDTH - 32 - 10 - imageLeftArrow.getWidth() - imageRightArrow.getWidth()) {
                GameFont.drawString(drawString[i], g, GameCanvas.WIDTH / 2 - GameFont.getStrWidth(drawString[i], 1) / 2 + -1, y + i * dy, 1);
                continue;
            }
            Menu.drawRunningString(g, drawString[i], 21 + imageLeftArrow.getWidth(), y + i * dy, GameCanvas.WIDTH - 32 - 10 - imageLeftArrow.getWidth() - imageRightArrow.getWidth(), 20, i == this.currentSelection);
        }
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        GameCanvas.drawSoftKeys(g, 0, 1);
    }

    private void showHiScores(Graphics g) {
        boolean mbPainted;
        if (this.isAfterGameHS) {
            this.currentHiScoresPage = GameCanvas.currentGameType;
        }
        if (!(mbPainted = Menu.drawMenuBorder(g, 16, 40, 160))) {
            return;
        }
        int x = GameCanvas.WIDTH / 2 + -1;
        int y = 52;
        String drawString = Localization.extUpperCase(Localization.gameString[Localization.HIGH_SCORES][0]);
        g.setColor(11591910);
        GameFont.drawString(drawString, g, y, 0);
        drawString = Localization.extUpperCase(Localization.gameString[Localization.GAME_TYPES][this.currentHiScoresPage]);
        int dx = 4;
        boolean isSelectedStringToLarge = GameFont.getStrWidth(drawString, 1) > GameCanvas.WIDTH - 32 - 10 - imageLeftArrow.getWidth() - imageRightArrow.getWidth();
        int dxArrow = dx + (isSelectedStringToLarge ? GameCanvas.WIDTH - 32 - 12 - imageLeftArrow.getWidth() - imageRightArrow.getWidth() : GameFont.getStrWidth(drawString, 1)) / 2;
        g.drawImage(imageLeftArrow, GameCanvas.WIDTH / 2 - dxArrow, (y += GameFont.height(1) * 2 - GameFont.height(1)) + -1, 24);
        g.drawImage(imageRightArrow, GameCanvas.WIDTH / 2 + dxArrow, y + -1, 20);
        if (this.needDrawLeftArrowPressed) {
            g.drawImage(imageLeftArrowPressed, GameCanvas.WIDTH / 2 - dxArrow, y + -1, 24);
        }
        if (this.needDrawRightArrowPressed) {
            g.drawImage(imageRightArrowPressed, GameCanvas.WIDTH / 2 + dxArrow, y + -1, 20);
        }
        if (GameFont.getStrWidth(drawString, 1) <= GameCanvas.WIDTH - 32 - 10 - imageLeftArrow.getWidth() - imageRightArrow.getWidth()) {
            GameFont.drawString(drawString, g, x - GameFont.getStrWidth(drawString, 1) / 2, y, 1);
        } else {
            Menu.drawRunningString(g, drawString, 21 + imageLeftArrow.getWidth(), y, GameCanvas.WIDTH - 32 - 10 - imageLeftArrow.getWidth() - imageRightArrow.getWidth(), 20, true);
        }
        y += GameFont.height(1) + 4;
        int ddy = GameFont.height(1) + -1;
        for (int i = 0; i < 5; ++i) {
            drawString = Integer.toString(i + 1) + ". " + GameCanvas.playerNames[this.currentHiScoresPage][i];
            GameFont.drawString(drawString, g, 21, y, 1);
            drawString = "" + GameCanvas.scores[this.currentHiScoresPage][i];
            GameFont.drawString(drawString, g, GameCanvas.WIDTH - 16 - 5 - GameFont.getStrWidth(drawString, 1), y, 1);
            y += ddy;
        }
        GameCanvas.drawSoftKeys(g, 5, 1);
    }

    private void showHelp(Graphics g) {
        boolean mbPainted;
        int scrollWidth = 6;
        if (this.needInitBreaks) {
            int otstup1 = 45 + GameFont.height(0) + 4;
            int otstup2 = GameCanvas.HEIGHT / 2 + imageMenu.getHeight() / 2 - GameFont.height(1);
            sizeWindow = otstup2 - otstup1;
            this.textHieght = GameFont.height(1) + 0;
            this.initBreaks(Localization.extUpperCase(this.curString), GameCanvas.WIDTH - 10 - 32 - scrollWidth * 2, sizeWindow);
            this.shiftNum = (this.nLines - this.linesOnScreen) * this.textHieght / this.shiftStep;
            this.needInitBreaks = false;
        }
        if (!(mbPainted = Menu.drawMenuBorder(g, 16, 40, 160))) {
            return;
        }
        ++this.counterScroll;
        if (this.scrollingDirection != 0 && this.counterScroll == 2) {
            this.counterScroll = 1;
            this.makeScrollingText(this.scrollingDirection);
        }
        int y = 52;
        g.setColor(11591910);
        String drawString = this.menuState == 14 ? Localization.gameString[Localization.HELP][0] : Localization.gameString[Localization.ABOUT][0];
        GameFont.drawString(drawString, g, y, 0);
        y = 45 + GameFont.height(0);
        g.setClip(16, y, GameCanvas.WIDTH - 16 - 4, sizeWindow);
        for (int i = 0; i < this.linesOnScreen + 2; ++i) {
            try {
                drawString = this.curString.substring(this.breaks[this.currentShiftText * this.shiftStep / this.textHieght + i], this.breaks[this.currentShiftText * this.shiftStep / this.textHieght + i + 1]);
                GameFont.drawString(drawString, g, 21, y + i * this.textHieght - this.currentShiftText * this.shiftStep % this.textHieght, 1);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        int maxPosition = this.shiftNum + 1;
        int currentPosition = this.currentShiftText + 1;
        if (!this.scrolling && currentPosition < maxPosition) {
            this.scrolling = true;
        }
        if (this.scrolling) {
            this.drawScroll(g, GameCanvas.WIDTH - 16 - scrollWidth - 2, y, scrollWidth, 160 - 10 * scrollWidth, maxPosition, currentPosition);
        }
        GameCanvas.drawSoftKeys(g, 5, 1);
    }

    private void showConfirm(Graphics g) {
        boolean mbPainted;
        if (this.needInitBreaks) {
            this.textHieght = GameFont.height(1);
            this.initBreaks(Localization.extUpperCase(this.curString), GameCanvas.WIDTH - 32 - 6, 66);
            this.needInitBreaks = false;
        }
        if (!(mbPainted = Menu.drawMenuBorder(g, 16, 80, 70))) {
            return;
        }
        g.setColor(11591910);
        int y = GameCanvas.HEIGHT / 2 - this.nLines * this.textHieght / 2;
        for (int i = 0; i < this.nLines; ++i) {
            String drawString = this.curString.substring(this.breaks[i], this.breaks[i + 1]);
            if (drawString.endsWith(" ")) {
                drawString = drawString.substring(0, drawString.length() - 1);
            }
            GameFont.drawString(drawString, g, y + i * this.textHieght + 2, 1);
        }
        GameCanvas.drawSoftKeys(g, 0, 2);
    }

    public static boolean drawMenuBorder(Graphics g, int offsetX, int offsetY, int borderHight) {
        try {
            if (needRollingScroll) {
                needRollingScroll = false;
                rollCounter = 1;
                isKeysEnable = false;
            } else if (rollCounter == 1) {
                rollCounter = 4;
            }
            if (rollCounter == 4 && !isKeysEnable && ++keysBlockCounter == 4) {
                keysBlockCounter = 0;
                isKeysEnable = true;
            }
            g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
            g.drawImage(imageMenu, GameCanvas.WIDTH / 2, (GameCanvas.HEIGHT - rollHeight) / 2, 17);
            if (rollCounter < 4) {
                ++rollCounter;
                return false;
            }
        }
        catch (Exception e) {
            GameCanvas.addError("Menu.drawMenuBorder()", e);
        }
        return true;
    }

    private void drawScroll(Graphics g, int x, int y, int w, int h, int maxPos, int curPos) {
        g.setColor(11591910);
        g.drawLine(x, y + w / 2, x + w, y + w / 2);
        g.drawLine(x, y + w / 2, x + w / 2, y);
        g.drawLine(x + w / 2, y, x + w, y + w / 2);
        g.drawLine(x, y + h + w / 2, x + w, y + h + w / 2);
        g.drawLine(x, y + h + w / 2, x + w / 2, y + h + w);
        g.drawLine(x + w / 2, y + h + w, x + w, y + h + w / 2);
        int dh = h / 3;
        g.drawRect(x, y + w / 2 + (h - dh) * (curPos - 1) / maxPos, w, h - (h - dh) * (maxPos - 1) / maxPos);
    }

    private void fillTriangle(Graphics g, int x, int y) {
        g.setColor(1644912);
        g.drawLine(x, y, x + 5, y);
        g.drawLine(x + 1, y + 1, x + 4, y + 1);
        g.drawLine(x + 2, y + 2, x + 3, y + 2);
    }

    private void makeScrollingText(int direction) {
        this.currentShiftText += direction;
        if (this.currentShiftText + direction > this.shiftNum) {
            this.currentShiftText = this.shiftNum;
        }
        if (this.currentShiftText + direction < 0) {
            this.currentShiftText = 0;
        }
    }

    private void initBreaks(String str, int textFieldWidth, int textFieldHeight) {
        this.linesOnScreen = textFieldHeight / this.textHieght;
        char[] charString = str.toCharArray();
        int breakPos = 1;
        int curLine = 1;
        int stringWidth = 0;
        int charStringLength = charString.length;
        this.breaks[0] = 0;
        for (int curPos = 0; curPos < charString.length; ++curPos) {
            if (charString[curPos] == ' ' || charString[curPos] == '\u00b6' || charString[curPos] == '-' || charString[curPos] == '.' || charString[curPos] == '@' || charString[curPos] == ',') {
                breakPos = curPos - 1;
            }
            if ((stringWidth = GameFont.getStrWidth(str.substring(this.breaks[curLine - 1], curPos + 1), 1)) < textFieldWidth && charString[curPos] != '\u00b6') continue;
            if (this.breaks[curLine - 1] != breakPos) {
                this.breaks[curLine] = breakPos + 2;
            } else {
                while (curPos < charString.length && charString[curPos] != ' ' && charString[curPos] != '-' && charString[curPos] != '.' && charString[curPos] != '@' && charString[curPos] != ',') {
                    ++curPos;
                }
                this.breaks[curLine] = curPos;
            }
            ++curLine;
            stringWidth = 0;
            if (charString[curPos] != '\u00b6') continue;
            charString[curPos] = 32;
        }
        this.nLines = curLine;
        this.breaks[this.nLines] = str.length();
        this.curString = new String(charString);
        GameCanvas.getInstance.setLoadingProgress(100);
    }

    public static void drawRunningString(Graphics g, String string, int x, int y, int length, int anc, boolean needRun) {
        Menu.drawRunningString(g, string, x, y, length, 1, anc, needRun);
    }

    public static void drawRunningString(Graphics g, String string, int x, int y, int length, int font, int anc, boolean needRun) {
        int stringWidth = GameFont.getStrWidth(string, font);
        g.setClip(x, 0, length, GameCanvas.HEIGHT);
        if (!needRun) {
            GameFont.drawString(string, g, x, y, font);
            return;
        }
        if (!runningString.equals(string)) {
            runningString = new String(string);
            runningCounter = 0;
            runningDirection = 1;
        }
        runningCounter += runningDirection;
        if (runningDirection == 1) {
            if (stringWidth - runningCounter < length - 1) {
                runningDirection = -1;
            }
        } else if (runningCounter < 0) {
            runningDirection = 1;
        }
        GameFont.drawString(string, g, x - runningCounter, y, font);
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    private String currentString(int index) {
        String str = null;
        if (this.menuState == 18) {
            switch (index + (this.hasContinue ? 0 : 1)) {
                case 0: {
                    str = Localization.gameString[Localization.CONTINUE][0];
                    break;
                }
                case 1: {
                    str = Localization.gameString[Localization.NEW_GAME][0];
                    break;
                }
                case 2: {
                    str = Localization.gameString[Localization.SETTINGS][0];
                    break;
                }
                case 3: {
                    str = Localization.gameString[Localization.HIGH_SCORES][0];
                    break;
                }
                case 4: {
                    str = Localization.gameString[Localization.HELP][0];
                    break;
                }
                case 5: {
                    str = Localization.gameString[Localization.TELL_A_FRIEND][0];
                    break;
                }
                case 6: {
                    str = Localization.gameString[Localization.MORE_GAMES][0];
                    break;
                }
                case 7: {
                    str = Localization.gameString[Localization.UPLOAD][0];
                    break;
                }
                case 8: {
                    str = Localization.gameString[Localization.ABOUT][0];
                    break;
                }
                case 9: {
                    str = Localization.gameString[Localization.EXIT][0];
                }
            }
        }
        return str;
    }

    public static char[] getLastPlayerName() {
        return lastPlayerName;
    }

    public static void setCurrentPlayerName(String s) {
        while (s.length() < 7) {
            s = s + "0";
        }
        lastPlayerName = s.toCharArray();
    }

    public int processKey(int keyCode, int gameAction, boolean isPressed) {
        if (keyCode == 42 && isPressed) {
            return 0;
        }
        if (!isPressed || !isIntroShown) {
            this.needDrawLeftArrowPressed = false;
            this.needDrawRightArrowPressed = false;
            this.scrollingDirection = 0;
            return 0;
        }
        if (this.paused) {
            if (keyCode == -7 || keyCode == -7) {
                this.resume();
            }
            return 0;
        }
        switch (this.menuState) {
            case 18: {
                if (keyCode == -6 || keyCode == 53 || gameAction == 8) {
                    this.currentShiftText = 0;
                    this.needInitBreaks = true;
                    needRollingScroll = true;
                    this.currentHiScoresPage = GameCanvas.optionsGameType;
                    this.isAfterGameHS = false;
                    switch (this.currentSelection + (this.hasContinue ? 0 : 1)) {
                        case 0: {
                            this.close();
                            return 6;
                        }
                        case 1: {
                            if (this.hasContinue) {
                                this.curString = Localization.gameString[Localization.TEXT_CONFIRM_START][0];
                                this.menuState = (byte)19;
                                break;
                            }
                            this.close();
                            return 5;
                        }
                        case 2: {
                            this.currentSelection = 0;
                            this.curString = Localization.gameString[Localization.SETTINGS][0];
                            this.prevGameType = GameCanvas.optionsGameType;
                            this.prevGameDifficulty = GameCanvas.optionsGameDifficulty;
                            this.prevGameLanguage = GameCanvas.optionsLanguage;
                            this.menuState = (byte)12;
                            break;
                        }
                        case 3: {
                            this.menuState = (byte)13;
                            break;
                        }
                        case 4: {
                            this.scrolling = false;
                            this.curString = Localization.gameString[Localization.HELP_TEXT][0];
                            this.menuState = (byte)14;
                            break;
                        }
                        case 8: {
                            this.scrolling = false;
                            this.curString = Localization.gameString[Localization.ABOUT_TEXT][0];
                            this.menuState = (byte)15;
                            break;
                        }
                        case 9: {
                            this.curString = Localization.gameString[Localization.EXIT_TEXT][0];
                            this.menuState = (byte)17;
                        }
                    }
                }
                if (keyCode == 52 || gameAction == 2) {
                    this.needDrawLeftArrowPressed = true;
                    --this.currentSelection;
                    if (this.currentSelection + (this.hasContinue ? 0 : 1) == 5 || this.currentSelection + (this.hasContinue ? 0 : 1) == 6 || this.currentSelection + (this.hasContinue ? 0 : 1) == 7) {
                        this.currentSelection -= 3;
                    }
                    if (this.currentSelection < 0) {
                        this.currentSelection = 8 + (this.hasContinue ? 1 : 0);
                    }
                }
                if (keyCode == 54 || gameAction == 5) {
                    this.needDrawRightArrowPressed = true;
                    ++this.currentSelection;
                    if (this.currentSelection + (this.hasContinue ? 0 : 1) == 5 || this.currentSelection + (this.hasContinue ? 0 : 1) == 6 || this.currentSelection + (this.hasContinue ? 0 : 1) == 7) {
                        this.currentSelection += 3;
                    }
                    if (this.currentSelection >= 9 + (this.hasContinue ? 1 : 0)) {
                        this.currentSelection = 0;
                    }
                }
                if (keyCode != -7 && keyCode != -7) break;
                this.needInitBreaks = true;
                needRollingScroll = true;
                this.curString = Localization.gameString[Localization.EXIT_TEXT][0];
                this.menuState = (byte)17;
                break;
            }
            case 12: {
                if (keyCode == 50 || gameAction == 1) {
                    --this.currentSelection;
                    if (this.currentSelection < 0) {
                        this.currentSelection = 3;
                    }
                }
                if (keyCode == 56 || gameAction == 6) {
                    ++this.currentSelection;
                    if (this.currentSelection >= 4) {
                        this.currentSelection = 0;
                    }
                }
                if (keyCode == 54 || gameAction == 5) {
                    this.needDrawRightArrowPressed = true;
                    switch (this.currentSelection) {
                        case 0: {
                            if (++GameCanvas.optionsGameType >= 2) {
                                GameCanvas.optionsGameType = 0;
                            }
                            this.maxLevelAvailable = GameCanvas.maxLevelAvailable[GameCanvas.optionsGameType];
                            break;
                        }
                        case 1: {
                            if (++GameCanvas.optionsGameDifficulty < 3) break;
                            GameCanvas.optionsGameDifficulty = 0;
                            break;
                        }
                        case 2: {
                            if (++GameCanvas.optionsLanguage >= Localization.gameString[Localization.LANG].length) {
                                GameCanvas.optionsLanguage = 0;
                            }
                            Localization.Load();
                            break;
                        }
                        case 3: {
                            boolean bl = GameCanvas.optionsMusicOn = !GameCanvas.optionsMusicOn;
                            if (GameCanvas.optionsMusicOn) {
                                GameCanvas.soundPlayer.play(0, true, true);
                                break;
                            }
                            GameCanvas.soundPlayer.stop(0);
                        }
                    }
                }
                if (keyCode == 52 || gameAction == 2) {
                    this.needDrawLeftArrowPressed = true;
                    switch (this.currentSelection) {
                        case 0: {
                            if (--GameCanvas.optionsGameType < 0) {
                                GameCanvas.optionsGameType = 1;
                            }
                            this.maxLevelAvailable = GameCanvas.maxLevelAvailable[GameCanvas.optionsGameType];
                            break;
                        }
                        case 1: {
                            if (--GameCanvas.optionsGameDifficulty >= 0) break;
                            GameCanvas.optionsGameDifficulty = 2;
                            break;
                        }
                        case 2: {
                            if (--GameCanvas.optionsLanguage < 0) {
                                GameCanvas.optionsLanguage = Localization.gameString[Localization.LANG].length - 1;
                            }
                            Localization.Load();
                            break;
                        }
                        case 3: {
                            boolean bl = GameCanvas.optionsMusicOn = !GameCanvas.optionsMusicOn;
                            if (GameCanvas.optionsMusicOn) {
                                GameCanvas.soundPlayer.play(0, true, true);
                                break;
                            }
                            GameCanvas.soundPlayer.stop(0);
                        }
                    }
                }
                if (keyCode == -6) {
                    this.currentSelection = this.isAfterGameHS ? 0 : (this.hasContinue ? 2 : 1);
                    GameCanvas.saveSettings();
                    this.menuState = (byte)18;
                }
                if (keyCode != -7 && keyCode != -7) break;
                this.currentSelection = this.isAfterGameHS ? 0 : (this.hasContinue ? 2 : 1);
                GameCanvas.optionsGameType = this.prevGameType;
                GameCanvas.optionsGameDifficulty = this.prevGameDifficulty;
                GameCanvas.optionsLanguage = this.prevGameLanguage;
                Localization.Load();
                this.menuState = (byte)18;
                break;
            }
            case 13: {
                if (keyCode == 54 || gameAction == 5) {
                    this.needDrawRightArrowPressed = true;
                    ++this.currentHiScoresPage;
                    if (this.currentHiScoresPage >= 2) {
                        this.currentHiScoresPage = 0;
                    }
                }
                if (keyCode == 52 || gameAction == 2) {
                    this.needDrawLeftArrowPressed = true;
                    --this.currentHiScoresPage;
                    if (this.currentHiScoresPage < 0) {
                        this.currentHiScoresPage = 1;
                    }
                }
                if (keyCode != -7 && keyCode != -7) break;
                this.currentSelection = this.isAfterGameHS ? 1 : (this.hasContinue ? 3 : 2);
                this.menuState = (byte)18;
                break;
            }
            case 14: 
            case 15: {
                if (keyCode == 56 || gameAction == 6) {
                    this.scrollingDirection = 1;
                    this.counterScroll = 0;
                    this.makeScrollingText(this.scrollingDirection);
                }
                if (keyCode == 50 || gameAction == 1) {
                    this.scrollingDirection = -1;
                    this.counterScroll = 0;
                    this.makeScrollingText(this.scrollingDirection);
                }
                if (keyCode != -7 && keyCode != -7) break;
                this.currentSelection = (this.hasContinue ? 4 : 3) + (this.menuState == 15 ? 4 : 0);
                this.menuState = (byte)18;
                break;
            }
            case 19: {
                if (keyCode == -6) {
                    this.close();
                    return 5;
                }
                if (keyCode != -7 && keyCode != -7) break;
                this.menuState = (byte)18;
                break;
            }
            case 17: {
                if (keyCode == -6) {
                    this.close();
                    return 7;
                }
                if (keyCode != -7 && keyCode != -7) break;
                GameMidlet.exitToBrowser = false;
                this.menuState = (byte)18;
            }
        }
        return 0;
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        GameCanvas.soundPlayer.stop(0);
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        if (GameCanvas.optionsMusicOn && !GameCanvas.primeStart) {
            GameCanvas.soundPlayer.play(0, true, true);
        }
    }

    public void close() {
        imageMainMenuBackground = null;
        imageMenuItem = null;
        imageLeftArrowPressed = null;
        imageRightArrowPressed = null;
        imageLeftArrow = null;
        imageRightArrow = null;
        this.breaks = null;
        GameCanvas.soundPlayer.stop(0);
        System.gc();
    }

    static {
        user_highscore = 0;
        scores = new int[5];
        scorestime = new long[5];
        lastPlayerName = new char[7];
        currentCharSelection = 0;
        optionsGameType = 0;
        optionsGameDifficulty = 0;
        optionsSoundOn = true;
        optionsMusicOn = true;
        counter = 0;
        isIntroShown = false;
        isKeysEnable = true;
        stepAnimationMenuItem = 0;
        posYAnimationMenuItem = 0;
        posYMenuItem = 0;
        needRollingScroll = true;
        rollCounter = 1;
        keysBlockCounter = 0;
        sizeWindow = 0;
        runningCounter = 0;
        runningDirection = 1;
        runningString = "";
    }
}

