/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class TextField {
    private int xLocation;
    private int yLocation;
    public static int yTextField;
    private String[] strings;
    private int currentStringNum;
    private int height;
    private byte deltaX = (byte)3;
    private byte deltaY = (byte)3;
    private int xString;
    private int maxStrings;
    private static Font headerFont;
    private int step = 0;
    private boolean sent;
    public static final int SIZE_STEP = 15;

    public TextField(int x, int y, int heightTxt, String string, int maxStrings) {
        this.xLocation = x;
        this.yLocation = yTextField = y;
        this.height = heightTxt + 2;
        this.currentStringNum = 0;
        this.maxStrings = maxStrings;
        this.strings = new String[maxStrings];
        this.strings[0] = string;
        this.sent = false;
        this.xString = this.xLocation + this.deltaX;
    }

    public void addStep() {
        if (this.sent && this.step < 15) {
            ++this.step;
        } else {
            this.sent = false;
            this.step = 0;
        }
    }

    public boolean getSent() {
        return this.sent;
    }

    public void draw(Graphics g) {
        g.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
        g.setColor(0, 0, 0);
        g.fillRect(this.xLocation - 2, this.yLocation, GameCanvas.WIDTH - (this.xLocation - 2) * 2, this.height * (this.currentStringNum + 1));
        g.setColor(11591910);
        g.drawRect(this.xLocation - 3, this.yLocation, GameCanvas.WIDTH - (this.xLocation - 3) * 2, this.height * (this.currentStringNum + 1));
        if (this.sent) {
            GameFont.drawString(Localization.gameString[Localization.MESSAGE_SENT][0], g, this.xString - 1, this.yLocation + this.deltaY, 1);
        } else {
            for (int i = 0; i < this.currentStringNum + 1; ++i) {
                GameFont.drawString(this.strings[i], g, this.xString - 1, this.yLocation + this.height * i + this.deltaY, 1);
            }
        }
    }

    public void addChar(int c) {
        String str = String.valueOf(c);
        int widthChar = GameFont.getStrWidth(str, 1);
        int widthStr = GameFont.getStrWidth(this.strings[this.currentStringNum], 1);
        System.out.println("GameCanvas.WIDTH - (( xLocation - 2 ) * 2 ) = " + (GameCanvas.WIDTH - (this.xLocation - 2) * 2));
        System.out.println("widthChar + widthStr = " + (widthChar + widthStr));
        if (widthChar + widthStr > GameCanvas.WIDTH - (this.xLocation - 2) * 2 - widthChar) {
            ++this.currentStringNum;
            if (this.currentStringNum > this.maxStrings - 1) {
                --this.currentStringNum;
                return;
            }
            this.strings[this.currentStringNum] = new String(str);
            return;
        }
        this.strings[this.currentStringNum] = this.strings[this.currentStringNum].concat(str);
    }

    public void dellChar() {
        if (this.strings[this.currentStringNum].length() > 1) {
            this.strings[this.currentStringNum] = this.strings[this.currentStringNum].substring(0, this.strings[this.currentStringNum].length() - 1);
        } else if (this.currentStringNum != 0) {
            --this.currentStringNum;
        }
    }

    public String getNumber() {
        String number = new String();
        for (int i = 0; i < this.currentStringNum + 1; ++i) {
            number = number.concat(this.strings[i]);
        }
        return number;
    }

    public void dellNumber() {
        this.currentStringNum = 0;
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = null;
        }
        this.strings[0] = new String("+");
    }

    public void sendSMS(String address, String messageText) {
        if (!this.sent) {
            try {
                address = "sms://" + this.getNumber() + ":0";
                MessageConnection mc = (MessageConnection)Connector.open((String)address);
                TextMessage tm = (TextMessage)mc.newMessage("text");
                tm.setPayloadText(Localization.gameString[Localization.MESSAGE_TEXT][0]);
                mc.send((Message)tm);
                mc.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sent = true;
            this.dellNumber();
        }
    }

    static {
        headerFont = Font.getFont((int)0, (int)0, (int)0);
    }
}

