/*
 * Decompiled with CFR 0.152.
 */
import com.exploringxml.xml.Node;
import com.exploringxml.xml.Xparse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class KMUILanguage {
    static final String S_TEXTS = "texts";
    static Hashtable hashTexts = new Hashtable();
    static KMUICanvas canvas;
    static String language;

    static final void init(KMUICanvas c) {
        canvas = c;
    }

    static final void readTextFile(String s, Class c) throws Exception {
        int cc;
        hashTexts.clear();
        InputStream is = c.getResourceAsStream(s);
        StringBuffer sb = new StringBuffer();
        while ((cc = KMUILanguage.getNextCharacter(is)) != -1) {
            sb.append((char)cc);
        }
        is.close();
        is = null;
        int[] occur = new int[]{1, 1};
        Node root = new Xparse().parse(sb.toString());
        Node n = root.find("texts/texts" + language, occur);
        Enumeration en = null;
        if (n.attributes != null) {
            en = n.attributes.keys();
            while (en.hasMoreElements()) {
                Object k = en.nextElement();
                String res = (String)n.attributes.get(k);
                res = res.trim();
                String key = k.toString();
                hashTexts.put(key, res);
            }
            en = null;
        }
        root = null;
        n = null;
        System.gc();
    }

    public static int getNextCharacter(InputStream inpStream) throws IOException {
        int a = inpStream.read();
        if (a == -1) {
            return -1;
        }
        int t = a;
        if ((t | 0xC0) == t) {
            int b = inpStream.read();
            if (b == 255) {
                t = -1;
            } else {
                if (b < 128) {
                    throw new IOException("Bad UTF-8 Encoding encountered");
                }
                if ((t | 0xE0) == t) {
                    int c = inpStream.read();
                    if (c == 255) {
                        t = -1;
                    } else {
                        if (c < 128) {
                            throw new IOException("Bad UTF-8 Encoding encountered");
                        }
                        t = (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
                    }
                } else {
                    t = (a & 0x1F) << 6 | b & 0x3F;
                }
            }
        }
        return t;
    }

    static final String getImage(String key) {
        if (key != null && canvas != null && key.indexOf("\\") == 0) {
            return canvas.getImage(key);
        }
        return key;
    }

    static final String getText(String key) {
        String s = (String)hashTexts.get(key);
        if (s == null && canvas != null) {
            if (key.indexOf("\\") == 0) {
                return canvas.getText(key);
            }
            if (key.indexOf("/") == 0) {
                String st = canvas.getText(key);
                s = (String)hashTexts.get(st);
            } else {
                s = "";
            }
        }
        return s;
    }

    static {
        language = "en";
    }
}

